/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapLinkedFreeHeader;
import com.ibm.j9ddr.vm29.j9.gc.GCScavengerForwardedHeader;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.MM_ScavengerForwardedHeader;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;

class GCScavengerForwardedHeader_V1
extends GCScavengerForwardedHeader {
    private static final int ALL_TAGS = (int)(MM_ScavengerForwardedHeader.FORWARDED_TAG | MM_ScavengerForwardedHeader.GROW_TAG);

    protected GCScavengerForwardedHeader_V1(J9ObjectPointer j9ObjectPointer) {
        super(j9ObjectPointer);
    }

    @Override
    public J9ObjectPointer getForwardedObject() throws CorruptDataException {
        if (this.isForwardedPointer()) {
            return this.getForwardedObjectNoCheck();
        }
        return J9ObjectPointer.NULL;
    }

    protected J9ObjectPointer getForwardedObjectNoCheck() throws CorruptDataException {
        if (J9BuildFlags.gc_compressedPointers && !J9BuildFlags.env_littleEndian) {
            U32 u32 = U32Pointer.cast(this.objectPointer.clazzEA()).at(0L).bitAnd(~ALL_TAGS);
            U32 u322 = U32Pointer.cast(this.objectPointer.clazzEA()).at(1L);
            J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(new UDATA(u32).bitOr(new UDATA(u322).leftShift(32)));
            return j9ObjectPointer;
        }
        J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(UDATAPointer.cast(this.objectPointer.clazzEA()).at(0L));
        return j9ObjectPointer.untag(ALL_TAGS);
    }

    @Override
    public J9ObjectPointer getReverseForwardedPointer() throws CorruptDataException {
        GCHeapLinkedFreeHeader gCHeapLinkedFreeHeader = GCHeapLinkedFreeHeader.fromJ9Object(this.objectPointer).getNext();
        return gCHeapLinkedFreeHeader.getObject();
    }

    @Override
    public boolean isForwardedPointer() throws CorruptDataException {
        return this.objectPointer.clazz().allBitsIn(MM_ScavengerForwardedHeader.FORWARDED_TAG);
    }

    @Override
    public boolean isReverseForwardedPointer() throws CorruptDataException {
        UDATA uDATA = UDATA.cast(this.objectPointer.clazz());
        return uDATA.bitAnd(J9Consts.J9_GC_OBJ_HEAP_HOLE_MASK).eq(J9Consts.J9_GC_MULTI_SLOT_HOLE);
    }

    @Override
    public UDATA getObjectSize() throws CorruptDataException {
        UDATA uDATA;
        J9ObjectPointer j9ObjectPointer = this.getForwardedObjectNoCheck();
        if (ObjectModel.hasBeenMoved(j9ObjectPointer) && !ObjectModel.hasBeenHashed(j9ObjectPointer)) {
            uDATA = ObjectModel.getSizeInBytesWithHeader(j9ObjectPointer);
            uDATA = ObjectModel.adjustSizeInBytes(uDATA);
        } else {
            uDATA = ObjectModel.getConsumedSizeInBytesWithHeader(j9ObjectPointer);
        }
        return uDATA;
    }
}

