/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cuda;

import com.ibm.cuda.CudaDevice;
import com.ibm.cuda.CudaException;
import com.ibm.cuda.CudaFunction;
import com.ibm.cuda.CudaGlobal;
import com.ibm.cuda.CudaJitOptions;
import com.ibm.cuda.CudaPermission;
import com.ibm.cuda.CudaSurface;
import com.ibm.cuda.CudaTexture;
import com.ibm.cuda.internal.CudaUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class CudaModule {
    final int deviceId;
    private final Map<String, CudaFunction> functions;
    private final Map<String, CudaGlobal> globals;
    private final AtomicLong nativeHandle;
    private final Map<String, CudaSurface> surfaces;
    private final Map<String, CudaTexture> textures;

    private static native long getFunction(int var0, long var1, String var3) throws CudaException;

    private static native long getGlobal(int var0, long var1, String var3) throws CudaException;

    private static native long getSurface(int var0, long var1, String var3) throws CudaException;

    private static native long getTexture(int var0, long var1, String var3) throws CudaException;

    private static native long load(int var0, byte[] var1, long var2) throws CudaException;

    private static native void unload(int var0, long var1) throws CudaException;

    public CudaModule(CudaDevice cudaDevice, byte[] byArray) throws CudaException {
        this(cudaDevice, byArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CudaModule(CudaDevice cudaDevice, byte[] byArray, CudaJitOptions cudaJitOptions) throws CudaException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(CudaPermission.LoadModule);
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.deviceId = cudaDevice.getDeviceId();
        long l = cudaJitOptions == null ? 0L : cudaJitOptions.getHandle();
        try {
            this.functions = new HashMap<String, CudaFunction>();
            this.globals = new HashMap<String, CudaGlobal>();
            this.nativeHandle = new AtomicLong(CudaModule.load(this.deviceId, byArray, l));
            this.surfaces = new HashMap<String, CudaSurface>();
            this.textures = new HashMap<String, CudaTexture>();
        }
        finally {
            if (cudaJitOptions != null) {
                cudaJitOptions.releaseHandle(true);
            }
        }
    }

    public CudaModule(CudaDevice cudaDevice, InputStream inputStream) throws CudaException, IOException {
        this(cudaDevice, inputStream, null);
    }

    public CudaModule(CudaDevice cudaDevice, InputStream inputStream, CudaJitOptions cudaJitOptions) throws CudaException, IOException {
        this(cudaDevice, CudaUtil.read(inputStream, true), cudaJitOptions);
    }

    public CudaFunction getFunction(String string) throws CudaException {
        CudaFunction cudaFunction = this.functions.get(string);
        if (cudaFunction == null) {
            long l = CudaModule.getFunction(this.deviceId, this.getHandle(), string);
            cudaFunction = new CudaFunction(this.deviceId, l);
            this.functions.put(string, cudaFunction);
        }
        return cudaFunction;
    }

    public CudaGlobal getGlobal(String string) throws CudaException {
        CudaGlobal cudaGlobal = this.globals.get(string);
        if (cudaGlobal == null) {
            long l = CudaModule.getGlobal(this.deviceId, this.getHandle(), string);
            cudaGlobal = new CudaGlobal(l);
            this.globals.put(string, cudaGlobal);
        }
        return cudaGlobal;
    }

    private long getHandle() {
        long l = this.nativeHandle.get();
        if (l == 0L) {
            throw new IllegalStateException();
        }
        return l;
    }

    public CudaSurface getSurface(String string) throws CudaException {
        CudaSurface cudaSurface = this.surfaces.get(string);
        if (cudaSurface == null) {
            long l = CudaModule.getSurface(this.deviceId, this.getHandle(), string);
            cudaSurface = new CudaSurface(l);
            this.surfaces.put(string, cudaSurface);
        }
        return cudaSurface;
    }

    public CudaTexture getTexture(String string) throws CudaException {
        CudaTexture cudaTexture = this.textures.get(string);
        if (cudaTexture == null) {
            long l = CudaModule.getTexture(this.deviceId, this.getHandle(), string);
            cudaTexture = new CudaTexture(l);
            this.textures.put(string, cudaTexture);
        }
        return cudaTexture;
    }

    public void unload() throws CudaException {
        long l = this.nativeHandle.getAndSet(0L);
        if (l != 0L) {
            this.functions.clear();
            this.globals.clear();
            this.surfaces.clear();
            this.textures.clear();
            CudaModule.unload(this.deviceId, l);
        }
    }

    public static final class Cache {
        private final Map<Object, Map<CudaDevice, CudaModule>> store = new HashMap<Object, Map<CudaDevice, CudaModule>>(1);

        public CudaModule get(CudaDevice cudaDevice, Object object) {
            Map<CudaDevice, CudaModule> map = this.store.get(object);
            return map == null ? null : map.get(cudaDevice);
        }

        public CudaModule put(CudaDevice cudaDevice, Object object, CudaModule cudaModule) {
            Map<CudaDevice, CudaModule> map = this.store.get(object);
            if (map == null) {
                map = new HashMap<CudaDevice, CudaModule>();
                this.store.put(object, map);
            }
            return map.put(cudaDevice, cudaModule);
        }
    }
}

