/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm29.j9.gc.GCMemoryPool;
import com.ibm.j9ddr.vm29.j9.gc.GCMemoryPoolIterator;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MemoryPoolPointer;
import java.util.NoSuchElementException;

class GCTarokMemoryPoolIterator
extends GCMemoryPoolIterator {
    protected MM_MemoryPoolPointer _currentMemoryPool = null;
    protected GCHeapRegionIterator _regionIterator = GCHeapRegionIterator.from();
    protected GCHeapRegionDescriptor _region = null;

    public GCTarokMemoryPoolIterator() throws CorruptDataException {
        this.advancePool();
    }

    private void advancePool() {
        this._currentMemoryPool = null;
        this._region = null;
        while (this._regionIterator.hasNext()) {
            this._region = this._regionIterator.next();
            MM_MemoryPoolPointer mM_MemoryPoolPointer = this._region.getMemoryPool();
            if (!mM_MemoryPoolPointer.notNull()) continue;
            this._currentMemoryPool = mM_MemoryPoolPointer;
            break;
        }
    }

    @Override
    public GCMemoryPool next() {
        try {
            if (this.hasNext()) {
                GCMemoryPool gCMemoryPool = GCMemoryPool.fromMemoryPoolPointerInRegion(this._region, this._currentMemoryPool);
                this.advancePool();
                return gCMemoryPool;
            }
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Memory Pool corruption detected", corruptDataException, false);
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    @Override
    public boolean hasNext() {
        return null != this._currentMemoryPool;
    }

    @Override
    public String toString() {
        GCTarokMemoryPoolIterator gCTarokMemoryPoolIterator = null;
        try {
            gCTarokMemoryPoolIterator = new GCTarokMemoryPoolIterator();
        }
        catch (CorruptDataException corruptDataException) {
            EventManager.raiseCorruptDataEvent("Corruption detected", corruptDataException, false);
            return corruptDataException.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = System.getProperty("line.separator");
        while (gCTarokMemoryPoolIterator.hasNext()) {
            stringBuilder.append(gCTarokMemoryPoolIterator.next() + string);
        }
        return stringBuilder.toString();
    }
}

