/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.lang.management.internal;

import com.ibm.java.lang.management.internal.GarbageCollectorMXBeanImpl;
import com.ibm.java.lang.management.internal.LazyDelegatingNotifier;
import com.ibm.java.lang.management.internal.ManagementPermissionHelper;
import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.java.lang.management.internal.MemoryManagerMXBeanImpl;
import com.ibm.java.lang.management.internal.MemoryPoolMXBeanImpl;
import com.ibm.oti.shared.SharedClassStatistics;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.ObjectName;

public class MemoryMXBeanImpl
extends LazyDelegatingNotifier
implements MemoryMXBean {
    private static final MemoryMXBeanImpl instance;
    private static final Constructor<MemoryUsage> memUsageConstructor;
    private final List<MemoryManagerMXBean> memoryManagerList;
    private final List<MemoryPoolMXBean> managedPoolList = new LinkedList<MemoryPoolMXBean>();
    private ObjectName objectName;

    protected MemoryMXBeanImpl() {
        this.memoryManagerList = new LinkedList<MemoryManagerMXBean>();
        this.createMemoryPools();
        this.createMemoryManagers();
        this.setManagedMemoryPoolsForManagers();
    }

    private void setManagedMemoryPoolsForManagers() {
        for (MemoryManagerMXBeanImpl memoryManagerMXBeanImpl : this.memoryManagerList) {
            for (MemoryPoolMXBeanImpl memoryPoolMXBeanImpl : this.managedPoolList) {
                if (memoryManagerMXBeanImpl instanceof GarbageCollectorMXBean) {
                    if (MemoryType.HEAP != memoryPoolMXBeanImpl.getType() || !memoryManagerMXBeanImpl.isManagedPoolImpl(memoryManagerMXBeanImpl.id, memoryPoolMXBeanImpl.getID())) continue;
                    memoryManagerMXBeanImpl.addMemoryPool(memoryPoolMXBeanImpl);
                    continue;
                }
                if (MemoryType.NON_HEAP != memoryPoolMXBeanImpl.getType()) continue;
                memoryManagerMXBeanImpl.addMemoryPool(memoryPoolMXBeanImpl);
            }
        }
    }

    public static MemoryMXBeanImpl getInstance() {
        return instance;
    }

    private native void createMemoryManagers();

    private void createMemoryManagerHelper(String string, int n, boolean bl) {
        MemoryManagerMXBean memoryManagerMXBean;
        if (bl) {
            String string2 = "java.lang:type=GarbageCollector";
            memoryManagerMXBean = this.makeGCBean(string2, string, n);
        } else {
            String string3 = "java.lang:type=MemoryManager";
            memoryManagerMXBean = new MemoryManagerMXBeanImpl(string3, string, n);
        }
        this.memoryManagerList.add(memoryManagerMXBean);
    }

    protected GarbageCollectorMXBean makeGCBean(String string, String string2, int n) {
        return new GarbageCollectorMXBeanImpl(string, string2, n, this);
    }

    public List<MemoryManagerMXBean> getMemoryManagerMXBeans(boolean bl) {
        ArrayList arrayList = this.memoryManagerList;
        return bl ? new ArrayList(arrayList) : arrayList;
    }

    public List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        LinkedList<GarbageCollectorMXBean> linkedList = new LinkedList<GarbageCollectorMXBean>();
        for (MemoryManagerMXBean memoryManagerMXBean : this.memoryManagerList) {
            if (!(memoryManagerMXBean instanceof GarbageCollectorMXBean)) continue;
            linkedList.add((GarbageCollectorMXBean)memoryManagerMXBean);
        }
        return linkedList;
    }

    private native void createMemoryPools();

    private void createMemoryPoolHelper(String string, int n, boolean bl) {
        this.managedPoolList.add(this.makeMemoryPoolBean(string, bl ? MemoryType.HEAP : MemoryType.NON_HEAP, n));
    }

    protected MemoryPoolMXBean makeMemoryPoolBean(String string, MemoryType memoryType, int n) {
        return new MemoryPoolMXBeanImpl(string, memoryType, n, this);
    }

    public List<MemoryPoolMXBean> getMemoryPoolMXBeans(boolean bl) {
        ArrayList arrayList = this.managedPoolList;
        return bl ? new ArrayList(arrayList) : arrayList;
    }

    @Override
    public void gc() {
        System.gc();
    }

    private native MemoryUsage getHeapMemoryUsageImpl(Class<MemoryUsage> var1, Constructor<MemoryUsage> var2);

    @Override
    public MemoryUsage getHeapMemoryUsage() {
        if (null != memUsageConstructor) {
            return this.getHeapMemoryUsageImpl(MemoryUsage.class, memUsageConstructor);
        }
        return null;
    }

    private native MemoryUsage getNonHeapMemoryUsageImpl(Class<MemoryUsage> var1, Constructor<MemoryUsage> var2);

    @Override
    public MemoryUsage getNonHeapMemoryUsage() {
        if (null != memUsageConstructor) {
            return this.getNonHeapMemoryUsageImpl(MemoryUsage.class, memUsageConstructor);
        }
        return null;
    }

    private native int getObjectPendingFinalizationCountImpl();

    @Override
    public int getObjectPendingFinalizationCount() {
        return this.getObjectPendingFinalizationCountImpl();
    }

    private native boolean isVerboseImpl();

    @Override
    public boolean isVerbose() {
        return this.isVerboseImpl();
    }

    private native void setVerboseImpl(boolean var1);

    @Override
    public void setVerbose(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        this.setVerboseImpl(bl);
    }

    private native long getMaxHeapSizeLimitImpl();

    public long getMaxHeapSizeLimit() {
        return this.getMaxHeapSizeLimitImpl();
    }

    private native long getMaxHeapSizeImpl();

    public long getMaxHeapSize() {
        return this.getMaxHeapSizeImpl();
    }

    private native long getMinHeapSizeImpl();

    public long getMinHeapSize() {
        return this.getMinHeapSizeImpl();
    }

    private native void setMaxHeapSizeImpl(long var1);

    public void setMaxHeapSize(long l) {
        if (!this.isSetMaxHeapSizeSupported()) {
            throw new UnsupportedOperationException();
        }
        if (l < this.getMinHeapSize() || l > this.getMaxHeapSizeLimit()) {
            throw new IllegalArgumentException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        this.setMaxHeapSizeImpl(l);
    }

    private native boolean isSetMaxHeapSizeSupportedImpl();

    public boolean isSetMaxHeapSizeSupported() {
        return this.isSetMaxHeapSizeSupportedImpl();
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        String[] stringArray = new String[]{"java.management.memory.threshold.exceeded", "java.management.memory.collection.threshold.exceeded"};
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(stringArray, Notification.class.getName(), "Memory Notification");
        return mBeanNotificationInfoArray;
    }

    public long getSharedClassCacheSize() {
        return SharedClassStatistics.maxSizeBytes();
    }

    public long getSharedClassCacheSoftmxBytes() {
        return SharedClassStatistics.softmxBytes();
    }

    public long getSharedClassCacheMinAotBytes() {
        return SharedClassStatistics.minAotBytes();
    }

    public long getSharedClassCacheMaxAotBytes() {
        return SharedClassStatistics.maxAotBytes();
    }

    public long getSharedClassCacheMinJitDataBytes() {
        return SharedClassStatistics.minJitDataBytes();
    }

    public long getSharedClassCacheMaxJitDataBytes() {
        return SharedClassStatistics.maxJitDataBytes();
    }

    private native boolean setSharedClassCacheSoftmxBytesImpl(long var1);

    private native boolean setSharedClassCacheMinAotBytesImpl(long var1);

    private native boolean setSharedClassCacheMaxAotBytesImpl(long var1);

    private native boolean setSharedClassCacheMinJitDataBytesImpl(long var1);

    private native boolean setSharedClassCacheMaxJitDataBytesImpl(long var1);

    public boolean setSharedClassCacheSoftmxBytes(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        return this.setSharedClassCacheSoftmxBytesImpl(l);
    }

    public boolean setSharedClassCacheMinAotBytes(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        return this.setSharedClassCacheMinAotBytesImpl(l);
    }

    public boolean setSharedClassCacheMaxAotBytes(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        return this.setSharedClassCacheMaxAotBytesImpl(l);
    }

    public boolean setSharedClassCacheMinJitDataBytes(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        return this.setSharedClassCacheMinJitDataBytesImpl(l);
    }

    public boolean setSharedClassCacheMaxJitDataBytes(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        return this.setSharedClassCacheMaxJitDataBytesImpl(l);
    }

    private native long getSharedClassCacheSoftmxUnstoredBytesImpl();

    private native long getSharedClassCacheMaxAotUnstoredBytesImpl();

    private native long getSharedClassCacheMaxJitDataUnstoredBytesImpl();

    public long getSharedClassCacheSoftmxUnstoredBytes() {
        return this.getSharedClassCacheSoftmxUnstoredBytesImpl();
    }

    public long getSharedClassCacheMaxAotUnstoredBytes() {
        return this.getSharedClassCacheMaxAotUnstoredBytesImpl();
    }

    public long getSharedClassCacheMaxJitDataUnstoredBytes() {
        return this.getSharedClassCacheMaxJitDataUnstoredBytesImpl();
    }

    public long getSharedClassCacheFreeSpace() {
        return SharedClassStatistics.freeSpaceBytes();
    }

    public String getGCMode() {
        return this.getGCModeImpl();
    }

    private native String getGCModeImpl();

    private native long getGCMasterThreadCpuUsedImpl();

    public long getGCMasterThreadCpuUsed() {
        return this.getGCMasterThreadCpuUsedImpl();
    }

    private native long getGCSlaveThreadsCpuUsedImpl();

    public long getGCSlaveThreadsCpuUsed() {
        return this.getGCSlaveThreadsCpuUsedImpl();
    }

    private native int getMaximumGCThreadsImpl();

    public int getMaximumGCThreads() {
        return this.getMaximumGCThreadsImpl();
    }

    private native int getCurrentGCThreadsImpl();

    public int getCurrentGCThreads() {
        return this.getCurrentGCThreadsImpl();
    }

    @Override
    public ObjectName getObjectName() {
        if (this.objectName == null) {
            this.objectName = ManagementUtils.createObjectName("java.lang:type=Memory");
        }
        return this.objectName;
    }

    protected void startNotificationThread() {
    }

    static {
        Constructor constructor;
        instance = new MemoryMXBeanImpl();
        try {
            constructor = MemoryUsage.class.getConstructor(Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            constructor = null;
        }
        memUsageConstructor = constructor;
    }
}

