/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.javacore;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageRegister;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.ImageStackFrame;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.javacore.JCCorruptData;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class JCImageThread
implements ImageThread {
    private final String fImageThreadID;
    private final ImagePointer fNativeThreadID;
    private Properties fProperties;
    private Vector fRegisters;
    private Vector fStackSections;
    private Vector fStackFrames;
    private ImagePointer fSystemThreadID;

    public JCImageThread(ImagePointer imagePointer) throws JCInvalidArgumentsException {
        if (imagePointer == null) {
            throw new JCInvalidArgumentsException("Must pass a valid threadID pointer");
        }
        this.fImageThreadID = "0x" + Long.toHexString(imagePointer.getAddress());
        this.fNativeThreadID = imagePointer;
        this.fRegisters = new Vector();
        this.fStackSections = new Vector();
        this.fStackFrames = new Vector();
        this.fProperties = new Properties();
    }

    @Override
    public String getID() throws CorruptDataException {
        if (this.fImageThreadID == null) {
            throw new CorruptDataException(new JCCorruptData(null));
        }
        return this.fImageThreadID;
    }

    @Override
    public Properties getProperties() {
        return this.fProperties;
    }

    public void addProperty(Object object, Object object2) {
        this.fProperties.put(object, object2);
    }

    @Override
    public Iterator getRegisters() {
        return this.fRegisters.iterator();
    }

    @Override
    public Iterator getStackSections() {
        return this.fStackSections.iterator();
    }

    @Override
    public Iterator getStackFrames() throws DataUnavailable {
        if (this.fStackFrames.isEmpty()) {
            throw new DataUnavailable("Native stack frame data not available");
        }
        return this.fStackFrames.iterator();
    }

    public void addImageStackFrame(ImageStackFrame imageStackFrame) {
        if (imageStackFrame != null) {
            this.fStackFrames.add(imageStackFrame);
        }
    }

    public void addImageStackSection(ImageSection imageSection) {
        if (imageSection != null) {
            this.fStackSections.add(imageSection);
        }
    }

    public ImagePointer getInternalID() {
        return this.fNativeThreadID;
    }

    public void setSystemThreadID(ImagePointer imagePointer) {
        this.fSystemThreadID = imagePointer;
    }

    public ImagePointer getSystemThreadID() {
        return this.fSystemThreadID;
    }

    public void addRegister(ImageRegister imageRegister) {
        this.fRegisters.add(imageRegister);
    }
}

