/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapMap;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapMapPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_IncrementalGenerationalGCPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MarkMapPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_ParallelGlobalGCPointer;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.io.PrintStream;

public class MarkMapCommand
extends Command {
    protected static GCHeapMap markMap;

    public MarkMapCommand() {
        this.addCommand("markmap", "<command> <object>", "query the markmap");
    }

    private void printHelp(PrintStream printStream) {
        printStream.println("Usage: !markmap <command> <object>");
        printStream.println("Supported commands:");
        printStream.println("   help                    Print the help text");
        printStream.println("   ismarked <object>       Query the markmap to see if <object> is marked");
        printStream.println("   near <object>           Print out marked objects near <object>");
        printStream.println("   scanRange <start> <end> Print out marked objects in the specified range");
        printStream.println("   bits <object>           Show the address of the mark slot corresponding to <object>");
        printStream.println("   fromBits <addr>         Show the heap range covered by a mark slot");
        printStream.println("   source <object>         Try to find out where <object> was relocated from");
        printStream.println("   show                    Display the current markmap in use");
        printStream.println("   set <markMap>           Change the current markmap");
        printStream.println();
        printStream.println("WARNING: markmap data is almost certainly out of date at any time. Interpret these results with extreme care!");
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        String string2;
        if (string.equals("!markmap")) {
            if (stringArray.length < 1) {
                printStream.println("No command specified");
                this.printHelp(printStream);
                return;
            }
            string2 = stringArray[0];
        } else {
            string2 = string.substring("!markmap".length());
        }
        if (string2.equalsIgnoreCase("ismarked")) {
            this.isMarked(stringArray, context, printStream);
        } else if (string2.equalsIgnoreCase("near")) {
            this.near(stringArray, context, printStream);
        } else if (string2.equalsIgnoreCase("bits")) {
            this.markBits(stringArray, context, printStream);
        } else if (string2.equalsIgnoreCase("fromBits")) {
            this.fromBits(stringArray, context, printStream);
        } else if (string2.equalsIgnoreCase("source")) {
            this.findSource(stringArray, context, printStream);
        } else if (string2.equalsIgnoreCase("scanRange")) {
            this.scanRange(stringArray, context, printStream);
        } else if (string2.equalsIgnoreCase("show")) {
            this.showMarkMap(stringArray, context, printStream);
        } else if (string2.equalsIgnoreCase("set")) {
            this.setMarkMap(stringArray, context, printStream);
        } else if (string2.equals("help")) {
            this.printHelp(printStream);
        } else {
            printStream.println("Unrecognised command: " + string2);
            this.printHelp(printStream);
        }
    }

    protected void isMarked(String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            long l = CommandUtils.parsePointer(stringArray[1], J9BuildFlags.env_data64);
            J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(l);
            GCHeapMap.MarkedObject markedObject = markMap.queryObject(j9ObjectPointer);
            if (markedObject != null) {
                if (markedObject.wasRelocated()) {
                    printStream.format("Object %s is marked and relocated to %s\n", markedObject.object.getHexAddress(), markedObject.relocatedObject.getHexAddress());
                } else {
                    printStream.format("Object %s is marked\n", markedObject.object.getHexAddress());
                }
            } else {
                printStream.format("Object %s is not marked\n", j9ObjectPointer.getHexAddress());
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    protected void near(String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            long l = CommandUtils.parsePointer(stringArray[1], J9BuildFlags.env_data64);
            J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(l);
            J9ObjectPointer j9ObjectPointer2 = j9ObjectPointer.untag(markMap.getPageSize(j9ObjectPointer) - 1);
            J9ObjectPointer j9ObjectPointer3 = j9ObjectPointer2.addOffset(markMap.getPageSize(j9ObjectPointer));
            GCHeapMap.MarkedObject[] markedObjectArray = markMap.queryRange(j9ObjectPointer2, j9ObjectPointer3);
            this.reportResults(j9ObjectPointer2, j9ObjectPointer3, markedObjectArray, printStream);
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    protected void scanRange(String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            long l = CommandUtils.parsePointer(stringArray[1], J9BuildFlags.env_data64);
            long l2 = CommandUtils.parsePointer(stringArray[2], J9BuildFlags.env_data64);
            J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(l);
            J9ObjectPointer j9ObjectPointer2 = J9ObjectPointer.cast(l2);
            GCHeapMap.MarkedObject[] markedObjectArray = markMap.queryRange(j9ObjectPointer, j9ObjectPointer2);
            this.reportResults(j9ObjectPointer, j9ObjectPointer2, markedObjectArray, printStream);
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    protected void reportResults(J9ObjectPointer j9ObjectPointer, J9ObjectPointer j9ObjectPointer2, GCHeapMap.MarkedObject[] markedObjectArray, PrintStream printStream) {
        if (markedObjectArray.length == 0) {
            printStream.format("No marked objects in the range %s -> %s\n", j9ObjectPointer.getHexAddress(), j9ObjectPointer2.getHexAddress());
        } else {
            printStream.format("Marked objects in the range %s -> %s\n", j9ObjectPointer.getHexAddress(), j9ObjectPointer2.getHexAddress());
            for (int i = 0; i < markedObjectArray.length; ++i) {
                GCHeapMap.MarkedObject markedObject = markedObjectArray[i];
                if (markedObject.wasRelocated()) {
                    printStream.format("\t!j9object %s -> !j9object %s\n", markedObject.object.getHexAddress(), markedObject.relocatedObject.getHexAddress());
                    continue;
                }
                printStream.format("\t!j9object %s\n", markedObject.object.getHexAddress());
            }
        }
    }

    protected void markBits(String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            long l = CommandUtils.parsePointer(stringArray[1], J9BuildFlags.env_data64);
            J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(l);
            J9ObjectPointer j9ObjectPointer2 = J9ObjectPointer.cast(l).untag(markMap.getPageSize(j9ObjectPointer) - 1);
            J9ObjectPointer j9ObjectPointer3 = j9ObjectPointer2.addOffset(markMap.getPageSize(j9ObjectPointer));
            GCHeapMap.MarkedObject[] markedObjectArray = markMap.queryRange(j9ObjectPointer2, j9ObjectPointer3);
            if (markedObjectArray.length > 0) {
                if (markedObjectArray[0].wasRelocated()) {
                    printStream.format("Mark bits for the compacted range %s -> %s: !j9x %s\n", j9ObjectPointer2.getHexAddress(), j9ObjectPointer3.getHexAddress(), markedObjectArray[0].markBitsSlot.getHexAddress());
                } else {
                    printStream.format("Mark bits for the range %s -> %s: !j9x %s\n", j9ObjectPointer2.getHexAddress(), j9ObjectPointer3.getHexAddress(), markedObjectArray[0].markBitsSlot.getHexAddress());
                }
            } else {
                try {
                    UDATA[] uDATAArray = markMap.getSlotIndexAndMask(j9ObjectPointer2);
                    UDATAPointer uDATAPointer = markMap.getHeapMapBits().add(uDATAArray[0]);
                    printStream.format("Mark bits for the range %s -> %s: !j9x %s\n", j9ObjectPointer2.getHexAddress(), j9ObjectPointer3.getHexAddress(), uDATAPointer.getHexAddress());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    printStream.format("Object %s is not in the heap\n", j9ObjectPointer.getHexAddress());
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    protected void fromBits(String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        long l = CommandUtils.parsePointer(stringArray[1], J9BuildFlags.env_data64);
        UDATAPointer uDATAPointer = UDATAPointer.cast(l);
        UDATAPointer uDATAPointer2 = markMap.getHeapMapBits();
        UDATA uDATA = markMap.getSlotIndexAndMask(J9ObjectPointer.cast(markMap.getHeapTop().subOffset(markMap.getObjectGrain())))[0];
        uDATA = uDATA.add(1L);
        UDATAPointer uDATAPointer3 = uDATAPointer2.add(uDATA);
        if (uDATAPointer.gte(uDATAPointer2) && uDATAPointer.lte(uDATAPointer3)) {
            IDATA iDATA = uDATAPointer.sub(uDATAPointer2);
            int n = markMap.getPageSize(null);
            iDATA = iDATA.mult(n);
            J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(markMap.getHeapBase().addOffset(iDATA));
            J9ObjectPointer j9ObjectPointer2 = j9ObjectPointer.addOffset(n);
            printStream.format("Mark bits at %s corresponds to heap range %s -> %s\n", uDATAPointer.getHexAddress(), j9ObjectPointer.getHexAddress(), j9ObjectPointer2.getHexAddress());
        } else {
            printStream.format("Address %s is not in the mark map\n", uDATAPointer.getHexAddress());
        }
    }

    protected void findSource(String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        try {
            long l = CommandUtils.parsePointer(stringArray[1], J9BuildFlags.env_data64);
            J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(l);
            J9ObjectPointer j9ObjectPointer2 = J9ObjectPointer.cast(markMap.getHeapBase());
            J9ObjectPointer j9ObjectPointer3 = J9ObjectPointer.cast(markMap.getHeapTop());
            if (j9ObjectPointer.gte(j9ObjectPointer2) && j9ObjectPointer.lt(j9ObjectPointer3)) {
                int n = 0;
                while (j9ObjectPointer2.lt(j9ObjectPointer3)) {
                    J9ObjectPointer j9ObjectPointer4 = j9ObjectPointer2;
                    J9ObjectPointer j9ObjectPointer5 = j9ObjectPointer4.addOffset(markMap.getPageSize(j9ObjectPointer2));
                    GCHeapMap.MarkedObject[] markedObjectArray = markMap.queryRange(j9ObjectPointer4, j9ObjectPointer5);
                    for (int i = 0; i < markedObjectArray.length; ++i) {
                        GCHeapMap.MarkedObject markedObject = markedObjectArray[i];
                        if (!markedObject.wasRelocated() || !markedObject.relocatedObject.eq(j9ObjectPointer)) continue;
                        printStream.format("Object %s was relocated to %s\n", markedObject.object.getHexAddress(), markedObject.relocatedObject.getHexAddress());
                        ++n;
                    }
                    j9ObjectPointer2 = j9ObjectPointer5;
                }
                if (n > 0) {
                    printStream.format("%1 relocation candidates found\n", n);
                } else {
                    printStream.format("No relocation candidates found\n", new Object[0]);
                }
            } else {
                printStream.format("Object %s is not in the heap\n", j9ObjectPointer.getHexAddress());
            }
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    protected void showMarkMap(String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        this.showActiveMarkMap(printStream);
        try {
            printStream.format("\nKnown mark maps:\n", new Object[0]);
            MM_GCExtensionsPointer mM_GCExtensionsPointer = GCExtensions.getGCExtensionsPointer();
            if (GCExtensions.isStandardGC()) {
                MM_ParallelGlobalGCPointer mM_ParallelGlobalGCPointer = MM_ParallelGlobalGCPointer.cast(mM_GCExtensionsPointer._globalCollector());
                MM_MarkMapPointer mM_MarkMapPointer = mM_ParallelGlobalGCPointer._markingScheme()._markMap();
                printStream.format("\tactive: %s\n", mM_MarkMapPointer.getHexAddress());
            } else if (GCExtensions.isVLHGC()) {
                MM_IncrementalGenerationalGCPointer mM_IncrementalGenerationalGCPointer = MM_IncrementalGenerationalGCPointer.cast(mM_GCExtensionsPointer._globalCollector());
                printStream.format("\tprevious: %s\n", mM_IncrementalGenerationalGCPointer._markMapManager()._previousMarkMap().getHexAddress());
                printStream.format("\tnext: %s\n", mM_IncrementalGenerationalGCPointer._markMapManager()._nextMarkMap().getHexAddress());
            } else if (GCExtensions.isMetronomeGC()) {
                MM_MarkMapPointer mM_MarkMapPointer = mM_GCExtensionsPointer.realtimeGC()._markingScheme()._markMap();
                printStream.format("\tactive: %s\n", mM_MarkMapPointer.getHexAddress());
            } else {
                printStream.format("\tUnrecognized GC policy!\n", new Object[0]);
            }
            try {
                if (mM_GCExtensionsPointer.referenceChainWalkerMarkMap().notNull()) {
                    printStream.format("\treference chain walker: %s\n", mM_GCExtensionsPointer.referenceChainWalkerMarkMap().getHexAddress());
                }
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
    }

    protected void showActiveMarkMap(PrintStream printStream) {
        printStream.format("Currently active mark map: !mm_heapmap %s\n", markMap.getHeapMap().getHexAddress());
        printStream.format("\tHeap: %s -> %s\n", markMap.getHeapBase().getHexAddress(), markMap.getHeapTop().getHexAddress());
        UDATA uDATA = markMap.getSlotIndexAndMask(J9ObjectPointer.cast(markMap.getHeapTop().subOffset(markMap.getObjectGrain())))[0];
        uDATA = uDATA.add(1L);
        printStream.format("\tBits: %s -> %s\n", markMap.getHeapMapBits().getHexAddress(), markMap.getHeapMapBits().add(uDATA).getHexAddress());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setMarkMap(String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        GCHeapMap gCHeapMap = null;
        try {
            if (stringArray[1].equalsIgnoreCase("active") || stringArray[1].equalsIgnoreCase("default")) {
                gCHeapMap = GCHeapMap.from();
            } else if (stringArray[1].equalsIgnoreCase("previous")) {
                if (!GCExtensions.isVLHGC()) throw new DDRInteractiveCommandException("Only valid when running balanced!");
                MM_GCExtensionsPointer mM_GCExtensionsPointer = GCExtensions.getGCExtensionsPointer();
                MM_IncrementalGenerationalGCPointer mM_IncrementalGenerationalGCPointer = MM_IncrementalGenerationalGCPointer.cast(mM_GCExtensionsPointer._globalCollector());
                gCHeapMap = GCHeapMap.fromHeapMap(mM_IncrementalGenerationalGCPointer._markMapManager()._previousMarkMap());
            } else if (stringArray[1].equalsIgnoreCase("next")) {
                if (!GCExtensions.isVLHGC()) throw new DDRInteractiveCommandException("Only valid when running balanced!");
                MM_GCExtensionsPointer mM_GCExtensionsPointer = GCExtensions.getGCExtensionsPointer();
                MM_IncrementalGenerationalGCPointer mM_IncrementalGenerationalGCPointer = MM_IncrementalGenerationalGCPointer.cast(mM_GCExtensionsPointer._globalCollector());
                gCHeapMap = GCHeapMap.fromHeapMap(mM_IncrementalGenerationalGCPointer._markMapManager()._nextMarkMap());
            } else {
                long l = CommandUtils.parsePointer(stringArray[1], J9BuildFlags.env_data64);
                MM_HeapMapPointer mM_HeapMapPointer = MM_HeapMapPointer.cast(l);
                gCHeapMap = GCHeapMap.fromHeapMap(mM_HeapMapPointer);
            }
            gCHeapMap.queryObject(J9ObjectPointer.cast(gCHeapMap.getHeapBase()));
            gCHeapMap.queryObject(J9ObjectPointer.cast(gCHeapMap.getHeapTop().subOffset(gCHeapMap.getObjectGrain())));
        }
        catch (CorruptDataException corruptDataException) {
            throw new DDRInteractiveCommandException(corruptDataException);
        }
        if (gCHeapMap == null) return;
        markMap = gCHeapMap;
        this.showActiveMarkMap(printStream);
    }

    static {
        try {
            markMap = GCHeapMap.from();
        }
        catch (CorruptDataException corruptDataException) {
            markMap = null;
        }
    }
}

