/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.tdump.zebedee.util;

import com.ibm.j9ddr.corereaders.tdump.zebedee.util.InvalidTemplateFile;
import com.ibm.j9ddr.corereaders.tdump.zebedee.util.TemplateField;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Template {
    private String templateName;
    private HashMap fieldNameTable = new HashMap();
    private ArrayList fields = new ArrayList();
    private int length;
    private static HashMap templateMap = new HashMap();
    private static Logger log = Logger.getLogger("j9ddr.core_readers");

    public static Template getTemplate(String string) throws FileNotFoundException, InvalidTemplateFile {
        Template template = (Template)templateMap.get(string);
        if (template == null) {
            template = new Template(string);
            templateMap.put(string, template);
        }
        return template;
    }

    private Template(String string) throws FileNotFoundException, InvalidTemplateFile {
        InputStream inputStream;
        log.fine("creating new template from file: " + string);
        if (string.charAt(0) == '/') {
            inputStream = Template.class.getResourceAsStream(string);
            if (inputStream == null) {
                throw new FileNotFoundException("getResourceAsStream failed for " + string);
            }
        } else {
            inputStream = new FileInputStream(string);
        }
        this.create(inputStream);
    }

    private void create(InputStream inputStream) throws InvalidTemplateFile {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(true);
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new Error("unexpected error: " + parserConfigurationException);
        }
        ErrorHandler errorHandler = new ErrorHandler(){

            @Override
            public void error(SAXParseException sAXParseException) throws SAXException {
                throw sAXParseException;
            }

            @Override
            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                throw sAXParseException;
            }

            @Override
            public void warning(SAXParseException sAXParseException) throws SAXException {
                throw sAXParseException;
            }
        };
        documentBuilder.setErrorHandler(errorHandler);
        EntityResolver entityResolver = new EntityResolver(){

            @Override
            public InputSource resolveEntity(String string, String string2) {
                if (string2.equals("file://template.dtd")) {
                    InputStream inputStream = this.getClass().getResourceAsStream("template.dtd");
                    if (inputStream == null) {
                        throw new Error("could not load template.dtd");
                    }
                    return new InputSource(inputStream);
                }
                return null;
            }
        };
        documentBuilder.setEntityResolver(entityResolver);
        Document document = null;
        try {
            document = documentBuilder.parse(inputStream);
        }
        catch (SAXParseException sAXParseException) {
            throw new InvalidTemplateFile("bad xml: " + sAXParseException + " line number " + sAXParseException.getLineNumber());
        }
        catch (SAXException sAXException) {
            throw new InvalidTemplateFile("bad xml: " + sAXException);
        }
        catch (IOException iOException) {
            throw new Error("unexpected error: " + iOException);
        }
        Element element = document.getDocumentElement();
        Element element2 = null;
        this.templateName = element.getAttribute("name");
        log.fine("creating type " + this.templateName);
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            element2 = (Element)node;
            break;
        }
        this.length = this.createTemplateFields(element2, "", 0) / 8;
    }

    public String templateName() {
        return this.templateName;
    }

    public TemplateField getField(String string) throws NoSuchFieldException {
        TemplateField templateField = (TemplateField)this.fieldNameTable.get(string);
        if (templateField == null) {
            throw new NoSuchFieldException("no field with name " + string + " in template " + this.templateName);
        }
        return templateField;
    }

    public List getFields() {
        return this.fields;
    }

    public int getOffset(String string) throws NoSuchFieldException {
        return this.getField(string).getOffset();
    }

    private int createTemplateFields(Element element, String string, int n) {
        boolean bl = element.hasAttribute("union");
        int n2 = 0;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            if (node.getNodeType() != 1 || (element2 = (Element)node).getTagName().equals("pointer")) continue;
            String string2 = element2.getAttribute("name");
            String string3 = string.length() > 0 ? string + "." + string2 : string2;
            log.fine("creating field " + string3 + " at bit offset 0x" + Template.hex(n));
            TemplateField templateField = new TemplateField(string3, this, element2, n);
            this.fieldNameTable.put(string3, templateField);
            this.fieldNameTable.put(string2, templateField);
            this.fields.add(templateField);
            if (!element2.getTagName().equals("array")) {
                this.createTemplateFields(element2, string3, n);
            }
            if (bl) {
                if (templateField.bitLength() <= n2) continue;
                n2 = templateField.bitLength();
                continue;
            }
            n += templateField.bitLength();
        }
        return n + n2;
    }

    public int length() {
        return this.length;
    }

    private static String hex(long l) {
        return Long.toHexString(l);
    }

    private static String hex(int n) {
        return Integer.toHexString(n);
    }

    private static String pad(String string, int n) {
        for (int i = string.length(); i < n; ++i) {
            string = " " + string;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(stringArray[0]);
        }
        catch (Exception exception) {
            System.err.println("Could not create output file " + stringArray[0] + ": " + exception);
            System.exit(1);
        }
        PrintStream printStream = new PrintStream(fileOutputStream);
        for (int i = 1; i < stringArray.length; ++i) {
            try {
                Template template = Template.getTemplate(stringArray[i]);
                printStream.println("=== " + template.templateName() + " ===");
                printStream.println("");
                printStream.println("Offset  Length  Field");
                printStream.println("======  ======  =====");
                printStream.println("");
                for (TemplateField templateField : template.fields) {
                    String string = Template.pad(Template.hex(templateField.getOffset()), 6);
                    String string2 = null;
                    string2 = templateField.isBitField() ? Template.pad("" + templateField.bitLength() + " b", 6) : Template.pad("" + templateField.byteLength(), 6);
                    printStream.println(string + "  " + string2 + "  " + templateField.getName());
                }
                if (i >= stringArray.length - 1) continue;
                printStream.println("");
                printStream.println("");
                continue;
            }
            catch (Exception exception) {
                System.out.println("Unexpected exception: " + exception);
                return;
            }
        }
    }
}

