/*
 * Decompiled with CFR 0.152.
 */
package openj9.tools.attach.diagnostics.base;

import com.ibm.oti.vm.VM;
import com.ibm.tools.attach.target.IPC;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import openj9.management.internal.LockInfoBase;
import openj9.management.internal.ThreadInfoBase;
import openj9.tools.attach.diagnostics.base.DiagnosticProperties;

public class DiagnosticUtils {
    public static final String DIAGNOSTICS_THREAD_PRINT = "Thread.print";
    public static final String DIAGNOSTICS_GC_RUN = "GC.run";
    public static final String DIAGNOSTICS_GC_CLASS_HISTOGRAM = "GC.class_histogram";
    public static final String COMMAND_STRING = "command_string";
    public static final String DIAGNOSTICS_OPTION_SEPARATOR = ",";
    public static final String LIVE_OPTION = "live";
    private static final String THREAD_LOCKED_SYNCHRONIZERS_OPTION = "-l";
    private static final Map<String, Function<String, DiagnosticProperties>> commandTable = new HashMap<String, Function<String, DiagnosticProperties>>();

    public static String makeHeapHistoCommand(boolean bl) {
        String string = DIAGNOSTICS_GC_CLASS_HISTOGRAM;
        if (bl) {
            string = "GC.class_histogram,live";
        }
        return string;
    }

    public static String makeThreadPrintCommand(boolean bl) {
        String string = bl ? "Thread.print,-l" : DIAGNOSTICS_THREAD_PRINT;
        return string;
    }

    private static native String getHeapClassStatisticsImpl();

    public static DiagnosticProperties executeDiagnosticCommand(String string) {
        DiagnosticProperties diagnosticProperties;
        IPC.logMessage("executeDiagnosticCommand: ", string);
        String[] stringArray = string.split(DIAGNOSTICS_OPTION_SEPARATOR);
        Function<String, DiagnosticProperties> function = commandTable.get(stringArray[0]);
        if (null == function) {
            diagnosticProperties = DiagnosticProperties.makeStatusProperties(true, "Command " + string + " not recognized");
        } else {
            diagnosticProperties = function.apply(string);
            diagnosticProperties.put(COMMAND_STRING, string);
        }
        return diagnosticProperties;
    }

    private static DiagnosticProperties getHeapStatistics(String string) {
        boolean bl = Arrays.stream(string.split(DIAGNOSTICS_OPTION_SEPARATOR)).anyMatch(Predicate.isEqual(LIVE_OPTION));
        if (bl) {
            DiagnosticUtils.runGC();
        }
        String string2 = DiagnosticUtils.getHeapClassStatisticsImpl();
        String string3 = System.lineSeparator();
        if (!"\n".equals(string3)) {
            string2 = string2.replace("\n", string3);
        }
        return DiagnosticProperties.makeStringResult(string2);
    }

    private static DiagnosticProperties getThreadInfo(String string) {
        Object object;
        DiagnosticProperties diagnosticProperties = null;
        boolean bl = true;
        boolean bl2 = false;
        String[] stringArray = string.split(DIAGNOSTICS_OPTION_SEPARATOR);
        if (stringArray.length > 2) {
            bl = false;
        } else if (stringArray.length == 2) {
            object = stringArray[1];
            if (((String)object).startsWith(THREAD_LOCKED_SYNCHRONIZERS_OPTION)) {
                if (THREAD_LOCKED_SYNCHRONIZERS_OPTION.length() == ((String)object).length() || ((String)object).toLowerCase().equals("-l=true")) {
                    bl2 = true;
                }
            } else {
                bl = false;
            }
        }
        if (!bl) {
            diagnosticProperties = DiagnosticProperties.makeErrorProperties("Command not recognized: " + string);
        } else {
            ThreadInfoBase[] threadInfoBaseArray;
            object = new StringWriter(2000);
            PrintWriter printWriter = new PrintWriter((Writer)object);
            printWriter.println(System.getProperty("java.vm.info"));
            printWriter.println();
            for (ThreadInfoBase threadInfoBase : threadInfoBaseArray = DiagnosticUtils.dumpAllThreadsImpl(true, bl2, Integer.MAX_VALUE)) {
                printWriter.print(threadInfoBase.toString());
                if (bl2) {
                    LockInfoBase[] lockInfoBaseArray = threadInfoBase.getLockedSynchronizers();
                    printWriter.printf("%n\tLocked ownable synchronizers: %d%n", lockInfoBaseArray.length);
                    for (LockInfoBase lockInfoBase : lockInfoBaseArray) {
                        printWriter.printf("\t- %s%n", lockInfoBase.toString());
                    }
                }
                printWriter.println();
            }
            printWriter.flush();
            diagnosticProperties = DiagnosticProperties.makeStringResult(((StringWriter)object).toString());
        }
        return diagnosticProperties;
    }

    private static native ThreadInfoBase[] dumpAllThreadsImpl(boolean var0, boolean var1, int var2);

    private static DiagnosticProperties runGC() {
        VM.globalGC();
        return DiagnosticProperties.makeCommandSucceeded();
    }

    static {
        commandTable.put(DIAGNOSTICS_GC_CLASS_HISTOGRAM, DiagnosticUtils::getHeapStatistics);
        commandTable.put(DIAGNOSTICS_GC_RUN, string -> DiagnosticUtils.runGC());
        commandTable.put(DIAGNOSTICS_THREAD_PRINT, DiagnosticUtils::getThreadInfo);
    }
}

