/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import com.ibm.jvm.DumpConfigurationUnavailableException;
import com.ibm.jvm.DumpPermission;
import com.ibm.jvm.InvalidDumpOptionException;
import com.ibm.jvm.ToolDumpPermission;
import com.ibm.oti.vm.VM;

public class Dump {
    private static final String SystemRequestPrefix = "z/OS".equalsIgnoreCase(System.getProperty("os.name")) ? "system:dsn=" : "system:file=";
    private static final DumpPermission DUMP_PERMISSION = new DumpPermission();
    private static final ToolDumpPermission TOOL_DUMP_PERMISSION = new ToolDumpPermission();
    private static final String LEGACY_DUMP_PERMISSION_PROPERTY = "com.ibm.jvm.enableLegacyDumpSecurity";
    private static final DumpOptionsLock dumpLock = new DumpOptionsLock();

    public static void JavaDump() {
        Dump.checkLegacySecurityPermssion();
        Dump.JavaDumpImpl();
    }

    public static void HeapDump() {
        Dump.checkLegacySecurityPermssion();
        Dump.HeapDumpImpl();
    }

    public static void SystemDump() {
        Dump.checkLegacySecurityPermssion();
        Dump.SystemDumpImpl();
    }

    private Dump() {
    }

    private static native int JavaDumpImpl();

    private static native int HeapDumpImpl();

    private static native int SystemDumpImpl();

    public static void SnapDump() {
        Dump.checkLegacySecurityPermssion();
        Dump.SnapDumpImpl();
    }

    private static native int SnapDumpImpl();

    public static String javaDumpToFile(String string) throws InvalidDumpOptionException {
        String string2 = null;
        if ("".equals(string)) {
            string = null;
        }
        if (string != null) {
            Dump.checkForExtraOptions(string);
            string2 = "java:file=" + string;
        } else {
            string2 = "java";
        }
        String string3 = null;
        string3 = Dump.triggerDump(string2, "javaDumpToFile");
        return string3;
    }

    public static String javaDumpToFile() {
        try {
            return Dump.triggerDump("java", "javaDumpToFile");
        }
        catch (InvalidDumpOptionException invalidDumpOptionException) {
            return null;
        }
    }

    public static String heapDumpToFile(String string) throws InvalidDumpOptionException {
        String string2 = null;
        if ("".equals(string)) {
            string = null;
        }
        if (string != null) {
            Dump.checkForExtraOptions(string);
            string2 = "heap:file=" + string + ",";
        } else {
            string2 = "heap:";
        }
        string2 = string2 + "opts=PHD";
        String string3 = null;
        string3 = Dump.triggerDump(string2, "heapDumpToFile");
        return string3;
    }

    public static String heapDumpToFile() {
        try {
            return Dump.triggerDump("heap:opts=PHD", "heapDumpToFile");
        }
        catch (InvalidDumpOptionException invalidDumpOptionException) {
            return null;
        }
    }

    public static String systemDumpToFile(String string) throws InvalidDumpOptionException {
        String string2 = null;
        if ("".equals(string)) {
            string = null;
        }
        if (string != null) {
            Dump.checkForExtraOptions(string);
            string2 = SystemRequestPrefix + string;
        } else {
            string2 = "system";
        }
        String string3 = null;
        string3 = Dump.triggerDump(string2, "systemDumpToFile");
        return string3;
    }

    public static String systemDumpToFile() {
        try {
            return Dump.triggerDump("system", "systemDumpToFile");
        }
        catch (InvalidDumpOptionException invalidDumpOptionException) {
            return null;
        }
    }

    public static String snapDumpToFile(String string) throws InvalidDumpOptionException {
        String string2 = null;
        if ("".equals(string)) {
            string = null;
        }
        if (string != null) {
            Dump.checkForExtraOptions(string);
            string2 = "snap:file=" + string;
        } else {
            string2 = "snap";
        }
        String string3 = null;
        string3 = Dump.triggerDump(string2, "snapDumpToFile");
        return string3;
    }

    public static String snapDumpToFile() {
        try {
            return Dump.triggerDump("snap", "snapDumpToFile");
        }
        catch (InvalidDumpOptionException invalidDumpOptionException) {
            return null;
        }
    }

    private static void checkForExtraOptions(String string) throws InvalidDumpOptionException {
        if (string.contains(",")) {
            throw new InvalidDumpOptionException("Invalid dump filename specified.");
        }
    }

    private static void checkDumpSecurityPermssion() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(DUMP_PERMISSION);
        }
    }

    private static void checkToolSecurityPermssion() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(TOOL_DUMP_PERMISSION);
        }
    }

    private static void checkLegacySecurityPermssion() throws SecurityException {
        if (!"false".equalsIgnoreCase(VM.getVMLangAccess().internalGetProperties().getProperty(LEGACY_DUMP_PERMISSION_PROPERTY))) {
            Dump.checkDumpSecurityPermssion();
        }
    }

    public static String triggerDump(String string) throws InvalidDumpOptionException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (Dump.isToolDump(string)) {
            Dump.checkToolSecurityPermssion();
        }
        return Dump.triggerDump(string, "triggerDump");
    }

    private static String triggerDump(String string, String string2) throws InvalidDumpOptionException {
        Dump.checkDumpSecurityPermssion();
        return Dump.triggerDumpsImpl(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDumpOptions(String string) throws InvalidDumpOptionException, DumpConfigurationUnavailableException {
        Dump.checkDumpSecurityPermssion();
        if (Dump.isToolDump(string)) {
            Dump.checkToolSecurityPermssion();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        DumpOptionsLock dumpOptionsLock = dumpLock;
        synchronized (dumpOptionsLock) {
            Dump.setDumpOptionsImpl(string);
        }
    }

    public static String[] queryDumpOptions() {
        Dump.checkDumpSecurityPermssion();
        String string = Dump.queryDumpOptionsImpl();
        if (string != null) {
            if ("".equals(string)) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            return string.split("\n");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetDumpOptions() throws DumpConfigurationUnavailableException {
        Dump.checkDumpSecurityPermssion();
        DumpOptionsLock dumpOptionsLock = dumpLock;
        synchronized (dumpOptionsLock) {
            Dump.resetDumpOptionsImpl();
        }
    }

    private static native void setDumpOptionsImpl(String var0) throws InvalidDumpOptionException, DumpConfigurationUnavailableException;

    private static native String queryDumpOptionsImpl();

    private static native void resetDumpOptionsImpl() throws DumpConfigurationUnavailableException;

    private static native String triggerDumpsImpl(String var0, String var1) throws InvalidDumpOptionException;

    private static native boolean isToolDump(String var0);

    private static final class DumpOptionsLock {
        private DumpOptionsLock() {
        }
    }
}

