/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.lang.management.internal;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.IOException;
import java.lang.management.MemoryType;
import java.lang.management.PlatformManagedObject;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public final class ManagementUtils {
    private static final String NOTIFICATION_EMITTER_TYPE = "javax.management.NotificationEmitter";
    private static final boolean isUnix;
    public static final boolean VERBOSE_MODE;
    public static final String BUFFERPOOL_MXBEAN_DOMAIN_TYPE = "java.nio:type=BufferPool";

    public static void verifyFieldTypes(CompositeData compositeData, String[] stringArray, String[] stringArray2) {
        Object[] objectArray = compositeData.getAll(stringArray);
        if (objectArray.length != stringArray2.length) {
            throw new IllegalArgumentException(Msg.getString("K05E8"));
        }
        for (int i = 0; i < objectArray.length; ++i) {
            String string;
            String string2;
            Object object = objectArray[i];
            if (object == null || (string2 = object.getClass().getName()).equals(string = stringArray2[i]) || (string.equals(CompositeData.class.getName()) ? object instanceof CompositeData : string.equals(TabularData.class.getName()) && object instanceof TabularData)) continue;
            throw new IllegalArgumentException(Msg.getString("K05E9", (Object)string, string2));
        }
    }

    public static void verifyFieldNames(CompositeData compositeData, String[] stringArray) {
        for (String string : stringArray) {
            if (compositeData.containsKey(string)) continue;
            throw new IllegalArgumentException(Msg.getString("K05EA", string));
        }
    }

    public static void verifyFieldNumber(CompositeData compositeData, int n) {
        if (compositeData == null) {
            throw new NullPointerException(Msg.getString("K05EB"));
        }
        if (compositeData.values().size() != n) {
            throw new IllegalArgumentException(Msg.getString("K05EC"));
        }
    }

    public static List<String> convertStringArrayToList(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public static Object convertTabularDataToMap(TabularData tabularData) {
        if (tabularData == null) {
            return null;
        }
        Set<String> set = tabularData.getTabularType().getRowType().keySet();
        if (set.size() != 2) {
            throw new IllegalArgumentException(Msg.getString("K05ED"));
        }
        String[] stringArray = set.toArray(new String[2]);
        Collection<?> collection = tabularData.values();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(collection.size());
        for (CompositeData compositeData : collection) {
            hashMap.put(compositeData.get(stringArray[0]), compositeData.get(stringArray[1]));
        }
        return hashMap;
    }

    private static <T> T convertFromCompositeData(CompositeData compositeData, Class<T> clazz) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (compositeData == null) {
            return null;
        }
        Method method = clazz.getMethod("from", CompositeData.class);
        return clazz.cast(method.invoke(null, compositeData));
    }

    public static <T> T convertFromOpenType(Object object, Class<?> clazz, Class<T> clazz2) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        if (object == null) {
            return null;
        }
        Object object2 = null;
        if (clazz.isArray() && clazz2.isArray()) {
            Class<?> clazz3 = clazz.getComponentType();
            Class<?> clazz4 = clazz2.getComponentType();
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            object2 = Array.newInstance(clazz4, n);
            for (int i = 0; i < n; ++i) {
                Array.set(object2, i, ManagementUtils.convertFromOpenType(objectArray[i], clazz3, clazz4));
            }
        } else if (clazz.equals(CompositeData.class)) {
            object2 = ManagementUtils.convertFromCompositeData((CompositeData)object, clazz2);
        } else if (clazz.equals(TabularData.class)) {
            if (clazz2.equals(Map.class)) {
                object2 = ManagementUtils.convertTabularDataToMap((TabularData)object);
            }
        } else if (clazz.equals(String[].class)) {
            if (clazz2.equals(List.class)) {
                object2 = ManagementUtils.convertStringArrayToList((String[])object);
            }
        } else if (clazz.equals(String.class) && clazz2.equals(MemoryType.class)) {
            object2 = ManagementUtils.convertStringToMemoryType((String)object);
        }
        return (T)object2;
    }

    private static MemoryType convertStringToMemoryType(String string) {
        MemoryType memoryType;
        block2: {
            memoryType = null;
            try {
                memoryType = MemoryType.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!VERBOSE_MODE) break block2;
                illegalArgumentException.printStackTrace(System.err);
            }
        }
        return memoryType;
    }

    public static TabularData toSystemPropertiesTabularData(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        TabularDataSupport tabularDataSupport = null;
        try {
            String[] stringArray = new String[]{"key", "value"};
            String[] stringArray2 = new String[]{"key", "value"};
            OpenType[] openTypeArray = new OpenType[]{SimpleType.STRING, SimpleType.STRING};
            CompositeType compositeType = new CompositeType(map.getClass().getName(), map.getClass().getName(), stringArray, stringArray2, openTypeArray);
            TabularType tabularType = new TabularType(map.getClass().getName(), map.getClass().getName(), compositeType, new String[]{"key"});
            tabularDataSupport = new TabularDataSupport(tabularType);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                tabularDataSupport.put(new CompositeDataSupport(compositeType, stringArray, new String[]{string, string2}));
            }
        }
        catch (OpenDataException openDataException) {
            if (VERBOSE_MODE) {
                openDataException.printStackTrace(System.err);
            }
            tabularDataSupport = null;
        }
        return tabularDataSupport;
    }

    public static Class<?> getClassMaybePrimitive(String string) throws ClassNotFoundException {
        Class<Object> clazz;
        int n = string.lastIndexOf(46);
        if (n != -1 && (clazz = System.getSecurityManager()) != null) {
            ((SecurityManager)((Object)clazz)).checkPackageAccess(string.substring(0, n));
        }
        clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (string.equals(Boolean.TYPE.getName())) {
                clazz = Boolean.TYPE;
            }
            if (string.equals(Character.TYPE.getName())) {
                clazz = Character.TYPE;
            }
            if (string.equals(Byte.TYPE.getName())) {
                clazz = Byte.TYPE;
            }
            if (string.equals(Short.TYPE.getName())) {
                clazz = Short.TYPE;
            }
            if (string.equals(Integer.TYPE.getName())) {
                clazz = Integer.TYPE;
            }
            if (string.equals(Long.TYPE.getName())) {
                clazz = Long.TYPE;
            }
            if (string.equals(Float.TYPE.getName())) {
                clazz = Float.TYPE;
            }
            if (string.equals(Double.TYPE.getName())) {
                clazz = Double.TYPE;
            }
            if (string.equals(Void.TYPE.getName())) {
                clazz = Void.TYPE;
            }
            if (VERBOSE_MODE) {
                classNotFoundException.printStackTrace(System.err);
            }
            throw classNotFoundException;
        }
        return clazz;
    }

    public static boolean isWrapperClass(Class<?> clazz, Class<?> clazz2) {
        boolean bl = true;
        if (clazz2.equals(Boolean.TYPE) && !clazz.equals(Boolean.class)) {
            bl = false;
        } else if (clazz2.equals(Character.TYPE) && !clazz.equals(Character.class)) {
            bl = false;
        } else if (clazz2.equals(Byte.TYPE) && !clazz.equals(Byte.class)) {
            bl = false;
        } else if (clazz2.equals(Short.TYPE) && !clazz.equals(Short.class)) {
            bl = false;
        } else if (clazz2.equals(Integer.TYPE) && !clazz.equals(Integer.class)) {
            bl = false;
        } else if (clazz2.equals(Long.TYPE) && !clazz.equals(Long.class)) {
            bl = false;
        } else if (clazz2.equals(Float.TYPE) && !clazz.equals(Float.class)) {
            bl = false;
        } else if (clazz2.equals(Double.TYPE) && !clazz.equals(Double.class)) {
            bl = false;
        }
        return bl;
    }

    public static boolean isANotificationEmitter(MBeanServerConnection mBeanServerConnection, ObjectName objectName) throws IOException, IllegalArgumentException {
        boolean bl = false;
        try {
            bl = mBeanServerConnection.isInstanceOf(objectName, NOTIFICATION_EMITTER_TYPE);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            bl = false;
        }
        return bl;
    }

    public static boolean isRunningOnUnix() {
        return isUnix;
    }

    public static ObjectName createObjectName(String string) {
        try {
            return ObjectName.getInstance(string);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            if (VERBOSE_MODE) {
                malformedObjectNameException.printStackTrace();
            }
            return null;
        }
    }

    public static ObjectName createObjectName(String string, String string2) {
        try {
            return ObjectName.getInstance(string + ",name=" + string2);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            if (VERBOSE_MODE) {
                malformedObjectNameException.printStackTrace();
            }
            return null;
        }
    }

    public static ObjectName checkNamedMXBean(String string, Class<?> clazz) {
        if (string == null) {
            throw new NullPointerException(Msg.getString("K0603"));
        }
        if (clazz == null) {
            throw new NullPointerException(Msg.getString("K0614"));
        }
        ObjectName objectName = Metadata.makeObjectName(string);
        ObjectName[] objectNameArray = Metadata.objectNamesByInterface.get(clazz);
        if (objectNameArray != null) {
            for (ObjectName objectName2 : objectNameArray) {
                if (!objectName2.apply(objectName)) continue;
                return objectName;
            }
            String string2 = objectName.getDomain();
            String string3 = objectName.getKeyProperty("type");
            for (ObjectName objectName3 : objectNameArray) {
                if (!string2.equals(objectName3.getDomain()) || !Objects.equals(string3, objectName3.getKeyProperty("type"))) continue;
                return objectName;
            }
        }
        throw new IllegalArgumentException(Msg.getString("K0605", (Object)string, clazz.getName()));
    }

    public static void checkSupported(Class<?> clazz) {
        if (!Metadata.managementInterfaces.contains(clazz)) {
            throw new IllegalArgumentException(Msg.getString("K0601", clazz.getName()));
        }
    }

    public static void checkSupportedSingleton(Class<?> clazz) {
        ManagementUtils.checkSupported(clazz);
        if (Metadata.isMultiInstanceBeanInterface(clazz)) {
            throw new IllegalArgumentException(Msg.getString("K0602", clazz.getName()));
        }
    }

    public static Set<PlatformManagedObject> getAllAvailableMXBeans() {
        HashSet<PlatformManagedObject> hashSet = new HashSet<PlatformManagedObject>();
        for (List<PlatformManagedObject> list : Metadata.beansByInterface.values()) {
            hashSet.addAll(list);
        }
        return hashSet;
    }

    public static Set<Class<? extends PlatformManagedObject>> getPlatformManagementInterfaces() {
        return Collections.unmodifiableSet(Metadata.managementInterfaces);
    }

    public static <T extends PlatformManagedObject> T getPlatformMXBean(Class<T> clazz) {
        PlatformManagedObject platformManagedObject;
        ManagementUtils.checkSupportedSingleton(clazz);
        List<PlatformManagedObject> list = Metadata.beansByInterface.get(clazz);
        if (list != null && list.size() == 1 && clazz.isAssignableFrom((platformManagedObject = list.get(0)).getClass())) {
            return (T)((PlatformManagedObject)clazz.cast(platformManagedObject));
        }
        return null;
    }

    public static <T extends PlatformManagedObject> List<T> getPlatformMXBeans(Class<T> clazz) throws IllegalArgumentException {
        ManagementUtils.checkSupported(clazz);
        LinkedList<T> linkedList = new LinkedList<T>();
        List<PlatformManagedObject> list = Metadata.beansByInterface.get(clazz);
        if (list != null) {
            for (PlatformManagedObject platformManagedObject : list) {
                linkedList.add(clazz.cast(platformManagedObject));
            }
        }
        return linkedList;
    }

    static {
        Properties properties = VM.getVMLangAccess().internalGetProperties();
        String string = properties.getProperty("os.name");
        isUnix = "aix".equalsIgnoreCase(string) || "linux".equalsIgnoreCase(string) || "mac os x".equalsIgnoreCase(string) || "z/OS".equalsIgnoreCase(string);
        VERBOSE_MODE = properties.getProperty("com.ibm.lang.management.verbose") != null;
    }

    private static final class Metadata {
        static final Map<Class<?>, List<PlatformManagedObject>> beansByInterface = new HashMap();
        static final Set<Class<? extends PlatformManagedObject>> managementInterfaces = new HashSet<Class<? extends PlatformManagedObject>>();
        static final Set<Class<?>> multiInstanceBeanInterfaces = new HashSet();
        static final Map<Class<?>, ObjectName[]> objectNamesByInterface = new HashMap();

        private Metadata() {
        }

        static ObjectName makeObjectName(String string) {
            try {
                return ObjectName.getInstance(string);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw new IllegalArgumentException(Msg.getString("K0604", string), malformedObjectNameException);
            }
        }

        static boolean isMultiInstanceBeanInterface(Class<?> clazz) {
            return multiInstanceBeanInterfaces.contains(clazz);
        }

        static {
            Component.registerAll();
        }
    }

    private static final class Component<T extends PlatformManagedObject> {
        private static final String GUEST_OPERATING_SYSTEM_MXBEAN_NAME = "com.ibm.virtualization.management:type=GuestOS";
        private static final String HYPERVISOR_MXBEAN_NAME = "com.ibm.virtualization.management:type=Hypervisor";
        private static final String JVM_CPU_MONITOR_MXBEAN_NAME = "com.ibm.lang.management:type=JvmCpuMonitor";
        private static final String OPENJ9_DIAGNOSTICS_MXBEAN_NAME = "openj9.lang.management:type=OpenJ9Diagnostics";
        private final Map<ObjectName, PlatformManagedObject> beansByName;
        private final Set<Class<?>> interfaceTypes;
        private final boolean isSingleton;

        static void registerAll() {
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
            super.validateAndRegister();
        }

        private static <T> void addNew(Set<T> set, T t) {
            if (!set.add(t)) {
                throw new IllegalArgumentException();
            }
        }

        private static void checkNames(Collection<? extends PlatformManagedObject> collection, ObjectName objectName) {
            for (PlatformManagedObject platformManagedObject : collection) {
                ObjectName objectName2 = platformManagedObject.getObjectName();
                if (!objectName.apply(objectName2)) {
                    throw new IllegalArgumentException(Msg.getString("K0615", (Object)objectName2.getCanonicalName(), objectName));
                }
                if (!objectName2.isPattern()) continue;
                throw new IllegalArgumentException(Msg.getString("K0616", objectName2.getCanonicalName()));
            }
        }

        private static <T extends PlatformManagedObject> Component<T> create(String string, T t) {
            return new Component<T>(string, t);
        }

        private static <T extends PlatformManagedObject> Component<T> create(String string, Collection<? extends T> collection) {
            return new Component<T>(string + ",name=*", collection);
        }

        private static <T> List<T> excluding(List<T> list, Class<?> clazz) {
            ArrayList<T> arrayList = new ArrayList<T>();
            for (T t : list) {
                if (clazz.isInstance(t)) continue;
                arrayList.add(t);
            }
            return arrayList;
        }

        private static <K, V> void putNew(Map<K, V> map, K k, V v) {
            if (map.containsKey(k)) {
                throw new IllegalArgumentException();
            }
            map.put(k, v);
        }

        private Component(String string, T t) {
            ObjectName objectName = Metadata.makeObjectName(string);
            if (objectName.isPattern()) {
                throw new IllegalArgumentException(string);
            }
            if (t == null) {
                this.beansByName = Collections.emptyMap();
            } else {
                Component.checkNames(Collections.singleton(t), objectName);
                this.beansByName = Collections.singletonMap(objectName, t);
            }
            this.interfaceTypes = new HashSet();
            this.isSingleton = true;
        }

        private Component(String string, Collection<? extends T> collection) {
            ObjectName objectName = Metadata.makeObjectName(string);
            if (!objectName.isPattern()) {
                throw new IllegalArgumentException(string);
            }
            Component.checkNames(collection, objectName);
            this.beansByName = new HashMap<ObjectName, PlatformManagedObject>(collection.size());
            this.interfaceTypes = new HashSet();
            this.isSingleton = true;
            for (PlatformManagedObject platformManagedObject : collection) {
                Component.putNew(this.beansByName, platformManagedObject.getObjectName(), platformManagedObject);
            }
        }

        private Component<T> addInterface(Class<? super T> clazz) {
            Component.addNew(this.interfaceTypes, clazz);
            return this;
        }

        private Component<T> addInterfaceIf(Class<?> clazz, boolean bl) {
            if (bl) {
                for (PlatformManagedObject platformManagedObject : this.beansByName.values()) {
                    if (clazz.isInstance(platformManagedObject)) continue;
                    throw new IllegalArgumentException();
                }
                Component.addNew(this.interfaceTypes, clazz);
            }
            return this;
        }

        private void validateAndRegister() {
            Class<?> clazz2;
            Collection<PlatformManagedObject> collection = this.beansByName.values();
            for (PlatformManagedObject set2 : collection) {
                for (Class<?> clazz2 : this.interfaceTypes) {
                    if (clazz2.isInstance(set2)) continue;
                    throw new IllegalArgumentException();
                }
            }
            Map<Class<?>, List<PlatformManagedObject>> map = Metadata.beansByInterface;
            for (PlatformManagedObject platformManagedObject : collection) {
                for (Class<?> clazz3 : this.interfaceTypes) {
                    List list = (List)map.get(clazz3);
                    if (list == null) {
                        list = new ArrayList(2);
                        map.put(clazz3, list);
                    }
                    list.add(platformManagedObject);
                }
            }
            Set<Class<? extends PlatformManagedObject>> set = Metadata.managementInterfaces;
            for (Class<?> clazz2 : this.interfaceTypes) {
                Class<?> clazz3;
                if (!PlatformManagedObject.class.isAssignableFrom(clazz2)) continue;
                clazz3 = clazz2;
                set.add(clazz3);
            }
            if (!this.isSingleton) {
                Metadata.multiInstanceBeanInterfaces.addAll(this.interfaceTypes);
            }
            Map<Class<?>, ObjectName[]> map2 = Metadata.objectNamesByInterface;
            clazz2 = this.beansByName.keySet();
            int n = clazz2.size();
            for (Class clazz4 : this.interfaceTypes) {
                int n2;
                ObjectName[] objectNameArray = map2.get(clazz4);
                if (objectNameArray == null) {
                    n2 = 0;
                    objectNameArray = new ObjectName[n];
                } else {
                    n2 = objectNameArray.length;
                    ObjectName[] objectNameArray2 = objectNameArray;
                    objectNameArray = new ObjectName[n2 + n];
                    System.arraycopy((Object)objectNameArray2, 0, (Object)objectNameArray, 0, n2);
                }
                Iterator iterator = clazz2.iterator();
                while (iterator.hasNext()) {
                    ObjectName objectName = (ObjectName)iterator.next();
                    objectNameArray[n2++] = objectName;
                }
                map2.put(clazz4, objectNameArray);
            }
        }
    }
}

