/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders;

import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.ICoreFileReader;
import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.aix.AIXDumpReaderFactory;
import com.ibm.j9ddr.corereaders.debugger.JniReader;
import com.ibm.j9ddr.corereaders.elf.ELFDumpReaderFactory;
import com.ibm.j9ddr.corereaders.macho.MachoDumpReaderFactory;
import com.ibm.j9ddr.corereaders.minidump.MiniDumpReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;

public class CoreReader {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    private static final List<Class<? extends ICoreFileReader>> coreReaders;

    public static ICore readCoreFile(String string) throws IOException {
        Enum enum_ = null;
        IOException iOException = null;
        for (Class<? extends ICoreFileReader> clazz : coreReaders) {
            try {
                ICoreFileReader iCoreFileReader = clazz.newInstance();
                ICoreFileReader.DumpTestResult dumpTestResult = iCoreFileReader.testDump(string);
                if (dumpTestResult == ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT) {
                    return iCoreFileReader.processDump(string);
                }
                enum_ = dumpTestResult.accrue((ICoreFileReader.DumpTestResult)enum_);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.log(Level.WARNING, "IllegalAccessException thrown creating " + clazz.getName(), illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                logger.log(Level.WARNING, "Exception thrown creating " + clazz.getName(), instantiationException.getCause());
            }
            catch (InvalidDumpFormatException invalidDumpFormatException) {
                logger.log(Level.WARNING, "InvalidDumpFormatException thrown creating " + clazz.getName(), invalidDumpFormatException);
            }
            catch (IOException iOException2) {
                if (iOException != null) continue;
                iOException = iOException2;
            }
        }
        if (enum_ == null) {
            if (iOException != null) {
                throw new IOException("I/O problems reading core file: " + iOException.getMessage());
            }
            throw new Error("No core file readers found");
        }
        switch (1.$SwitchMap$com$ibm$j9ddr$corereaders$ICoreFileReader$DumpTestResult[enum_.ordinal()]) {
            case 1: {
                throw new FileNotFoundException("Could not find: " + new File(string).getAbsolutePath());
            }
            case 2: {
                throw new IOException("Dump: " + string + " not recognised by any core reader");
            }
        }
        throw new IllegalStateException("Unexpected state: " + enum_);
    }

    public static ICore readCoreFile(ImageInputStream imageInputStream) throws IOException {
        Enum enum_ = null;
        IOException iOException = null;
        for (Class<? extends ICoreFileReader> clazz : coreReaders) {
            try {
                ICoreFileReader iCoreFileReader = clazz.newInstance();
                ICoreFileReader.DumpTestResult dumpTestResult = iCoreFileReader.testDump(imageInputStream);
                if (dumpTestResult == ICoreFileReader.DumpTestResult.RECOGNISED_FORMAT) {
                    return iCoreFileReader.processDump(imageInputStream);
                }
                enum_ = dumpTestResult.accrue((ICoreFileReader.DumpTestResult)enum_);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.log(Level.WARNING, "IllegalAccessException thrown creating " + clazz.getName(), illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                logger.log(Level.WARNING, "Exception thrown creating " + clazz.getName(), instantiationException.getCause());
            }
            catch (InvalidDumpFormatException invalidDumpFormatException) {
                logger.log(Level.WARNING, "InvalidDumpFormatException thrown creating " + clazz.getName(), invalidDumpFormatException);
            }
            catch (IOException iOException2) {
                if (iOException != null) continue;
                iOException = iOException2;
            }
        }
        if (enum_ == null) {
            if (iOException != null) {
                throw new IOException("I/O problems reading core file: " + iOException.getMessage());
            }
            throw new Error("No core file readers found");
        }
        switch (1.$SwitchMap$com$ibm$j9ddr$corereaders$ICoreFileReader$DumpTestResult[enum_.ordinal()]) {
            case 2: {
                throw new IOException("Dump input stream : not recognised by any core reader");
            }
        }
        throw new IllegalStateException("Unexpected state: " + enum_);
    }

    public static byte[] getFileHeader(String string) throws IOException {
        FileImageInputStream fileImageInputStream = new FileImageInputStream(new File(string));
        return CoreReader.getFileHeader(fileImageInputStream);
    }

    public static byte[] getFileHeader(ImageInputStream imageInputStream) throws IOException {
        byte[] byArray = new byte[2048];
        try {
            imageInputStream.seek(0L);
            imageInputStream.readFully(byArray);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        finally {
            imageInputStream.seek(0L);
        }
        return byArray;
    }

    static {
        ArrayList arrayList = new ArrayList();
        arrayList.add(JniReader.class);
        arrayList.add(MiniDumpReader.class);
        arrayList.add(ELFDumpReaderFactory.class);
        arrayList.add(MachoDumpReaderFactory.class);
        try {
            Class<?> clazz = Class.forName("com.ibm.j9ddr.corereaders.tdump.TDumpReader");
            if (ICoreFileReader.class.isAssignableFrom(clazz)) {
                Class<?> clazz2 = clazz;
                arrayList.add(clazz2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        arrayList.add(AIXDumpReaderFactory.class);
        coreReaders = Collections.unmodifiableList(arrayList);
    }
}

