/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.command;

import com.ibm.j9ddr.command.CommandReader;
import com.ibm.j9ddr.command.ExitException;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractive;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;

public class JNICommandReader
extends CommandReader {
    private static final BlockingQueue<String> commandQueue = new SynchronousQueue<String>(true);
    public static String newline = System.getProperty("line.separator");
    private static final Semaphore lock = new Semaphore(0, true);

    public JNICommandReader(PrintStream printStream) {
        super(printStream);
    }

    public static void enqueueCommand(String string, String string2) {
        try {
            commandQueue.put("!" + string + " " + string2 + newline);
            lock.acquire();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private String getCommand() {
        try {
            return commandQueue.take();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processInput(DDRInteractive dDRInteractive) throws Exception {
        while (true) {
            String string;
            if ((string = this.getCommand()).length() == 0) {
                continue;
            }
            try {
                this.processLine(dDRInteractive, string);
                continue;
            }
            catch (ExitException exitException) {
                return;
            }
            finally {
                lock.release();
                continue;
            }
            break;
        }
    }

    @Override
    public void setInputStream(InputStream inputStream) {
    }
}

