/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders.zos.dumpreader;

import com.ibm.dtfj.corereaders.zos.dumpreader.AddressRange;
import com.ibm.dtfj.corereaders.zos.dumpreader.AddressSpaceImageInputStream;
import com.ibm.dtfj.corereaders.zos.dumpreader.Dump;
import com.ibm.dtfj.corereaders.zos.util.CharConversion;
import com.ibm.dtfj.corereaders.zos.util.IntegerMap;
import com.ibm.dtfj.corereaders.zos.util.ObjectLruCache;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AddressSpace
implements Serializable {
    protected Dump dump;
    protected int asid;
    protected IntegerMap addressMap = new IntegerMap();
    private int quickCacheHits;
    private int cacheHits;
    private int cacheMisses;
    private ObjectLruCache blockCache;
    protected long lastBlockAddress;
    private byte[] lastBlock;
    protected long lastButOneBlockAddress;
    private byte[] lastButOneBlock;
    protected AddressRange[] ranges;
    private AddressSpaceImageInputStream imageStream;
    private boolean is64bit;
    private HashMap userMap = new HashMap();
    public static final long WILD_POINTER = -4995072469322842385L;
    private static Logger log = Logger.getLogger(AddressSpace.class.getName());
    private static final boolean printStats = Boolean.getBoolean("zebedee.printStats");

    public AddressSpace(Dump dump, int n) {
        this.dump = dump;
        this.asid = n;
        this.initialize();
    }

    public Dump getDump() {
        return this.dump;
    }

    public AddressSpace getRootAddressSpace() {
        return this.dump.rootSpace;
    }

    private void initialize() {
        this.blockCache = new ObjectLruCache(500);
        this.userMap = new HashMap();
        this.lastBlockAddress = -1L;
        this.lastButOneBlockAddress = -1L;
        if (printStats && this.getClass() == AddressSpace.class) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    System.out.println("stats for asid " + AddressSpace.hex(AddressSpace.this.asid) + ":");
                    System.out.println("    cacheMisses = " + AddressSpace.this.cacheMisses);
                    System.out.println("    cacheHits = " + AddressSpace.this.cacheHits);
                    System.out.println("    quickCacheHits = " + AddressSpace.this.quickCacheHits);
                }
            });
        }
    }

    public Map getUserMap() {
        return this.userMap;
    }

    public int getAsid() {
        return this.asid;
    }

    public AddressRange[] getAddressRanges() {
        if (this.ranges != null) {
            return this.ranges;
        }
        long[] lArray = this.addressMap.getKeysArray();
        Arrays.sort(lArray);
        long l = 0L;
        long l2 = 0L;
        Vector<AddressRange> vector = new Vector<AddressRange>();
        for (int i = 0; i < lArray.length; ++i) {
            if (i == 0) {
                l = lArray[0];
            } else if (lArray[i] != l2 + 4096L) {
                vector.add(new AddressRange(l, l2 + 4096L - l));
                l = lArray[i];
            }
            l2 = lArray[i];
        }
        vector.add(new AddressRange(l, l2 + 4096L - l));
        this.ranges = vector.toArray(new AddressRange[0]);
        return this.ranges;
    }

    public AddressRange[] getUnusedAddressRanges() {
        this.getAddressRanges();
        AddressRange[] addressRangeArray = new AddressRange[this.ranges.length - 1];
        for (int i = 0; i < addressRangeArray.length; ++i) {
            long l = this.ranges[i].getEndAddress() + 1L;
            long l2 = this.ranges[i + 1].getStartAddress() - 1L;
            addressRangeArray[i] = new AddressRange(l, l2 - l);
        }
        return addressRangeArray;
    }

    public AddressSpaceImageInputStream getImageInputStream() {
        if (this.imageStream == null) {
            this.imageStream = new AddressSpaceImageInputStream(this);
        }
        assert (this.imageStream != null);
        return this.imageStream;
    }

    private void checkIfWild(long l) {
        assert (l != -4995072469322842385L);
        assert ((int)l != -559038737);
        assert (l < -4995072469322846481L || l > -4995072469322838289L) : AddressSpace.hex(l);
        assert ((int)l < -559042833 || (int)l > -559034641) : AddressSpace.hex((int)l);
    }

    protected long roundToPage(long l) {
        this.checkIfWild(l);
        if (this.is64bit()) {
            return l & 0xFFFFFFFFFFFFF000L;
        }
        return l & 0x7FFFF000L;
    }

    public long stripTopBit(long l) {
        this.checkIfWild(l);
        if (this.is64bit()) {
            assert (l >= 0L) : AddressSpace.hex(l);
            return l;
        }
        return l & Integer.MAX_VALUE;
    }

    private void read(long l, byte[] byArray) throws IOException {
        long l2;
        long l3;
        if (log.isLoggable(Level.FINER)) {
            log.finer("request to read " + byArray.length + " from address 0x" + AddressSpace.hex(l));
        }
        if ((l3 = this.addressMap.get(l2 = this.roundToPage(l))) == -1L) {
            if (this.asid != 1 && (l3 = this.dump.rootSpace.addressMap.get(l2)) != -1L) {
                log.fine("found address " + AddressSpace.hex(l) + " in root address space");
            }
            if (l3 == -1L) {
                throw new IOException("block address " + AddressSpace.hex(l) + " not in dump");
            }
        }
        this.dump.seek(l3);
        if (byArray.length > 4096) {
            throw new Error("to be completed");
        }
        this.dump.readFully(byArray);
    }

    final byte[] getBlockFromQuickCache(long l) {
        assert ((l & 0xFFFL) == 0L);
        if (l == this.lastBlockAddress) {
            ++this.quickCacheHits;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("request to get block for address 0x" + AddressSpace.hex(l) + " met by quick cache");
            }
            return this.lastBlock;
        }
        if (l == this.lastButOneBlockAddress) {
            ++this.quickCacheHits;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("request to get block for address 0x" + AddressSpace.hex(l) + " met by quick cache");
            }
            return this.lastButOneBlock;
        }
        return null;
    }

    final void putBlockInQuickCache(long l, byte[] byArray) {
        assert ((l & 0xFFFL) == 0L);
        this.lastButOneBlockAddress = this.lastBlockAddress;
        this.lastButOneBlock = this.lastBlock;
        this.lastBlockAddress = l;
        this.lastBlock = byArray;
    }

    final byte[] getBlock(long l) throws IOException {
        byte[] byArray = this.getBlockFromQuickCache(l = this.roundToPage(l));
        return byArray != null ? byArray : this.getBlockFromCacheOrDisk(l);
    }

    protected byte[] getBlockFromCacheOrDisk(long l) throws IOException {
        assert ((l & 0xFFFL) == 0L);
        byte[] byArray = (byte[])this.blockCache.get(l);
        if (byArray == null) {
            ++this.cacheMisses;
            byArray = new byte[4096];
            this.read(l, byArray);
            this.blockCache.put(l, byArray);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("request to get block for address 0x" + AddressSpace.hex(l) + " met by file read");
            }
        } else {
            ++this.cacheHits;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("request to get block for address 0x" + AddressSpace.hex(l) + " met by cache");
            }
        }
        this.putBlockInQuickCache(l, byArray);
        return byArray;
    }

    public int read(long l) throws IOException {
        return this.getBlock(l)[(int)l & 0xFFF] & 0xFF;
    }

    public int readInt(long l) throws IOException {
        int n = (int)l & 0xFFF;
        if (n < 4093) {
            return Dump.readInt(this.getBlock(l), n);
        }
        int n2 = this.read(l++);
        int n3 = this.read(l++);
        int n4 = this.read(l++);
        int n5 = this.read(l++);
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public int readUnsignedByte(long l) throws IOException {
        return this.readInt(l) >>> 24;
    }

    public byte readByte(long l) throws IOException {
        return (byte)this.readUnsignedByte(l);
    }

    public int readUnsignedShort(long l) throws IOException {
        return this.readInt(l) >>> 16;
    }

    public short readShort(long l) throws IOException {
        return (short)this.readUnsignedShort(l);
    }

    public long readUnsignedInt(long l) throws IOException {
        long l2 = this.readInt(l);
        return l2 & 0xFFFFFFFFL;
    }

    public long readLong(long l) throws IOException {
        long l2 = this.readInt(l);
        long l3 = this.readInt(l + 4L);
        return l2 << 32 | l3 & 0xFFFFFFFFL;
    }

    public long readWord(long l) throws IOException {
        return this.is64bit ? this.readLong(l) : (long)this.readInt(l) & 0xFFFFFFFFL;
    }

    public int getWordLength() {
        return this.is64bit ? 8 : 4;
    }

    public void read(long l, byte[] byArray, int n, int n2) throws IOException {
        l = this.stripTopBit(l);
        while (true) {
            int n3;
            byte[] byArray2;
            int n4;
            if (n2 <= (n4 = (byArray2 = this.getBlock(l)).length - (n3 = (int)(l % (long)byArray2.length)))) {
                System.arraycopy(byArray2, n3, byArray, n, n2);
                return;
            }
            System.arraycopy(byArray2, n3, byArray, n, n4);
            l += (long)n4;
            n += n4;
            n2 -= n4;
        }
    }

    public String readEbcdicString(long l, int n) throws IOException {
        byte[] byArray = new byte[n];
        this.read(l, byArray, 0, n);
        return CharConversion.getEbcdicString(byArray);
    }

    public String readEbcdicString(long l) throws IOException {
        int n = this.readUnsignedShort(l);
        return this.readEbcdicString(l + 2L, n);
    }

    public String readEbcdicCString(long l) throws IOException {
        int n = 0;
        long l2 = l;
        while (this.read(l2) != 0) {
            ++l2;
            ++n;
        }
        return this.readEbcdicString(l, n);
    }

    public String readAsciiString(long l, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((char)this.read(l++));
        }
        return stringBuffer.toString();
    }

    public String readAsciiCString(long l) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.read(l++)) != 0) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public String readAsciiString(long l) throws IOException {
        int n = this.readUnsignedShort(l);
        return this.readAsciiString(l + 2L, n);
    }

    public String readUtf8String(long l) throws IOException {
        int n = this.readUnsignedShort(l);
        return this.readAsciiString(l + 2L, n);
    }

    public boolean isValid(long l) {
        AddressRange[] addressRangeArray = this.getAddressRanges();
        for (int i = 0; i < addressRangeArray.length; ++i) {
            if (l < addressRangeArray[i].getStartAddress() || l > addressRangeArray[i].getEndAddress()) continue;
            return true;
        }
        return false;
    }

    public boolean is64bit() {
        return this.is64bit;
    }

    public void setIs64bit(boolean bl) {
        log.fine("Set address space " + this.asid + " as " + (bl ? "64-bit" : "32-bit"));
        this.is64bit = bl;
    }

    void mapAddressToFileOffset(long l, long l2) {
        if (this.addressMap.get(l) != -1L) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("duplicate address 0x" + AddressSpace.hex(l) + " for asid " + this.asid);
            }
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("mapping address 0x" + AddressSpace.hex(l) + " to offset " + AddressSpace.hex(l2) + " for asid " + this.asid);
        }
        this.addressMap.put(l, l2);
    }

    private static String hex(int n) {
        return Integer.toHexString(n);
    }

    private static String hex(long l) {
        return Long.toHexString(l);
    }

    public String toString() {
        return AddressSpace.hex(this.asid);
    }

    void setDump(Dump dump) {
        this.dump = dump;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.asid);
        objectOutputStream.writeObject(this.addressMap);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.asid = objectInputStream.readInt();
        this.addressMap = (IntegerMap)objectInputStream.readObject();
        this.initialize();
    }
}

