/*
 * Decompiled with CFR 0.152.
 */
package openj9.tools.attach.diagnostics.info;

import com.ibm.oti.util.Msg;
import java.io.IOException;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Properties;
import openj9.tools.attach.diagnostics.base.DiagnosticProperties;
import openj9.tools.attach.diagnostics.base.DiagnosticsInfo;
import openj9.tools.attach.diagnostics.info.JvmThreadInfo;

public class ThreadGroupInfo
implements DiagnosticsInfo {
    private static final String CURRENT_GROUPINFO_VERSION = "0";
    private static final String TIME_FORMAT_STRING = "\t%s time: %d ns%n";
    static final String THREAD_GROUP_PREFIX = "threadgroup.";
    static final String CPU_TIME = "cpu_time";
    static final String USER_TIME = "user_time";
    private static final String THREAD_GROUP_VERSION = "threadgroup.version";
    private static final String NUM_THREADS = "threadgroup.num_threads";
    private final int numThreads;
    private final JvmThreadInfo[] myThreads;
    private final String groupInfoVersion;
    private final DiagnosticProperties myProps;
    private final String javaInfo;
    private boolean addSynchronizers;

    public ThreadGroupInfo(Properties properties, boolean bl) throws IOException {
        this.addSynchronizers = bl;
        try {
            this.myProps = new DiagnosticProperties(properties);
            if (this.myProps.containsField("openj9_diagnostics.error") && this.myProps.getBoolean("openj9_diagnostics.error")) {
                String string = this.myProps.getPropertyOrNull("openj9_diagnostics.errormsg");
                String string2 = this.myProps.getPropertyOrNull("openj9_diagnostics.errortype");
                if (null != string && !string.isEmpty()) {
                    string2 = string2 + ": " + string;
                }
                throw new IOException(string2);
            }
            if (!this.myProps.containsField(NUM_THREADS)) {
                throw new IOException("OPENJ9_INCOMPATIBLE_JAVA_VERSION");
            }
            this.numThreads = this.myProps.getInt(NUM_THREADS);
            this.groupInfoVersion = properties.getProperty(THREAD_GROUP_VERSION);
            if (!ThreadGroupInfo.checkVersion(this.groupInfoVersion)) {
                throw new IOException(Msg.getString("K080A", this.groupInfoVersion));
            }
            this.javaInfo = properties.getProperty("openj9_diagnostics.java_info");
            if (this.numThreads <= 0) {
                throw new UnsupportedOperationException("Cannot determine number of threads");
            }
            this.myThreads = new JvmThreadInfo[this.numThreads];
            for (int i = 0; i < this.numThreads; ++i) {
                this.myThreads[i] = new JvmThreadInfo(this.myProps, i);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(numberFormatException);
        }
    }

    public static DiagnosticProperties getThreadInfoProperties() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfoArray = threadMXBean.dumpAllThreads(true, true);
        DiagnosticProperties diagnosticProperties = ThreadGroupInfo.getThreadInfoPropertiesImpl(threadMXBean, threadInfoArray);
        return diagnosticProperties;
    }

    public static DiagnosticProperties getThreadInfoProperties(long[] lArray) {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        int n = lArray.length;
        ThreadInfo[] threadInfoArray = new ThreadInfo[n];
        for (int i = 0; i < n; ++i) {
            threadInfoArray[i] = threadMXBean.getThreadInfo(lArray[i]);
        }
        DiagnosticProperties diagnosticProperties = ThreadGroupInfo.getThreadInfoPropertiesImpl(threadMXBean, threadInfoArray);
        return diagnosticProperties;
    }

    private static DiagnosticProperties getThreadInfoPropertiesImpl(ThreadMXBean threadMXBean, ThreadInfo[] threadInfoArray) {
        DiagnosticProperties diagnosticProperties = new DiagnosticProperties();
        diagnosticProperties.put("openj9_diagnostics.error", false);
        int n = threadInfoArray.length;
        diagnosticProperties.put(NUM_THREADS, n);
        diagnosticProperties.put(THREAD_GROUP_VERSION, CURRENT_GROUPINFO_VERSION);
        diagnosticProperties.put("openj9_diagnostics.java_info", System.getProperty("java.vm.info"));
        boolean bl = threadMXBean.isThreadCpuTimeSupported() && threadMXBean.isThreadCpuTimeEnabled();
        for (int i = 0; i < n; ++i) {
            if (null == threadInfoArray[i]) continue;
            JvmThreadInfo.put(threadInfoArray[i], diagnosticProperties, i);
            if (!bl) continue;
            String string = JvmThreadInfo.thrdNumPrefix(i);
            long l = threadInfoArray[i].getThreadId();
            long l2 = threadMXBean.getThreadCpuTime(l);
            diagnosticProperties.put(string + CPU_TIME, l2);
            long l3 = threadMXBean.getThreadUserTime(l);
            diagnosticProperties.put(string + USER_TIME, l3);
        }
        DiagnosticProperties.dumpPropertiesIfDebug("Threads:", diagnosticProperties.toProperties());
        return diagnosticProperties;
    }

    int activeCount() {
        return this.numThreads;
    }

    @Override
    public String toString() {
        String string;
        String string2 = System.lineSeparator();
        StringBuffer stringBuffer = new StringBuffer(2000);
        for (int i = 0; i < this.numThreads; ++i) {
            ThreadInfo threadInfo = this.myThreads[i].getThreadInfo();
            if (null == threadInfo) {
                stringBuffer.setLength(0);
                break;
            }
            stringBuffer.append(threadInfo.toString());
            LockInfo[] lockInfoArray = threadInfo.getLockedSynchronizers();
            if (this.addSynchronizers) {
                stringBuffer.append(String.format("%n\tLocked ownable synchronizers: %d%n", lockInfoArray.length));
                for (LockInfo lockInfo : lockInfoArray) {
                    stringBuffer.append(String.format("\t- %s%n", lockInfo.toString()));
                }
                stringBuffer.append(string2);
            }
            LockInfo[] lockInfoArray2 = JvmThreadInfo.thrdNumPrefix(i);
            try {
                String string3 = (String)lockInfoArray2 + CPU_TIME;
                String string4 = (String)lockInfoArray2 + USER_TIME;
                if (this.myProps.containsField(string3)) {
                    long l = this.myProps.getLong(string3);
                    stringBuffer.append(String.format(TIME_FORMAT_STRING, "CPU", l));
                }
                if (this.myProps.containsField(string4)) {
                    long l = this.myProps.getLong(string4);
                    stringBuffer.append(String.format(TIME_FORMAT_STRING, "User", l));
                }
            }
            catch (IOException | NumberFormatException exception) {
                // empty catch block
            }
            stringBuffer.append(string2);
        }
        if ((string = stringBuffer.toString()).isEmpty()) {
            string = "Incompatible data from target VM:" + string2 + DiagnosticProperties.printProperties(this.myProps.toProperties());
        }
        return string;
    }

    public String getGroupInfoVersion() {
        return this.groupInfoVersion;
    }

    @Override
    public String getJavaInfo() {
        return this.javaInfo;
    }

    private static boolean checkVersion(String string) {
        return CURRENT_GROUPINFO_VERSION.equals(string);
    }
}

