/*
 * Decompiled with CFR 0.152.
 */
package openj9.tools.attach.diagnostics.info;

import com.ibm.java.lang.management.internal.LockInfoUtil;
import com.ibm.java.lang.management.internal.MonitorInfoUtil;
import com.ibm.java.lang.management.internal.StackTraceElementUtil;
import java.io.IOException;
import java.util.Set;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import openj9.tools.attach.diagnostics.base.DiagnosticProperties;

public class JvmInfo {
    protected static final String ARRAY_SIZE = "array_size";

    protected static void addFields(DiagnosticProperties diagnosticProperties, String string, CompositeType compositeType, CompositeData compositeData) {
        for (String string2 : compositeType.keySet()) {
            Object object;
            Object object2;
            OpenType openType;
            boolean bl;
            String string3 = string + string2;
            Object object3 = compositeData.get(string2);
            OpenType<?> openType2 = compositeType.getType(string2);
            boolean bl2 = bl = null != object3;
            if (JvmInfo.isSimpleType(openType2)) {
                if (!bl) continue;
                diagnosticProperties.put(string3, object3.toString());
                continue;
            }
            diagnosticProperties.put(string3, bl);
            if (!bl) continue;
            if (openType2.isArray()) {
                openType = (ArrayType)openType2;
                object2 = JvmInfo.getCompositeType(((ArrayType)openType).getElementOpenType());
                object = (CompositeData[])object3;
                int n = ((CompositeData[])object).length;
                diagnosticProperties.put(string3 + ARRAY_SIZE, n);
                for (int i = 0; i < n; ++i) {
                    String string4 = string3 + '.' + Integer.toString(i) + '.';
                    JvmInfo.addFields(diagnosticProperties, string4, (CompositeType)object2, object[i]);
                }
                continue;
            }
            openType = JvmInfo.getCompositeType(openType2);
            object2 = string3 + '.';
            object = (CompositeData)object3;
            JvmInfo.addFields(diagnosticProperties, (String)object2, (CompositeType)openType, (CompositeData)object);
        }
    }

    protected static CompositeType getCompositeType(OpenType<?> openType) {
        String string;
        CompositeType compositeType = null;
        switch (string = openType.getTypeName()) {
            case "java.lang.management.LockInfo": {
                compositeType = LockInfoUtil.getCompositeType();
                break;
            }
            case "java.lang.management.MonitorInfo": {
                compositeType = MonitorInfoUtil.getCompositeType();
                break;
            }
            case "java.lang.StackTraceElement": {
                compositeType = StackTraceElementUtil.getCompositeType();
                break;
            }
        }
        return compositeType;
    }

    protected static CompositeData extractFields(DiagnosticProperties diagnosticProperties, String string, CompositeType compositeType) throws IOException {
        Set<String> set = compositeType.keySet();
        int n = set.size();
        String[] stringArray = set.toArray(new String[n]);
        Object[] objectArray = new Object[n];
        try {
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                String string3 = string + string2;
                CompositeData[] compositeDataArray = null;
                OpenType<?> openType = compositeType.getType(string2);
                if (JvmInfo.isSimpleType(openType)) {
                    compositeDataArray = diagnosticProperties.getSimple(openType.getTypeName(), string3);
                } else {
                    boolean bl = diagnosticProperties.getBoolean(string3);
                    if (bl) {
                        Object object;
                        Object object2;
                        if (openType.isArray()) {
                            int n2 = diagnosticProperties.getInt(string3 + ARRAY_SIZE);
                            object2 = (ArrayType)openType;
                            object = JvmInfo.getCompositeType(((ArrayType)object2).getElementOpenType());
                            CompositeData[] compositeDataArray2 = new CompositeData[n2];
                            for (int j = 0; j < n2; ++j) {
                                CompositeData compositeData;
                                String string4 = string3 + '.' + Integer.toString(j) + '.';
                                compositeDataArray2[j] = compositeData = JvmInfo.extractFields(diagnosticProperties, string4, (CompositeType)object);
                            }
                            compositeDataArray = compositeDataArray2;
                        } else {
                            CompositeType compositeType2 = JvmInfo.getCompositeType(openType);
                            object2 = string3 + '.';
                            object = JvmInfo.extractFields(diagnosticProperties, (String)object2, compositeType2);
                            compositeDataArray = object;
                        }
                    }
                }
                objectArray[i] = compositeDataArray;
            }
            CompositeDataSupport compositeDataSupport = new CompositeDataSupport(compositeType, stringArray, objectArray);
            return compositeDataSupport;
        }
        catch (NumberFormatException | OpenDataException exception) {
            throw new IOException(exception);
        }
    }

    static boolean isSimpleType(OpenType<?> openType) {
        return SimpleType.class.isAssignableFrom(openType.getClass());
    }
}

