/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.lang.management.internal;

import com.ibm.java.lang.management.internal.ManagementPermissionHelper;
import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.java.lang.management.internal.MemoryMXBeanImpl;
import com.ibm.oti.util.Msg;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Constructor;
import java.util.LinkedList;
import javax.management.ObjectName;

public class MemoryPoolMXBeanImpl
implements MemoryPoolMXBean {
    private static final Constructor<MemoryUsage> memUsageConstructor;
    private final String name;
    private final int id;
    private final MemoryType type;
    private final MemoryMXBeanImpl memBean;
    private final ObjectName objectName;

    protected MemoryPoolMXBeanImpl(String string, MemoryType memoryType, int n, MemoryMXBeanImpl memoryMXBeanImpl) {
        this.objectName = ManagementUtils.createObjectName("java.lang:type=MemoryPool", string);
        this.name = string;
        this.type = memoryType;
        this.id = n;
        this.memBean = memoryMXBeanImpl;
    }

    private native MemoryUsage getCollectionUsageImpl(int var1, Class<MemoryUsage> var2, Constructor<MemoryUsage> var3);

    @Override
    public MemoryUsage getCollectionUsage() {
        if (null != memUsageConstructor) {
            return this.getCollectionUsageImpl(this.id, MemoryUsage.class, memUsageConstructor);
        }
        return null;
    }

    private native MemoryUsage getPreCollectionUsageImpl(int var1, Class<MemoryUsage> var2, Constructor<MemoryUsage> var3);

    public MemoryUsage getPreCollectionUsage() {
        return this.getPreCollectionUsageImpl(this.getID(), MemoryUsage.class, memUsageConstructor);
    }

    private native long getCollectionUsageThresholdImpl(int var1);

    @Override
    public long getCollectionUsageThreshold() {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EE"));
        }
        return this.getCollectionUsageThresholdImpl(this.id);
    }

    private native long getCollectionUsageThresholdCountImpl(int var1);

    @Override
    public long getCollectionUsageThresholdCount() {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EE"));
        }
        return this.getCollectionUsageThresholdCountImpl(this.id);
    }

    @Override
    public String[] getMemoryManagerNames() {
        LinkedList<String> linkedList = new LinkedList<String>();
        block0: for (MemoryManagerMXBean memoryManagerMXBean : this.memBean.getMemoryManagerMXBeans(false)) {
            for (String string : memoryManagerMXBean.getMemoryPoolNames()) {
                if (!string.equals(this.name)) continue;
                linkedList.add(memoryManagerMXBean.getName());
                continue block0;
            }
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    int getID() {
        return this.id;
    }

    private native MemoryUsage getPeakUsageImpl(int var1, Class<MemoryUsage> var2, Constructor<MemoryUsage> var3);

    @Override
    public MemoryUsage getPeakUsage() {
        return this.getPeakUsageImpl(this.id, MemoryUsage.class, memUsageConstructor);
    }

    @Override
    public MemoryType getType() {
        return this.type;
    }

    private native MemoryUsage getUsageImpl(int var1, Class<MemoryUsage> var2, Constructor<MemoryUsage> var3);

    @Override
    public MemoryUsage getUsage() {
        return this.getUsageImpl(this.id, MemoryUsage.class, memUsageConstructor);
    }

    private native long getUsageThresholdImpl(int var1);

    @Override
    public long getUsageThreshold() {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EF"));
        }
        return this.getUsageThresholdImpl(this.id);
    }

    private native long getUsageThresholdCountImpl(int var1);

    @Override
    public long getUsageThresholdCount() {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EF"));
        }
        return this.getUsageThresholdCountImpl(this.id);
    }

    private native boolean isCollectionUsageThresholdExceededImpl(int var1);

    @Override
    public boolean isCollectionUsageThresholdExceeded() {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EE"));
        }
        return this.isCollectionUsageThresholdExceededImpl(this.id);
    }

    private native boolean isCollectionUsageThresholdSupportedImpl(int var1);

    @Override
    public boolean isCollectionUsageThresholdSupported() {
        return this.isCollectionUsageThresholdSupportedImpl(this.id);
    }

    private native boolean isUsageThresholdExceededImpl(int var1);

    @Override
    public boolean isUsageThresholdExceeded() {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EF"));
        }
        return this.isUsageThresholdExceededImpl(this.id);
    }

    private native boolean isUsageThresholdSupportedImpl(int var1);

    @Override
    public boolean isUsageThresholdSupported() {
        return this.isUsageThresholdSupportedImpl(this.id);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    private native void resetPeakUsageImpl(int var1);

    @Override
    public void resetPeakUsage() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        this.resetPeakUsageImpl(this.id);
    }

    private native void setCollectionUsageThresholdImpl(int var1, long var2);

    @Override
    public void setCollectionUsageThreshold(long l) {
        if (!this.isCollectionUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EE"));
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        if (l < 0L) {
            throw new IllegalArgumentException(Msg.getString("K05FE"));
        }
        if (this.exceedsMaxPoolSize(l)) {
            throw new IllegalArgumentException(Msg.getString("K05FF"));
        }
        this.setCollectionUsageThresholdImpl(this.id, l);
    }

    private native void setUsageThresholdImpl(int var1, long var2);

    @Override
    public void setUsageThreshold(long l) {
        if (!this.isUsageThresholdSupported()) {
            throw new UnsupportedOperationException(Msg.getString("K05EF"));
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ManagementPermissionHelper.MPCONTROL);
        }
        if (l < 0L) {
            throw new IllegalArgumentException(Msg.getString("K05F0"));
        }
        if (this.exceedsMaxPoolSize(l)) {
            throw new IllegalArgumentException(Msg.getString("K05F1"));
        }
        this.setUsageThresholdImpl(this.id, l);
    }

    private boolean exceedsMaxPoolSize(long l) {
        MemoryUsage memoryUsage = this.getUsage();
        return -1L != memoryUsage.getMax() && 0L != memoryUsage.getMax() && memoryUsage.getMax() < l;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    static {
        Constructor constructor;
        try {
            constructor = MemoryUsage.class.getConstructor(Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            constructor = null;
        }
        memUsageConstructor = constructor;
    }
}

