/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import com.ibm.oti.util.Msg;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.CodeSource;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import sun.reflect.CallerSensitive;

public final class AccessController {
    static final int OBJS_INDEX_ACC = 0;
    static final int OBJS_INDEX_PDS = 1;
    static final int OBJS_ARRAY_SIZE = 3;
    static final int OBJS_INDEX_PERMS_OR_CACHECHECKED = 2;
    private static final SecurityPermission createAccessControlContext;

    private static native void initializeInternal();

    private AccessController() {
    }

    private static native Object[] getAccSnapshot(int var0, boolean var1);

    private static native ProtectionDomain getCallerPD(int var0);

    private static void throwACE(boolean bl, Permission permission, ProtectionDomain protectionDomain, boolean bl2) {
        if (bl) {
            DebugRecursionDetection.getTlDebug().set("");
            AccessControlContext.debugPrintAccess();
            if (bl2) {
                System.err.println("access denied " + permission + " due to untrusted AccessControlContext since " + createAccessControlContext + " is denied.");
            } else {
                System.err.println("access denied " + permission);
            }
            DebugRecursionDetection.getTlDebug().remove();
        }
        if (bl && (AccessControlContext.debugSetting() & 8) != 0) {
            DebugRecursionDetection.getTlDebug().set("");
            new Exception("Stack trace").printStackTrace();
            if (bl2) {
                System.err.println("domain that failed " + createAccessControlContext + " check " + protectionDomain);
            } else {
                System.err.println("domain that failed " + protectionDomain);
            }
            DebugRecursionDetection.getTlDebug().remove();
        }
        if (bl2) {
            throw new AccessControlException(Msg.getString("K002d", permission, createAccessControlContext), permission);
        }
        throw new AccessControlException(Msg.getString("K002c", permission), permission);
    }

    private static boolean checkPermissionHelper(Permission permission, AccessControlContext accessControlContext, Object[] objectArray, int n, AccessControlContext.AccessCache accessCache, Object[] objectArray2, int n2, int n3) {
        ProtectionDomain protectionDomain;
        int n4;
        boolean bl = false;
        boolean bl2 = (n2 & 2) != 0;
        Object[] objectArray3 = AccessController.generatePDarray(accessControlContext, objectArray2, bl2, n3);
        if (bl2 && 0 != (AccessControlContext.debugSetting() & 4)) {
            DebugRecursionDetection.getTlDebug().set("");
            AccessControlContext.debugPrintAccess();
            if (null == objectArray3 || 0 == objectArray3.length) {
                System.err.println("domain (context is null)");
            } else {
                for (n4 = 0; n4 < objectArray3.length; ++n4) {
                    System.err.println("domain " + n4 + " " + objectArray3[n4]);
                }
            }
            DebugRecursionDetection.getTlDebug().remove();
        }
        int n5 = n4 = objectArray3 == null ? 0 : objectArray3.length;
        if (null != accessControlContext && null != accessControlContext.context && 1 != accessControlContext.authorizeState && null != System.getSecurityManager() && null != (protectionDomain = (ProtectionDomain)objectArray2[n3 - 1]) && !protectionDomain.implies(createAccessControlContext)) {
            AccessController.throwACE((n2 & 1) != 0, permission, protectionDomain, true);
        }
        if (2 == n3) {
            if (null != accessControlContext && (null != accessControlContext.doPrivilegedAcc || null != accessControlContext.nextStackAcc || accessControlContext.isLimitedContext)) {
                accessCache = new AccessControlContext.AccessCache();
                return AccessControlContext.checkPermissionWithCache(permission, objectArray3, n2, accessControlContext, false, null, null, accessCache);
            }
            if (objectArray3 != null) {
                for (int i = 0; i < n4; ++i) {
                    if (objectArray3[n4 - i - 1] == null || ((ProtectionDomain)objectArray3[n4 - i - 1]).implies(permission)) continue;
                    AccessController.throwACE((n2 & 1) != 0, permission, (ProtectionDomain)objectArray3[n4 - i - 1], false);
                }
            }
        } else if (AccessControlContext.checkPermissionWithCache(permission, objectArray3, n2, (AccessControlContext)objectArray[n * 3], null != objectArray[n * 3 + 2], (Permission[])objectArray[n * 3 + 2], null, accessCache)) {
            bl = true;
        }
        return bl;
    }

    private static void debugPrintStack(boolean bl, Permission permission) {
        if (bl && (AccessControlContext.debugSetting() & 2) != 0) {
            DebugRecursionDetection.getTlDebug().set("");
            new Exception("Stack trace for " + permission).printStackTrace();
            DebugRecursionDetection.getTlDebug().remove();
        }
    }

    private static boolean debugHelperPreJEP140(Object[] objectArray, Permission permission) {
        boolean bl = true;
        if (AccessControlContext.debugCodeBaseArray != null) {
            bl = false;
            for (int i = 2; i < objectArray.length; ++i) {
                CodeSource codeSource;
                Object object = objectArray[i];
                if (object == null || (codeSource = ((ProtectionDomain)object).getCodeSource()) == null || !AccessControlContext.debugCodeBase(codeSource.getLocation())) continue;
                bl = true;
                break;
            }
            AccessControlContext accessControlContext = (AccessControlContext)objectArray[0];
            if (!bl) {
                boolean bl2 = bl = accessControlContext != null && accessControlContext.hasDebugCodeBase();
            }
        }
        if (bl && !AccessControlContext.debugPermission(permission)) {
            bl = false;
        }
        AccessController.debugPrintStack(bl, permission);
        return bl;
    }

    private static boolean debugHelperJEP140(Object[] objectArray, Permission permission) {
        boolean bl = true;
        if (AccessControlContext.debugCodeBaseArray != null) {
            bl = false;
            block0: for (int i = 0; i < objectArray.length / 3; ++i) {
                AccessControlContext accessControlContext = (AccessControlContext)objectArray[i * 3];
                Object[] objectArray2 = (Object[])objectArray[i * 3 + 1];
                for (int j = 1; j < objectArray2.length; ++j) {
                    CodeSource codeSource;
                    Object object = objectArray2[j];
                    if (object == null || (codeSource = ((ProtectionDomain)object).getCodeSource()) == null || !AccessControlContext.debugCodeBase(codeSource.getLocation())) continue;
                    bl = true;
                    break block0;
                }
                if (accessControlContext == null || !accessControlContext.hasDebugCodeBase()) continue;
                bl = true;
                break;
            }
        }
        if (bl) {
            bl = AccessControlContext.debugPermission(permission);
        }
        AccessController.debugPrintStack(bl, permission);
        return bl;
    }

    public static void checkPermission(Permission permission) throws AccessControlException {
        Object[] objectArray;
        boolean bl;
        if (permission == null) {
            throw new NullPointerException();
        }
        int n = 0;
        if (AccessControlContext.debugSetting() != 0 && null == DebugRecursionDetection.getTlDebug().get()) {
            n = 3;
        }
        boolean bl2 = bl = 0 != (objectArray = AccessController.getAccSnapshot(1, false)).length % 3;
        if (bl) {
            if (n != 0 && !AccessController.debugHelperPreJEP140(objectArray, permission)) {
                n = 1;
            }
            AccessController.checkPermissionHelper(permission, (AccessControlContext)objectArray[0], null, 0, null, objectArray, n, 2);
        } else {
            Object[] objectArray2;
            AccessControlContext accessControlContext;
            int n2 = objectArray.length / 3;
            if (n != 0 && !AccessController.debugHelperJEP140(objectArray, permission)) {
                n = 1;
            }
            AccessControlContext.AccessCache accessCache = new AccessControlContext.AccessCache();
            for (int i = 0; i < n2 && !AccessController.checkPermissionHelper(permission, accessControlContext = (AccessControlContext)objectArray[i * 3], objectArray, i, accessCache, objectArray2 = (Object[])objectArray[i * 3 + 1], n, 1); ++i) {
            }
        }
        if ((n & 2) != 0) {
            DebugRecursionDetection.getTlDebug().set("");
            AccessControlContext.debugPrintAccess();
            System.err.println("access allowed " + permission);
            DebugRecursionDetection.getTlDebug().remove();
        }
    }

    private static void keepalive(AccessControlContext accessControlContext) {
    }

    private static void keepalive(Permission ... permissionArray) {
    }

    public static AccessControlContext getContext() {
        return AccessController.getContextHelper(false);
    }

    @CallerSensitive
    private static AccessControlContext getContextHelper(boolean bl) {
        boolean bl2;
        Object[] objectArray = AccessController.getAccSnapshot(2, bl);
        boolean bl3 = bl2 = 0 != objectArray.length % 3;
        if (bl2) {
            AccessControlContext accessControlContext = (AccessControlContext)objectArray[0];
            ProtectionDomain[] protectionDomainArray = AccessController.generatePDarray(accessControlContext, objectArray, false, 2);
            int n = AccessController.getNewAuthorizedState(accessControlContext, (ProtectionDomain)objectArray[1]);
            AccessControlContext accessControlContext2 = null != accessControlContext && (null != accessControlContext.doPrivilegedAcc || null != accessControlContext.nextStackAcc || accessControlContext.isLimitedContext) ? new AccessControlContext(accessControlContext, protectionDomainArray, n) : new AccessControlContext(protectionDomainArray, n);
            if (null != accessControlContext && null != accessControlContext.domainCombiner) {
                accessControlContext2.domainCombiner = accessControlContext.domainCombiner;
            }
            return accessControlContext2;
        }
        int n = objectArray.length / 3;
        AccessControlContext accessControlContext = null;
        AccessControlContext accessControlContext3 = null;
        DomainCombiner domainCombiner = null;
        for (int i = 0; i < n; ++i) {
            AccessControlContext accessControlContext4 = (AccessControlContext)objectArray[i * 3];
            ProtectionDomain[] protectionDomainArray = AccessController.generatePDarray(accessControlContext4, (Object[])objectArray[i * 3 + 1], false, 1);
            int n2 = AccessController.getNewAuthorizedState(accessControlContext4, (ProtectionDomain)((Object[])objectArray[i * 3 + 1])[0]);
            AccessControlContext accessControlContext5 = null != accessControlContext4 && accessControlContext4.isLimitedContext || 1 < n ? new AccessControlContext(accessControlContext4, protectionDomainArray, n2) : new AccessControlContext(protectionDomainArray, n2);
            if (null != accessControlContext4 && null != accessControlContext4.domainCombiner) {
                accessControlContext5.domainCombiner = accessControlContext4.domainCombiner;
                if (domainCombiner == null) {
                    domainCombiner = accessControlContext4.domainCombiner;
                }
            }
            if (null != objectArray[i * 3 + 2]) {
                accessControlContext5.isLimitedContext = true;
                accessControlContext5.limitedPerms = (Permission[])objectArray[i * 3 + 2];
            }
            if (null == accessControlContext3) {
                accessControlContext = accessControlContext5;
            } else {
                accessControlContext3.nextStackAcc = accessControlContext5;
            }
            accessControlContext3 = accessControlContext5;
        }
        if (accessControlContext != null && accessControlContext.domainCombiner == null && domainCombiner != null) {
            accessControlContext.domainCombiner = domainCombiner;
        }
        return accessControlContext;
    }

    private static ProtectionDomain[] generatePDarray(AccessControlContext accessControlContext, Object[] objectArray, boolean bl, int n) {
        ProtectionDomain[] protectionDomainArray = null;
        if (null != accessControlContext && null != accessControlContext.domainCombiner && (1 == accessControlContext.authorizeState || null == System.getSecurityManager())) {
            if (bl) {
                DebugRecursionDetection.getTlDebug().set("");
                AccessControlContext.debugPrintAccess();
                System.err.println("AccessController invoking the Combiner");
                DebugRecursionDetection.getTlDebug().remove();
            }
            protectionDomainArray = accessControlContext.domainCombiner.combine(AccessController.toArrayOfProtectionDomains(objectArray, null, n), accessControlContext.context);
        } else {
            protectionDomainArray = AccessController.toArrayOfProtectionDomains(objectArray, accessControlContext, n);
        }
        if (null != protectionDomainArray && 0 == protectionDomainArray.length) {
            protectionDomainArray = null;
        }
        return protectionDomainArray;
    }

    private static int getNewAuthorizedState(AccessControlContext accessControlContext, ProtectionDomain protectionDomain) {
        int n;
        if (null != accessControlContext && null != System.getSecurityManager()) {
            n = accessControlContext.authorizeState;
            if (2 == n) {
                n = null == protectionDomain || protectionDomain.implies(createAccessControlContext) ? 1 : 0;
            }
        } else {
            n = 1;
        }
        return n;
    }

    static ProtectionDomain[] toArrayOfProtectionDomains(Object[] objectArray, AccessControlContext accessControlContext, int n) {
        ProtectionDomain[] protectionDomainArray = accessControlContext == null ? null : accessControlContext.context;
        ProtectionDomain[] protectionDomainArray2 = null;
        if (objectArray == null) {
            if (protectionDomainArray != null && protectionDomainArray.length != 0) {
                protectionDomainArray2 = protectionDomainArray;
            }
        } else if (protectionDomainArray == null) {
            int n2 = objectArray.length - n;
            for (int i = 0; i < n2; ++i) {
                if (objectArray[n + i] != null) continue;
                n2 = i;
                break;
            }
            if (n2 > 0) {
                protectionDomainArray2 = new ProtectionDomain[n2];
                System.arraycopy((Object)objectArray, n, (Object)protectionDomainArray2, 0, n2);
            }
        } else {
            Object object;
            int n3 = objectArray.length;
            int n4 = protectionDomainArray.length;
            int n5 = 0;
            protectionDomainArray2 = new ProtectionDomain[n3 + n4];
            block1: for (int i = n; i < n3 && (object = objectArray[i]) != null; ++i) {
                int n6 = n4;
                do {
                    if (--n6 >= 0) continue;
                    protectionDomainArray2[n5] = (ProtectionDomain)object;
                    ++n5;
                    continue block1;
                } while (protectionDomainArray[n6] != object);
            }
            if (n5 + n4 == 0) {
                protectionDomainArray2 = null;
            } else if (n5 == 0) {
                protectionDomainArray2 = protectionDomainArray;
            } else {
                if (n5 < n3) {
                    ProtectionDomain[] protectionDomainArray3 = new ProtectionDomain[n5 + n4];
                    System.arraycopy((Object)protectionDomainArray2, 0, (Object)protectionDomainArray3, 0, n5);
                    protectionDomainArray2 = protectionDomainArray3;
                }
                System.arraycopy((Object)protectionDomainArray, 0, (Object)protectionDomainArray2, n5, n4);
            }
        }
        return protectionDomainArray2;
    }

    @CallerSensitive
    public static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
        return privilegedAction.run();
    }

    @CallerSensitive
    public static <T> T doPrivileged(PrivilegedAction<T> privilegedAction, AccessControlContext accessControlContext) {
        T t = privilegedAction.run();
        AccessController.keepalive(accessControlContext);
        return t;
    }

    @CallerSensitive
    public static <T> T doPrivileged(PrivilegedExceptionAction<T> privilegedExceptionAction) throws PrivilegedActionException {
        try {
            return privilegedExceptionAction.run();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PrivilegedActionException(exception);
        }
    }

    @CallerSensitive
    public static <T> T doPrivileged(PrivilegedExceptionAction<T> privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        try {
            T t = privilegedExceptionAction.run();
            AccessController.keepalive(accessControlContext);
            return t;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PrivilegedActionException(exception);
        }
    }

    @CallerSensitive
    public static <T> T doPrivilegedWithCombiner(PrivilegedAction<T> privilegedAction) {
        return AccessController.doPrivileged(privilegedAction, AccessController.getContextHelper(true));
    }

    @CallerSensitive
    public static <T> T doPrivilegedWithCombiner(PrivilegedExceptionAction<T> privilegedExceptionAction) throws PrivilegedActionException {
        return AccessController.doPrivileged(privilegedExceptionAction, AccessController.getContextHelper(true));
    }

    private static void checkPermsNPE(Permission ... permissionArray) {
        for (int i = 0; i < permissionArray.length; ++i) {
            if (null != permissionArray[i]) continue;
            throw new NullPointerException();
        }
    }

    @CallerSensitive
    public static <T> T doPrivileged(PrivilegedAction<T> privilegedAction, AccessControlContext accessControlContext, Permission ... permissionArray) {
        AccessController.checkPermsNPE(permissionArray);
        T t = privilegedAction.run();
        AccessController.keepalive(accessControlContext);
        AccessController.keepalive(permissionArray);
        return t;
    }

    @CallerSensitive
    public static <T> T doPrivilegedWithCombiner(PrivilegedAction<T> privilegedAction, AccessControlContext accessControlContext, Permission ... permissionArray) {
        ProtectionDomain[] protectionDomainArray;
        AccessController.checkPermsNPE(permissionArray);
        ProtectionDomain protectionDomain = AccessController.getCallerPD(1);
        if (protectionDomain == null) {
            protectionDomainArray = null;
        } else {
            ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[1];
            protectionDomainArray = protectionDomainArray2;
            protectionDomainArray2[0] = protectionDomain;
        }
        ProtectionDomain[] protectionDomainArray3 = protectionDomainArray;
        return AccessController.doPrivileged(privilegedAction, new AccessControlContext(accessControlContext, protectionDomainArray3, AccessController.getNewAuthorizedState(accessControlContext, protectionDomain)), permissionArray);
    }

    @CallerSensitive
    public static <T> T doPrivileged(PrivilegedExceptionAction<T> privilegedExceptionAction, AccessControlContext accessControlContext, Permission ... permissionArray) throws PrivilegedActionException {
        try {
            AccessController.checkPermsNPE(permissionArray);
            T t = privilegedExceptionAction.run();
            AccessController.keepalive(accessControlContext);
            AccessController.keepalive(permissionArray);
            return t;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PrivilegedActionException(exception);
        }
    }

    public static <T> T doPrivilegedWithCombiner(PrivilegedExceptionAction<T> privilegedExceptionAction, AccessControlContext accessControlContext, Permission ... permissionArray) throws PrivilegedActionException {
        ProtectionDomain[] protectionDomainArray;
        AccessController.checkPermsNPE(permissionArray);
        ProtectionDomain protectionDomain = AccessController.getCallerPD(1);
        if (protectionDomain == null) {
            protectionDomainArray = null;
        } else {
            ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[1];
            protectionDomainArray = protectionDomainArray2;
            protectionDomainArray2[0] = protectionDomain;
        }
        ProtectionDomain[] protectionDomainArray3 = protectionDomainArray;
        return AccessController.doPrivileged(privilegedExceptionAction, new AccessControlContext(accessControlContext, protectionDomainArray3, AccessController.getNewAuthorizedState(accessControlContext, protectionDomain)), permissionArray);
    }

    static {
        AccessController.initializeInternal();
        createAccessControlContext = new SecurityPermission("createAccessControlContext");
    }

    static final class DebugRecursionDetection {
        private static ThreadLocal<String> tlDebug = new ThreadLocal();

        DebugRecursionDetection() {
        }

        static ThreadLocal<String> getTlDebug() {
            return tlDebug;
        }
    }
}

