/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.util.Arrays;
import java.util.Properties;

public final class ActivationGroupDesc
implements Serializable {
    private String className;
    private String location;
    private MarshalledObject<?> data;
    private CommandEnvironment env;
    private Properties props;
    private static final long serialVersionUID = -4936225423168276595L;

    public ActivationGroupDesc(Properties properties, CommandEnvironment commandEnvironment) {
        this(null, null, null, properties, commandEnvironment);
    }

    public ActivationGroupDesc(String string, String string2, MarshalledObject<?> marshalledObject, Properties properties, CommandEnvironment commandEnvironment) {
        this.props = properties;
        this.env = commandEnvironment;
        this.data = marshalledObject;
        this.location = string2;
        this.className = string;
    }

    public String getClassName() {
        return this.className;
    }

    public String getLocation() {
        return this.location;
    }

    public MarshalledObject<?> getData() {
        return this.data;
    }

    public Properties getPropertyOverrides() {
        return this.props != null ? (Properties)this.props.clone() : null;
    }

    public CommandEnvironment getCommandEnvironment() {
        return this.env;
    }

    public boolean equals(Object object) {
        if (object instanceof ActivationGroupDesc) {
            ActivationGroupDesc activationGroupDesc = (ActivationGroupDesc)object;
            return (this.className == null ? activationGroupDesc.className == null : this.className.equals(activationGroupDesc.className)) && (this.location == null ? activationGroupDesc.location == null : this.location.equals(activationGroupDesc.location)) && (this.data == null ? activationGroupDesc.data == null : this.data.equals(activationGroupDesc.data)) && (this.env == null ? activationGroupDesc.env == null : this.env.equals(activationGroupDesc.env)) && (this.props == null ? activationGroupDesc.props == null : this.props.equals(activationGroupDesc.props));
        }
        return false;
    }

    public int hashCode() {
        return (this.location == null ? 0 : this.location.hashCode() << 24) ^ (this.env == null ? 0 : this.env.hashCode() << 16) ^ (this.className == null ? 0 : this.className.hashCode() << 8) ^ (this.data == null ? 0 : this.data.hashCode());
    }

    public static class CommandEnvironment
    implements Serializable {
        private static final long serialVersionUID = 6165754737887770191L;
        private String command;
        private String[] options;

        public CommandEnvironment(String string, String[] stringArray) {
            this.command = string;
            if (stringArray == null) {
                this.options = new String[0];
            } else {
                this.options = new String[stringArray.length];
                System.arraycopy((Object)stringArray, 0, (Object)this.options, 0, stringArray.length);
            }
        }

        public String getCommandPath() {
            return this.command;
        }

        public String[] getCommandOptions() {
            return (String[])this.options.clone();
        }

        public boolean equals(Object object) {
            if (object instanceof CommandEnvironment) {
                CommandEnvironment commandEnvironment = (CommandEnvironment)object;
                return (this.command == null ? commandEnvironment.command == null : this.command.equals(commandEnvironment.command)) && Arrays.equals(this.options, commandEnvironment.options);
            }
            return false;
        }

        public int hashCode() {
            return this.command == null ? 0 : this.command.hashCode();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.options == null) {
                this.options = new String[0];
            }
        }
    }
}

