/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.target;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import com.ibm.tools.attach.target.AttachHandler;
import com.ibm.tools.attach.target.AttachmentConnection;
import com.ibm.tools.attach.target.CommonDirectory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.security.SecureRandom;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.Set;

public class IPC {
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    public static final int JNI_OK = 0;
    static final int TRACEPOINT_STATUS_NORMAL = 0;
    static final int TRACEPOINT_STATUS_LOGGING = 1;
    static final int TRACEPOINT_STATUS_ERROR = -1;
    static final int TRACEPOINT_STATUS_OOM_DURING_WAIT = -2;
    static final int TRACEPOINT_STATUS_OOM_DURING_TERMINATE = -3;
    static final String LOCAL_CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
    private static final EnumSet<PosixFilePermission> NON_OWNER_READ_WRITE = EnumSet.of(PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE);
    static final int LOGGING_UNKNOWN = 0;
    static final int LOGGING_DISABLED = 1;
    static final int LOGGING_ENABLED = 2;
    public static boolean isWindows = false;
    private static Random randomGen;
    static PrintStream logStream;
    static int loggingStatus;
    static String defaultVmId;
    public static final syncObject accessorMutex;

    static native int chmod(String var0, int var1);

    static native int chownFileToTargetUid(String var0, long var1);

    static int mkdirWithPermissions(String string, int n) throws IOException {
        int n2 = IPC.mkdirWithPermissionsImpl(string, n);
        if (0 != n2) {
            throw new IOException(string);
        }
        return n2;
    }

    static native int mkdirWithPermissionsImpl(String var0, int var1);

    public static void checkOwnerAccessOnly(String string) throws IOException {
        block5: {
            long l = IPC.getUid();
            long l2 = CommonDirectory.getFileOwner(string);
            if (0L != l && l2 != l) {
                IPC.logMessage("Wrong permissions or ownership for ", string);
                throw new IOException(Msg.getString("K0803", (Object)string, l2));
            }
            if (!isWindows) {
                try {
                    Set<PosixFilePermission> set = Files.getPosixFilePermissions(Paths.get(string, new String[0]), LinkOption.NOFOLLOW_LINKS);
                    set.retainAll(NON_OWNER_READ_WRITE);
                    if (!set.isEmpty()) {
                        String string2 = Files.getPosixFilePermissions(Paths.get(string, new String[0]), LinkOption.NOFOLLOW_LINKS).toString();
                        IPC.logMessage("Wrong permissions: " + string2 + " for ", string);
                        throw new IOException(Msg.getString("K0805", (Object)string, string2));
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    String string3 = VM.getVMLangAccess().internalGetProperties().getProperty("os.name");
                    if (null == string3 || string3.startsWith("Windows")) break block5;
                    throw new IOException(Msg.getString("K0806", string), unsupportedOperationException);
                }
            }
        }
    }

    static native int openSemaphore(String var0, String var1);

    static native int waitSemaphore();

    static native int notifyVm(String var0, String var1, int var2);

    static native int cancelNotify(String var0, String var1, int var2);

    static native void closeSemaphore();

    static native int destroySemaphore();

    public static native long getUid();

    static native boolean isUsingDefaultUid();

    static native long getProcessId();

    public static boolean processExists(long l) {
        int n = IPC.processExistsImpl(l);
        return n > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isLoggingEnabled() {
        boolean bl = false;
        if (1 == loggingStatus) {
            bl = false;
        } else if (2 == loggingStatus) {
            bl = true;
        } else {
            syncObject syncObject2 = accessorMutex;
            synchronized (syncObject2) {
                bl = 2 == loggingStatus;
            }
        }
        return bl;
    }

    private static native int processExistsImpl(long var0);

    static void createNewFileWithPermissions(File file, int n) throws IOException {
        int n2;
        String string = file.getAbsolutePath();
        if (file.exists()) {
            IPC.logMessage("Found existing file ", string);
            if (!file.delete()) {
                IPC.logMessage("Cannot delete existing file ", string);
                throw new IOException(Msg.getString("K0807", string));
            }
        }
        if (0 != (n2 = IPC.createFileWithPermissionsImpl(file.getAbsolutePath(), n))) {
            IPC.logMessage("Cannot create new file ", string);
            throw new IOException(Msg.getString("K0808", string));
        }
    }

    private static native int createFileWithPermissionsImpl(String var0, int var1);

    static String getTmpDir() {
        String string = IPC.getTempDirImpl();
        if (null == string) {
            IPC.logMessage("Could not get system temporary directory. Trying java.io.tmpdir");
            string = VM.getVMLangAccess().internalGetProperties().getProperty(JAVA_IO_TMPDIR);
        }
        return string;
    }

    private static native String getTempDirImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRandomNumber() {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            if (null == randomGen) {
                randomGen = new Random(System.nanoTime());
            }
            return randomGen.nextInt();
        }
    }

    public static String getRandomString() {
        SecureRandom secureRandom = new SecureRandom();
        return Long.toHexString(secureRandom.nextLong());
    }

    static native void tracepoint(int var0, String var1);

    public static void logMessage(String string) {
        if (IPC.isLoggingEnabled()) {
            IPC.printLogMessage(string);
        }
    }

    public static void logMessage(String string, String string2) {
        if (IPC.isLoggingEnabled()) {
            IPC.printLogMessage(string + string2);
        }
    }

    public static void logMessage(String string, int n) {
        if (IPC.isLoggingEnabled()) {
            IPC.printLogMessage(string + Integer.toString(n));
        }
    }

    public static void logMessage(String string, int n, String string2) {
        if (IPC.isLoggingEnabled()) {
            IPC.printLogMessage(string + Integer.toString(n) + string2);
        }
    }

    public static void logMessage(String string, int n, String string2, String string3) {
        if (IPC.isLoggingEnabled()) {
            IPC.printLogMessage(string + Integer.toString(n) + string2 + string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logMessage(String string, Throwable throwable) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            if (IPC.isLoggingEnabled()) {
                IPC.printMessageWithHeader(string, logStream);
                throwable.printStackTrace(logStream);
                logStream.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printLogMessage(String string) {
        syncObject syncObject2 = accessorMutex;
        synchronized (syncObject2) {
            if (!Objects.isNull(logStream)) {
                IPC.printMessageWithHeader(string, logStream);
                logStream.flush();
            }
        }
    }

    static void printMessageWithHeader(String string, PrintStream printStream) {
        IPC.tracepoint(1, string);
        IPC.printLogMessageHeader(printStream);
        printStream.println(string);
    }

    private static void printLogMessageHeader(PrintStream printStream) {
        long l = System.currentTimeMillis();
        printStream.print(l);
        printStream.print(" ");
        String string = AttachHandler.getVmId();
        if (0 == string.length()) {
            string = defaultVmId;
        }
        printStream.print(string);
        printStream.print(": ");
        printStream.print(Thread.currentThread().getId());
        printStream.print(" [");
        printStream.print(Thread.currentThread().getName());
        printStream.print("]: ");
    }

    static void setDefaultVmId(String string) {
        defaultVmId = string;
    }

    public static void sendProperties(Properties properties, OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        properties.store(byteArrayOutputStream, "");
        outputStream.write(byteArrayOutputStream.toByteArray());
        outputStream.write(0);
    }

    public static Properties receiveProperties(InputStream inputStream, boolean bl) throws IOException {
        byte[] byArray = AttachmentConnection.streamReceiveBytes(inputStream, 0, bl);
        Properties properties = new Properties();
        properties.load(new ByteArrayInputStream(byArray));
        return properties;
    }

    static {
        loggingStatus = 0;
        accessorMutex = new syncObject();
    }

    static final class syncObject {
        syncObject() {
        }
    }
}

