/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.debugger;

import com.ibm.j9ddr.corereaders.debugger.JniMemory;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import java.io.IOException;
import javax.imageio.stream.ImageInputStreamImpl;

public class JniImageInputStream
extends ImageInputStreamImpl {
    private final JniMemory memory;

    public JniImageInputStream(JniMemory jniMemory) {
        this.memory = jniMemory;
    }

    @Override
    public int read() throws IOException {
        try {
            byte by = this.memory.getByteAt(this.streamPos);
            ++this.streamPos;
            return by;
        }
        catch (MemoryFault memoryFault) {
            throw new IOException(memoryFault.getMessage() + ":" + memoryFault.getAddress());
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            return this.memory.getBytesAt(this.streamPos, byArray, n, n2);
        }
        catch (MemoryFault memoryFault) {
            throw new IOException(memoryFault.getMessage() + ":" + memoryFault.getAddress());
        }
    }
}

