/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.stackwalker;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmPicker;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.BaseAlgorithm;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.IAlgorithm;
import com.ibm.j9ddr.vm29.j9.J9ConfigFlags;
import com.ibm.j9ddr.vm29.j9.stackwalker.JITStackWalker;
import com.ibm.j9ddr.vm29.j9.stackwalker.MapIterator;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalkerUtils;
import com.ibm.j9ddr.vm29.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.U16Pointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITExceptionTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITStackAtlasPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9StackWalkFlags;
import com.ibm.j9ddr.vm29.pointer.generated.TRBuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.TR_ByteCodeInfoPointer;
import com.ibm.j9ddr.vm29.pointer.generated.TR_InlinedCallSitePointer;
import com.ibm.j9ddr.vm29.structure.CLimits;
import com.ibm.j9ddr.vm29.structure.J9JITExceptionTable;
import com.ibm.j9ddr.vm29.structure.J9JITStackAtlas;
import com.ibm.j9ddr.vm29.structure.J9StackWalkConstants;
import com.ibm.j9ddr.vm29.structure.MethodMetaDataConstants;
import com.ibm.j9ddr.vm29.structure.TR_InlinedCallSite;
import com.ibm.j9ddr.vm29.types.I16;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.U64;
import com.ibm.j9ddr.vm29.types.U8;
import com.ibm.j9ddr.vm29.types.UDATA;
import com.ibm.j9ddr.vm29.types.UScalar;
import java.util.LinkedList;

public class MethodMetaData {
    public static final long REGISTER_MAP_VALUE_FOR_GAP = -86062338L;
    public static final long BYTE_CODE_INFO_VALUE_FOR_GAP = 0L;
    private static MethodMetaDataImpl impl;
    private static final AlgorithmPicker<MethodMetaDataImpl> picker;

    public static I16 getJitTotalFrameSize(J9JITExceptionTablePointer j9JITExceptionTablePointer) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitTotalFrameSize(j9JITExceptionTablePointer);
    }

    public static VoidPointer getJitInlinedCallInfo(J9JITExceptionTablePointer j9JITExceptionTablePointer) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitInlinedCallInfo(j9JITExceptionTablePointer);
    }

    public static void jitAddSpilledRegistersForDataResolve(WalkState walkState) throws CorruptDataException {
        MethodMetaData.getImpl().jitAddSpilledRegistersForDataResolve(walkState);
    }

    public static UDATA getJitDataResolvePushes() throws CorruptDataException {
        return MethodMetaData.getImpl().getJitDataResolvePushes();
    }

    public static VoidPointer getStackMapFromJitPC(J9JavaVMPointer j9JavaVMPointer, J9JITExceptionTablePointer j9JITExceptionTablePointer, UDATA uDATA) throws CorruptDataException {
        return MethodMetaData.getImpl().getStackMapFromJitPC(j9JavaVMPointer, j9JITExceptionTablePointer, uDATA);
    }

    public static J9JITStackAtlasPointer getJitGCStackAtlas(J9JITExceptionTablePointer j9JITExceptionTablePointer) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitGCStackAtlas(j9JITExceptionTablePointer);
    }

    public static VoidPointer getFirstInlinedCallSite(J9JITExceptionTablePointer j9JITExceptionTablePointer, VoidPointer voidPointer) throws CorruptDataException {
        return MethodMetaData.getImpl().getFirstInlinedCallSite(j9JITExceptionTablePointer, voidPointer);
    }

    public static UDATA getJitInlineDepthFromCallSite(J9JITExceptionTablePointer j9JITExceptionTablePointer, VoidPointer voidPointer) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitInlineDepthFromCallSite(j9JITExceptionTablePointer, voidPointer);
    }

    public static boolean hasMoreInlinedMethods(VoidPointer voidPointer) throws CorruptDataException {
        return MethodMetaData.getImpl().hasMoreInlinedMethods(voidPointer);
    }

    public static VoidPointer getInlinedMethod(VoidPointer voidPointer) throws CorruptDataException {
        return MethodMetaData.getImpl().getInlinedMethod(voidPointer);
    }

    public static UDATA getCurrentByteCodeIndexAndIsSameReceiver(J9JITExceptionTablePointer j9JITExceptionTablePointer, VoidPointer voidPointer, VoidPointer voidPointer2, boolean[] blArray) throws CorruptDataException {
        return MethodMetaData.getImpl().getCurrentByteCodeIndexAndIsSameReceiver(j9JITExceptionTablePointer, voidPointer, voidPointer2, blArray);
    }

    public static void jitAddSpilledRegisters(WalkState walkState) throws CorruptDataException {
        MethodMetaData.getImpl().jitAddSpilledRegisters(walkState);
    }

    public static void jitAddSpilledRegisters(WalkState walkState, VoidPointer voidPointer) throws CorruptDataException {
        MethodMetaData.getImpl().jitAddSpilledRegisters(walkState, voidPointer);
    }

    public static UDATAPointer getObjectArgScanCursor(WalkState walkState) throws CorruptDataException {
        return MethodMetaData.getImpl().getObjectArgScanCursor(walkState);
    }

    public static U8Pointer getJitDescriptionCursor(VoidPointer voidPointer, WalkState walkState) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitDescriptionCursor(voidPointer, walkState);
    }

    public static U16 getJitNumberOfMapBytes(J9JITStackAtlasPointer j9JITStackAtlasPointer) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitNumberOfMapBytes(j9JITStackAtlasPointer);
    }

    public static U32 getJitRegisterMap(J9JITExceptionTablePointer j9JITExceptionTablePointer, VoidPointer voidPointer) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitRegisterMap(j9JITExceptionTablePointer, voidPointer);
    }

    public static U32 getJitHighWordRegisterMap(J9JITExceptionTablePointer j9JITExceptionTablePointer, VoidPointer voidPointer) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitHighWordRegisterMap(j9JITExceptionTablePointer, voidPointer);
    }

    public static U8Pointer getNextDescriptionCursor(J9JITExceptionTablePointer j9JITExceptionTablePointer, VoidPointer voidPointer, U8Pointer u8Pointer) throws CorruptDataException {
        return MethodMetaData.getImpl().getNextDescriptionCursor(j9JITExceptionTablePointer, voidPointer, u8Pointer);
    }

    public static U16 getJitNumberOfParmSlots(J9JITStackAtlasPointer j9JITStackAtlasPointer) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitNumberOfParmSlots(j9JITStackAtlasPointer);
    }

    public static U8Pointer getJitInternalPointerMap(J9JITStackAtlasPointer j9JITStackAtlasPointer) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitInternalPointerMap(j9JITStackAtlasPointer);
    }

    public static void walkJITFrameSlotsForInternalPointers(WalkState walkState, U8Pointer u8Pointer, UDATAPointer uDATAPointer, VoidPointer voidPointer, J9JITStackAtlasPointer j9JITStackAtlasPointer) throws CorruptDataException {
        MethodMetaData.getImpl().walkJITFrameSlotsForInternalPointers(walkState, u8Pointer, uDATAPointer, voidPointer, j9JITStackAtlasPointer);
    }

    public static VoidPointer getNextInlinedCallSite(J9JITExceptionTablePointer j9JITExceptionTablePointer, VoidPointer voidPointer) throws CorruptDataException {
        return MethodMetaData.getImpl().getNextInlinedCallSite(j9JITExceptionTablePointer, voidPointer);
    }

    public static U8 getNextDescriptionBit(U8Pointer u8Pointer) throws CorruptDataException {
        return MethodMetaData.getImpl().getNextDescriptionBit(u8Pointer);
    }

    public static UDATAPointer getObjectTempScanCursor(WalkState walkState) throws CorruptDataException {
        return MethodMetaData.getImpl().getObjectTempScanCursor(walkState);
    }

    public static int getJitRecompilationResolvePushes() {
        return MethodMetaData.getImpl().getJitRecompilationResolvePushes();
    }

    public static int getJitVirtualMethodResolvePushes() {
        return MethodMetaData.getImpl().getJitVirtualMethodResolvePushes();
    }

    public static int getJitStaticMethodResolvePushes() {
        return MethodMetaData.getImpl().getJitStaticMethodResolvePushes();
    }

    public static VoidPointer getStackAllocMapFromJitPC(J9JavaVMPointer j9JavaVMPointer, J9JITExceptionTablePointer j9JITExceptionTablePointer, UDATA uDATA, VoidPointer voidPointer) throws CorruptDataException {
        return MethodMetaData.getImpl().getStackAllocMapFromJitPC(j9JavaVMPointer, j9JITExceptionTablePointer, uDATA, voidPointer);
    }

    public static U8Pointer getJitStackSlots(J9JITExceptionTablePointer j9JITExceptionTablePointer, VoidPointer voidPointer) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitStackSlots(j9JITExceptionTablePointer, voidPointer);
    }

    public static void markClassesInInlineRanges(J9JITExceptionTablePointer j9JITExceptionTablePointer, WalkState walkState) throws CorruptDataException {
        MethodMetaData.getImpl().markClassesInInlineRanges(j9JITExceptionTablePointer, walkState);
    }

    public static void jitGetMapsFromPC(J9JavaVMPointer j9JavaVMPointer, J9JITExceptionTablePointer j9JITExceptionTablePointer, UDATA uDATA, JITMaps jITMaps) throws CorruptDataException {
        MethodMetaData.getImpl().jitGetMapsFromPC(j9JavaVMPointer, j9JITExceptionTablePointer, uDATA, jITMaps);
    }

    private static MethodMetaDataImpl getImpl() {
        if (impl == null) {
            impl = picker.pickAlgorithm();
        }
        return impl;
    }

    static {
        picker = new AlgorithmPicker<MethodMetaDataImpl>("ALG_METHOD_META_DATA_VERSION"){

            @Override
            protected Iterable<? extends MethodMetaDataImpl> allAlgorithms() {
                LinkedList<MethodMetaData_29_V0> linkedList = new LinkedList<MethodMetaData_29_V0>();
                linkedList.add(new MethodMetaData_29_V0());
                return linkedList;
            }
        };
    }

    private static class MethodMetaData_29_V0
    extends BaseAlgorithm
    implements MethodMetaDataImpl {
        private static boolean alignStackMaps = J9ConfigFlags.arch_arm || TRBuildFlags.host_SH4 || TRBuildFlags.host_MIPS;

        protected MethodMetaData_29_V0() {
            super(90, 0);
        }

        @Override
        public I16 getJitTotalFrameSize(J9JITExceptionTablePointer j9JITExceptionTablePointer) throws CorruptDataException {
            return new I16(j9JITExceptionTablePointer.totalFrameSize());
        }

        @Override
        public VoidPointer getJitInlinedCallInfo(J9JITExceptionTablePointer j9JITExceptionTablePointer) throws CorruptDataException {
            return j9JITExceptionTablePointer.inlinedCalls();
        }

        @Override
        public void jitAddSpilledRegistersForDataResolve(WalkState walkState) throws CorruptDataException {
            UDATAPointer uDATAPointer = walkState.unwindSP.add(MethodMetaData_29_V0.getJitSlotsBeforeSavesInDataResolve());
            int n = 0;
            int n2 = 0;
            while ((long)n2 < J9StackWalkConstants.J9SW_POTENTIAL_SAVED_REGISTERS) {
                walkState.registerEAs[n++] = uDATAPointer;
                uDATAPointer = uDATAPointer.add(1L);
                ++n2;
            }
            StackWalkerUtils.swPrintf(walkState, 2, "\t{0} slots skipped before scalar registers", MethodMetaData_29_V0.getJitSlotsBeforeSavesInDataResolve());
            JITStackWalker.jitPrintRegisterMapArray(walkState, "DataResolve");
        }

        private static UDATA getJitSlotsBeforeSavesInDataResolve() {
            if (J9ConfigFlags.arch_x86) {
                if (J9BuildFlags.env_data64) {
                    return new UDATA(16L);
                }
                return new UDATA(20L);
            }
            return new UDATA(0L);
        }

        @Override
        public void jitAddSpilledRegisters(WalkState walkState) throws CorruptDataException {
            throw new UnsupportedOperationException("Not implemented at 2.6");
        }

        @Override
        public void jitAddSpilledRegisters(WalkState walkState, VoidPointer voidPointer) throws CorruptDataException {
            UDATA uDATA = new UDATA(0L);
            UDATA uDATA2 = new UDATA(0L);
            UDATA uDATA3 = new UDATA(0L);
            UDATAPointer uDATAPointer = UDATAPointer.NULL;
            int n = 0;
            J9JITExceptionTablePointer j9JITExceptionTablePointer = walkState.jitInfo;
            UDATA uDATA4 = walkState.jitInfo.registerSaveDescription();
            if (J9ConfigFlags.arch_x86) {
                UDATA uDATA5 = new UDATA(this.getJitProloguePushes(walkState.jitInfo));
                U8 u8 = new U8(1L);
                if (!uDATA5.eq(0L)) {
                    uDATAPointer = walkState.bp.sub(new UDATA(this.getJitScalarTempSlots(walkState.jitInfo)).add(new UDATA(this.getJitObjectTempSlots(walkState.jitInfo)).add(uDATA5)));
                    uDATA4 = uDATA4.bitAnd(J9StackWalkConstants.J9SW_REGISTER_MAP_MASK);
                    do {
                        if (uDATA4.anyBitsIn(1L)) {
                            walkState.registerEAs[n] = uDATAPointer;
                            uDATAPointer = uDATAPointer.add(1L);
                        }
                        u8 = u8.add(1);
                        ++n;
                    } while (!(uDATA4 = uDATA4.rightShift(1)).eq(0L));
                }
            } else if (J9ConfigFlags.arch_power || TRBuildFlags.host_MIPS) {
                if (J9ConfigFlags.arch_power) {
                    uDATA = uDATA4.bitAnd(new UDATA(131071L));
                    uDATA2 = uDATA4.rightShift(17).bitAnd(new UDATA(65535L));
                    uDATA3 = new UDATA(15L);
                } else if (TRBuildFlags.host_MIPS) {
                    uDATA = uDATA4.bitAnd(31);
                    uDATA2 = uDATA4.rightShift(13);
                    uDATA3 = new UDATA(24L).sub(uDATA);
                }
                uDATAPointer = walkState.bp.subOffset(uDATA2);
                if (J9ConfigFlags.arch_power) {
                    n += uDATA3.intValue();
                    U8 u8 = new U8(uDATA3.add(1L));
                    do {
                        if (uDATA.anyBitsIn(1L)) {
                            walkState.registerEAs[n] = uDATAPointer;
                            uDATAPointer = uDATAPointer.add(1L);
                        }
                        u8 = u8.add(1);
                        ++n;
                    } while (!(uDATA = uDATA.rightShift(1)).eq(0L));
                } else {
                    n += uDATA3.intValue();
                    while (!uDATA.eq(0L)) {
                        walkState.registerEAs[n++] = uDATAPointer;
                        uDATAPointer = uDATAPointer.add(1L);
                        uDATA = uDATA.sub(1L);
                    }
                }
            } else if ((J9ConfigFlags.arch_arm || TRBuildFlags.host_SH4 || J9ConfigFlags.arch_s390) && !(uDATA = uDATA4.bitAnd(new UDATA(65535L))).eq(0L)) {
                uDATA2 = new UDATA(65535L).bitAnd(uDATA4.rightShift(16));
                uDATAPointer = walkState.bp.subOffset(uDATA2);
                U8 u8 = new U8(1L);
                do {
                    if (uDATA.anyBitsIn(1L)) {
                        walkState.registerEAs[n] = uDATAPointer;
                        uDATAPointer = uDATAPointer.add(1L);
                    }
                    u8 = u8.add(1);
                    ++n;
                } while (!(uDATA = uDATA.rightShift(1)).eq(0L));
            }
            JITStackWalker.jitPrintRegisterMapArray(walkState, "Frame");
        }

        private U8Pointer GET_REGISTER_SAVE_DESCRIPTION_CURSOR(boolean bl, VoidPointer voidPointer) {
            if (J9ConfigFlags.arch_s390) {
                return U8Pointer.cast(voidPointer).add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(bl)).add(8L);
            }
            return U8Pointer.cast(voidPointer).add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(bl)).add(4L);
        }

        public U16 getJitProloguePushes(J9JITExceptionTablePointer j9JITExceptionTablePointer) throws CorruptDataException {
            return j9JITExceptionTablePointer.prologuePushes();
        }

        public I16 getJitScalarTempSlots(J9JITExceptionTablePointer j9JITExceptionTablePointer) throws CorruptDataException {
            return j9JITExceptionTablePointer.scalarTempSlots();
        }

        public I16 getJitObjectTempSlots(J9JITExceptionTablePointer j9JITExceptionTablePointer) throws CorruptDataException {
            return j9JITExceptionTablePointer.objectTempSlots();
        }

        @Override
        public UDATA getJitDataResolvePushes() throws CorruptDataException {
            if (J9ConfigFlags.arch_x86) {
                if (J9BuildFlags.env_data64) {
                    return new UDATA(35L);
                }
                return new UDATA(32L);
            }
            if (J9ConfigFlags.arch_arm) {
                return new UDATA(12L);
            }
            if (J9ConfigFlags.arch_s390) {
                if (J9BuildFlags.jit_32bitUses64bitRegisters) {
                    return new UDATA(32L);
                }
                return new UDATA(16L);
            }
            if (J9ConfigFlags.arch_power) {
                return new UDATA(33L);
            }
            if (TRBuildFlags.host_MIPS) {
                return new UDATA(32L);
            }
            if (TRBuildFlags.host_SH4) {
                return new UDATA(16L);
            }
            return new UDATA(0L);
        }

        @Override
        public VoidPointer getStackMapFromJitPC(J9JavaVMPointer j9JavaVMPointer, J9JITExceptionTablePointer j9JITExceptionTablePointer, UDATA uDATA) throws CorruptDataException {
            JITMaps jITMaps = new JITMaps();
            this.jitGetMapsFromPC(j9JavaVMPointer, j9JITExceptionTablePointer, uDATA, jITMaps);
            return VoidPointer.cast(jITMaps.stackMap);
        }

        @Override
        public J9JITStackAtlasPointer getJitGCStackAtlas(J9JITExceptionTablePointer j9JITExceptionTablePointer) throws CorruptDataException {
            return J9JITStackAtlasPointer.cast(j9JITExceptionTablePointer.gcStackAtlas());
        }

        @Override
        public void jitGetMapsFromPC(J9JavaVMPointer j9JavaVMPointer, J9JITExceptionTablePointer j9JITExceptionTablePointer, UDATA uDATA, JITMaps jITMaps) throws CorruptDataException {
            MapIterator mapIterator = new MapIterator();
            UDATA uDATA2 = uDATA.sub(j9JITExceptionTablePointer.startPC()).sub(1L);
            boolean bl = MethodMetaData_29_V0.HAS_FOUR_BYTE_OFFSET(j9JITExceptionTablePointer);
            jITMaps.stackMap = PointerPointer.NULL;
            jITMaps.inlineMap = PointerPointer.NULL;
            if (j9JITExceptionTablePointer.gcStackAtlas().isNull()) {
                return;
            }
            this.initializeIterator(mapIterator, j9JITExceptionTablePointer);
            this.findMapsAtPC(mapIterator, uDATA2, jITMaps, bl);
        }

        private void findMapsAtPC(MapIterator mapIterator, UDATA uDATA, JITMaps jITMaps, boolean bl) throws CorruptDataException {
            while (this.getNextMap(mapIterator, bl).notNull()) {
                if (!this.matchingRange(mapIterator, uDATA)) continue;
                jITMaps.stackMap = MethodMetaData_29_V0.currentStackMap(mapIterator);
                jITMaps.inlineMap = MethodMetaData_29_V0.currentInlineMap(mapIterator);
                break;
            }
        }

        private static PointerPointer currentInlineMap(MapIterator mapIterator) {
            return PointerPointer.cast(mapIterator._currentInlineMap);
        }

        private static PointerPointer currentStackMap(MapIterator mapIterator) {
            return PointerPointer.cast(mapIterator._currentStackMap);
        }

        private boolean matchingRange(MapIterator mapIterator, UDATA uDATA) {
            return mapIterator._rangeStartOffset.lte(uDATA) && uDATA.lte(mapIterator._rangeEndOffset);
        }

        private U8Pointer getNextMap(MapIterator mapIterator, boolean bl) throws CorruptDataException {
            mapIterator._currentMap = mapIterator._nextMap;
            if (mapIterator._currentMap.notNull()) {
                mapIterator._currentInlineMap = mapIterator._currentMap;
                if (!MethodMetaData_29_V0.IS_BYTECODEINFO_MAP(bl, mapIterator._currentMap)) {
                    mapIterator._currentStackMap = mapIterator._currentMap;
                }
                mapIterator._rangeStartOffset = MethodMetaData_29_V0.GET_LOW_PC_OFFSET_VALUE(bl, mapIterator._currentMap);
                mapIterator._mapIndex = mapIterator._mapIndex.add(1);
                if (mapIterator._mapIndex.lt(mapIterator._stackAtlas.numberOfMaps())) {
                    mapIterator._nextMap = MethodMetaData_29_V0.GET_NEXT_STACK_MAP(bl, mapIterator._currentMap, mapIterator._stackAtlas);
                    mapIterator._rangeEndOffset = MethodMetaData_29_V0.GET_LOW_PC_OFFSET_VALUE(bl, mapIterator._nextMap).sub(1L);
                } else {
                    mapIterator._nextMap = U8Pointer.NULL;
                    mapIterator._rangeEndOffset = mapIterator._methodMetaData.endPC().sub(mapIterator._methodMetaData.startPC()).sub(1L);
                }
            }
            return mapIterator._currentMap;
        }

        private static UDATA GET_LOW_PC_OFFSET_VALUE(boolean bl, U8Pointer u8Pointer) throws CorruptDataException {
            UScalar uScalar = null;
            uScalar = bl ? U32Pointer.cast(MethodMetaData_29_V0.ADDRESS_OF_LOW_PC_OFFSET_IN_STACK_MAP(bl, u8Pointer)).at(0L) : U16Pointer.cast(MethodMetaData_29_V0.ADDRESS_OF_LOW_PC_OFFSET_IN_STACK_MAP(bl, u8Pointer)).at(0L);
            return new UDATA(uScalar);
        }

        private static U32 GET_SIZEOF_BYTECODEINFO_MAP(boolean bl) {
            return new U32(4L).add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(bl));
        }

        private static U8Pointer ADDRESS_OF_BYTECODEINFO_IN_STACK_MAP(boolean bl, U8Pointer u8Pointer) {
            return u8Pointer.add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(bl));
        }

        private static U8Pointer ADDRESS_OF_LOW_PC_OFFSET_IN_STACK_MAP(boolean bl, U8Pointer u8Pointer) {
            return u8Pointer;
        }

        private static U8Pointer ADDRESS_OF_REGISTERMAP(boolean bl, U8Pointer u8Pointer) {
            if (J9ConfigFlags.arch_s390) {
                return u8Pointer.add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(bl)).add(12L);
            }
            return u8Pointer.add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(bl)).add(8L);
        }

        private static boolean RANGE_NEEDS_FOUR_BYTE_OFFSET(Scalar scalar) {
            return scalar.gte(new U64(CLimits.USHRT_MAX));
        }

        private static boolean HAS_FOUR_BYTE_OFFSET(J9JITExceptionTablePointer j9JITExceptionTablePointer) throws CorruptDataException {
            if (AlgorithmVersion.getVersionOf("FOUR_BYTE_OFFSETS_VERSION").getAlgorithmVersion() > 0 && j9JITExceptionTablePointer.flags().anyBitsIn(J9JITExceptionTable.JIT_METADATA_FLAGS_USED_FOR_SIZE)) {
                return j9JITExceptionTablePointer.flags().anyBitsIn(J9JITExceptionTable.JIT_METADATA_GC_MAP_32_BIT_OFFSETS);
            }
            return MethodMetaData_29_V0.RANGE_NEEDS_FOUR_BYTE_OFFSET(j9JITExceptionTablePointer.endPC().sub(j9JITExceptionTablePointer.startPC()));
        }

        private static U32 SIZEOF_MAP_OFFSET(boolean bl) {
            return alignStackMaps || bl ? new U32(4L) : new U32(2L);
        }

        private static boolean IS_BYTECODEINFO_MAP(boolean bl, U8Pointer u8Pointer) throws CorruptDataException {
            return !TR_ByteCodeInfoPointer.cast(MethodMetaData_29_V0.ADDRESS_OF_BYTECODEINFO_IN_STACK_MAP(bl, u8Pointer))._doNotProfile().eq(0L);
        }

        private static U8Pointer GET_REGISTER_MAP_CURSOR(boolean bl, U8Pointer u8Pointer) {
            if (J9ConfigFlags.arch_s390) {
                return u8Pointer.add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(bl).add(12));
            }
            return u8Pointer.add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(bl).add(8));
        }

        private static U8Pointer GET_NEXT_STACK_MAP(boolean bl, U8Pointer u8Pointer, J9JITStackAtlasPointer j9JITStackAtlasPointer) throws CorruptDataException {
            U8Pointer u8Pointer2 = u8Pointer;
            if (MethodMetaData_29_V0.IS_BYTECODEINFO_MAP(bl, u8Pointer)) {
                u8Pointer2 = u8Pointer2.add(MethodMetaData_29_V0.GET_SIZEOF_BYTECODEINFO_MAP(bl));
            } else {
                u8Pointer2 = MethodMetaData_29_V0.GET_REGISTER_MAP_CURSOR(bl, u8Pointer);
                if (U32Pointer.cast(u8Pointer2).at(0L).anyBitsIn(MethodMetaDataConstants.INTERNAL_PTR_REG_MASK) && j9JITStackAtlasPointer.internalPointerMap().notNull()) {
                    u8Pointer2 = u8Pointer2.add(u8Pointer2.add(4L).at(0L).add(1));
                }
                if ((u8Pointer2 = u8Pointer2.add(3L).add(j9JITStackAtlasPointer.numberOfMapBytes())).at(0L).anyBitsIn(128L)) {
                    u8Pointer2 = u8Pointer2.add(j9JITStackAtlasPointer.numberOfMapBytes());
                }
                u8Pointer2 = u8Pointer2.add(1L);
            }
            return u8Pointer2;
        }

        private void initializeIterator(MapIterator mapIterator, J9JITExceptionTablePointer j9JITExceptionTablePointer) throws CorruptDataException {
            mapIterator._methodMetaData = j9JITExceptionTablePointer;
            mapIterator._stackAtlas = J9JITStackAtlasPointer.cast(j9JITExceptionTablePointer.gcStackAtlas());
            mapIterator._currentStackMap = U8Pointer.NULL;
            mapIterator._currentInlineMap = U8Pointer.NULL;
            mapIterator._nextMap = this.getFirstStackMap(mapIterator._stackAtlas);
            mapIterator._mapIndex = new U32(0L);
        }

        private U8Pointer getFirstStackMap(J9JITStackAtlasPointer j9JITStackAtlasPointer) throws CorruptDataException {
            return U8Pointer.cast(j9JITStackAtlasPointer).add(J9JITStackAtlas.SIZEOF).add(j9JITStackAtlasPointer.numberOfMapBytes());
        }

        @Override
        public VoidPointer getFirstInlinedCallSite(J9JITExceptionTablePointer j9JITExceptionTablePointer, VoidPointer voidPointer) throws CorruptDataException {
            return this.getFirstInlinedCallSiteWithByteCodeInfo(j9JITExceptionTablePointer, voidPointer, VoidPointer.NULL);
        }

        private VoidPointer ADDRESS_OF_BYTECODEINFO_IN_STACK_MAP(boolean bl, VoidPointer voidPointer) {
            return VoidPointer.cast(U8Pointer.cast(voidPointer).add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(bl)));
        }

        private VoidPointer getFirstInlinedCallSiteWithByteCodeInfo(J9JITExceptionTablePointer j9JITExceptionTablePointer, VoidPointer voidPointer, VoidPointer voidPointer2) throws CorruptDataException {
            I32 i32;
            if (voidPointer2.isNull()) {
                voidPointer2 = this.ADDRESS_OF_BYTECODEINFO_IN_STACK_MAP(MethodMetaData_29_V0.HAS_FOUR_BYTE_OFFSET(j9JITExceptionTablePointer), voidPointer);
            }
            if ((i32 = new I32(TR_ByteCodeInfoPointer.cast(voidPointer2)._callerIndex())).lt(0)) {
                return VoidPointer.NULL;
            }
            return this.getNotUnloadedInlinedCallSiteArrayElement(j9JITExceptionTablePointer, i32);
        }

        private U32 sizeOfInlinedCallSiteArrayElement(J9JITExceptionTablePointer j9JITExceptionTablePointer) throws CorruptDataException {
            return new U32(TR_InlinedCallSite.SIZEOF).add(J9JITStackAtlasPointer.cast(j9JITExceptionTablePointer.gcStackAtlas()).numberOfMapBytes());
        }

        private U8Pointer getInlinedCallSiteArrayElement(J9JITExceptionTablePointer j9JITExceptionTablePointer, I32 i32) throws CorruptDataException {
            U8Pointer u8Pointer = U8Pointer.cast(this.getJitInlinedCallInfo(j9JITExceptionTablePointer));
            if (u8Pointer.notNull()) {
                return u8Pointer.add(this.sizeOfInlinedCallSiteArrayElement(j9JITExceptionTablePointer).mult(i32.intValue()));
            }
            return U8Pointer.NULL;
        }

        private boolean isUnloadedInlinedMethod(J9MethodPointer j9MethodPointer) {
            return UDATA.cast(j9MethodPointer).bitNot().eq(0L);
        }

        private VoidPointer getNotUnloadedInlinedCallSiteArrayElement(J9JITExceptionTablePointer j9JITExceptionTablePointer, I32 i32) throws CorruptDataException {
            VoidPointer voidPointer = VoidPointer.cast(this.getInlinedCallSiteArrayElement(j9JITExceptionTablePointer, i32));
            while (this.isUnloadedInlinedMethod(J9MethodPointer.cast(this.getInlinedMethod(voidPointer))) && !(voidPointer = this.getNextInlinedCallSite(j9JITExceptionTablePointer, voidPointer)).isNull()) {
            }
            return voidPointer;
        }

        @Override
        public UDATA getJitInlineDepthFromCallSite(J9JITExceptionTablePointer j9JITExceptionTablePointer, VoidPointer voidPointer) throws CorruptDataException {
            UDATA uDATA = new UDATA(0L);
            do {
                uDATA = uDATA.add(1L);
            } while ((voidPointer = this.getNextInlinedCallSite(j9JITExceptionTablePointer, voidPointer)).notNull());
            return uDATA;
        }

        @Override
        public VoidPointer getNextInlinedCallSite(J9JITExceptionTablePointer j9JITExceptionTablePointer, VoidPointer voidPointer) throws CorruptDataException {
            if (this.hasMoreInlinedMethods(voidPointer)) {
                return this.getNotUnloadedInlinedCallSiteArrayElement(j9JITExceptionTablePointer, new I32(MethodMetaData_29_V0.getByteCodeInfo(voidPointer)._callerIndex()));
            }
            return VoidPointer.NULL;
        }

        @Override
        public boolean hasMoreInlinedMethods(VoidPointer voidPointer) throws CorruptDataException {
            TR_ByteCodeInfoPointer tR_ByteCodeInfoPointer = MethodMetaData_29_V0.getByteCodeInfo(voidPointer);
            return !tR_ByteCodeInfoPointer._callerIndex().lt(new I32(0L));
        }

        private static TR_ByteCodeInfoPointer getByteCodeInfo(VoidPointer voidPointer) throws CorruptDataException {
            return TR_ByteCodeInfoPointer.cast(TR_InlinedCallSitePointer.cast(voidPointer)._byteCodeInfoEA());
        }

        @Override
        public VoidPointer getInlinedMethod(VoidPointer voidPointer) throws CorruptDataException {
            return TR_InlinedCallSitePointer.cast(voidPointer)._methodInfo();
        }

        @Override
        public UDATA getCurrentByteCodeIndexAndIsSameReceiver(J9JITExceptionTablePointer j9JITExceptionTablePointer, VoidPointer voidPointer, VoidPointer voidPointer2, boolean[] blArray) throws CorruptDataException {
            TR_ByteCodeInfoPointer tR_ByteCodeInfoPointer = TR_ByteCodeInfoPointer.cast(this.getByteCodeInfoFromStackMap(j9JITExceptionTablePointer, voidPointer));
            if (voidPointer2.notNull()) {
                VoidPointer voidPointer3 = this.getFirstInlinedCallSiteWithByteCodeInfo(j9JITExceptionTablePointer, voidPointer, VoidPointer.cast(tR_ByteCodeInfoPointer));
                if (!voidPointer3.eq(voidPointer2)) {
                    VoidPointer voidPointer4;
                    do {
                        voidPointer4 = voidPointer3;
                    } while (!(voidPointer3 = this.getNextInlinedCallSite(j9JITExceptionTablePointer, voidPointer3)).eq(voidPointer2));
                    tR_ByteCodeInfoPointer = MethodMetaData_29_V0.getByteCodeInfo(voidPointer4);
                }
            } else if (!tR_ByteCodeInfoPointer._callerIndex().eq(-1L)) {
                VoidPointer voidPointer5;
                VoidPointer voidPointer6 = voidPointer5 = this.getFirstInlinedCallSiteWithByteCodeInfo(j9JITExceptionTablePointer, voidPointer, VoidPointer.cast(tR_ByteCodeInfoPointer));
                while (voidPointer5.notNull() && this.hasMoreInlinedMethods(voidPointer5)) {
                    voidPointer6 = voidPointer5;
                    voidPointer5 = this.getNextInlinedCallSite(j9JITExceptionTablePointer, voidPointer5);
                }
                tR_ByteCodeInfoPointer = MethodMetaData_29_V0.getByteCodeInfo(voidPointer6);
            }
            if (blArray != null) {
                blArray[0] = !tR_ByteCodeInfoPointer._isSameReceiver().eq(0L);
            }
            return new UDATA(tR_ByteCodeInfoPointer._byteCodeIndex());
        }

        private VoidPointer getByteCodeInfoFromStackMap(J9JITExceptionTablePointer j9JITExceptionTablePointer, VoidPointer voidPointer) throws CorruptDataException {
            return VoidPointer.cast(MethodMetaData_29_V0.ADDRESS_OF_BYTECODEINFO_IN_STACK_MAP(MethodMetaData_29_V0.HAS_FOUR_BYTE_OFFSET(j9JITExceptionTablePointer), U8Pointer.cast(voidPointer)));
        }

        @Override
        public UDATAPointer getObjectArgScanCursor(WalkState walkState) throws CorruptDataException {
            return UDATAPointer.cast(U8Pointer.cast(walkState.bp).addOffset(J9JITStackAtlasPointer.cast(walkState.jitInfo.gcStackAtlas()).parmBaseOffset()));
        }

        @Override
        public U8Pointer getJitDescriptionCursor(VoidPointer voidPointer, WalkState walkState) throws CorruptDataException {
            return U8Pointer.NULL;
        }

        @Override
        public U16 getJitNumberOfMapBytes(J9JITStackAtlasPointer j9JITStackAtlasPointer) throws CorruptDataException {
            return j9JITStackAtlasPointer.numberOfMapBytes();
        }

        @Override
        public U32 getJitRegisterMap(J9JITExceptionTablePointer j9JITExceptionTablePointer, VoidPointer voidPointer) throws CorruptDataException {
            return U32Pointer.cast(this.GET_REGISTER_MAP_CURSOR(MethodMetaData_29_V0.HAS_FOUR_BYTE_OFFSET(j9JITExceptionTablePointer), voidPointer)).at(0L);
        }

        @Override
        public U32 getJitHighWordRegisterMap(J9JITExceptionTablePointer j9JITExceptionTablePointer, VoidPointer voidPointer) throws CorruptDataException {
            if (J9ConfigFlags.arch_s390) {
                return U32Pointer.cast(MethodMetaData_29_V0.GET_HIGHWORD_REGISTER_MAP_CURSOR(MethodMetaData_29_V0.HAS_FOUR_BYTE_OFFSET(j9JITExceptionTablePointer), voidPointer)).at(0L);
            }
            return new U32(0L);
        }

        @Override
        public U8Pointer getNextDescriptionCursor(J9JITExceptionTablePointer j9JITExceptionTablePointer, VoidPointer voidPointer, U8Pointer u8Pointer) throws CorruptDataException {
            throw new UnsupportedOperationException("Not implemented at 2.6");
        }

        @Override
        public U8Pointer getJitInternalPointerMap(J9JITStackAtlasPointer j9JITStackAtlasPointer) throws CorruptDataException {
            return j9JITStackAtlasPointer.internalPointerMap();
        }

        @Override
        public U16 getJitNumberOfParmSlots(J9JITStackAtlasPointer j9JITStackAtlasPointer) throws CorruptDataException {
            return j9JITStackAtlasPointer.numberOfParmSlots();
        }

        @Override
        public U8 getNextDescriptionBit(U8Pointer u8Pointer) throws CorruptDataException {
            return u8Pointer.at(0L);
        }

        @Override
        public UDATAPointer getObjectTempScanCursor(WalkState walkState) throws CorruptDataException {
            return walkState.bp.addOffset(J9JITStackAtlasPointer.cast(walkState.jitInfo.gcStackAtlas()).localBaseOffset());
        }

        @Override
        public int getJitRecompilationResolvePushes() {
            if (J9ConfigFlags.arch_x86) {
                if (J9BuildFlags.env_data64) {
                    return 9;
                }
                return 3;
            }
            if (J9ConfigFlags.arch_s390) {
                return 7 + 64 / UDATA.SIZEOF;
            }
            if (J9ConfigFlags.arch_power) {
                return 3;
            }
            return 0;
        }

        @Override
        public int getJitVirtualMethodResolvePushes() {
            if (J9ConfigFlags.arch_x86) {
                if (J9BuildFlags.env_data64) {
                    return 2;
                }
                return 4;
            }
            if (J9ConfigFlags.arch_power) {
                return 0;
            }
            if (TRBuildFlags.host_SH4) {
                return 2;
            }
            return 0;
        }

        @Override
        public int getJitStaticMethodResolvePushes() {
            if (J9ConfigFlags.arch_x86) {
                if (J9BuildFlags.env_data64) {
                    return 1;
                }
                return 1;
            }
            return 0;
        }

        @Override
        public void walkJITFrameSlotsForInternalPointers(WalkState walkState, U8Pointer u8Pointer, UDATAPointer uDATAPointer, VoidPointer voidPointer, J9JITStackAtlasPointer j9JITStackAtlasPointer) throws CorruptDataException {
            VoidPointer voidPointer2 = VoidPointer.cast(j9JITStackAtlasPointer.internalPointerMap());
            U8Pointer u8Pointer2 = U8Pointer.cast(voidPointer2);
            U8 u8 = new U8(0L);
            UDATA uDATA = UDATAPointer.cast(u8Pointer2).at(0L);
            if (uDATA.eq(UDATA.cast(voidPointer))) {
                return;
            }
            UDATA uDATA2 = new UDATA(this.getJitRegisterMap(walkState.jitInfo, voidPointer));
            u8Pointer2 = u8Pointer2.add(UDATA.SIZEOF);
            StackWalkerUtils.swPrintf(walkState, 6, "Address {0}", u8Pointer2.getHexAddress());
            U8 u82 = u8Pointer2.at(0L);
            u8Pointer2 = u8Pointer2.add(1L);
            if (alignStackMaps) {
                u8Pointer2 = u8Pointer2.add(1L);
            }
            StackWalkerUtils.swPrintf(walkState, 6, "Num internal ptr map bytes {0}", u82);
            I16 i16 = new I16(U16Pointer.cast(u8Pointer2).at(0L));
            StackWalkerUtils.swPrintf(walkState, 6, "Address {0}", u8Pointer2.getHexAddress());
            u8Pointer2 = u8Pointer2.add(2L);
            StackWalkerUtils.swPrintf(walkState, 6, "Index of first internal ptr {0}", i16);
            I16 i162 = new I16(U16Pointer.cast(u8Pointer2).at(0L));
            StackWalkerUtils.swPrintf(walkState, 6, "Address {0}", u8Pointer2.getHexAddress());
            u8Pointer2 = u8Pointer2.add(2L);
            StackWalkerUtils.swPrintf(walkState, 6, "Offset of first internal ptr {0}", i162);
            StackWalkerUtils.swPrintf(walkState, 6, "Address {0}", u8Pointer2.getHexAddress());
            U8 u83 = u8Pointer2.at(0L);
            u8Pointer2 = u8Pointer2.add(1L);
            StackWalkerUtils.swPrintf(walkState, 6, "Num distinct pinning arrays {0}", u83);
            U8 u84 = new U8(0L);
            if (uDATA2.anyBitsIn(MethodMetaDataConstants.INTERNAL_PTR_REG_MASK) && !uDATA2.eq(new UDATA(4208904958L))) {
                u8 = new U8(1L);
            }
            while (u84.lt(u83)) {
                U8 u85 = u8Pointer2.at(0L);
                u8Pointer2 = u8Pointer2.add(1L);
                U8 u86 = u8Pointer2.at(0L);
                u8Pointer2 = u8Pointer2.add(1L);
                PointerPointer pointerPointer = PointerPointer.cast(walkState.bp.addOffset(i162.add(u85.intValue() * UDATA.SIZEOF)));
                J9ObjectPointer j9ObjectPointer = J9ObjectPointer.cast(pointerPointer.at(0L));
                IDATA iDATA = new IDATA(0L);
                StackWalkerUtils.swPrintf(walkState, 6, "Before object slot walk &address : {0} address : {1} bp {2} offset of first internal ptr {3}", pointerPointer.getHexAddress(), j9ObjectPointer.getHexAddress(), walkState.bp.getHexAddress(), i162);
                walkState.callBacks.objectSlotWalkFunction(walkState.walkThread, walkState, pointerPointer, VoidPointer.cast(pointerPointer));
                J9ObjectPointer j9ObjectPointer2 = J9ObjectPointer.cast(pointerPointer.at(0L));
                iDATA = new IDATA(UDATA.cast(j9ObjectPointer2).sub(UDATA.cast(j9ObjectPointer)));
                ++walkState.slotIndex;
                StackWalkerUtils.swPrintf(walkState, 6, "After object slot walk for pinning array with &address : {0} old address {1} new address {2} displacement {3}", pointerPointer.getHexAddress(), j9ObjectPointer.getHexAddress(), j9ObjectPointer2.getHexAddress(), iDATA);
                StackWalkerUtils.swPrintf(walkState, 6, "For pinning array {0} num internal pointer stack slots {1}", u85, u86);
                if (!iDATA.eq(0L)) {
                    Scalar scalar;
                    DataType dataType;
                    DataType dataType2;
                    U8 u87 = new U8(0L);
                    while (u87.lt(u86)) {
                        dataType2 = u8Pointer2.at(0L);
                        u8Pointer2 = u8Pointer2.add(1L);
                        dataType = PointerPointer.cast(walkState.bp.addOffset(i162.add(((Scalar)dataType2).intValue() * UDATA.SIZEOF)));
                        StackWalkerUtils.swPrintf(walkState, 6, "For pinning array {0} internal pointer auto {1} old address {2} displacement {3}", u85, dataType2, ((PointerPointer)dataType).at(0L).getHexAddress(), iDATA);
                        if (((PointerPointer)dataType).at(0L).notNull()) {
                            scalar = IDATA.cast(((PointerPointer)dataType).at(0L));
                            scalar = ((IDATA)scalar).add(iDATA);
                            StackWalkerUtils.swPrintf(walkState, 6, "For pinning array %d internal pointer auto %d new address %p\n", u85, dataType2, scalar);
                        }
                        u87 = u87.add(1);
                    }
                    if (!u8.eq(0L)) {
                        uDATA2 = uDATA2.bitAnd(J9StackWalkConstants.J9SW_REGISTER_MAP_MASK);
                        StackWalkerUtils.swPrintf(walkState, 6, "\tJIT-RegisterMap = {0}", uDATA2);
                        dataType2 = U8Pointer.cast(voidPointer);
                        dataType2 = J9ConfigFlags.arch_s390 ? ((U8Pointer)dataType2).add(12L) : ((U8Pointer)dataType2).add(8L);
                        dataType2 = walkState.jitInfo.endPC().sub(walkState.jitInfo.startPC()).gte(new UDATA(65535L)) || alignStackMaps ? ((U8Pointer)dataType2).add(8L) : ((U8Pointer)dataType2).add(6L);
                        dataType = ((U8Pointer)dataType2).at(0L);
                        dataType2 = ((U8Pointer)dataType2).add(1L);
                        u83 = ((U8Pointer)dataType2).at(0L);
                        dataType2 = ((U8Pointer)dataType2).add(1L);
                        scalar = new U8(0L);
                        while (((UScalar)scalar).lt(u83)) {
                            U8 u88 = ((U8Pointer)dataType2).at(0L);
                            dataType2 = ((U8Pointer)dataType2).add(1L);
                            U8 u89 = ((U8Pointer)dataType2).at(0L);
                            dataType2 = ((U8Pointer)dataType2).add(1L);
                            u87 = new U8(0L);
                            if (u88.eq(u85)) {
                                int n = J9StackWalkFlags.J9SW_REGISTER_MAP_WALK_REGISTERS_LOW_TO_HIGH ? 0 : (int)J9StackWalkConstants.J9SW_POTENTIAL_SAVED_REGISTERS - 1;
                                while (u87.lt(u89)) {
                                    U8 u810 = ((U8Pointer)dataType2).at(0L);
                                    dataType2 = ((U8Pointer)dataType2).add(1L);
                                    PointerPointer pointerPointer2 = J9StackWalkFlags.J9SW_REGISTER_MAP_WALK_REGISTERS_LOW_TO_HIGH ? PointerPointer.cast(walkState.registerEAs[n + u810.intValue() - 1].at(0L)) : PointerPointer.cast(walkState.registerEAs[n + u810.intValue()].at(0L));
                                    IDATA iDATA2 = IDATA.cast(pointerPointer2.at(0L));
                                    StackWalkerUtils.swPrintf(walkState, 6, "Original internal pointer reg address {0}", iDATA2);
                                    if (!iDATA2.eq(0L)) {
                                        iDATA2 = iDATA2.add(iDATA);
                                    }
                                    StackWalkerUtils.swPrintf(walkState, 6, "Adjusted internal pointer reg to be address {0} (disp {1})\n", iDATA2, iDATA);
                                    u87 = u87.add(1);
                                }
                                break;
                            }
                            dataType2 = ((U8Pointer)dataType2).add(u89);
                            scalar = ((U8)scalar).add(1);
                        }
                    }
                } else {
                    u8Pointer2 = u8Pointer2.add(u86);
                }
                u84 = u84.add(1);
            }
        }

        @Override
        public VoidPointer getStackAllocMapFromJitPC(J9JavaVMPointer j9JavaVMPointer, J9JITExceptionTablePointer j9JITExceptionTablePointer, UDATA uDATA, VoidPointer voidPointer) throws CorruptDataException {
            if (j9JITExceptionTablePointer.gcStackAtlas().isNull()) {
                return VoidPointer.NULL;
            }
            VoidPointer voidPointer2 = voidPointer.notNull() ? voidPointer : this.getStackMapFromJitPC(j9JavaVMPointer, j9JITExceptionTablePointer, uDATA);
            PointerPointer pointerPointer = PointerPointer.cast(J9JITStackAtlasPointer.cast(j9JITExceptionTablePointer.gcStackAtlas()).stackAllocMap());
            if (pointerPointer.notNull()) {
                if (UDATAPointer.cast(pointerPointer.at(0L)).eq(voidPointer2)) {
                    return VoidPointer.NULL;
                }
                UDATA uDATA2 = UDATA.cast(pointerPointer).add(UDATA.SIZEOF);
                return VoidPointer.cast(uDATA2);
            }
            return VoidPointer.NULL;
        }

        @Override
        public U8Pointer getJitStackSlots(J9JITExceptionTablePointer j9JITExceptionTablePointer, VoidPointer voidPointer) throws CorruptDataException {
            U8Pointer u8Pointer = this.GET_REGISTER_MAP_CURSOR(MethodMetaData_29_V0.HAS_FOUR_BYTE_OFFSET(j9JITExceptionTablePointer), voidPointer);
            if (U32Pointer.cast(u8Pointer).at(0L).anyBitsIn(MethodMetaDataConstants.INTERNAL_PTR_REG_MASK) && this.getJitInternalPointerMap(this.getJitGCStackAtlas(j9JITExceptionTablePointer)).notNull()) {
                u8Pointer = u8Pointer.add(u8Pointer.add(4L).at(0L).add(1));
            }
            u8Pointer = u8Pointer.add(4L);
            return u8Pointer;
        }

        private U8Pointer GET_REGISTER_MAP_CURSOR(boolean bl, VoidPointer voidPointer) {
            if (J9ConfigFlags.arch_s390) {
                return U8Pointer.cast(voidPointer).add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(bl).add(12));
            }
            return U8Pointer.cast(voidPointer).add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(bl).add(8));
        }

        private static U8Pointer GET_HIGHWORD_REGISTER_MAP_CURSOR(boolean bl, VoidPointer voidPointer) {
            return U8Pointer.cast(voidPointer).add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(bl).add(4));
        }

        private U32 getNumInlinedCallSites(J9JITExceptionTablePointer j9JITExceptionTablePointer) throws CorruptDataException {
            U32 u32 = new U32(0L);
            if (j9JITExceptionTablePointer.inlinedCalls().notNull()) {
                U32 u322 = new U32(UDATA.cast(j9JITExceptionTablePointer.gcStackAtlas()).sub(UDATA.cast(j9JITExceptionTablePointer.inlinedCalls())));
                u32 = new U32(u322.longValue() / this.sizeOfInlinedCallSiteArrayElement(j9JITExceptionTablePointer).longValue());
            }
            return u32;
        }

        private U8Pointer getInlinedCallSiteArrayElement(J9JITExceptionTablePointer j9JITExceptionTablePointer, int n) throws CorruptDataException {
            U8Pointer u8Pointer = U8Pointer.cast(this.getJitInlinedCallInfo(j9JITExceptionTablePointer));
            if (u8Pointer.notNull()) {
                return u8Pointer.add((long)n * this.sizeOfInlinedCallSiteArrayElement(j9JITExceptionTablePointer).longValue());
            }
            return U8Pointer.NULL;
        }

        private boolean isPatchedValue(J9MethodPointer j9MethodPointer) {
            return J9ConfigFlags.arch_power && j9MethodPointer.anyBitsIn(1L) || UDATA.cast(j9MethodPointer).bitNot().eq(0L);
        }

        @Override
        public void markClassesInInlineRanges(J9JITExceptionTablePointer j9JITExceptionTablePointer, WalkState walkState) throws CorruptDataException {
            J9MethodPointer j9MethodPointer = walkState.method;
            J9ConstantPoolPointer j9ConstantPoolPointer = walkState.constantPool;
            U32 u32 = this.getNumInlinedCallSites(j9JITExceptionTablePointer);
            int n = 0;
            for (n = 0; n < u32.intValue(); ++n) {
                U8Pointer u8Pointer = this.getInlinedCallSiteArrayElement(j9JITExceptionTablePointer, n);
                J9MethodPointer j9MethodPointer2 = J9MethodPointer.cast(this.getInlinedMethod(VoidPointer.cast(u8Pointer)));
                if (this.isPatchedValue(j9MethodPointer2)) continue;
                walkState.method = j9MethodPointer2;
                walkState.constantPool = StackWalkerUtils.UNTAGGED_METHOD_CP(walkState.method);
                StackWalkerUtils.WALK_METHOD_CLASS(walkState);
            }
            walkState.method = j9MethodPointer;
            walkState.constantPool = j9ConstantPoolPointer;
        }
    }

    private static interface MethodMetaDataImpl
    extends IAlgorithm {
        public UDATAPointer getObjectTempScanCursor(WalkState var1) throws CorruptDataException;

        public int getJitStaticMethodResolvePushes();

        public int getJitVirtualMethodResolvePushes();

        public int getJitRecompilationResolvePushes();

        public U8Pointer getJitDescriptionCursor(VoidPointer var1, WalkState var2) throws CorruptDataException;

        public void walkJITFrameSlotsForInternalPointers(WalkState var1, U8Pointer var2, UDATAPointer var3, VoidPointer var4, J9JITStackAtlasPointer var5) throws CorruptDataException;

        public U8Pointer getJitInternalPointerMap(J9JITStackAtlasPointer var1) throws CorruptDataException;

        public U16 getJitNumberOfParmSlots(J9JITStackAtlasPointer var1) throws CorruptDataException;

        public U8Pointer getNextDescriptionCursor(J9JITExceptionTablePointer var1, VoidPointer var2, U8Pointer var3) throws CorruptDataException;

        public U32 getJitRegisterMap(J9JITExceptionTablePointer var1, VoidPointer var2) throws CorruptDataException;

        public U32 getJitHighWordRegisterMap(J9JITExceptionTablePointer var1, VoidPointer var2) throws CorruptDataException;

        public U16 getJitNumberOfMapBytes(J9JITStackAtlasPointer var1) throws CorruptDataException;

        public I16 getJitTotalFrameSize(J9JITExceptionTablePointer var1) throws CorruptDataException;

        public UDATAPointer getObjectArgScanCursor(WalkState var1) throws CorruptDataException;

        public UDATA getCurrentByteCodeIndexAndIsSameReceiver(J9JITExceptionTablePointer var1, VoidPointer var2, VoidPointer var3, boolean[] var4) throws CorruptDataException;

        public boolean hasMoreInlinedMethods(VoidPointer var1) throws CorruptDataException;

        public VoidPointer getInlinedMethod(VoidPointer var1) throws CorruptDataException;

        public UDATA getJitInlineDepthFromCallSite(J9JITExceptionTablePointer var1, VoidPointer var2) throws CorruptDataException;

        public VoidPointer getFirstInlinedCallSite(J9JITExceptionTablePointer var1, VoidPointer var2) throws CorruptDataException;

        public VoidPointer getNextInlinedCallSite(J9JITExceptionTablePointer var1, VoidPointer var2) throws CorruptDataException;

        public J9JITStackAtlasPointer getJitGCStackAtlas(J9JITExceptionTablePointer var1) throws CorruptDataException;

        public VoidPointer getStackMapFromJitPC(J9JavaVMPointer var1, J9JITExceptionTablePointer var2, UDATA var3) throws CorruptDataException;

        public UDATA getJitDataResolvePushes() throws CorruptDataException;

        public void jitAddSpilledRegistersForDataResolve(WalkState var1) throws CorruptDataException;

        public VoidPointer getJitInlinedCallInfo(J9JITExceptionTablePointer var1) throws CorruptDataException;

        public void jitGetMapsFromPC(J9JavaVMPointer var1, J9JITExceptionTablePointer var2, UDATA var3, JITMaps var4) throws CorruptDataException;

        public void jitAddSpilledRegisters(WalkState var1) throws CorruptDataException;

        public void jitAddSpilledRegisters(WalkState var1, VoidPointer var2) throws CorruptDataException;

        public U8 getNextDescriptionBit(U8Pointer var1) throws CorruptDataException;

        public VoidPointer getStackAllocMapFromJitPC(J9JavaVMPointer var1, J9JITExceptionTablePointer var2, UDATA var3, VoidPointer var4) throws CorruptDataException;

        public U8Pointer getJitStackSlots(J9JITExceptionTablePointer var1, VoidPointer var2) throws CorruptDataException;

        public void markClassesInInlineRanges(J9JITExceptionTablePointer var1, WalkState var2) throws CorruptDataException;
    }

    public static class JITMaps {
        public PointerPointer stackMap = PointerPointer.NULL;
        public PointerPointer inlineMap = PointerPointer.NULL;
    }
}

