/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.java.lang.management.internal.StackTraceElementUtil;
import com.ibm.oti.util.Msg;
import java.lang.management.LockInfo;
import javax.management.openmbean.CompositeData;

public class MonitorInfo
extends LockInfo {
    private final int stackDepth;
    private final StackTraceElement stackFrame;

    public MonitorInfo(String string, int n, int n2, StackTraceElement stackTraceElement) {
        super(string, n);
        if (stackTraceElement == null && n2 >= 0 || stackTraceElement != null && n2 < 0) {
            String string2 = stackTraceElement == null ? Msg.getString("K0610") : Msg.getString("K0611");
            throw new IllegalArgumentException(Msg.getString("K060F", n2, string2));
        }
        this.stackDepth = n2;
        this.stackFrame = stackTraceElement;
    }

    private MonitorInfo(Object object, int n, StackTraceElement stackTraceElement) {
        super(object.getClass().getName(), System.identityHashCode(object));
        this.stackDepth = n;
        this.stackFrame = stackTraceElement;
    }

    public int getLockedStackDepth() {
        return this.stackDepth;
    }

    public StackTraceElement getLockedStackFrame() {
        return this.stackFrame;
    }

    public static MonitorInfo from(CompositeData compositeData) {
        MonitorInfo monitorInfo = null;
        if (compositeData != null) {
            ManagementUtils.verifyFieldNumber(compositeData, 4);
            String[] stringArray = new String[]{"className", "identityHashCode", "lockedStackFrame", "lockedStackDepth"};
            ManagementUtils.verifyFieldNames(compositeData, stringArray);
            String[] stringArray2 = new String[]{"java.lang.String", "java.lang.Integer", CompositeData.class.getName(), "java.lang.Integer"};
            ManagementUtils.verifyFieldTypes(compositeData, stringArray, stringArray2);
            Object[] objectArray = compositeData.getAll(stringArray);
            String string = (String)objectArray[0];
            int n = (Integer)objectArray[1];
            CompositeData compositeData2 = (CompositeData)objectArray[2];
            StackTraceElement stackTraceElement = StackTraceElementUtil.from(compositeData2);
            int n2 = (Integer)objectArray[3];
            monitorInfo = new MonitorInfo(string, n, n2, stackTraceElement);
        }
        return monitorInfo;
    }
}

