/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management;

import com.ibm.java.lang.management.internal.ManagementUtils;
import com.sun.management.internal.GcInfoUtil;
import java.lang.management.MemoryUsage;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataView;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;

public class GcInfo
implements CompositeData,
CompositeDataView {
    private final long index;
    private final long startTime;
    private final long endTime;
    private final Map<String, MemoryUsage> usageBeforeGc;
    private final Map<String, MemoryUsage> usageAfterGc;
    private CompositeData cdata;

    private CompositeData getCompositeData() {
        if (null == this.cdata) {
            this.cdata = GcInfoUtil.toCompositeData(this);
        }
        return this.cdata;
    }

    private void setCompositeData(CompositeData compositeData) {
        this.cdata = compositeData;
    }

    private GcInfo(long l, long l2, long l3, Map<String, MemoryUsage> map, Map<String, MemoryUsage> map2) {
        this.index = l;
        this.startTime = l2;
        this.endTime = l3;
        this.usageBeforeGc = map;
        this.usageAfterGc = map2;
    }

    public long getId() {
        return this.index;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return this.endTime - this.startTime;
    }

    public Map<String, MemoryUsage> getMemoryUsageBeforeGc() {
        return this.usageBeforeGc;
    }

    public Map<String, MemoryUsage> getMemoryUsageAfterGc() {
        return this.usageAfterGc;
    }

    public static GcInfo from(CompositeData compositeData) {
        GcInfo gcInfo = null;
        if (compositeData != null) {
            ManagementUtils.verifyFieldNumber(compositeData, 5);
            String[] stringArray = new String[]{"index", "startTime", "endTime", "usageBeforeGc", "usageAfterGc"};
            ManagementUtils.verifyFieldNames(compositeData, stringArray);
            String[] stringArray2 = new String[]{"java.lang.Long", "java.lang.Long", "java.lang.Long", TabularData.class.getName(), TabularData.class.getName()};
            ManagementUtils.verifyFieldTypes(compositeData, stringArray, stringArray2);
            Object[] objectArray = compositeData.getAll(stringArray);
            long l = (Long)objectArray[0];
            long l2 = (Long)objectArray[1];
            long l3 = (Long)objectArray[2];
            Map<String, MemoryUsage> map = GcInfo.convertTabularDataToMemoryUsageMap((TabularData)objectArray[3]);
            Map<String, MemoryUsage> map2 = GcInfo.convertTabularDataToMemoryUsageMap((TabularData)objectArray[4]);
            gcInfo = new GcInfo(l, l2, l3, map, map2);
            gcInfo.setCompositeData(compositeData);
        }
        return gcInfo;
    }

    private static Map<String, MemoryUsage> convertTabularDataToMemoryUsageMap(TabularData tabularData) {
        HashMap<String, MemoryUsage> hashMap = new HashMap<String, MemoryUsage>();
        for (CompositeData compositeData : tabularData.values()) {
            String string = (String)compositeData.get("key");
            MemoryUsage memoryUsage = MemoryUsage.from((CompositeData)compositeData.get("value"));
            hashMap.put(string, memoryUsage);
        }
        return hashMap;
    }

    @Override
    public boolean containsKey(String string) {
        return this.getCompositeData().containsKey(string);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.getCompositeData().containsValue(object);
    }

    @Override
    public boolean equals(Object object) {
        return this.getCompositeData().equals(object);
    }

    @Override
    public Object get(String string) {
        return this.getCompositeData().get(string);
    }

    @Override
    public Object[] getAll(String[] stringArray) {
        return this.getCompositeData().getAll(stringArray);
    }

    @Override
    public CompositeType getCompositeType() {
        return this.getCompositeData().getCompositeType();
    }

    @Override
    public int hashCode() {
        return this.getCompositeData().hashCode();
    }

    @Override
    public String toString() {
        return this.getCompositeData().toString();
    }

    @Override
    public Collection<?> values() {
        return this.getCompositeData().values();
    }

    @Override
    public CompositeData toCompositeData(CompositeType compositeType) {
        return this.getCompositeData();
    }

    static {
        GcInfoUtil.registerConverters();
    }
}

