/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.virtualization.management;

import com.ibm.oti.util.Msg;
import com.ibm.virtualization.management.internal.GuestOSMemoryUsageUtil;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;

public final class GuestOSMemoryUsage {
    private static final int HASHMASK = 0xFFFFFFF;
    private long memUsed;
    private long timestamp;
    private long maxMemLimit;

    public GuestOSMemoryUsage() {
    }

    private GuestOSMemoryUsage(long l, long l2, long l3) throws IllegalArgumentException {
        if (l < -1L || l3 < -1L || l2 < 0L || l > l3 && l3 >= 0L) {
            throw new IllegalArgumentException();
        }
        this.memUsed = l;
        this.timestamp = l2;
        this.maxMemLimit = l3;
    }

    public long getMemUsed() {
        return this.memUsed;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getMaxMemLimit() {
        return this.maxMemLimit;
    }

    void updateValues(long l, long l2, long l3) {
        this.memUsed = l;
        this.timestamp = l2;
        this.maxMemLimit = l3;
    }

    public static GuestOSMemoryUsage from(CompositeData compositeData) {
        GuestOSMemoryUsage guestOSMemoryUsage = null;
        if (null != compositeData) {
            long l;
            long l2;
            long l3;
            if (!GuestOSMemoryUsageUtil.getCompositeType().isValue(compositeData)) {
                throw new IllegalArgumentException(Msg.getString("K05E5"));
            }
            try {
                l3 = (Long)compositeData.get("memUsed");
                l2 = (Long)compositeData.get("timestamp");
                l = (Long)compositeData.get("maxMemLimit");
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IllegalArgumentException(Msg.getString("K05E6"));
            }
            guestOSMemoryUsage = new GuestOSMemoryUsage(l3, l2, l);
        }
        return guestOSMemoryUsage;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n========== ");
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" ==========\n\n");
        stringBuilder.append("timestamp = ");
        stringBuilder.append(this.timestamp);
        stringBuilder.append("\n");
        stringBuilder.append("memUsed = ");
        stringBuilder.append(this.memUsed);
        stringBuilder.append("\n");
        stringBuilder.append("maxMemLimit = ");
        stringBuilder.append(this.maxMemLimit);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!(object instanceof GuestOSMemoryUsage)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        GuestOSMemoryUsage guestOSMemoryUsage = (GuestOSMemoryUsage)object;
        if (guestOSMemoryUsage.getMemUsed() != this.getMemUsed()) {
            return false;
        }
        if (guestOSMemoryUsage.getTimestamp() != this.getTimestamp()) {
            return false;
        }
        return guestOSMemoryUsage.getMaxMemLimit() == this.getMaxMemLimit();
    }

    public int hashCode() {
        long l = this.getMemUsed() + this.getTimestamp() + this.getMaxMemLimit();
        return (int)(((l >> 32) + l & 0xFFFFFFFL) * 23L);
    }

    static {
        GuestOSMemoryUsageUtil.registerConverters();
    }
}

