/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.memory;

import com.ibm.j9ddr.corereaders.memory.AbstractMemory;
import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.corereaders.memory.BaseMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IMemorySource;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MemorySourceTable {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    private static final String FORCE_BINARY_CHOP_RESOLVER_SYSTEM_PROPERTY = "ddr.force.binary.address.resolver";
    private static final boolean FORCE_BINARY_CHOP_RESOLVER;
    private static final String ALLOW_THREE_TIER_TABLE_RESOLVER_PROPERTY = "ddr.allow.three.tier.address.resolver";
    private static final boolean ALLOW_THREE_TIER_TABLE_RESOLVER;
    static long tlbCacheHits;
    static long tlbCacheMisses;
    private IAddressResolverStrategy addressResolver = null;
    private final List<IMemorySource> rawMemorySources = new ArrayList<IMemorySource>();
    private List<IMemorySource> memorySources;

    public final void addMemorySource(IMemorySource source) {
        this.rawMemorySources.add(source);
        this.addressResolver = null;
    }

    public void removeMemorySource(IMemorySource source) {
        this.rawMemorySources.remove(source);
        this.addressResolver = null;
    }

    public final List<IMemoryRange> getMemorySources() {
        this.mergeOverlappingRanges();
        return new ArrayList<IMemoryRange>(this.memorySources);
    }

    public final IMemorySource getRangeForAddress(long address) {
        if (this.addressResolver == null) {
            this.pickAddressResolver();
        }
        return this.addressResolver.getRangeForAddress(address);
    }

    private void pickAddressResolver() {
        this.mergeOverlappingRanges();
        long highestAddress = 0L;
        int worstAlignment = Integer.MAX_VALUE;
        long smallestRange = Integer.MAX_VALUE;
        for (IMemoryRange iMemoryRange : this.memorySources) {
            int alignment;
            if (Addresses.greaterThan(iMemoryRange.getTopAddress(), highestAddress)) {
                highestAddress = iMemoryRange.getTopAddress();
            }
            if ((alignment = MemorySourceTable.getAlignment(iMemoryRange.getBaseAddress())) < worstAlignment) {
                worstAlignment = alignment;
            }
            if (iMemoryRange.getSize() >= smallestRange) continue;
            smallestRange = iMemoryRange.getSize();
        }
        logger.logp(Level.FINE, "MemoryRangeTable", "pickAddressResolver", "Picking address resolver. Highest Address = 0x{0}, worst alignment = {1} bit.", new Object[]{Long.toHexString(highestAddress), worstAlignment});
        if (FORCE_BINARY_CHOP_RESOLVER) {
            logger.logp(Level.FINE, "MemoryRangeTable", "pickAddressResolver", "Selection overridden with {0}", FORCE_BINARY_CHOP_RESOLVER_SYSTEM_PROPERTY);
            this.addressResolver = new BinaryChopAddressResolver(this.memorySources);
        } else if (worstAlignment >= 12 && smallestRange >= 4096L) {
            if (Addresses.lessThan(highestAddress, 0x100000000L)) {
                this.addressResolver = new FlatPageTableAddressResolver(this.memorySources, highestAddress, worstAlignment);
            } else if (ALLOW_THREE_TIER_TABLE_RESOLVER) {
                logger.logp(Level.FINE, "MemoryRangeTable", "pickAddressResolver", "Three tier table resolver selected, allowed by {0} setting", ALLOW_THREE_TIER_TABLE_RESOLVER_PROPERTY);
                this.addressResolver = new ThreeTierPageTableAddressResolver(this.memorySources, highestAddress, worstAlignment);
            }
        }
        if (this.addressResolver == null) {
            this.addressResolver = new BinaryChopAddressResolver(this.memorySources);
        }
        logger.logp(Level.FINE, "MemoryRangeTable", "pickAddressResolver", "Picked {0} as address resolver.", this.addressResolver.getClass().getSimpleName());
    }

    private void mergeOverlappingRanges() {
        this.memorySources = new ArrayList<IMemorySource>(this.rawMemorySources);
        Collections.sort(this.memorySources);
        if (this.memorySources.size() > 0) {
            ListIterator<IMemorySource> rangeIt = this.memorySources.listIterator();
            IMemorySource previous = rangeIt.next();
            while (rangeIt.hasNext()) {
                IMemorySource thisRange = rangeIt.next();
                if (thisRange.overlaps(previous)) {
                    logger.logp(Level.FINE, "MemoryRangeTable", "mergeOverlappingRanges", "Address range {0} overlaps with {1}", new Object[]{thisRange, previous});
                    if (previous.isSubRange(thisRange)) {
                        logger.logp(Level.FINER, "MemoryRangeTable", "mergeOverlappingRanges", "Removing {0}", thisRange);
                        rangeIt.remove();
                        continue;
                    }
                    if (previous.isBacked() == thisRange.isBacked()) {
                        logger.logp(Level.FINER, "MemoryRangeTable", "mergeOverlappingRanges", "Merging {0} and {1}", new Object[]{thisRange, previous});
                        rangeIt.remove();
                        rangeIt.previous();
                        rangeIt.remove();
                        MergedMemoryRange toAdd = new MergedMemoryRange(previous, thisRange);
                        rangeIt.add(toAdd);
                        previous = toAdd;
                        continue;
                    }
                    previous = thisRange;
                    continue;
                }
                previous = thisRange;
            }
        }
    }

    static int getAlignment(long address) {
        int alignment = 0;
        for (int i = 0; i < 64 && (address & 1L) == 0L; ++i) {
            ++alignment;
            address >>= 1;
        }
        return alignment;
    }

    static {
        tlbCacheHits = 0L;
        tlbCacheMisses = 0L;
        String forceBinaryResolverString = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(MemorySourceTable.FORCE_BINARY_CHOP_RESOLVER_SYSTEM_PROPERTY);
            }
        });
        logger.logp(Level.FINE, "MemoryRangeTable", "<clinit>", "System property {0} set to {1}", new Object[]{FORCE_BINARY_CHOP_RESOLVER_SYSTEM_PROPERTY, forceBinaryResolverString});
        if (forceBinaryResolverString != null && forceBinaryResolverString.toLowerCase().equals("true")) {
            FORCE_BINARY_CHOP_RESOLVER = true;
            logger.logp(Level.FINE, "MemoryRangeTable", "<clinit>", "BinaryChopResolver forced on.");
        } else {
            logger.logp(Level.FINE, "MemoryRangeTable", "<clinit>", "BinaryChopResolver NOT forced on.");
            FORCE_BINARY_CHOP_RESOLVER = false;
        }
        String allowThreeTierResolverString = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(MemorySourceTable.ALLOW_THREE_TIER_TABLE_RESOLVER_PROPERTY);
            }
        });
        logger.logp(Level.FINE, "MemoryRangeTable", "<clinit>", "System property {0} set to {1}", new Object[]{ALLOW_THREE_TIER_TABLE_RESOLVER_PROPERTY, allowThreeTierResolverString});
        if (allowThreeTierResolverString != null && allowThreeTierResolverString.toLowerCase().equals("true")) {
            ALLOW_THREE_TIER_TABLE_RESOLVER = true;
            logger.logp(Level.FINE, "MemoryRangeTable", "<clinit>", "ThreeTierResolver selection allowed.");
        } else {
            logger.logp(Level.FINE, "MemoryRangeTable", "<clinit>", "ThreeTierResolver selection NOT allowed.");
            ALLOW_THREE_TIER_TABLE_RESOLVER = false;
        }
    }

    private static interface IAddressResolverStrategy {
        public IMemorySource getRangeForAddress(long var1);
    }

    private static class BinaryChopAddressResolver
    implements IAddressResolverStrategy {
        private List<IMemorySource> memoryRanges;
        private IMemorySource tlbEntry1 = null;
        private long entry1HitCount = 0L;
        private IMemorySource tlbEntry2 = null;
        private long entry2HitCount = 0L;

        public BinaryChopAddressResolver(List<IMemorySource> memoryRanges) {
            this.memoryRanges = memoryRanges;
            Collections.sort(memoryRanges);
        }

        @Override
        public IMemorySource getRangeForAddress(long address) {
            IMemorySource midPoint;
            int bottom = 0;
            int top = this.memoryRanges.size() - 1;
            IMemorySource tlbEntry = this.tlbCheck(address);
            if (tlbEntry != null) {
                if (AbstractMemory.RECORDING_CACHE_STATS) {
                    ++tlbCacheHits;
                }
                return tlbEntry;
            }
            if (AbstractMemory.RECORDING_CACHE_STATS) {
                ++tlbCacheMisses;
            }
            while (true) {
                int middle;
                if (Addresses.greaterThan((midPoint = this.memoryRanges.get(middle = (bottom + top) / 2)).getBaseAddress(), address)) {
                    if (bottom == top) {
                        return null;
                    }
                    top = middle;
                    continue;
                }
                if (!Addresses.lessThan(midPoint.getTopAddress(), address)) break;
                if (top == bottom) {
                    return null;
                }
                if (middle == bottom) {
                    bottom = top;
                    continue;
                }
                bottom = middle;
            }
            this.tlbInsert(midPoint);
            return midPoint;
        }

        private IMemorySource tlbCheck(long address) {
            if (this.tlbEntry1 != null && this.tlbEntry1.contains(address)) {
                ++this.entry1HitCount;
                return this.tlbEntry1;
            }
            if (this.tlbEntry2 != null && this.tlbEntry2.contains(address)) {
                ++this.entry2HitCount;
                return this.tlbEntry2;
            }
            return null;
        }

        private void tlbInsert(IMemorySource newEntry) {
            if (this.tlbEntry1 == null) {
                this.tlbEntry1 = newEntry;
            } else if (this.tlbEntry2 == null) {
                this.tlbEntry2 = newEntry;
            } else if (this.entry1HitCount >= this.entry2HitCount) {
                this.tlbEntry2 = newEntry;
            } else {
                this.tlbEntry1 = newEntry;
            }
            this.entry1HitCount = 0L;
            this.entry2HitCount = 0L;
        }
    }

    private static class FlatPageTableAddressResolver
    implements IAddressResolverStrategy {
        private final IMemorySource[] pageTable;
        private final long alignment;

        public FlatPageTableAddressResolver(List<IMemorySource> memorySource, long highestAddress, int alignment) {
            this.alignment = alignment;
            long slots = (highestAddress >>> alignment) + 1L;
            this.pageTable = new IMemorySource[(int)slots];
            for (IMemorySource range : memorySource) {
                int baseSlot = (int)(range.getBaseAddress() >>> alignment);
                int topSlot = (int)(range.getTopAddress() >>> alignment);
                for (int i = baseSlot; i <= topSlot; ++i) {
                    this.pageTable[i] = range;
                }
            }
        }

        @Override
        public IMemorySource getRangeForAddress(long address) {
            int slot = (int)(address >>> (int)this.alignment);
            if (slot >= this.pageTable.length) {
                return null;
            }
            return this.pageTable[slot];
        }
    }

    private static class ThreeTierPageTableAddressResolver
    implements IAddressResolverStrategy {
        private final Object[] pageTable;
        private final int pageTableSize;
        private final long alignment;
        private final int topLevelBits;
        private final int midTierBits;
        private final int bottomTierBits;

        public ThreeTierPageTableAddressResolver(List<IMemorySource> memorySources, long highestAddress, int alignment) {
            this.alignment = alignment;
            long slots = highestAddress >>> alignment;
            int bits = (int)Math.ceil(Math.log(slots) / Math.log(2.0));
            if (bits > 40) {
                this.midTierBits = 20;
                this.bottomTierBits = 20;
                this.topLevelBits = bits - this.midTierBits - this.bottomTierBits;
            } else if (bits > 20) {
                this.topLevelBits = 0;
                this.bottomTierBits = 20;
                this.midTierBits = bits - this.bottomTierBits;
            } else {
                this.topLevelBits = 0;
                this.midTierBits = 0;
                this.bottomTierBits = bits;
            }
            this.pageTableSize = 1 << this.topLevelBits;
            this.pageTable = new Object[this.pageTableSize];
            for (IMemorySource range : memorySources) {
                long baseSlot = range.getBaseAddress() >>> alignment;
                long topSlot = range.getTopAddress() >>> alignment;
                for (long i = baseSlot; i <= topSlot; ++i) {
                    this.insert(i, range);
                }
            }
        }

        private void insert(long slotIndex, IMemorySource range) {
            IMemorySource[] bottomTier;
            int bottomTierIndex = (int)(slotIndex & (long)((1 << this.bottomTierBits) - 1));
            long workingSlotIndex = slotIndex >>> this.bottomTierBits;
            int midTierIndex = (int)(workingSlotIndex & (long)((1 << this.midTierBits) - 1));
            int topTierIndex = (int)(workingSlotIndex >>>= this.midTierBits);
            Object[] midTier = (Object[])this.pageTable[topTierIndex];
            if (midTier == null) {
                this.pageTable[topTierIndex] = midTier = new Object[1 << this.midTierBits];
            }
            if (null == (bottomTier = (IMemorySource[])midTier[midTierIndex])) {
                midTier[midTierIndex] = bottomTier = new IMemorySource[1 << this.bottomTierBits];
            }
            bottomTier[bottomTierIndex] = range;
        }

        @Override
        public IMemorySource getRangeForAddress(long address) {
            long slotIndex = address >>> (int)this.alignment;
            int bottomTierIndex = (int)(slotIndex & (long)((1 << this.bottomTierBits) - 1));
            long workingSlotIndex = slotIndex >>> this.bottomTierBits;
            int midTierIndex = (int)(workingSlotIndex & (long)((1 << this.midTierBits) - 1));
            int topTierIndex = (int)(workingSlotIndex >>>= this.midTierBits);
            if (topTierIndex < 0 || topTierIndex >= this.pageTableSize) {
                return null;
            }
            Object[] midTier = (Object[])this.pageTable[topTierIndex];
            if (midTier == null) {
                return null;
            }
            IMemorySource[] bottomTier = (IMemorySource[])midTier[midTierIndex];
            if (null == bottomTier) {
                return null;
            }
            return bottomTier[bottomTierIndex];
        }
    }

    private static class MergedMemoryRange
    extends BaseMemoryRange
    implements IMemorySource {
        private final IMemorySource lower;
        private final IMemorySource upper;

        public MergedMemoryRange(IMemorySource lower, IMemorySource upper) {
            super(lower.getBaseAddress(), upper.getTopAddress() - lower.getBaseAddress() + 1L);
            this.lower = lower;
            this.upper = upper;
            if (lower.isBacked() != upper.isBacked()) {
                throw new RuntimeException("Error: creating an instance of MergedMemoryRange where backed and unbacked memory sources are merged");
            }
        }

        @Override
        public int getAddressSpaceId() {
            return this.lower.getAddressSpaceId();
        }

        @Override
        public boolean isBacked() {
            return this.upper.isBacked();
        }

        @Override
        public int getBytes(long address, byte[] buffer, int offset, int length) throws MemoryFault {
            if (this.lower.contains(address) && this.lower.contains(address + (long)length)) {
                return this.lower.getBytes(address, buffer, offset, length);
            }
            if (Addresses.greaterThan(address, this.lower.getTopAddress())) {
                return this.upper.getBytes(address, buffer, offset, length);
            }
            int sizeInLower = (int)(this.lower.getTopAddress() - address + 1L);
            int read = this.lower.getBytes(address, buffer, offset, sizeInLower);
            if (read == sizeInLower) {
                read += this.upper.getBytes(address + (long)sizeInLower, buffer, offset + sizeInLower, length - sizeInLower);
            }
            return read;
        }

        @Override
        public boolean isExecutable() {
            return this.lower.isExecutable() && this.upper.isExecutable();
        }

        @Override
        public boolean isReadOnly() {
            return this.lower.isReadOnly() && this.upper.isReadOnly();
        }

        @Override
        public boolean isShared() {
            return this.lower.isShared() && this.upper.isShared();
        }

        @Override
        public String getName() {
            String lowerResult = this.lower.getName();
            String upperResult = this.upper.getName();
            if (lowerResult != null) {
                if (upperResult != null) {
                    return lowerResult + " merged with " + upperResult;
                }
                return lowerResult;
            }
            if (upperResult != null) {
                return upperResult;
            }
            return null;
        }
    }

    private static class DebugAddressResolverStrategy
    implements IAddressResolverStrategy {
        private final IAddressResolverStrategy trusted;
        private final IAddressResolverStrategy untrusted;

        public DebugAddressResolverStrategy(IAddressResolverStrategy trusted, IAddressResolverStrategy untrusted) {
            this.trusted = trusted;
            this.untrusted = untrusted;
        }

        @Override
        public IMemorySource getRangeForAddress(long address) {
            IMemorySource untrustedResult;
            IMemorySource trustedResult = this.trusted.getRangeForAddress(address);
            if (trustedResult.equals(untrustedResult = this.untrusted.getRangeForAddress(address))) {
                return trustedResult;
            }
            throw new RuntimeException("Mismatch for address 0x" + Long.toHexString(address) + ". Trusted gave " + trustedResult + ", untrusted gave " + untrustedResult);
        }
    }
}

