/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.elf.DataEntry;
import com.ibm.j9ddr.corereaders.elf.ELFDumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ELFPPC32DumpReader
extends ELFDumpReader {
    protected ELFPPC32DumpReader(ELFFileReader reader) throws IOException, InvalidDumpFormatException {
        super(reader);
    }

    @Override
    protected long getBasePointerFrom(Map<String, Number> registers) {
        return this.getStackPointerFrom(registers);
    }

    @Override
    protected long getInstructionPointerFrom(Map<String, Number> registers) {
        return registers.get("pc").longValue();
    }

    @Override
    protected long getLinkRegisterFrom(Map<String, Number> registers) {
        return registers.get("lr").longValue();
    }

    @Override
    protected String getProcessorType() {
        return "ppc";
    }

    @Override
    protected String getStackPointerRegisterName() {
        return "gpr1";
    }

    @Override
    protected SortedMap<String, Number> readRegisters() throws IOException {
        TreeMap<String, Number> registers = new TreeMap<String, Number>(new ELFDumpReader.RegisterComparator(this));
        for (int i = 0; i < 32; ++i) {
            registers.put("gpr" + i, (long)this._reader.readInt() & 0xFFFFFFFFL);
        }
        registers.put("pc", (long)this._reader.readInt() & 0xFFFFFFFFL);
        this._reader.readInt();
        this._reader.readInt();
        registers.put("ctr", (long)this._reader.readInt() & 0xFFFFFFFFL);
        registers.put("lr", (long)this._reader.readInt() & 0xFFFFFFFFL);
        registers.put("xer", (long)this._reader.readInt() & 0xFFFFFFFFL);
        registers.put("cr", (long)this._reader.readInt() & 0xFFFFFFFFL);
        return registers;
    }

    @Override
    protected String[] getDwarfRegisterKeys() {
        int i;
        String[] registerNames = new String[132];
        for (i = 0; i < 32; ++i) {
            registerNames[i] = "gpr" + i;
        }
        for (i = 32; i < 64; ++i) {
            registerNames[i] = "fpr" + i;
        }
        registerNames[64] = "ctr";
        registerNames[65] = "lr";
        for (i = 100; i < 132; ++i) {
            registerNames[i] = "spr" + i;
        }
        return registerNames;
    }

    @Override
    protected void readHighwordRegisters(DataEntry entry, Map<String, Number> registers) throws IOException, InvalidDumpFormatException {
        throw new InvalidDumpFormatException("Unexpected data entry in PPC32 ELF dump");
    }

    @Override
    protected long readUID() throws IOException {
        return (long)this._reader.readShort() & 0xFFFFL;
    }
}

