/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.gccheck.CheckReporter;

class ScanFormatter {
    protected static final int NUMBER_ELEMENTS_DISPLAYED_PER_LINE = 8;
    protected long _currentCount = 0L;
    protected boolean _displayedData = false;
    protected CheckReporter _reporter;

    public ScanFormatter(Check check, String title, AbstractPointer pointer) {
        this._reporter = check.getReporter();
        this._reporter.println(String.format("<gc check: Start scan %s (%s)>", title, ScanFormatter.formatPointer(pointer)));
    }

    public ScanFormatter(Check check, String title) {
        this._reporter = check.getReporter();
        this._reporter.println(String.format("<gc check: Start scan %s>", title));
    }

    static String formatPointer(AbstractPointer pointer) {
        if (J9BuildFlags.env_data64) {
            return String.format("%016X", pointer.getAddress());
        }
        return String.format("%08X", pointer.getAddress());
    }

    public void section(String type2) {
        this._reporter.println(String.format("  <%s>", type2));
        this._currentCount = 0L;
    }

    public void section(String type2, AbstractPointer pointer) {
        this._reporter.println(String.format("  <%s (%s)>", type2, ScanFormatter.formatPointer(pointer)));
        this._currentCount = 0L;
    }

    public void endSection() {
        if (0L != this._currentCount && this._displayedData) {
            this._reporter.println(">");
            this._currentCount = 0L;
        }
    }

    public void entry(AbstractPointer pointer) {
        if (0L == this._currentCount) {
            this._reporter.print("    <");
            this._displayedData = true;
        }
        this._reporter.print(ScanFormatter.formatPointer(pointer) + " ");
        ++this._currentCount;
        if (8L == this._currentCount) {
            this._reporter.println(">");
            this._currentCount = 0L;
        }
    }

    public void end(String type2, AbstractPointer pointer) {
        if (0L != this._currentCount && this._displayedData) {
            this._reporter.println(">");
        }
        this._reporter.println(String.format("<gc check: End scan %s (%s)>", type2, ScanFormatter.formatPointer(pointer)));
    }

    public void end(String type2) {
        if (0L != this._currentCount && this._displayedData) {
            this._reporter.println(">");
        }
        this._reporter.println(String.format("<gc check: End scan %s>", type2));
    }
}

