/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.ICommand;
import com.ibm.j9ddr.tools.ddrinteractive.commands.GpInfoCommand;
import com.ibm.j9ddr.tools.ddrinteractive.commands.SnapFormatWrapperCommand;
import com.ibm.j9ddr.tools.ddrinteractive.commands.SnapTraceCommand;
import com.ibm.j9ddr.tools.ddrinteractive.plugins.DDRInteractiveClassLoader;
import com.ibm.j9ddr.tools.ddrinteractive.plugins.PluginConfig;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseJVMCommands {
    private final Logger logger = CommandUtils.getLogger();

    protected List<ICommand> getBaseJVMCommands() {
        LinkedList<ICommand> baseJVMCommands = new LinkedList<ICommand>();
        baseJVMCommands.add(new GpInfoCommand());
        baseJVMCommands.add(new SnapTraceCommand());
        baseJVMCommands.add(new SnapFormatWrapperCommand());
        return baseJVMCommands;
    }

    protected void loadPlugins(List<ICommand> toPassBack, Object obj) {
        if (!(obj instanceof DDRInteractiveClassLoader)) {
            this.logger.fine("Plugin classloader is not an instance of DRRInteractiveClassLoader. No plugins have been loaded");
            return;
        }
        DDRInteractiveClassLoader loader = (DDRInteractiveClassLoader)obj;
        for (PluginConfig plugin : loader.getPlugins()) {
            try {
                ICommand command = plugin.newInstance();
                toPassBack.add(command);
            }
            catch (Throwable e) {
                this.logger.log(Level.WARNING, "Failed to create an instance of " + plugin.getId(), e);
            }
        }
    }
}

