/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.events.IEventListener;
import com.ibm.j9ddr.vm29.events.EventManager;
import com.ibm.j9ddr.vm29.j9.ObjectModel;
import com.ibm.j9ddr.vm29.j9.gc.CorruptFreeEntryException;
import com.ibm.j9ddr.vm29.j9.gc.GCBase;
import com.ibm.j9ddr.vm29.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapLinkedFreeHeader;
import com.ibm.j9ddr.vm29.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm29.j9.gc.GCMemoryPoolAddressOrderedList;
import com.ibm.j9ddr.vm29.j9.gc.GCMemoryPoolAggregatedCellList;
import com.ibm.j9ddr.vm29.j9.gc.GCMemoryPoolSplitAddressOrderedList;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_HeapLinkedFreeHeaderPointer;
import com.ibm.j9ddr.vm29.pointer.generated.MM_MemoryPoolPointer;
import com.ibm.j9ddr.vm29.types.UDATA;

public abstract class GCMemoryPool {
    protected String _poolName = null;
    protected MemoryPoolType _memoryPoolType = MemoryPoolType.NULL;
    protected GCHeapRegionDescriptor _region = null;
    protected MM_MemoryPoolPointer _memoryPool = null;

    public GCMemoryPool(GCHeapRegionDescriptor region, MM_MemoryPoolPointer memoryPool) throws CorruptDataException {
        this._poolName = memoryPool._poolName().getCStringAtOffset(0L);
        this._memoryPool = memoryPool;
        this._region = region;
    }

    public static GCMemoryPool fromMemoryPoolPointerInRegion(GCHeapRegionDescriptor region, MM_MemoryPoolPointer memoryPool) throws CorruptDataException {
        MM_GCExtensionsPointer gcExtensions = GCBase.getExtensions();
        boolean splitFreeListsEnabled = gcExtensions.splitFreeListSplitAmount().gt(1);
        boolean isConcurrentSweepEnabled = gcExtensions.concurrentSweep();
        if (GCExtensions.isSegregatedHeap()) {
            return new GCMemoryPoolAggregatedCellList(region, memoryPool);
        }
        if (GCExtensions.isStandardGC()) {
            String poolName = memoryPool._poolName().getCStringAtOffset(0L);
            if (poolName.equals("Allocate/Survivor1") || poolName.equals("Allocate/Survivor2")) {
                return new GCMemoryPoolAddressOrderedList(region, memoryPool);
            }
            if (poolName.equals("Unknown") || poolName.equals("LOA") || poolName.equals("Tenure")) {
                if (splitFreeListsEnabled) {
                    if (isConcurrentSweepEnabled) {
                        return new GCMemoryPoolAddressOrderedList(region, memoryPool);
                    }
                    return new GCMemoryPoolSplitAddressOrderedList(region, memoryPool);
                }
                return new GCMemoryPoolAddressOrderedList(region, memoryPool);
            }
            throw new CorruptDataException("Unreachable");
        }
        if (GCExtensions.isVLHGC()) {
            throw new UnsupportedOperationException("Balanced GC not supported");
        }
        throw new CorruptDataException("Unreachable");
    }

    public MemoryPoolType getType() {
        return this._memoryPoolType;
    }

    public String getPoolName() {
        return this._poolName;
    }

    public GCHeapRegionDescriptor getRegion() {
        return this._region;
    }

    public MM_MemoryPoolPointer getMemoryPoolPointer() {
        return this._memoryPool;
    }

    protected void freeEntryCheckGeneric(GCHeapLinkedFreeHeader freeListEntry) throws CorruptDataException, CorruptFreeEntryException {
        MM_HeapLinkedFreeHeaderPointer freeListEntryAddress = freeListEntry.getHeader();
        UDATA size = freeListEntry.getSize();
        GCHeapRegionDescriptor region = this.getRegion();
        U8Pointer entryEndingAddressInclusive = U8Pointer.cast(freeListEntry.getHeader()).add(size.sub(1L));
        if (freeListEntry.getHeader().isNull()) {
            throw new CorruptFreeEntryException("freeEntryCorrupt", freeListEntryAddress);
        }
        if (!ObjectModel.isDeadObject(freeListEntry.getObject()) || ObjectModel.isSingleSlotDeadObject(freeListEntry.getObject())) {
            throw new CorruptFreeEntryException("freeEntryCorrupt", freeListEntryAddress);
        }
        if (!region.isAddressInRegion(VoidPointer.cast(freeListEntryAddress))) {
            throw new CorruptFreeEntryException("freeEntryCorrupt", freeListEntryAddress);
        }
        if (!region.isAddressInRegion(VoidPointer.cast(entryEndingAddressInclusive))) {
            throw new CorruptFreeEntryException("sizeFieldInvalid", freeListEntryAddress);
        }
    }

    public void checkFreeLists(IEventListener listener) {
        EventManager.register(listener);
        this.checkFreeListsImpl();
        EventManager.unregister(listener);
    }

    void checkFreeListsImpl() {
    }

    public String toString() {
        return String.format("Pool name: %s Pool Address: %s Region: %s", this.getPoolName(), this._memoryPool.getHexAddress(), this._region.getHeapRegionDescriptorPointer().getHexAddress());
    }

    public static enum MemoryPoolType {
        AOL,
        BUMP,
        SAOL,
        SEGREGATED,
        NULL;

    }
}

