/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

public class Humanize {
    public static String bytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        int exponent = (int)(Math.log(bytes) / Math.log(1024.0));
        char prefix = "KMGTPE".charAt(exponent - 1);
        return String.format("%.1f %sB", (double)bytes / Math.pow(1024.0, exponent), Character.valueOf(prefix));
    }

    public static String pointer(long value) {
        return "0x" + Long.toHexString(value).toUpperCase();
    }

    public static void main(String[] args) {
        System.out.println(Humanize.bytes(0L));
        System.out.println(Humanize.bytes(1023L));
        System.out.println(Humanize.bytes(1026L));
        System.out.println(Humanize.bytes(1048575L));
        System.out.println(Humanize.bytes(0x100000L));
        System.out.println(Humanize.bytes(0x3FF00000L));
        System.out.println(Humanize.bytes(0x40000000L));
    }
}

