/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

import com.ibm.j9ddr.corereaders.InvalidDumpFormatException;
import com.ibm.j9ddr.corereaders.elf.DataEntry;
import com.ibm.j9ddr.corereaders.elf.ELFDumpReader;
import com.ibm.j9ddr.corereaders.elf.ELFFileReader;
import java.io.IOException;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ELFS39064DumpReader
extends ELFDumpReader {
    protected ELFS39064DumpReader(ELFFileReader reader) throws IOException, InvalidDumpFormatException {
        super(reader);
    }

    @Override
    protected long getBasePointerFrom(Map<String, Number> registers) {
        return this.getStackPointerFrom(registers);
    }

    @Override
    protected long getInstructionPointerFrom(Map<String, Number> registers) {
        return registers.get("addr").longValue();
    }

    @Override
    protected long getLinkRegisterFrom(Map<String, Number> registers) {
        return 0L;
    }

    @Override
    protected String getProcessorType() {
        return "s390";
    }

    @Override
    protected String getStackPointerRegisterName() {
        return "addr";
    }

    @Override
    protected SortedMap<String, Number> readRegisters() throws IOException {
        int i;
        TreeMap<String, Number> registers = new TreeMap<String, Number>(new ELFDumpReader.RegisterComparator());
        registers.put("mask", this._reader.readLong());
        registers.put("addr", this._reader.readLong());
        for (i = 0; i < 16; ++i) {
            registers.put("gpr" + i, this._reader.readLong());
        }
        for (i = 0; i < 16; ++i) {
            registers.put("acr" + i, this._reader.readLong());
        }
        registers.put("origgpr2", this._reader.readLong());
        registers.put("trap", this._reader.readLong());
        registers.put("old_ilc", this._reader.readLong());
        return registers;
    }

    @Override
    protected String[] getDwarfRegisterKeys() {
        int i;
        String[] registerNames = new String[66];
        for (i = 0; i < 16; ++i) {
            registerNames[i] = "gpr" + i;
        }
        registerNames[16] = "fpr0";
        registerNames[17] = "fpr2";
        registerNames[18] = "fpr4";
        registerNames[19] = "fpr6";
        registerNames[20] = "fpr1";
        registerNames[21] = "fpr3";
        registerNames[22] = "fpr5";
        registerNames[23] = "fpr7";
        registerNames[24] = "fpr8";
        registerNames[25] = "fpr10";
        registerNames[26] = "fpr12";
        registerNames[27] = "fpr14";
        registerNames[28] = "fpr9";
        registerNames[29] = "fpr11";
        registerNames[30] = "fpr13";
        registerNames[31] = "fpr15";
        for (i = 0; i < 16; ++i) {
            registerNames[i + 32] = "cr" + i;
        }
        for (i = 0; i < 16; ++i) {
            registerNames[i + 48] = "ar" + i;
        }
        registerNames[64] = "mask";
        registerNames[65] = "addr";
        return registerNames;
    }

    @Override
    protected void readHighwordRegisters(DataEntry entry, Map<String, Number> registers) throws IOException, InvalidDumpFormatException {
        throw new InvalidDumpFormatException("Unexpected data entry in S39064 ELF dump");
    }

    @Override
    protected long readUID() throws IOException {
        return (long)this._reader.readInt() & 0xFFFFFFFFL;
    }
}

