/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageProcess;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RASPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9JavaVMHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;

public class CoreInfoCommand
extends Command {
    private static final String nl = System.getProperty("line.separator");

    public CoreInfoCommand() {
        this.addCommand("coreinfo", "", "Prints commandline, platform and -version info of VM found in the current core file.");
    }

    private void printUsage(PrintStream out) {
        out.println("coreinfo - Prints commandline, platform and -version info of VM found in the current core file.");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (0 < args.length) {
            out.println("!coreinfo expects no args. Usage :");
            this.printUsage(out);
            return;
        }
        try {
            J9RASPointer ras = DataType.getJ9RASPointer();
            J9JavaVMPointer vm = J9RASHelper.getVM(ras);
            IProcess process = vm.getProcess();
            J9DDRImageProcess ddrProcess = new J9DDRImageProcess(process);
            try {
                out.println("COMMANDLINE\n" + ddrProcess.getCommandLine() + "\n");
            }
            catch (DataUnavailable e) {
                out.println("COMMANDLINE is not available\n");
            }
            catch (com.ibm.dtfj.image.CorruptDataException e) {
                throw new DDRInteractiveCommandException("CorruptDataException occured while getting the commandline from process");
            }
            Properties properties = J9JavaVMHelper.getSystemProperties(vm);
            out.println("JAVA SERVICE LEVEL INFO\n" + ras.serviceLevel().getCStringAtOffset(0L));
            out.println("JAVA VERSION INFO\n" + properties.get("java.fullversion"));
            out.println("JAVA VM VERSION\t- " + properties.get("java.vm.version") + "\n");
            boolean is64BitPlatform = process.bytesPerPointer() == 8;
            ICore core = vm.getProcess().getAddressSpace().getCore();
            Platform platform = core.getPlatform();
            out.println("PLATFORM INFO");
            out.print("Platform Name :\t" + platform.name());
            if (is64BitPlatform) {
                out.println(" 64Bit");
            } else {
                out.println(" 32Bit");
            }
            out.println("OS Level\t: " + ras.osnameEA().getCStringAtOffset(0L) + " " + ras.osversionEA().getCStringAtOffset(0L));
            out.println("Processors -");
            out.println("  Architecture\t: " + ras.osarchEA().getCStringAtOffset(0L));
            out.println("  How Many\t: " + ras.cpus().longValue());
            try {
                properties = ddrProcess.getEnvironment();
                Enumeration<Object> processPropEnum = properties.keys();
                out.println("\nENVIRONMENT VARIABLES");
                while (processPropEnum.hasMoreElements()) {
                    String key = (String)processPropEnum.nextElement();
                    out.println(key + "=" + properties.get(key));
                }
            }
            catch (com.ibm.dtfj.image.CorruptDataException e) {
                throw new DDRInteractiveCommandException("CorruptDataException occured while getting the environment variables from process");
            }
            catch (DataUnavailable e) {
                out.println("Environment variables are not available\n");
            }
        }
        catch (CorruptDataException e) {
            e.printStackTrace();
        }
    }
}

