/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.structure.UnitTest;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=UnitTest.class)
public class UnitTestPointer
extends StructurePointer {
    public static final UnitTestPointer NULL = new UnitTestPointer(0L);

    protected UnitTestPointer(long address) {
        super(address);
    }

    public static UnitTestPointer cast(AbstractPointer structure) {
        return UnitTestPointer.cast(structure.getAddress());
    }

    public static UnitTestPointer cast(UDATA udata) {
        return UnitTestPointer.cast(udata.longValue());
    }

    public static UnitTestPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new UnitTestPointer(address);
    }

    @Override
    public UnitTestPointer add(long count) {
        return UnitTestPointer.cast(this.address + UnitTest.SIZEOF * count);
    }

    @Override
    public UnitTestPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public UnitTestPointer addOffset(long offset) {
        return UnitTestPointer.cast(this.address + offset);
    }

    @Override
    public UnitTestPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public UnitTestPointer sub(long count) {
        return UnitTestPointer.cast(this.address - UnitTest.SIZEOF * count);
    }

    @Override
    public UnitTestPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public UnitTestPointer subOffset(long offset) {
        return UnitTestPointer.cast(this.address - offset);
    }

    @Override
    public UnitTestPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public UnitTestPointer untag(long mask) {
        return UnitTestPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public UnitTestPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return UnitTest.SIZEOF;
    }
}

