/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.structure.ArrayList;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=ArrayList.class)
public class ArrayListPointer
extends StructurePointer {
    public static final ArrayListPointer NULL = new ArrayListPointer(0L);

    protected ArrayListPointer(long address) {
        super(address);
    }

    public static ArrayListPointer cast(AbstractPointer structure) {
        return ArrayListPointer.cast(structure.getAddress());
    }

    public static ArrayListPointer cast(UDATA udata) {
        return ArrayListPointer.cast(udata.longValue());
    }

    public static ArrayListPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new ArrayListPointer(address);
    }

    @Override
    public ArrayListPointer add(long count) {
        return ArrayListPointer.cast(this.address + ArrayList.SIZEOF * count);
    }

    @Override
    public ArrayListPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public ArrayListPointer addOffset(long offset) {
        return ArrayListPointer.cast(this.address + offset);
    }

    @Override
    public ArrayListPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public ArrayListPointer sub(long count) {
        return ArrayListPointer.cast(this.address - ArrayList.SIZEOF * count);
    }

    @Override
    public ArrayListPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public ArrayListPointer subOffset(long offset) {
        return ArrayListPointer.cast(this.address - offset);
    }

    @Override
    public ArrayListPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public ArrayListPointer untag(long mask) {
        return ArrayListPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public ArrayListPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return ArrayList.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_headerOffset_", declaredType="void**")
    public PointerPointer header() throws CorruptDataException {
        return PointerPointer.cast(this.getPointerAtOffset(ArrayList._headerOffset_));
    }

    public PointerPointer headerEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)ArrayList._headerOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_slabSizeOffset_", declaredType="UDATA")
    public UDATA slabSize() throws CorruptDataException {
        return new UDATA(this.getUDATAAtOffset(ArrayList._slabSizeOffset_));
    }

    public UDATAPointer slabSizeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)ArrayList._slabSizeOffset_);
    }
}

