/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.java.helper;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.view.dtfj.J9DDRDTFJUtils;
import java.util.Iterator;

public class DTFJJavaRuntimeHelper {
    private static long totalSizeOfAllHeaps = -1L;

    public static long getTotalHeapSize(JavaRuntime runtime, IProcess process) throws CorruptDataException {
        if (totalSizeOfAllHeaps > 0L) {
            return totalSizeOfAllHeaps;
        }
        if (runtime == null) {
            throw new CorruptDataException((CorruptData)J9DDRDTFJUtils.newCorruptData(process, "No Java Runtime present"));
        }
        Iterator heaps = runtime.getHeaps();
        while (heaps.hasNext()) {
            Iterator sections;
            Object nextHeap = heaps.next();
            if (nextHeap instanceof JavaHeap) {
                sections = ((JavaHeap)nextHeap).getSections();
            } else {
                throw new CorruptDataException((CorruptData)J9DDRDTFJUtils.newCorruptData(process, "Corrupt heap encountered whilst calculating total heap size"));
            }
            while (sections.hasNext()) {
                Object nextSection = sections.next();
                if (nextSection instanceof ImageSection) {
                    long sectionSize = ((ImageSection)nextSection).getSize();
                    if (Long.MAX_VALUE - sectionSize > totalSizeOfAllHeaps) {
                        totalSizeOfAllHeaps += sectionSize;
                        continue;
                    }
                    return Long.MAX_VALUE;
                }
                throw new CorruptDataException((CorruptData)J9DDRDTFJUtils.newCorruptData(process, "Corrupt section encountered whilst calculating total heap size"));
            }
        }
        return totalSizeOfAllHeaps;
    }
}

