/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.view.dtfj.image;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageAddressSpace;
import java.util.Properties;

public class J9DDRImagePointer
implements ImagePointer {
    private final IProcess proc;
    private final long address;

    public J9DDRImagePointer(IProcess proc, long address) {
        this.proc = proc;
        this.address = address;
    }

    public ImagePointer add(long offset) {
        return new J9DDRImagePointer(this.proc, this.address + offset);
    }

    public long getAddress() {
        return this.address;
    }

    public ImageAddressSpace getAddressSpace() {
        return new J9DDRImageAddressSpace(this.proc.getAddressSpace());
    }

    public byte getByteAt(long index) throws MemoryAccessException, CorruptDataException {
        try {
            return this.proc.getByteAt(this.address + index);
        }
        catch (MemoryFault e) {
            MemoryAccessException toThrow = new MemoryAccessException(this.add(index));
            toThrow.initCause((Throwable)e);
            throw toThrow;
        }
    }

    public double getDoubleAt(long index) throws MemoryAccessException, CorruptDataException {
        try {
            long data = this.proc.getLongAt(this.address + index);
            return Double.longBitsToDouble(data);
        }
        catch (MemoryFault e) {
            MemoryAccessException toThrow = new MemoryAccessException(this.add(index));
            toThrow.initCause((Throwable)e);
            throw toThrow;
        }
    }

    public float getFloatAt(long index) throws MemoryAccessException, CorruptDataException {
        try {
            int data = this.proc.getIntAt(this.address + index);
            return Float.intBitsToFloat(data);
        }
        catch (MemoryFault e) {
            MemoryAccessException toThrow = new MemoryAccessException(this.add(index));
            toThrow.initCause((Throwable)e);
            throw toThrow;
        }
    }

    public int getIntAt(long index) throws MemoryAccessException, CorruptDataException {
        try {
            return this.proc.getIntAt(this.address + index);
        }
        catch (MemoryFault e) {
            MemoryAccessException toThrow = new MemoryAccessException(this.add(index));
            toThrow.initCause((Throwable)e);
            throw toThrow;
        }
    }

    public long getLongAt(long index) throws MemoryAccessException, CorruptDataException {
        try {
            return this.proc.getLongAt(this.address + index);
        }
        catch (MemoryFault e) {
            MemoryAccessException toThrow = new MemoryAccessException(this.add(index));
            toThrow.initCause((Throwable)e);
            throw toThrow;
        }
    }

    public ImagePointer getPointerAt(long index) throws MemoryAccessException, CorruptDataException {
        try {
            long ptr = this.proc.getPointerAt(this.address + index);
            return new J9DDRImagePointer(this.proc, ptr);
        }
        catch (MemoryFault e) {
            MemoryAccessException toThrow = new MemoryAccessException(this.add(index));
            toThrow.initCause((Throwable)e);
            throw toThrow;
        }
    }

    public short getShortAt(long index) throws MemoryAccessException, CorruptDataException {
        try {
            return this.proc.getShortAt(this.address + index);
        }
        catch (MemoryFault e) {
            MemoryAccessException toThrow = new MemoryAccessException(this.add(index));
            toThrow.initCause((Throwable)e);
            throw toThrow;
        }
    }

    public boolean isExecutable() throws DataUnavailable {
        return this.proc.isExecutable(this.address);
    }

    public boolean isReadOnly() throws DataUnavailable {
        return this.proc.isReadOnly(this.address);
    }

    public boolean isShared() throws DataUnavailable {
        return this.proc.isShared(this.address);
    }

    public String toString() {
        return Long.toHexString(this.address);
    }

    public boolean equals(Object obj) {
        if (obj instanceof J9DDRImagePointer) {
            J9DDRImagePointer other = (J9DDRImagePointer)obj;
            if (other.address != this.address) {
                return false;
            }
            return other.proc.getAddressSpace().equals(this.proc.getAddressSpace());
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.address >>> 3);
    }

    public Properties getProperties() {
        return this.proc.getProperties(this.address);
    }
}

