/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLDOMComparator {
    protected HashMap<String, File> opts = new HashMap();
    protected static final String OPT_J9DDR_FILE = "-ddr";
    protected static final String OPT_JEXTRACT_FILE = "-jx";
    protected static final String OPT_CONFIG_FILE = "-f";
    private Document xmlJ9DDR = null;
    private Document xmlJExtract = null;
    private Properties xpathQueries = null;
    private ArrayList<String> messages = new ArrayList();

    public Iterator<String> getMessages() {
        return this.messages.iterator();
    }

    public static void main(String[] args) {
        XMLDOMComparator comp = new XMLDOMComparator();
        comp.parseArgs(args);
        comp.compareXML();
    }

    public boolean compareXML() {
        this.parseXML();
        this.loadXPathProperties();
        return this.areDOMsEqual();
    }

    private boolean areDOMsEqual() {
        boolean result = true;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpathJ9DDR = factory.newXPath();
        XPath xpathJExtract = factory.newXPath();
        for (String string : this.xpathQueries.keySet()) {
            String xpath = this.xpathQueries.getProperty(string);
            this.messages.add("Test : " + string + " : " + xpath);
            try {
                NodeList resultJ9DDR = (NodeList)xpathJ9DDR.evaluate(xpath, this.xmlJ9DDR, XPathConstants.NODESET);
                NodeList resultJExtract = (NodeList)xpathJExtract.evaluate(xpath, this.xmlJExtract, XPathConstants.NODESET);
                boolean testResult = this.areNodeListsEqual(resultJ9DDR, resultJExtract);
                if (!testResult) {
                    this.messages.add("Test failed : node lists are not equal");
                }
                result &= testResult;
            }
            catch (XPathExpressionException e) {
                this.messages.add("Skipping test, error in XPath expression : " + e.getMessage());
            }
        }
        return result;
    }

    private boolean areNodeListsEqual(NodeList resultJ9DDR, NodeList resultJExtract) {
        boolean result = true;
        if (resultJ9DDR.getLength() != resultJExtract.getLength()) {
            this.messages.add("The number of nodes returned does not match");
            return false;
        }
        for (int i = 0; i < resultJ9DDR.getLength(); ++i) {
            Node nodeJ9DDR = resultJ9DDR.item(i);
            Node nodeJExtract = resultJExtract.item(i);
            result &= this.areNodeListsEqual(nodeJ9DDR.getChildNodes(), nodeJExtract.getChildNodes());
            String nodeName = nodeJ9DDR.getNodeName();
            if (!nodeJ9DDR.getNodeName().equals(nodeJExtract.getNodeName())) {
                this.messages.add("The node names did not match : " + nodeJ9DDR.getNodeName() + " != " + nodeJExtract.getNodeName());
                return false;
            }
            if (nodeJ9DDR.getNodeValue() == null) {
                if (nodeJExtract.getNodeValue() != null) {
                    this.messages.add("One node had a null value whilst the other was non-null : Node : " + nodeName);
                    return false;
                }
            } else if (!nodeJ9DDR.getNodeValue().equals(nodeJExtract.getNodeValue())) {
                this.messages.add("The values for node " + nodeName + " do not match : " + nodeJ9DDR.getNodeValue() + " != " + nodeJExtract.getNodeValue());
                return false;
            }
            if (nodeJ9DDR.hasAttributes() ^ nodeJExtract.hasAttributes()) {
                this.messages.add("The number of attributes for " + nodeName + " do not match");
                return false;
            }
            if (!nodeJ9DDR.hasAttributes() || !nodeJExtract.hasAttributes()) continue;
            NamedNodeMap mapJ9DDR = nodeJ9DDR.getAttributes();
            NamedNodeMap mapJExtract = nodeJExtract.getAttributes();
            if (mapJ9DDR.getLength() != mapJExtract.getLength()) {
                this.messages.add("The number of attributes for " + nodeName + " do not match");
                return false;
            }
            for (int j = 0; j < mapJ9DDR.getLength(); ++j) {
                Node attrJ9DDR = mapJ9DDR.item(j);
                Node attrJExtract = mapJExtract.item(j);
                if (!attrJ9DDR.getNodeName().equals(attrJExtract.getNodeName())) {
                    this.messages.add("The attribute for " + nodeName + " does not match : " + attrJ9DDR.getNodeName() + " != " + attrJExtract.getNodeName());
                    return false;
                }
                if (attrJ9DDR.getNodeValue().equals(attrJExtract.getNodeValue())) continue;
                this.messages.add("The attribute " + attrJ9DDR.getNodeName() + " for node " + nodeName + " does not match : " + attrJ9DDR.getNodeValue() + " != " + attrJExtract.getNodeValue());
                return false;
            }
        }
        return result;
    }

    private void loadXPathProperties() {
        try {
            this.xpathQueries = new Properties();
            FileInputStream fis = new FileInputStream(this.opts.get(OPT_CONFIG_FILE));
            this.xpathQueries.load(fis);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("General failure parsing the XPath config : " + this.opts.get(OPT_CONFIG_FILE).getAbsolutePath() + ". " + e.getMessage());
        }
    }

    private void parseXML() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.xmlJ9DDR = builder.parse(this.opts.get(OPT_J9DDR_FILE));
            this.xmlJExtract = builder.parse(this.opts.get(OPT_JEXTRACT_FILE));
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("The XML file contains invalid XML");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to read from XML file : " + e.getMessage());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("General failure parsing the XML : " + e.getMessage());
        }
    }

    public XMLDOMComparator() {
        this.opts.put(OPT_J9DDR_FILE, null);
        this.opts.put(OPT_JEXTRACT_FILE, null);
        this.opts.put(OPT_CONFIG_FILE, null);
    }

    public void parseArgs(String[] args) {
        try {
            for (int i = 0; i < args.length; i += 2) {
                File file;
                if (this.opts.containsKey(args[i])) {
                    file = new File(args[i + 1]);
                    if (!file.exists()) {
                        throw new IllegalArgumentException("The file " + file.getAbsolutePath() + " does not exist or cannot be found");
                    }
                } else {
                    throw new IllegalArgumentException("Invalid option : " + args[i]);
                }
                this.opts.put(args[i], file);
            }
            for (String key : this.opts.keySet()) {
                File value = this.opts.get(key);
                if (value != null) continue;
                throw new IllegalArgumentException("The option " + key + " has not been set.");
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            XMLDOMComparator.printHelp();
            System.exit(1);
        }
    }

    private static final void printHelp() {
        System.out.println("Usage :\n\njava XMLDOMComparator -ddr <path to J9DDR XML file> -jx <path to JExtract XML file> -f <path to config file>\n");
        System.out.println("<path to J9DDR XML file> : full path to the XML file which has been generated by J9DDR");
        System.out.println("<path to JExtract XML file> : full path to the XML file which has been generated by JExtract");
        System.out.println("<path to config file> : full path to the XPath properties file which controls the nodes to be tested");
    }
}

