/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.minidump.unwind;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.IAddressSpace;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.minidump.unwind.UnwindCode;
import com.ibm.j9ddr.corereaders.minidump.unwind.UnwindModule;

public class UnwindInfo {
    private static final int FLAGS_CHAINED = 4;
    private long address;
    private UnwindModule module;
    private IAddressSpace process;
    private static final int OFFSET_VERSION = 0;
    private static final int OFFSET_FLAGS = 0;
    private static final int OFFSET_SIZEOFPROLOG = 1;
    private static final int OFFSET_COUNTOFCODES = 2;
    private static final int OFFSET_FRAMEREGISTER = 3;
    private static final int OFFSET_FRAMEOFFSET = 3;
    private static final int OFFSET_UNWINDCODE = 4;

    public UnwindInfo(IAddressSpace process, UnwindModule module, long address) throws CorruptDataException {
        this.address = address;
        this.module = module;
        this.process = process;
        byte version = this.getVersion();
        if (version != 1) {
            throw new CorruptDataException(String.format("Incorrect version number %d in UNWIND_INFO at 0x&08x", version, address));
        }
    }

    private byte getVersion() throws MemoryFault {
        byte version = (byte)(this.process.getByteAt(0L + this.module.getLoadAddress() + this.address) & 7);
        return version;
    }

    private byte getFlags() throws MemoryFault {
        byte flags = (byte)(this.process.getByteAt(0L + this.module.getLoadAddress() + this.address) & 0xFFFFFFF8);
        flags = (byte)(flags >> 3);
        return flags;
    }

    private byte getPrologSize() throws MemoryFault {
        byte prologSize = this.process.getByteAt(1L + this.module.getLoadAddress() + this.address);
        return prologSize;
    }

    private byte getCountOfCodes() throws MemoryFault {
        byte codeCount = this.process.getByteAt(2L + this.module.getLoadAddress() + this.address);
        return codeCount;
    }

    public String toString() {
        Object str = "";
        try {
            byte version = this.getVersion();
            byte flags = this.getFlags();
            byte prologSize = this.getPrologSize();
            byte countOfCodes = this.getCountOfCodes();
            str = (String)str + String.format("Version: 0x%x, flags 0x%x, SizeOfProlog 0x%02x, CountOfCodes %d", version, flags, prologSize, countOfCodes);
            long unwindCodeAddr = 4L + this.address;
            byte codeIndex = 0;
            while (codeIndex < countOfCodes) {
                UnwindCode c = new UnwindCode(this.process, this.module, this, unwindCodeAddr);
                str = (String)str + "\n\t";
                str = (String)str + c.toString();
                codeIndex = (byte)(codeIndex + c.getNodeCount());
                unwindCodeAddr += (long)(2 * c.getNodeCount());
            }
            return str;
        }
        catch (MemoryFault mf) {
            return "Error getting UnwindInfo " + mf.toString();
        }
        catch (CorruptDataException e) {
            return "Error getting UnwindInfo " + e.toString();
        }
    }

    public long apply(long stackPointer) throws CorruptDataException {
        byte version = this.getVersion();
        if (version != 1) {
            throw new CorruptDataException("Invalid version " + version + " in UNWIND_INFO expected 1");
        }
        byte flags = this.getFlags();
        byte prologSize = this.getPrologSize();
        byte countOfCodes = this.getCountOfCodes();
        if (countOfCodes != 0) {
            long unwindCodeAddr = 4L + this.address;
            byte codeIndex = 0;
            while (codeIndex < countOfCodes) {
                UnwindCode c = new UnwindCode(this.process, this.module, this, unwindCodeAddr);
                stackPointer = c.getNewSP(stackPointer);
                codeIndex = (byte)(codeIndex + c.getNodeCount());
                unwindCodeAddr += (long)(2 * c.getNodeCount());
            }
        }
        if ((flags & 4) == 4) {
            UnwindInfo chainedInfo = this.getChainedUnwindInfo();
            stackPointer = chainedInfo.apply(stackPointer);
        }
        return stackPointer;
    }

    private UnwindInfo getChainedUnwindInfo() throws CorruptDataException {
        long chainedAddress = this.process.getIntAt(this.module.getLoadAddress() + this.address + 4L + (long)(this.getCountOfCodes() * 2) + 8L);
        UnwindInfo chainedEntry = new UnwindInfo(this.process, this.module, chainedAddress);
        return chainedEntry;
    }
}

