/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf;

class SectionHeaderEntry {
    static final int SHT_SYMTAB = 2;
    static final int SHT_STRTAB = 3;
    static final int SHT_NOBITS = 8;
    static final int SHT_DYNSYM = 11;
    static final int SHF_ALLOC = 2;
    long _name;
    long _type;
    final long _flags;
    final long address;
    final long offset;
    final long size;
    final long link;

    SectionHeaderEntry(long name, long type, long flags, long address, long offset, long size, long link, long info) {
        this._name = name;
        this._type = type;
        this._flags = flags;
        this.address = address;
        this.offset = offset;
        this.size = size;
        this.link = link;
    }

    boolean isSymbolTable() {
        return 2L == this._type || 11L == this._type;
    }

    public boolean isStringTable() {
        return 3L == this._type;
    }

    public boolean isNoBits() {
        return 8L == this._type;
    }

    public boolean isAllocated() {
        return (this._flags & 2L) == 2L;
    }

    public String toString() {
        return String.format("Name %d, Type %d, Flags 0x%x, Address 0x%x, Offset 0x%x, Size 0x%x", this._name, this._type, this._flags, this.address, this.offset, this.size);
    }
}

