/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.DDRSymbolFinder;
import com.ibm.j9ddr.DataUnavailableException;
import com.ibm.j9ddr.IVMData;
import com.ibm.j9ddr.J9DDRClassLoader;
import com.ibm.j9ddr.StructureHeader;
import com.ibm.j9ddr.StructureReader;
import com.ibm.j9ddr.blobs.BlobFactory;
import com.ibm.j9ddr.blobs.IBlobFactory;
import com.ibm.j9ddr.corereaders.ICore;
import com.ibm.j9ddr.corereaders.Platform;
import com.ibm.j9ddr.corereaders.memory.IMemoryImageInputStream;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.ISymbol;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.exceptions.CorruptStructuresException;
import com.ibm.j9ddr.exceptions.JVMNotDDREnabledException;
import com.ibm.j9ddr.exceptions.JVMNotFoundException;
import com.ibm.j9ddr.exceptions.MissingDDRStructuresException;
import com.ibm.j9ddr.exceptions.UnknownArchitectureException;
import com.ibm.j9ddr.util.WeakValueMap;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.imageio.stream.MemoryCacheImageInputStream;

public abstract class VMDataFactory {
    private static final String STRUCTUREFILE_PROPERTY = "com.ibm.j9ddr.structurefile";
    private static final String SEARCHEYECATCHER_PROPERTY = "com.ibm.j9ddr.searcheyecatcher";
    private static final String NOEXTRASEARCHFORNODE_PROPERTY = "com.ibm.j9ddr.noextrasearchfornode";
    public static final String J9RAS_SYMBOL = "_j9ras_";
    private static final byte[] eyecatcher;
    private static final long integrityCheck = -6172840429334713771L;
    private static final int BIT_PATTERNS_OFFSET = 8;
    private static final int J9RAS_VERSION_OFFSET = 16;
    private static final int DDR_DATA_POINTER_OFFSET = 24;
    private static final int MINIMUM_J9RAS_MAJOR_VERSION = 2;
    private static long j9RASAddress;
    private static WeakValueMap<IProcess, List<IVMData>> vmDataCache;

    public static IVMData getVMData(IProcess process) throws IOException {
        List<IVMData> cachedVMData = vmDataCache.get(process);
        if (cachedVMData != null && cachedVMData.size() > 0) {
            return cachedVMData.get(0);
        }
        cachedVMData = VMDataFactory.getAllVMData(process);
        if (cachedVMData.size() > 0) {
            return cachedVMData.get(0);
        }
        return null;
    }

    public static synchronized List<IVMData> getAllVMData(IProcess process) throws IOException {
        List<IVMData> cachedVMData = vmDataCache.get(process);
        if (cachedVMData != null) {
            return cachedVMData;
        }
        ArrayList<IVMData> data = new ArrayList<IVMData>();
        ImageInputStream in = null;
        boolean EOM = false;
        long address = 0L;
        j9RASAddress = 0L;
        while (!EOM) {
            try {
                address = j9RASAddress + 1L;
                in = VMDataFactory.getStructureDataFile(process, address);
                if (in != null) {
                    EOM = !(in instanceof IMemoryImageInputStream);
                    IVMData vmdata = VMDataFactory.getVMData(process, in);
                    data.add(vmdata);
                    if (vmdata.getClassLoader().getHeader().getCoreVersion() != 1) continue;
                    EOM = true;
                    break;
                }
                EOM = true;
            }
            catch (JVMNotFoundException e) {
                EOM = true;
            }
            catch (JVMNotDDREnabledException e) {
                EOM |= process.getPlatform() == Platform.ZOS;
            }
            catch (MissingDDRStructuresException e) {
                EOM |= process.getPlatform() == Platform.ZOS;
            }
            catch (CorruptStructuresException e) {
                EOM |= process.getPlatform() == Platform.ZOS;
            }
            catch (IOException e) {}
        }
        if (System.getProperty(NOEXTRASEARCHFORNODE_PROPERTY) == null && data.size() == 0) {
            StructureHeader header = null;
            try {
                header = VMDataFactory.findNodeVersion(process);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
            if (header != null && (in = VMDataFactory.getBlobFromLibrary(process, header)) != null) {
                IVMData vmdata = VMDataFactory.getVMData(process, in);
                data.add(vmdata);
            }
        }
        vmDataCache.put(process, data);
        return data;
    }

    private static IVMData getVMData(IProcess process, ImageInputStream in) throws IOException {
        final StructureReader structureReader = new StructureReader(in);
        J9DDRClassLoader ddrClassLoader = AccessController.doPrivileged(new PrivilegedAction<J9DDRClassLoader>(){

            @Override
            public J9DDRClassLoader run() {
                return new J9DDRClassLoader(structureReader, VMDataFactory.class.getClassLoader());
            }
        });
        try {
            IVMData vmData = ddrClassLoader.getIVMData(process, j9RASAddress);
            Class<?> dataTypeClazz = ddrClassLoader.loadClassRelativeToStream("j9.DataType", false);
            Method initMethod = dataTypeClazz.getDeclaredMethod("init", IProcess.class, StructureReader.class);
            initMethod.invoke(null, process, structureReader);
            String basePackageName = structureReader.getPackageName(StructureReader.PackageNameType.POINTER_PACKAGE_DOT_NAME);
            Class<?> rasClazz = ddrClassLoader.loadClass(basePackageName + ".J9RASPointer");
            Method getStructureMethod = rasClazz.getDeclaredMethod("cast", Long.TYPE);
            Object pointer = getStructureMethod.invoke(null, j9RASAddress);
            Method setMethod = dataTypeClazz.getDeclaredMethod("setJ9RASPointer", pointer.getClass());
            setMethod.invoke((Object)vmData, pointer);
            VMDataFactory.addFragments(rasClazz, pointer, structureReader, vmData);
            if (!Boolean.FALSE.toString().equals(System.getProperty("com.ibm.j9ddr.symbols.from.pointers"))) {
                DDRSymbolFinder.addSymbols(process, j9RASAddress, structureReader);
            }
            return vmData;
        }
        catch (ClassNotFoundException e) {
            Logger logger = Logger.getLogger("j9ddr.structure_reader");
            logger.log(Level.FINE, null, e);
            throw new IOException(String.format("Invalid or unavailable structure offset data.  %s", e.getMessage()));
        }
        catch (NoSuchMethodException e) {
            Logger logger = Logger.getLogger("j9ddr.structure_reader");
            logger.log(Level.FINE, null, e);
            throw new IOException(String.format("Invalid or unavailable structure offset data.  %s", e.getMessage()));
        }
        catch (IllegalAccessException e) {
            Logger logger = Logger.getLogger("j9ddr.structure_reader");
            logger.log(Level.FINE, null, e);
            throw new IOException(String.format("Invalid or unavailable structure offset data.  %s", e.getMessage()));
        }
        catch (InvocationTargetException e) {
            Logger logger = Logger.getLogger("j9ddr.structure_reader");
            logger.log(Level.FINE, null, e);
            throw new IOException(String.format("Invalid or unavailable structure offset data.  %s", e.getMessage()));
        }
        catch (InstantiationException e) {
            Logger logger = Logger.getLogger("j9ddr.structure_reader");
            logger.log(Level.FINE, null, e);
            throw new IOException(String.format("Invalid or unavailable structure offset data.  %s", e.getMessage()));
        }
    }

    private static void addFragments(Class<?> rasClazz, Object rasptr, StructureReader structureReader, IVMData vmdata) {
        try {
            InputStream in = rasClazz.getResourceAsStream("/fragments/fragments.properties");
            if (in == null) {
                Logger logger = Logger.getLogger("j9ddr.structure_reader");
                logger.log(Level.FINE, "Failed to find fragments property file");
                return;
            }
            Properties fragments = new Properties();
            fragments.load(in);
            in.close();
            Method method = rasClazz.getDeclaredMethod("buildID", null);
            Object u64 = method.invoke(rasptr, (Object[])null);
            method = u64.getClass().getMethod("getHexValue", null);
            Object result = method.invoke(u64, (Object[])null);
            String buildID = result.toString();
            if (buildID.length() < 8) {
                return;
            }
            String shortID = buildID.substring(buildID.length() - 8);
            String key = vmdata.getVersion() + "-" + buildID;
            if (VMDataFactory.hasFragmentBeenLoaded(rasClazz, fragments, structureReader, key)) {
                return;
            }
            key = vmdata.getVersion() + "-" + shortID;
            if (VMDataFactory.hasFragmentBeenLoaded(rasClazz, fragments, structureReader, key)) {
                return;
            }
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger("j9ddr.structure_reader");
            logger.log(Level.FINE, "Failed to process blob fragments", e);
        }
    }

    private static boolean hasFragmentBeenLoaded(Class<?> rasClazz, Properties fragments, StructureReader reader, String key) throws IOException {
        if (fragments.containsKey(key)) {
            InputStream in = rasClazz.getResourceAsStream("/fragments/" + fragments.getProperty(key));
            MemoryCacheImageInputStream iis = new MemoryCacheImageInputStream(in);
            reader.addStructures(iis);
            iis.close();
            return true;
        }
        return false;
    }

    private static ImageInputStream getStructureDataFile(IProcess process, long start) throws IOException {
        try {
            if (process.getPlatform() == Platform.ZOS) {
                return VMDataFactory.getStructureDataFileFromSymbol(process);
            }
            return VMDataFactory.getStructureDataFileFromRASEyecatcher(process, start);
        }
        catch (JVMNotFoundException e) {
            String structureFileName = System.getProperty(STRUCTUREFILE_PROPERTY);
            if (structureFileName != null) {
                try {
                    return VMDataFactory.getStructureDataFromFile(structureFileName, process);
                }
                catch (Exception e1) {
                    IOException ioe = new IOException();
                    ioe.initCause(e);
                    throw ioe;
                }
            }
            if (process.getPlatform() == Platform.ZOS) {
                try {
                    return VMDataFactory.getStructureDataFileFromSymbol(process);
                }
                catch (JVMNotFoundException e1) {
                    if (System.getProperty(SEARCHEYECATCHER_PROPERTY) != null) {
                        return VMDataFactory.getStructureDataFileFromRASEyecatcher(process, start);
                    }
                    throw e1;
                }
            }
            throw e;
        }
    }

    private static ImageInputStream getStructureDataFileFromRASEyecatcher(IProcess process, long start) throws IOException {
        try {
            long address = process.findPattern(eyecatcher, 1, start);
            while (address != -1L) {
                long bitPattern = process.getLongAt(address + 8L);
                if (bitPattern == -6172840429334713771L) {
                    return VMDataFactory.foundRAS(process, address);
                }
                address = process.findPattern(eyecatcher, 1, address + (long)eyecatcher.length);
            }
            throw new JVMNotFoundException(process, "Could not find J9RAS structure. No Java in process?");
        }
        catch (MemoryFault e) {
            Logger logger = Logger.getLogger("j9ddr.structure_reader");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            logger.logp(Level.FINE, null, null, sw.toString());
            throw new IOException(e.getMessage());
        }
    }

    private static ImageInputStream getStructureDataFileFromSymbol(IProcess process) throws IOException {
        try {
            for (IModule iModule : process.getModules()) {
                for (ISymbol iSymbol : iModule.getSymbols()) {
                    if (!iSymbol.getName().equals(J9RAS_SYMBOL)) continue;
                    return VMDataFactory.foundRAS(process, iSymbol.getAddress());
                }
            }
        }
        catch (CorruptDataException e) {
            throw new IOException(e.getMessage());
        }
        catch (DataUnavailableException e) {
            throw new IOException(e.getMessage());
        }
        throw new JVMNotFoundException(process, "Could not find _j9ras_ symbol in process");
    }

    private static ImageInputStream getStructureDataFromFile(String fileName, IProcess addressSpace) throws IOException {
        File blobFile = new File(fileName);
        FileImageInputStream iis = new FileImageInputStream(blobFile);
        iis.setByteOrder(addressSpace.getByteOrder());
        return iis;
    }

    private static ImageInputStream foundRAS(IProcess addressSpace, long candidateAddress) throws IOException {
        try {
            long marker;
            j9RASAddress = candidateAddress;
            String structureFileName = System.getProperty(STRUCTUREFILE_PROPERTY);
            if (structureFileName != null) {
                try {
                    return VMDataFactory.getStructureDataFromFile(structureFileName, addressSpace);
                }
                catch (FileNotFoundException e) {
                    return VMDataFactory.getBlobFromArchive(structureFileName, addressSpace);
                }
            }
            int j9RASVersion = addressSpace.getIntAt(candidateAddress + 16L);
            short j9RASMajorVersion = (short)(j9RASVersion >> 16);
            if (j9RASMajorVersion < 2) {
                return VMDataFactory.locateInServiceVMStructure(addressSpace);
            }
            long ddrDataStart = addressSpace.getPointerAt(candidateAddress + 24L);
            if (0L == ddrDataStart) {
                try {
                    return VMDataFactory.locateInServiceVMStructure(addressSpace);
                }
                catch (IOException e) {
                    MissingDDRStructuresException ioe = new MissingDDRStructuresException(addressSpace, "System dump was generated by a DDR-enabled JVM, but did not contain embedded DDR structures. This dump cannot be analyzed by DDR. You can specify the location of a DDR structure file to use with the com.ibm.j9ddr.structurefile system property");
                    ioe.initCause(e);
                    throw ioe;
                }
            }
            long l = marker = addressSpace.bytesPerPointer() == 4 ? 0xFFFFFFFF00000000L | ddrDataStart : ddrDataStart;
            if (marker == -2L) {
                StructureHeader header = new StructureHeader(1);
                ddrDataStart = candidateAddress + 24L + (long)(addressSpace.bytesPerPointer() * 2);
                IMemoryImageInputStream stream = new IMemoryImageInputStream(addressSpace, ddrDataStart);
                header.readBlobVersion(stream);
                return VMDataFactory.getBlobFromLibrary(addressSpace, header);
            }
            if (marker == -1L) {
                if (j9RASVersion == 0x100000) {
                    ddrDataStart = candidateAddress + 24L + (long)(addressSpace.bytesPerPointer() * 2);
                } else {
                    MissingDDRStructuresException ioe = new MissingDDRStructuresException(addressSpace, "System dump was generated by a DDR-enabled JVM, but did not contain embedded DDR structures. This dump cannot be analyzed by DDR. You can specify the location of a DDR structure file to use with the com.ibm.j9ddr.structurefile system property");
                    throw ioe;
                }
            }
            return new IMemoryImageInputStream(addressSpace, ddrDataStart);
        }
        catch (MemoryFault e) {
            Logger logger = Logger.getLogger("j9ddr.structure_reader");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            logger.logp(Level.FINE, null, null, sw.toString());
            throw new IOException(e.getMessage());
        }
    }

    private static ImageInputStream locateInServiceVMStructure(IProcess process) throws IOException {
        String path = VMDataFactory.getBlobBasedirInArchive(process);
        String j9vmid = VMDataFactory.getJ9VMBuildInCore(process);
        try {
            return VMDataFactory.getBlobFromArchive(path + j9vmid, process);
        }
        catch (IOException e) {
            InputStream indexIS = VMDataFactory.class.getResourceAsStream("/ddr.structurefiles.index");
            if (indexIS == null) {
                throw new JVMNotDDREnabledException(process, "DDR could not find VM structure data archive index. J9VM build ID: " + j9vmid + ". Platform: " + path + ". You can specify a structure file to use manually with the com.ibm.j9ddr.structurefile system property.");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(indexIS));
            String allBlobs = reader.readLine();
            String[] blobs = allBlobs.split(":");
            StringBuffer candidates = new StringBuffer();
            for (int i = 0; i < blobs.length; ++i) {
                if (!blobs[i].startsWith(path)) continue;
                if (candidates.length() != 0) {
                    candidates.append(", ");
                }
                candidates.append(blobs[i]);
            }
            throw new JVMNotDDREnabledException(process, "DDR could not find VM structure data file. J9VM build ID: " + j9vmid + ". Platform: " + path + ". You can specify a structure file to use manually with the com.ibm.j9ddr.structurefile system property." + (String)(candidates.length() > 0 ? " Possible structure file matches: " + candidates.toString() + "." : ""));
        }
    }

    private static ImageInputStream getBlobFromArchive(String path, IProcess process) throws IOException {
        InputStream blobFile = VMDataFactory.class.getResourceAsStream("/" + path);
        if (blobFile != null) {
            InputStreamImageWrapper iis = new InputStreamImageWrapper(blobFile);
            iis.setByteOrder(process.getByteOrder());
            return iis;
        }
        throw new JVMNotDDREnabledException(process, "DDR could not find VM structure data file " + path);
    }

    private static String getJ9VMBuildInCore(IProcess process) throws IOException {
        try {
            byte[] pattern = null;
            try {
                pattern = "J9VM - ".getBytes("ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
            long addr = process.findPattern(pattern, 1, 0L);
            if (addr != -1L) {
                long startBuildIDAddr = -1L;
                for (long i = 0L; i < 30L; ++i) {
                    if (process.getByteAt(addr + i) != 95) continue;
                    if (startBuildIDAddr == -1L) {
                        startBuildIDAddr = addr + i + 1L;
                        continue;
                    }
                    byte[] buildID = new byte[(int)(addr + i - startBuildIDAddr)];
                    int j = 0;
                    while ((long)j < addr + i - startBuildIDAddr) {
                        buildID[j] = process.getByteAt(startBuildIDAddr + (long)j);
                        ++j;
                    }
                    return new String(buildID, "UTF-8");
                }
            }
        }
        catch (MemoryFault e) {
            throw new IOException(e.getMessage());
        }
        throw new JVMNotDDREnabledException(process, "No J9VM build ID found in process");
    }

    private static String getBlobBasedirInArchive(IProcess process) throws IOException {
        ICore core = process.getAddressSpace().getCore();
        Platform platform = core.getPlatform();
        int bytesPerPointer = process.bytesPerPointer();
        switch (platform) {
            case AIX: {
                if (bytesPerPointer == 4) {
                    return "aix/ppc-32/";
                }
                return "aix/ppc-64/";
            }
            case LINUX: {
                String processorType = core.getProperties().getProperty("cpu.type");
                if (bytesPerPointer == 4) {
                    if (processorType.equals("x86")) {
                        return "linux/ia32/";
                    }
                    if (processorType.equals("ppc")) {
                        return "linux/ppc-32/";
                    }
                    if (processorType.equals("s390")) {
                        return "linux/s390-31/";
                    }
                } else {
                    if (processorType.equals("amd64")) {
                        return "linux/amd64/";
                    }
                    if (processorType.equals("ppc")) {
                        return "linux/ppc-64/";
                    }
                    if (processorType.equals("s390")) {
                        return "linux/s390-64/";
                    }
                }
                throw new UnknownArchitectureException(process, "Could not determine architecture for Linux core file.");
            }
            case WINDOWS: {
                if (bytesPerPointer == 4) {
                    return "win/ia32/";
                }
                return "win/amd64/";
            }
            case ZOS: {
                if (bytesPerPointer == 4) {
                    return "zos/s390-31/";
                }
                return "zos/s390-64/";
            }
        }
        throw new UnknownArchitectureException(process, "Could not determine platform of core file.");
    }

    public static void clearCache() {
        vmDataCache.clear();
    }

    private static ImageInputStream getBlobFromLibrary(IProcess process, StructureHeader header) throws JVMNotFoundException {
        try {
            if (header != null) {
                IBlobFactory factory = BlobFactory.getInstance();
                IBlobFactory.Platforms platform = null;
                switch (process.getPlatform()) {
                    case LINUX: {
                        platform = process.bytesPerPointer() == 4 ? IBlobFactory.Platforms.xi32 : IBlobFactory.Platforms.xa64;
                        break;
                    }
                }
                if (platform != null) {
                    int[] data = header.getBlobVersionArray();
                    return factory.getBlob(platform, header.getPackageID(), data[2], data[1], data[0]);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new JVMNotFoundException(process, (Throwable)e);
        }
    }

    private static StructureHeader findNodeVersion(IProcess proc) throws Exception {
        byte[] pattern = "v0.".getBytes();
        long pos = 0L;
        do {
            int[] data = new int[3];
            data[0] = 0;
            int count = 1;
            if ((pos = proc.findPattern(pattern, 0, pos)) == -1L) continue;
            pos += (long)(pattern.length - 1);
            StringBuilder version = new StringBuilder();
            while (count < 3) {
                try {
                    char b = (char)proc.getByteAt(++pos);
                    if (b >= '0' && b <= '9') {
                        version.append(b);
                        continue;
                    }
                    try {
                        Integer i = Integer.parseInt(version.toString());
                        data[count++] = i;
                        version = new StringBuilder();
                    }
                    catch (NumberFormatException e) {
                        break;
                    }
                }
                catch (MemoryFault e) {
                    // empty catch block
                    break;
                }
            }
            if (count != 3) continue;
            int blobVersion = data[0] << 16 | data[1] << 8 | data[2];
            StructureHeader header = new StructureHeader(StructureHeader.BlobID.node, blobVersion, "node");
            return header;
        } while (pos != -1L);
        return null;
    }

    static {
        vmDataCache = new WeakValueMap();
        try {
            eyecatcher = "J9VMRAS".getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    private static class InputStreamImageWrapper
    extends ImageInputStreamImpl {
        private ByteArrayInputStream is;

        public InputStreamImageWrapper(InputStream inputStream) throws IOException {
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int r = inputStream.read(buffer, 0, buffer.length);
            while (r != -1) {
                out.write(buffer, 0, r);
                r = inputStream.read(buffer, 0, buffer.length);
            }
            this.is = new ByteArrayInputStream(out.toByteArray());
        }

        @Override
        public int read() throws IOException {
            int read = this.is.read();
            ++this.streamPos;
            return read;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = this.is.read(b, off, len);
            if (read != -1) {
                this.streamPos += (long)read;
            }
            return read;
        }

        @Override
        public long getStreamPosition() throws IOException {
            return this.streamPos;
        }

        @Override
        public void seek(long pos) throws IOException {
            super.seek(pos);
            this.is.reset();
            this.is.skip(this.streamPos);
        }
    }
}

