/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CTypeParser {
    private static final Pattern arrayPattern = Pattern.compile("(.*?)\\s*((?:\\[[^\\]]*\\]\\s*)+)$");
    private static final Pattern pointerPattern = Pattern.compile("(.*?)\\s*((?:[*]\\s*)+)$");
    private static final Pattern bitfieldPattern = Pattern.compile("(.*?)\\s*(:\\s*\\d+)$");
    private static final Pattern trailingConstPattern = Pattern.compile("(.*?)(?<=[\\s*])const$");
    private static final Pattern trailingVolatilePattern = Pattern.compile("(.*?)(?<=[\\s*])volatile$");
    private String suffix;
    private String prefix;
    private String coreType;

    public CTypeParser(String typeDeclaration) {
        this.coreType = typeDeclaration.trim();
        this.prefix = "";
        this.coreType = this.coreType.replace("::", "$");
        if (this.coreType.startsWith("const ")) {
            this.prefix = "const ";
            this.coreType = this.coreType.substring("const".length()).trim();
        }
        if (this.coreType.startsWith("volatile ")) {
            this.prefix = "volatile ";
            this.coreType = this.coreType.substring("volatile".length()).trim();
        }
        StringBuilder suffixBuilder = new StringBuilder();
        while (true) {
            Matcher m;
            if ((m = arrayPattern.matcher(this.coreType)).find()) {
                this.coreType = m.group(1);
                suffixBuilder.insert(0, this.stripSpaces(m.group(2)));
            } else {
                m = pointerPattern.matcher(this.coreType);
                if (m.find()) {
                    this.coreType = m.group(1);
                    suffixBuilder.insert(0, this.stripSpaces(m.group(2)));
                } else {
                    m = bitfieldPattern.matcher(this.coreType);
                    if (m.find()) {
                        this.coreType = m.group(1);
                        suffixBuilder.insert(0, this.stripSpaces(m.group(2)));
                    } else {
                        m = trailingConstPattern.matcher(this.coreType);
                        if (m.find()) {
                            this.coreType = m.group(1);
                            suffixBuilder.insert(0, " const ");
                        } else {
                            m = trailingVolatilePattern.matcher(this.coreType);
                            if (!m.find()) break;
                            this.coreType = m.group(1);
                            suffixBuilder.insert(0, " volatile ");
                        }
                    }
                }
            }
            this.coreType = this.coreType.trim();
        }
        this.suffix = suffixBuilder.toString().trim();
    }

    private String stripSpaces(String input) {
        StringBuilder builder = new StringBuilder();
        for (char c : input.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getCoreType() {
        return this.coreType;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

