/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.elf.unwind;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.elf.LinuxProcessAddressSpace;
import com.ibm.j9ddr.corereaders.elf.ProgramHeaderEntry;
import com.ibm.j9ddr.corereaders.elf.unwind.CIE;
import com.ibm.j9ddr.corereaders.elf.unwind.FDE;
import com.ibm.j9ddr.corereaders.elf.unwind.UnwindTable;
import com.ibm.j9ddr.corereaders.memory.IMemoryImageInputStream;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;

public class Unwind {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    LinuxProcessAddressSpace process;
    private List<FDE> frameDescriptionEntries = new LinkedList<FDE>();

    public Unwind(LinuxProcessAddressSpace _process) {
        this.process = _process;
    }

    public void addCallFrameInformation(long libraryBaseAddress, ProgramHeaderEntry ph, String libName) throws CorruptDataException, IOException {
        if (!ph.isEhFrame()) {
            throw new CorruptDataException("Unexpected program header type, expected GNU_EH_FRAME");
        }
        long cfiAddress = this.getCFIAddress(libraryBaseAddress, ph, libName);
        if (cfiAddress != 0L) {
            this.parseCallFrameInformation(cfiAddress, libName);
        }
    }

    private void parseCallFrameInformation(long cfiAddress, String libName) throws CorruptDataException, IOException {
        boolean dumpData = false;
        HashMap<Long, CIE> cieTable = new HashMap<Long, CIE>();
        if (dumpData) {
            System.err.printf("Dumping data for %s!\n", libName);
        }
        try {
            if (dumpData) {
                System.err.printf("Reading cfi info from 0x%x\n", cfiAddress);
            }
            IMemoryImageInputStream cfiStream = new IMemoryImageInputStream(this.process, cfiAddress);
            while (true) {
                CIE cie;
                if (dumpData) {
                    System.err.printf("Reading length at position %d\n", cfiStream.getStreamPosition());
                }
                long cieAddress = cfiStream.getStreamPosition();
                long length = (long)cfiStream.readInt() & 0xFFFFFFFFL;
                long startPos = cfiStream.getStreamPosition();
                if (dumpData) {
                    System.err.printf("Got length: %x (%1$d)\n", length);
                }
                if (length == 0L) {
                    if (dumpData) {
                        System.err.printf("Length = 0, end of cfi.\n", new Object[0]);
                    }
                    break;
                }
                if (length == -1L) {
                    length = cfiStream.readLong();
                    if (dumpData) {
                        System.err.printf("Got extended length: %x\n", length);
                    }
                    throw new CorruptDataException("CFI record contained unhandled extended length field.");
                }
                if (dumpData) {
                    System.err.printf("Reading ciePointer at position %d\n", cfiStream.getStreamPosition());
                }
                int ciePointer = cfiStream.readInt();
                if (dumpData) {
                    System.err.printf("Got ciePointer: %x\n", ciePointer);
                }
                if (ciePointer == 0) {
                    if (dumpData) {
                        System.err.printf("CIE!\n", new Object[0]);
                    }
                    cie = new CIE(this, cfiStream, startPos, length);
                    cieTable.put(cieAddress, cie);
                    if (!dumpData) continue;
                    cie.dump(System.err);
                    System.err.printf("--- End CIE\n", new Object[0]);
                    continue;
                }
                if (dumpData) {
                    System.err.printf("FDE!\n", new Object[0]);
                }
                if ((cie = (CIE)cieTable.get(startPos - (long)ciePointer)) == null) {
                    throw new IOException(String.format("Missing CIE record @0x%x (0x%x - 0x%x) for FDE@0x%x", (long)ciePointer - startPos, ciePointer, startPos, startPos));
                }
                FDE fde = new FDE(this, cfiStream, cie, startPos, length);
                this.frameDescriptionEntries.add(fde);
                if (!dumpData) continue;
                fde.dump(System.err);
                System.err.printf("--- End FDE\n", new Object[0]);
            }
        }
        catch (MemoryFault e) {
            logger.log(Level.FINER, "MemoryFault in parseCallFrameInformation for " + libName, e);
        }
        catch (IOException e) {
            logger.log(Level.FINER, "IOException in parseCallFrameInformation for " + libName, e);
        }
        catch (CorruptDataException e) {
            logger.log(Level.FINER, "CorruptDataException in parseCallFrameInformation for " + libName, e);
        }
    }

    private long getCFIAddress(long libraryBaseAddress, ProgramHeaderEntry ph, String libName) throws IOException, MemoryFault {
        IMemoryImageInputStream headerStream = new IMemoryImageInputStream(this.process, libraryBaseAddress + ph.fileOffset);
        long startPos = headerStream.getStreamPosition();
        byte version = headerStream.readByte();
        if (version != 1) {
            headerStream.close();
            throw new IOException(String.format("Invalid version number for .eh_frame_hdr @ 0x%x in library %s, was %d not 1", libraryBaseAddress, libName, version));
        }
        byte ptrEncoding = headerStream.readByte();
        byte countEncoding = headerStream.readByte();
        byte tableEncoding = headerStream.readByte();
        long ehFramePtrPos = headerStream.getStreamPosition() - startPos;
        long ehFramePtr = this.readEncodedPC(headerStream, ptrEncoding);
        long cfiAddress = 0L;
        long cfiOffset = 0L;
        if ((ptrEncoding & 0x10) == 16) {
            cfiOffset = ehFramePtrPos + ehFramePtr;
        }
        cfiAddress = libraryBaseAddress + ph.fileOffset + cfiOffset;
        return cfiAddress;
    }

    static String byteArrayToHexString(byte[] ba) {
        Object s = "";
        for (byte b : ba) {
            s = (String)s + String.format("0x%x ", b);
        }
        return s;
    }

    public static long readUnsignedLEB128(ImageInputStream cfiStream) throws IOException {
        byte b = cfiStream.readByte();
        long value = 0L;
        int shift = 0;
        while ((b & 0x80) == 128) {
            value += (long)((b & 0x7F) << shift);
            shift += 7;
            b = cfiStream.readByte();
        }
        return value += (long)((b & 0x7F) << shift);
    }

    public static long readSignedLEB128(ImageInputStream cfiStream) throws IOException {
        byte b;
        long value = 0L;
        int shift = 0;
        do {
            b = cfiStream.readByte();
            value += (long)((b & 0x7F) << shift);
            shift += 7;
        } while ((b & 0x80) == 128);
        if ((b & 0x40) == 64) {
            value |= -(1L << shift);
        }
        return value;
    }

    long readEncodedPC(ImageInputStream stream, byte pcEncodingType) throws IOException {
        this.process.bytesPerPointer();
        switch (pcEncodingType & 0xF) {
            case 0: {
                if (this.process.bytesPerPointer() == 8) {
                    return stream.readLong();
                }
                return stream.readInt();
            }
            case 1: {
                return Unwind.readUnsignedLEB128(stream);
            }
            case 9: {
                return Unwind.readSignedLEB128(stream);
            }
            case 2: 
            case 10: {
                return stream.readShort();
            }
            case 3: 
            case 11: {
                return stream.readInt();
            }
            case 4: 
            case 12: {
                return stream.readLong();
            }
        }
        throw new IOException(String.format("Unsupported encoding 0x%x", pcEncodingType & 0xF));
    }

    public UnwindTable getUnwindTableForInstructionAddress(long instructionPointer) throws CorruptDataException, IOException {
        for (FDE f : this.frameDescriptionEntries) {
            try {
                if (!f.contains(instructionPointer)) continue;
                return new UnwindTable(f, this, instructionPointer);
            }
            catch (IOException iOException) {
            }
            catch (CorruptDataException corruptDataException) {
            }
        }
        return null;
    }

    protected class DW_EH_PE {
        static final int absptr = 0;
        static final int omit = 255;
        static final int uleb128 = 1;
        static final int udata2 = 2;
        static final int udata4 = 3;
        static final int udata8 = 4;
        static final int sleb128 = 9;
        static final int sdata2 = 10;
        static final int sdata4 = 11;
        static final int sdata8 = 12;
        static final int signed = 8;
        static final int pcrel = 16;
        static final int textrel = 32;
        static final int datarel = 48;
        static final int funcrel = 64;
        static final int aligned = 80;
        static final int indirect = 128;

        protected DW_EH_PE() {
        }
    }
}

