/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.j9.stackwalker;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.j9.AlgorithmPicker;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.BaseAlgorithm;
import com.ibm.j9ddr.vm29.j9.IAlgorithm;
import com.ibm.j9ddr.vm29.j9.J9ConfigFlags;
import com.ibm.j9ddr.vm29.j9.stackwalker.JITStackWalker;
import com.ibm.j9ddr.vm29.j9.stackwalker.MapIterator;
import com.ibm.j9ddr.vm29.j9.stackwalker.StackWalkerUtils;
import com.ibm.j9ddr.vm29.j9.stackwalker.WalkState;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.U16Pointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITExceptionTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JITStackAtlasPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9StackWalkFlags;
import com.ibm.j9ddr.vm29.pointer.generated.TRBuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.TR_ByteCodeInfoPointer;
import com.ibm.j9ddr.vm29.pointer.generated.TR_InlinedCallSitePointer;
import com.ibm.j9ddr.vm29.structure.CLimits;
import com.ibm.j9ddr.vm29.structure.J9JITExceptionTable;
import com.ibm.j9ddr.vm29.structure.J9JITStackAtlas;
import com.ibm.j9ddr.vm29.structure.J9StackWalkConstants;
import com.ibm.j9ddr.vm29.structure.MethodMetaDataConstants;
import com.ibm.j9ddr.vm29.structure.TR_InlinedCallSite;
import com.ibm.j9ddr.vm29.types.I16;
import com.ibm.j9ddr.vm29.types.I32;
import com.ibm.j9ddr.vm29.types.IDATA;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U16;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.U64;
import com.ibm.j9ddr.vm29.types.U8;
import com.ibm.j9ddr.vm29.types.UDATA;
import com.ibm.j9ddr.vm29.types.UScalar;
import java.util.LinkedList;

public class MethodMetaData {
    public static final long REGISTER_MAP_VALUE_FOR_GAP = -86062338L;
    public static final long BYTE_CODE_INFO_VALUE_FOR_GAP = 0L;
    private static MethodMetaDataImpl impl;
    private static final AlgorithmPicker<MethodMetaDataImpl> picker;

    public static I16 getJitTotalFrameSize(J9JITExceptionTablePointer md) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitTotalFrameSize(md);
    }

    public static VoidPointer getJitInlinedCallInfo(J9JITExceptionTablePointer md) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitInlinedCallInfo(md);
    }

    public static void jitAddSpilledRegistersForDataResolve(WalkState walkState) throws CorruptDataException {
        MethodMetaData.getImpl().jitAddSpilledRegistersForDataResolve(walkState);
    }

    public static UDATA getJitDataResolvePushes() throws CorruptDataException {
        return MethodMetaData.getImpl().getJitDataResolvePushes();
    }

    public static VoidPointer getStackMapFromJitPC(J9JavaVMPointer javaVM, J9JITExceptionTablePointer methodMetaData, UDATA jitPC) throws CorruptDataException {
        return MethodMetaData.getImpl().getStackMapFromJitPC(javaVM, methodMetaData, jitPC);
    }

    public static J9JITStackAtlasPointer getJitGCStackAtlas(J9JITExceptionTablePointer md) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitGCStackAtlas(md);
    }

    public static VoidPointer getFirstInlinedCallSite(J9JITExceptionTablePointer methodMetaData, VoidPointer stackMap) throws CorruptDataException {
        return MethodMetaData.getImpl().getFirstInlinedCallSite(methodMetaData, stackMap);
    }

    public static UDATA getJitInlineDepthFromCallSite(J9JITExceptionTablePointer methodMetaData, VoidPointer inlinedCallSite) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitInlineDepthFromCallSite(methodMetaData, inlinedCallSite);
    }

    public static boolean hasMoreInlinedMethods(VoidPointer inlinedCallSite) throws CorruptDataException {
        return MethodMetaData.getImpl().hasMoreInlinedMethods(inlinedCallSite);
    }

    public static VoidPointer getInlinedMethod(VoidPointer inlinedCallSite) throws CorruptDataException {
        return MethodMetaData.getImpl().getInlinedMethod(inlinedCallSite);
    }

    public static UDATA getCurrentByteCodeIndexAndIsSameReceiver(J9JITExceptionTablePointer methodMetaData, VoidPointer stackMap, VoidPointer currentInlinedCallSite, boolean[] isSameReceiver) throws CorruptDataException {
        return MethodMetaData.getImpl().getCurrentByteCodeIndexAndIsSameReceiver(methodMetaData, stackMap, currentInlinedCallSite, isSameReceiver);
    }

    public static void jitAddSpilledRegisters(WalkState walkState) throws CorruptDataException {
        MethodMetaData.getImpl().jitAddSpilledRegisters(walkState);
    }

    public static void jitAddSpilledRegisters(WalkState walkState, VoidPointer stackMap) throws CorruptDataException {
        MethodMetaData.getImpl().jitAddSpilledRegisters(walkState, stackMap);
    }

    public static UDATAPointer getObjectArgScanCursor(WalkState walkState) throws CorruptDataException {
        return MethodMetaData.getImpl().getObjectArgScanCursor(walkState);
    }

    public static U8Pointer getJitDescriptionCursor(VoidPointer stackMap, WalkState walkState) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitDescriptionCursor(stackMap, walkState);
    }

    public static U16 getJitNumberOfMapBytes(J9JITStackAtlasPointer sa) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitNumberOfMapBytes(sa);
    }

    public static U32 getJitRegisterMap(J9JITExceptionTablePointer methodMetaData, VoidPointer stackMap) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitRegisterMap(methodMetaData, stackMap);
    }

    public static U32 getJitHighWordRegisterMap(J9JITExceptionTablePointer methodMetaData, VoidPointer stackMap) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitHighWordRegisterMap(methodMetaData, stackMap);
    }

    public static U8Pointer getNextDescriptionCursor(J9JITExceptionTablePointer metadata, VoidPointer stackMap, U8Pointer jitDescriptionCursor) throws CorruptDataException {
        return MethodMetaData.getImpl().getNextDescriptionCursor(metadata, stackMap, jitDescriptionCursor);
    }

    public static U16 getJitNumberOfParmSlots(J9JITStackAtlasPointer sa) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitNumberOfParmSlots(sa);
    }

    public static U8Pointer getJitInternalPointerMap(J9JITStackAtlasPointer sa) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitInternalPointerMap(sa);
    }

    public static void walkJITFrameSlotsForInternalPointers(WalkState walkState, U8Pointer jitDescriptionCursor, UDATAPointer scanCursor, VoidPointer stackMap, J9JITStackAtlasPointer gcStackAtlas) throws CorruptDataException {
        MethodMetaData.getImpl().walkJITFrameSlotsForInternalPointers(walkState, jitDescriptionCursor, scanCursor, stackMap, gcStackAtlas);
    }

    public static VoidPointer getNextInlinedCallSite(J9JITExceptionTablePointer methodMetaData, VoidPointer inlinedCallSite) throws CorruptDataException {
        return MethodMetaData.getImpl().getNextInlinedCallSite(methodMetaData, inlinedCallSite);
    }

    public static U8 getNextDescriptionBit(U8Pointer jitDescriptionCursor) throws CorruptDataException {
        return MethodMetaData.getImpl().getNextDescriptionBit(jitDescriptionCursor);
    }

    public static UDATAPointer getObjectTempScanCursor(WalkState walkState) throws CorruptDataException {
        return MethodMetaData.getImpl().getObjectTempScanCursor(walkState);
    }

    public static int getJitRecompilationResolvePushes() {
        return MethodMetaData.getImpl().getJitRecompilationResolvePushes();
    }

    public static int getJitVirtualMethodResolvePushes() {
        return MethodMetaData.getImpl().getJitVirtualMethodResolvePushes();
    }

    public static int getJitStaticMethodResolvePushes() {
        return MethodMetaData.getImpl().getJitStaticMethodResolvePushes();
    }

    public static VoidPointer getStackAllocMapFromJitPC(J9JavaVMPointer javaVM, J9JITExceptionTablePointer methodMetaData, UDATA jitPC, VoidPointer curStackMap) throws CorruptDataException {
        return MethodMetaData.getImpl().getStackAllocMapFromJitPC(javaVM, methodMetaData, jitPC, curStackMap);
    }

    public static U8Pointer getJitStackSlots(J9JITExceptionTablePointer metaData, VoidPointer stackMap) throws CorruptDataException {
        return MethodMetaData.getImpl().getJitStackSlots(metaData, stackMap);
    }

    public static void markClassesInInlineRanges(J9JITExceptionTablePointer metaData, WalkState walkState) throws CorruptDataException {
        MethodMetaData.getImpl().markClassesInInlineRanges(metaData, walkState);
    }

    public static void jitGetMapsFromPC(J9JavaVMPointer javaVM, J9JITExceptionTablePointer methodMetaData, UDATA jitPC, JITMaps maps) throws CorruptDataException {
        MethodMetaData.getImpl().jitGetMapsFromPC(javaVM, methodMetaData, jitPC, maps);
    }

    private static MethodMetaDataImpl getImpl() {
        if (impl == null) {
            impl = picker.pickAlgorithm();
        }
        return impl;
    }

    static {
        picker = new AlgorithmPicker<MethodMetaDataImpl>("ALG_METHOD_META_DATA_VERSION"){

            @Override
            protected Iterable<? extends MethodMetaDataImpl> allAlgorithms() {
                LinkedList<MethodMetaData_29_V0> toReturn = new LinkedList<MethodMetaData_29_V0>();
                toReturn.add(new MethodMetaData_29_V0());
                return toReturn;
            }
        };
    }

    private static class MethodMetaData_29_V0
    extends BaseAlgorithm
    implements MethodMetaDataImpl {
        private static boolean alignStackMaps = J9ConfigFlags.arch_arm || TRBuildFlags.host_SH4 || TRBuildFlags.host_MIPS;

        protected MethodMetaData_29_V0() {
            super(90, 0);
        }

        @Override
        public I16 getJitTotalFrameSize(J9JITExceptionTablePointer md) throws CorruptDataException {
            return new I16(md.totalFrameSize());
        }

        @Override
        public VoidPointer getJitInlinedCallInfo(J9JITExceptionTablePointer md) throws CorruptDataException {
            return md.inlinedCalls();
        }

        @Override
        public void jitAddSpilledRegistersForDataResolve(WalkState walkState) throws CorruptDataException {
            UDATAPointer slotCursor = walkState.unwindSP.add(MethodMetaData_29_V0.getJitSlotsBeforeSavesInDataResolve());
            int mapCursor = 0;
            int i = 0;
            while ((long)i < J9StackWalkConstants.J9SW_POTENTIAL_SAVED_REGISTERS) {
                walkState.registerEAs[mapCursor++] = slotCursor;
                slotCursor = slotCursor.add(1L);
                ++i;
            }
            StackWalkerUtils.swPrintf(walkState, 2, "\t{0} slots skipped before scalar registers", MethodMetaData_29_V0.getJitSlotsBeforeSavesInDataResolve());
            JITStackWalker.jitPrintRegisterMapArray(walkState, "DataResolve");
        }

        private static UDATA getJitSlotsBeforeSavesInDataResolve() {
            if (J9ConfigFlags.arch_x86) {
                if (J9BuildFlags.env_data64) {
                    return new UDATA(16L);
                }
                return new UDATA(20L);
            }
            return new UDATA(0L);
        }

        @Override
        public void jitAddSpilledRegisters(WalkState walkState) throws CorruptDataException {
            throw new UnsupportedOperationException("Not implemented at 2.6");
        }

        @Override
        public void jitAddSpilledRegisters(WalkState walkState, VoidPointer stackMap) throws CorruptDataException {
            UDATA savedGPRs = new UDATA(0L);
            UDATA saveOffset = new UDATA(0L);
            UDATA lowestRegister = new UDATA(0L);
            UDATAPointer saveCursor = UDATAPointer.NULL;
            int mapCursor = 0;
            J9JITExceptionTablePointer md = walkState.jitInfo;
            UDATA registerSaveDescription = walkState.jitInfo.registerSaveDescription();
            if (J9ConfigFlags.arch_x86) {
                UDATA prologuePushes = new UDATA(this.getJitProloguePushes(walkState.jitInfo));
                U8 i = new U8(1L);
                if (!prologuePushes.eq(0L)) {
                    saveCursor = walkState.bp.sub(new UDATA(this.getJitScalarTempSlots(walkState.jitInfo)).add(new UDATA(this.getJitObjectTempSlots(walkState.jitInfo)).add(prologuePushes)));
                    registerSaveDescription = registerSaveDescription.bitAnd(J9StackWalkConstants.J9SW_REGISTER_MAP_MASK);
                    do {
                        if (registerSaveDescription.anyBitsIn(1L)) {
                            walkState.registerEAs[mapCursor] = saveCursor;
                            saveCursor = saveCursor.add(1L);
                        }
                        i = i.add(1);
                        ++mapCursor;
                    } while (!(registerSaveDescription = registerSaveDescription.rightShift(1)).eq(0L));
                }
            } else if (J9ConfigFlags.arch_power || TRBuildFlags.host_MIPS) {
                if (J9ConfigFlags.arch_power) {
                    savedGPRs = registerSaveDescription.bitAnd(new UDATA(131071L));
                    saveOffset = registerSaveDescription.rightShift(17).bitAnd(new UDATA(65535L));
                    lowestRegister = new UDATA(15L);
                } else if (TRBuildFlags.host_MIPS) {
                    savedGPRs = registerSaveDescription.bitAnd(31);
                    saveOffset = registerSaveDescription.rightShift(13);
                    lowestRegister = new UDATA(24L).sub(savedGPRs);
                }
                saveCursor = walkState.bp.subOffset(saveOffset);
                if (J9ConfigFlags.arch_power) {
                    mapCursor += lowestRegister.intValue();
                    U8 i = new U8(lowestRegister.add(1L));
                    do {
                        if (savedGPRs.anyBitsIn(1L)) {
                            walkState.registerEAs[mapCursor] = saveCursor;
                            saveCursor = saveCursor.add(1L);
                        }
                        i = i.add(1);
                        ++mapCursor;
                    } while (!(savedGPRs = savedGPRs.rightShift(1)).eq(0L));
                } else {
                    mapCursor += lowestRegister.intValue();
                    while (!savedGPRs.eq(0L)) {
                        walkState.registerEAs[mapCursor++] = saveCursor;
                        saveCursor = saveCursor.add(1L);
                        savedGPRs = savedGPRs.sub(1L);
                    }
                }
            } else if ((J9ConfigFlags.arch_arm || TRBuildFlags.host_SH4 || J9ConfigFlags.arch_s390) && !(savedGPRs = registerSaveDescription.bitAnd(new UDATA(65535L))).eq(0L)) {
                saveOffset = new UDATA(65535L).bitAnd(registerSaveDescription.rightShift(16));
                saveCursor = walkState.bp.subOffset(saveOffset);
                U8 i = new U8(1L);
                do {
                    if (savedGPRs.anyBitsIn(1L)) {
                        walkState.registerEAs[mapCursor] = saveCursor;
                        saveCursor = saveCursor.add(1L);
                    }
                    i = i.add(1);
                    ++mapCursor;
                } while (!(savedGPRs = savedGPRs.rightShift(1)).eq(0L));
            }
            JITStackWalker.jitPrintRegisterMapArray(walkState, "Frame");
        }

        private U8Pointer GET_REGISTER_SAVE_DESCRIPTION_CURSOR(boolean fourByteOffset, VoidPointer stackMap) {
            if (J9ConfigFlags.arch_s390) {
                return U8Pointer.cast(stackMap).add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(fourByteOffset)).add(8L);
            }
            return U8Pointer.cast(stackMap).add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(fourByteOffset)).add(4L);
        }

        public U16 getJitProloguePushes(J9JITExceptionTablePointer md) throws CorruptDataException {
            return md.prologuePushes();
        }

        public I16 getJitScalarTempSlots(J9JITExceptionTablePointer md) throws CorruptDataException {
            return md.scalarTempSlots();
        }

        public I16 getJitObjectTempSlots(J9JITExceptionTablePointer md) throws CorruptDataException {
            return md.objectTempSlots();
        }

        @Override
        public UDATA getJitDataResolvePushes() throws CorruptDataException {
            if (J9ConfigFlags.arch_x86) {
                if (J9BuildFlags.env_data64) {
                    return new UDATA(35L);
                }
                return new UDATA(32L);
            }
            if (J9ConfigFlags.arch_arm) {
                return new UDATA(12L);
            }
            if (J9ConfigFlags.arch_s390) {
                if (J9BuildFlags.jit_32bitUses64bitRegisters) {
                    return new UDATA(32L);
                }
                return new UDATA(16L);
            }
            if (J9ConfigFlags.arch_power) {
                return new UDATA(33L);
            }
            if (TRBuildFlags.host_MIPS) {
                return new UDATA(32L);
            }
            if (TRBuildFlags.host_SH4) {
                return new UDATA(16L);
            }
            return new UDATA(0L);
        }

        @Override
        public VoidPointer getStackMapFromJitPC(J9JavaVMPointer javaVM, J9JITExceptionTablePointer methodMetaData, UDATA jitPC) throws CorruptDataException {
            JITMaps maps = new JITMaps();
            this.jitGetMapsFromPC(javaVM, methodMetaData, jitPC, maps);
            return VoidPointer.cast(maps.stackMap);
        }

        @Override
        public J9JITStackAtlasPointer getJitGCStackAtlas(J9JITExceptionTablePointer md) throws CorruptDataException {
            return J9JITStackAtlasPointer.cast(md.gcStackAtlas());
        }

        @Override
        public void jitGetMapsFromPC(J9JavaVMPointer javaVM, J9JITExceptionTablePointer methodMetaData, UDATA jitPC, JITMaps maps) throws CorruptDataException {
            MapIterator i = new MapIterator();
            UDATA offsetPC = jitPC.sub(methodMetaData.startPC()).sub(1L);
            boolean fourByteOffsets = MethodMetaData_29_V0.HAS_FOUR_BYTE_OFFSET(methodMetaData);
            maps.stackMap = PointerPointer.NULL;
            maps.inlineMap = PointerPointer.NULL;
            if (methodMetaData.gcStackAtlas().isNull()) {
                return;
            }
            this.initializeIterator(i, methodMetaData);
            this.findMapsAtPC(i, offsetPC, maps, fourByteOffsets);
        }

        private void findMapsAtPC(MapIterator i, UDATA offsetPC, JITMaps maps, boolean fourByteOffsets) throws CorruptDataException {
            while (this.getNextMap(i, fourByteOffsets).notNull()) {
                if (!this.matchingRange(i, offsetPC)) continue;
                maps.stackMap = MethodMetaData_29_V0.currentStackMap(i);
                maps.inlineMap = MethodMetaData_29_V0.currentInlineMap(i);
                break;
            }
        }

        private static PointerPointer currentInlineMap(MapIterator i) {
            return PointerPointer.cast(i._currentInlineMap);
        }

        private static PointerPointer currentStackMap(MapIterator i) {
            return PointerPointer.cast(i._currentStackMap);
        }

        private boolean matchingRange(MapIterator i, UDATA offset) {
            return i._rangeStartOffset.lte(offset) && offset.lte(i._rangeEndOffset);
        }

        private U8Pointer getNextMap(MapIterator i, boolean fourByteOffsets) throws CorruptDataException {
            i._currentMap = i._nextMap;
            if (i._currentMap.notNull()) {
                i._currentInlineMap = i._currentMap;
                if (!MethodMetaData_29_V0.IS_BYTECODEINFO_MAP(fourByteOffsets, i._currentMap)) {
                    i._currentStackMap = i._currentMap;
                }
                i._rangeStartOffset = MethodMetaData_29_V0.GET_LOW_PC_OFFSET_VALUE(fourByteOffsets, i._currentMap);
                i._mapIndex = i._mapIndex.add(1);
                if (i._mapIndex.lt(i._stackAtlas.numberOfMaps())) {
                    i._nextMap = MethodMetaData_29_V0.GET_NEXT_STACK_MAP(fourByteOffsets, i._currentMap, i._stackAtlas);
                    i._rangeEndOffset = MethodMetaData_29_V0.GET_LOW_PC_OFFSET_VALUE(fourByteOffsets, i._nextMap).sub(1L);
                } else {
                    i._nextMap = U8Pointer.NULL;
                    i._rangeEndOffset = i._methodMetaData.endPC().sub(i._methodMetaData.startPC()).sub(1L);
                }
            }
            return i._currentMap;
        }

        private static UDATA GET_LOW_PC_OFFSET_VALUE(boolean fourByteOffset, U8Pointer stackMap) throws CorruptDataException {
            UScalar returnValue = null;
            returnValue = fourByteOffset ? U32Pointer.cast(MethodMetaData_29_V0.ADDRESS_OF_LOW_PC_OFFSET_IN_STACK_MAP(fourByteOffset, stackMap)).at(0L) : U16Pointer.cast(MethodMetaData_29_V0.ADDRESS_OF_LOW_PC_OFFSET_IN_STACK_MAP(fourByteOffset, stackMap)).at(0L);
            return new UDATA(returnValue);
        }

        private static U32 GET_SIZEOF_BYTECODEINFO_MAP(boolean fourByteOffset) {
            return new U32(4L).add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(fourByteOffset));
        }

        private static U8Pointer ADDRESS_OF_BYTECODEINFO_IN_STACK_MAP(boolean fourByteOffset, U8Pointer stackMap) {
            return stackMap.add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(fourByteOffset));
        }

        private static U8Pointer ADDRESS_OF_LOW_PC_OFFSET_IN_STACK_MAP(boolean fourByteOffset, U8Pointer stackMap) {
            return stackMap;
        }

        private static U8Pointer ADDRESS_OF_REGISTERMAP(boolean fourByteOffset, U8Pointer stackMap) {
            if (J9ConfigFlags.arch_s390) {
                return stackMap.add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(fourByteOffset)).add(12L);
            }
            return stackMap.add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(fourByteOffset)).add(8L);
        }

        private static boolean RANGE_NEEDS_FOUR_BYTE_OFFSET(Scalar s) {
            return s.gte(new U64(CLimits.USHRT_MAX));
        }

        private static boolean HAS_FOUR_BYTE_OFFSET(J9JITExceptionTablePointer md) throws CorruptDataException {
            if (AlgorithmVersion.getVersionOf("FOUR_BYTE_OFFSETS_VERSION").getAlgorithmVersion() > 0 && md.flags().anyBitsIn(J9JITExceptionTable.JIT_METADATA_FLAGS_USED_FOR_SIZE)) {
                return md.flags().anyBitsIn(J9JITExceptionTable.JIT_METADATA_GC_MAP_32_BIT_OFFSETS);
            }
            return MethodMetaData_29_V0.RANGE_NEEDS_FOUR_BYTE_OFFSET(md.endPC().sub(md.startPC()));
        }

        private static U32 SIZEOF_MAP_OFFSET(boolean fourByteOffset) {
            return alignStackMaps || fourByteOffset ? new U32(4L) : new U32(2L);
        }

        private static boolean IS_BYTECODEINFO_MAP(boolean fourByteOffset, U8Pointer stackMap) throws CorruptDataException {
            return !TR_ByteCodeInfoPointer.cast(MethodMetaData_29_V0.ADDRESS_OF_BYTECODEINFO_IN_STACK_MAP(fourByteOffset, stackMap))._doNotProfile().eq(0L);
        }

        private static U8Pointer GET_REGISTER_MAP_CURSOR(boolean fourByteOffset, U8Pointer stackMap) {
            if (J9ConfigFlags.arch_s390) {
                return stackMap.add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(fourByteOffset).add(12));
            }
            return stackMap.add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(fourByteOffset).add(8));
        }

        private static U8Pointer GET_NEXT_STACK_MAP(boolean fourByteOffset, U8Pointer stackMap, J9JITStackAtlasPointer atlas) throws CorruptDataException {
            U8Pointer nextStackMap = stackMap;
            if (MethodMetaData_29_V0.IS_BYTECODEINFO_MAP(fourByteOffset, stackMap)) {
                nextStackMap = nextStackMap.add(MethodMetaData_29_V0.GET_SIZEOF_BYTECODEINFO_MAP(fourByteOffset));
            } else {
                nextStackMap = MethodMetaData_29_V0.GET_REGISTER_MAP_CURSOR(fourByteOffset, stackMap);
                if (U32Pointer.cast(nextStackMap).at(0L).anyBitsIn(MethodMetaDataConstants.INTERNAL_PTR_REG_MASK) && atlas.internalPointerMap().notNull()) {
                    nextStackMap = nextStackMap.add(nextStackMap.add(4L).at(0L).add(1));
                }
                if ((nextStackMap = nextStackMap.add(3L).add(atlas.numberOfMapBytes())).at(0L).anyBitsIn(128L)) {
                    nextStackMap = nextStackMap.add(atlas.numberOfMapBytes());
                }
                nextStackMap = nextStackMap.add(1L);
            }
            return nextStackMap;
        }

        private void initializeIterator(MapIterator i, J9JITExceptionTablePointer methodMetaData) throws CorruptDataException {
            i._methodMetaData = methodMetaData;
            i._stackAtlas = J9JITStackAtlasPointer.cast(methodMetaData.gcStackAtlas());
            i._currentStackMap = U8Pointer.NULL;
            i._currentInlineMap = U8Pointer.NULL;
            i._nextMap = this.getFirstStackMap(i._stackAtlas);
            i._mapIndex = new U32(0L);
        }

        private U8Pointer getFirstStackMap(J9JITStackAtlasPointer stackAtlas) throws CorruptDataException {
            return U8Pointer.cast(stackAtlas).add(J9JITStackAtlas.SIZEOF).add(stackAtlas.numberOfMapBytes());
        }

        @Override
        public VoidPointer getFirstInlinedCallSite(J9JITExceptionTablePointer methodMetaData, VoidPointer stackMap) throws CorruptDataException {
            return this.getFirstInlinedCallSiteWithByteCodeInfo(methodMetaData, stackMap, VoidPointer.NULL);
        }

        private VoidPointer ADDRESS_OF_BYTECODEINFO_IN_STACK_MAP(boolean fourByteOffset, VoidPointer stackMap) {
            return VoidPointer.cast(U8Pointer.cast(stackMap).add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(fourByteOffset)));
        }

        private VoidPointer getFirstInlinedCallSiteWithByteCodeInfo(J9JITExceptionTablePointer methodMetaData, VoidPointer stackMap, VoidPointer byteCodeInfo) throws CorruptDataException {
            I32 cix;
            if (byteCodeInfo.isNull()) {
                byteCodeInfo = this.ADDRESS_OF_BYTECODEINFO_IN_STACK_MAP(MethodMetaData_29_V0.HAS_FOUR_BYTE_OFFSET(methodMetaData), stackMap);
            }
            if ((cix = new I32(TR_ByteCodeInfoPointer.cast(byteCodeInfo)._callerIndex())).lt(0)) {
                return VoidPointer.NULL;
            }
            return this.getNotUnloadedInlinedCallSiteArrayElement(methodMetaData, cix);
        }

        private U32 sizeOfInlinedCallSiteArrayElement(J9JITExceptionTablePointer methodMetaData) throws CorruptDataException {
            return new U32(TR_InlinedCallSite.SIZEOF).add(J9JITStackAtlasPointer.cast(methodMetaData.gcStackAtlas()).numberOfMapBytes());
        }

        private U8Pointer getInlinedCallSiteArrayElement(J9JITExceptionTablePointer methodMetaData, I32 cix) throws CorruptDataException {
            U8Pointer inlinedCallSiteArray = U8Pointer.cast(this.getJitInlinedCallInfo(methodMetaData));
            if (inlinedCallSiteArray.notNull()) {
                return inlinedCallSiteArray.add(this.sizeOfInlinedCallSiteArrayElement(methodMetaData).mult(cix.intValue()));
            }
            return U8Pointer.NULL;
        }

        private boolean isUnloadedInlinedMethod(J9MethodPointer method) {
            return UDATA.cast(method).bitNot().eq(0L);
        }

        private VoidPointer getNotUnloadedInlinedCallSiteArrayElement(J9JITExceptionTablePointer methodMetaData, I32 cix) throws CorruptDataException {
            VoidPointer inlinedCallSite = VoidPointer.cast(this.getInlinedCallSiteArrayElement(methodMetaData, cix));
            while (this.isUnloadedInlinedMethod(J9MethodPointer.cast(this.getInlinedMethod(inlinedCallSite))) && !(inlinedCallSite = this.getNextInlinedCallSite(methodMetaData, inlinedCallSite)).isNull()) {
            }
            return inlinedCallSite;
        }

        @Override
        public UDATA getJitInlineDepthFromCallSite(J9JITExceptionTablePointer methodMetaData, VoidPointer inlinedCallSite) throws CorruptDataException {
            UDATA inlineDepth = new UDATA(0L);
            do {
                inlineDepth = inlineDepth.add(1L);
            } while ((inlinedCallSite = this.getNextInlinedCallSite(methodMetaData, inlinedCallSite)).notNull());
            return inlineDepth;
        }

        @Override
        public VoidPointer getNextInlinedCallSite(J9JITExceptionTablePointer methodMetaData, VoidPointer inlinedCallSite) throws CorruptDataException {
            if (this.hasMoreInlinedMethods(inlinedCallSite)) {
                return this.getNotUnloadedInlinedCallSiteArrayElement(methodMetaData, new I32(MethodMetaData_29_V0.getByteCodeInfo(inlinedCallSite)._callerIndex()));
            }
            return VoidPointer.NULL;
        }

        @Override
        public boolean hasMoreInlinedMethods(VoidPointer inlinedCallSite) throws CorruptDataException {
            TR_ByteCodeInfoPointer byteCodeInfo = MethodMetaData_29_V0.getByteCodeInfo(inlinedCallSite);
            return !byteCodeInfo._callerIndex().lt(new I32(0L));
        }

        private static TR_ByteCodeInfoPointer getByteCodeInfo(VoidPointer inlinedCallSite) throws CorruptDataException {
            return TR_ByteCodeInfoPointer.cast(TR_InlinedCallSitePointer.cast(inlinedCallSite)._byteCodeInfoEA());
        }

        @Override
        public VoidPointer getInlinedMethod(VoidPointer inlinedCallSite) throws CorruptDataException {
            return TR_InlinedCallSitePointer.cast(inlinedCallSite)._methodInfo();
        }

        @Override
        public UDATA getCurrentByteCodeIndexAndIsSameReceiver(J9JITExceptionTablePointer methodMetaData, VoidPointer stackMap, VoidPointer currentInlinedCallSite, boolean[] isSameReceiver) throws CorruptDataException {
            TR_ByteCodeInfoPointer byteCodeInfo = TR_ByteCodeInfoPointer.cast(this.getByteCodeInfoFromStackMap(methodMetaData, stackMap));
            if (currentInlinedCallSite.notNull()) {
                VoidPointer inlinedCallSite = this.getFirstInlinedCallSiteWithByteCodeInfo(methodMetaData, stackMap, VoidPointer.cast(byteCodeInfo));
                if (!inlinedCallSite.eq(currentInlinedCallSite)) {
                    VoidPointer previousInlinedCallSite;
                    do {
                        previousInlinedCallSite = inlinedCallSite;
                    } while (!(inlinedCallSite = this.getNextInlinedCallSite(methodMetaData, inlinedCallSite)).eq(currentInlinedCallSite));
                    byteCodeInfo = MethodMetaData_29_V0.getByteCodeInfo(previousInlinedCallSite);
                }
            } else if (!byteCodeInfo._callerIndex().eq(-1L)) {
                VoidPointer inlinedCallSite;
                VoidPointer prevInlinedCallSite = inlinedCallSite = this.getFirstInlinedCallSiteWithByteCodeInfo(methodMetaData, stackMap, VoidPointer.cast(byteCodeInfo));
                while (inlinedCallSite.notNull() && this.hasMoreInlinedMethods(inlinedCallSite)) {
                    prevInlinedCallSite = inlinedCallSite;
                    inlinedCallSite = this.getNextInlinedCallSite(methodMetaData, inlinedCallSite);
                }
                byteCodeInfo = MethodMetaData_29_V0.getByteCodeInfo(prevInlinedCallSite);
            }
            if (isSameReceiver != null) {
                isSameReceiver[0] = !byteCodeInfo._isSameReceiver().eq(0L);
            }
            return new UDATA(byteCodeInfo._byteCodeIndex());
        }

        private VoidPointer getByteCodeInfoFromStackMap(J9JITExceptionTablePointer methodMetaData, VoidPointer stackMap) throws CorruptDataException {
            return VoidPointer.cast(MethodMetaData_29_V0.ADDRESS_OF_BYTECODEINFO_IN_STACK_MAP(MethodMetaData_29_V0.HAS_FOUR_BYTE_OFFSET(methodMetaData), U8Pointer.cast(stackMap)));
        }

        @Override
        public UDATAPointer getObjectArgScanCursor(WalkState walkState) throws CorruptDataException {
            return UDATAPointer.cast(U8Pointer.cast(walkState.bp).addOffset(J9JITStackAtlasPointer.cast(walkState.jitInfo.gcStackAtlas()).parmBaseOffset()));
        }

        @Override
        public U8Pointer getJitDescriptionCursor(VoidPointer stackMap, WalkState walkState) throws CorruptDataException {
            return U8Pointer.NULL;
        }

        @Override
        public U16 getJitNumberOfMapBytes(J9JITStackAtlasPointer sa) throws CorruptDataException {
            return sa.numberOfMapBytes();
        }

        @Override
        public U32 getJitRegisterMap(J9JITExceptionTablePointer methodMetaData, VoidPointer stackMap) throws CorruptDataException {
            return U32Pointer.cast(this.GET_REGISTER_MAP_CURSOR(MethodMetaData_29_V0.HAS_FOUR_BYTE_OFFSET(methodMetaData), stackMap)).at(0L);
        }

        @Override
        public U32 getJitHighWordRegisterMap(J9JITExceptionTablePointer methodMetaData, VoidPointer stackMap) throws CorruptDataException {
            if (J9ConfigFlags.arch_s390) {
                return U32Pointer.cast(MethodMetaData_29_V0.GET_HIGHWORD_REGISTER_MAP_CURSOR(MethodMetaData_29_V0.HAS_FOUR_BYTE_OFFSET(methodMetaData), stackMap)).at(0L);
            }
            return new U32(0L);
        }

        @Override
        public U8Pointer getNextDescriptionCursor(J9JITExceptionTablePointer metadata, VoidPointer stackMap, U8Pointer jitDescriptionCursor) throws CorruptDataException {
            throw new UnsupportedOperationException("Not implemented at 2.6");
        }

        @Override
        public U8Pointer getJitInternalPointerMap(J9JITStackAtlasPointer sa) throws CorruptDataException {
            return sa.internalPointerMap();
        }

        @Override
        public U16 getJitNumberOfParmSlots(J9JITStackAtlasPointer sa) throws CorruptDataException {
            return sa.numberOfParmSlots();
        }

        @Override
        public U8 getNextDescriptionBit(U8Pointer jitDescriptionCursor) throws CorruptDataException {
            return jitDescriptionCursor.at(0L);
        }

        @Override
        public UDATAPointer getObjectTempScanCursor(WalkState walkState) throws CorruptDataException {
            return walkState.bp.addOffset(J9JITStackAtlasPointer.cast(walkState.jitInfo.gcStackAtlas()).localBaseOffset());
        }

        @Override
        public int getJitRecompilationResolvePushes() {
            if (J9ConfigFlags.arch_x86) {
                if (J9BuildFlags.env_data64) {
                    return 9;
                }
                return 3;
            }
            if (J9ConfigFlags.arch_s390) {
                return 7 + 64 / UDATA.SIZEOF;
            }
            if (J9ConfigFlags.arch_power) {
                return 3;
            }
            return 0;
        }

        @Override
        public int getJitVirtualMethodResolvePushes() {
            if (J9ConfigFlags.arch_x86) {
                if (J9BuildFlags.env_data64) {
                    return 2;
                }
                return 4;
            }
            if (J9ConfigFlags.arch_power) {
                return 0;
            }
            if (TRBuildFlags.host_SH4) {
                return 2;
            }
            return 0;
        }

        @Override
        public int getJitStaticMethodResolvePushes() {
            if (J9ConfigFlags.arch_x86) {
                if (J9BuildFlags.env_data64) {
                    return 1;
                }
                return 1;
            }
            return 0;
        }

        @Override
        public void walkJITFrameSlotsForInternalPointers(WalkState walkState, U8Pointer jitDescriptionCursor, UDATAPointer scanCursor, VoidPointer stackMap, J9JITStackAtlasPointer gcStackAtlas) throws CorruptDataException {
            VoidPointer internalPointerMap = VoidPointer.cast(gcStackAtlas.internalPointerMap());
            U8Pointer tempJitDescriptionCursor = U8Pointer.cast(internalPointerMap);
            U8 internalPointersInRegisters = new U8(0L);
            UDATA parmStackMap = UDATAPointer.cast(tempJitDescriptionCursor).at(0L);
            if (parmStackMap.eq(UDATA.cast(stackMap))) {
                return;
            }
            UDATA registerMap = new UDATA(this.getJitRegisterMap(walkState.jitInfo, stackMap));
            tempJitDescriptionCursor = tempJitDescriptionCursor.add(UDATA.SIZEOF);
            StackWalkerUtils.swPrintf(walkState, 6, "Address {0}", tempJitDescriptionCursor.getHexAddress());
            U8 numInternalPtrMapBytes = tempJitDescriptionCursor.at(0L);
            tempJitDescriptionCursor = tempJitDescriptionCursor.add(1L);
            if (alignStackMaps) {
                tempJitDescriptionCursor = tempJitDescriptionCursor.add(1L);
            }
            StackWalkerUtils.swPrintf(walkState, 6, "Num internal ptr map bytes {0}", numInternalPtrMapBytes);
            I16 indexOfFirstInternalPtr = new I16(U16Pointer.cast(tempJitDescriptionCursor).at(0L));
            StackWalkerUtils.swPrintf(walkState, 6, "Address {0}", tempJitDescriptionCursor.getHexAddress());
            tempJitDescriptionCursor = tempJitDescriptionCursor.add(2L);
            StackWalkerUtils.swPrintf(walkState, 6, "Index of first internal ptr {0}", indexOfFirstInternalPtr);
            I16 offsetOfFirstInternalPtr = new I16(U16Pointer.cast(tempJitDescriptionCursor).at(0L));
            StackWalkerUtils.swPrintf(walkState, 6, "Address {0}", tempJitDescriptionCursor.getHexAddress());
            tempJitDescriptionCursor = tempJitDescriptionCursor.add(2L);
            StackWalkerUtils.swPrintf(walkState, 6, "Offset of first internal ptr {0}", offsetOfFirstInternalPtr);
            StackWalkerUtils.swPrintf(walkState, 6, "Address {0}", tempJitDescriptionCursor.getHexAddress());
            U8 numDistinctPinningArrays = tempJitDescriptionCursor.at(0L);
            tempJitDescriptionCursor = tempJitDescriptionCursor.add(1L);
            StackWalkerUtils.swPrintf(walkState, 6, "Num distinct pinning arrays {0}", numDistinctPinningArrays);
            U8 i = new U8(0L);
            if (registerMap.anyBitsIn(MethodMetaDataConstants.INTERNAL_PTR_REG_MASK) && !registerMap.eq(new UDATA(4208904958L))) {
                internalPointersInRegisters = new U8(1L);
            }
            while (i.lt(numDistinctPinningArrays)) {
                U8 currPinningArrayIndex = tempJitDescriptionCursor.at(0L);
                tempJitDescriptionCursor = tempJitDescriptionCursor.add(1L);
                U8 numInternalPtrsForArray = tempJitDescriptionCursor.at(0L);
                tempJitDescriptionCursor = tempJitDescriptionCursor.add(1L);
                PointerPointer currPinningArrayCursor = PointerPointer.cast(walkState.bp.addOffset(offsetOfFirstInternalPtr.add(currPinningArrayIndex.intValue() * UDATA.SIZEOF)));
                J9ObjectPointer oldPinningArrayAddress = J9ObjectPointer.cast(currPinningArrayCursor.at(0L));
                IDATA displacement = new IDATA(0L);
                StackWalkerUtils.swPrintf(walkState, 6, "Before object slot walk &address : {0} address : {1} bp {2} offset of first internal ptr {3}", currPinningArrayCursor.getHexAddress(), oldPinningArrayAddress.getHexAddress(), walkState.bp.getHexAddress(), offsetOfFirstInternalPtr);
                walkState.callBacks.objectSlotWalkFunction(walkState.walkThread, walkState, currPinningArrayCursor, VoidPointer.cast(currPinningArrayCursor));
                J9ObjectPointer newPinningArrayAddress = J9ObjectPointer.cast(currPinningArrayCursor.at(0L));
                displacement = new IDATA(UDATA.cast(newPinningArrayAddress).sub(UDATA.cast(oldPinningArrayAddress)));
                ++walkState.slotIndex;
                StackWalkerUtils.swPrintf(walkState, 6, "After object slot walk for pinning array with &address : {0} old address {1} new address {2} displacement {3}", currPinningArrayCursor.getHexAddress(), oldPinningArrayAddress.getHexAddress(), newPinningArrayAddress.getHexAddress(), displacement);
                StackWalkerUtils.swPrintf(walkState, 6, "For pinning array {0} num internal pointer stack slots {1}", currPinningArrayIndex, numInternalPtrsForArray);
                if (!displacement.eq(0L)) {
                    U8 j = new U8(0L);
                    while (j.lt(numInternalPtrsForArray)) {
                        U8 internalPtrAuto = tempJitDescriptionCursor.at(0L);
                        tempJitDescriptionCursor = tempJitDescriptionCursor.add(1L);
                        PointerPointer currInternalPtrCursor = PointerPointer.cast(walkState.bp.addOffset(offsetOfFirstInternalPtr.add(internalPtrAuto.intValue() * UDATA.SIZEOF)));
                        StackWalkerUtils.swPrintf(walkState, 6, "For pinning array {0} internal pointer auto {1} old address {2} displacement {3}", currPinningArrayIndex, internalPtrAuto, currInternalPtrCursor.at(0L).getHexAddress(), displacement);
                        if (currInternalPtrCursor.at(0L).notNull()) {
                            IDATA internalPtrAddress = IDATA.cast(currInternalPtrCursor.at(0L));
                            internalPtrAddress = internalPtrAddress.add(displacement);
                            StackWalkerUtils.swPrintf(walkState, 6, "For pinning array %d internal pointer auto %d new address %p\n", currPinningArrayIndex, internalPtrAuto, internalPtrAddress);
                        }
                        j = j.add(1);
                    }
                    if (!internalPointersInRegisters.eq(0L)) {
                        registerMap = registerMap.bitAnd(J9StackWalkConstants.J9SW_REGISTER_MAP_MASK);
                        StackWalkerUtils.swPrintf(walkState, 6, "\tJIT-RegisterMap = {0}", registerMap);
                        U8Pointer tempJitDescriptionCursorForRegs = U8Pointer.cast(stackMap);
                        tempJitDescriptionCursorForRegs = J9ConfigFlags.arch_s390 ? tempJitDescriptionCursorForRegs.add(12L) : tempJitDescriptionCursorForRegs.add(8L);
                        tempJitDescriptionCursorForRegs = walkState.jitInfo.endPC().sub(walkState.jitInfo.startPC()).gte(new UDATA(65535L)) || alignStackMaps ? tempJitDescriptionCursorForRegs.add(8L) : tempJitDescriptionCursorForRegs.add(6L);
                        U8 numInternalPtrRegMapBytes = tempJitDescriptionCursorForRegs.at(0L);
                        tempJitDescriptionCursorForRegs = tempJitDescriptionCursorForRegs.add(1L);
                        numDistinctPinningArrays = tempJitDescriptionCursorForRegs.at(0L);
                        tempJitDescriptionCursorForRegs = tempJitDescriptionCursorForRegs.add(1L);
                        U8 k = new U8(0L);
                        while (k.lt(numDistinctPinningArrays)) {
                            U8 currPinningArrayIndexForRegister = tempJitDescriptionCursorForRegs.at(0L);
                            tempJitDescriptionCursorForRegs = tempJitDescriptionCursorForRegs.add(1L);
                            U8 numInternalPtrRegsForArray = tempJitDescriptionCursorForRegs.at(0L);
                            tempJitDescriptionCursorForRegs = tempJitDescriptionCursorForRegs.add(1L);
                            j = new U8(0L);
                            if (currPinningArrayIndexForRegister.eq(currPinningArrayIndex)) {
                                int mapCursor = J9StackWalkFlags.J9SW_REGISTER_MAP_WALK_REGISTERS_LOW_TO_HIGH ? 0 : (int)J9StackWalkConstants.J9SW_POTENTIAL_SAVED_REGISTERS - 1;
                                while (j.lt(numInternalPtrRegsForArray)) {
                                    U8 internalPtrRegNum = tempJitDescriptionCursorForRegs.at(0L);
                                    tempJitDescriptionCursorForRegs = tempJitDescriptionCursorForRegs.add(1L);
                                    PointerPointer internalPtrObject = J9StackWalkFlags.J9SW_REGISTER_MAP_WALK_REGISTERS_LOW_TO_HIGH ? PointerPointer.cast(walkState.registerEAs[mapCursor + internalPtrRegNum.intValue() - 1].at(0L)) : PointerPointer.cast(walkState.registerEAs[mapCursor + internalPtrRegNum.intValue()].at(0L));
                                    IDATA internalPtrAddress = IDATA.cast(internalPtrObject.at(0L));
                                    StackWalkerUtils.swPrintf(walkState, 6, "Original internal pointer reg address {0}", internalPtrAddress);
                                    if (!internalPtrAddress.eq(0L)) {
                                        internalPtrAddress = internalPtrAddress.add(displacement);
                                    }
                                    StackWalkerUtils.swPrintf(walkState, 6, "Adjusted internal pointer reg to be address {0} (disp {1})\n", internalPtrAddress, displacement);
                                    j = j.add(1);
                                }
                                break;
                            }
                            tempJitDescriptionCursorForRegs = tempJitDescriptionCursorForRegs.add(numInternalPtrRegsForArray);
                            k = k.add(1);
                        }
                    }
                } else {
                    tempJitDescriptionCursor = tempJitDescriptionCursor.add(numInternalPtrsForArray);
                }
                i = i.add(1);
            }
        }

        @Override
        public VoidPointer getStackAllocMapFromJitPC(J9JavaVMPointer javaVM, J9JITExceptionTablePointer methodMetaData, UDATA jitPC, VoidPointer curStackMap) throws CorruptDataException {
            if (methodMetaData.gcStackAtlas().isNull()) {
                return VoidPointer.NULL;
            }
            VoidPointer stackMap = curStackMap.notNull() ? curStackMap : this.getStackMapFromJitPC(javaVM, methodMetaData, jitPC);
            PointerPointer stackAllocMap = PointerPointer.cast(J9JITStackAtlasPointer.cast(methodMetaData.gcStackAtlas()).stackAllocMap());
            if (stackAllocMap.notNull()) {
                if (UDATAPointer.cast(stackAllocMap.at(0L)).eq(stackMap)) {
                    return VoidPointer.NULL;
                }
                UDATA returnValue = UDATA.cast(stackAllocMap).add(UDATA.SIZEOF);
                return VoidPointer.cast(returnValue);
            }
            return VoidPointer.NULL;
        }

        @Override
        public U8Pointer getJitStackSlots(J9JITExceptionTablePointer metaData, VoidPointer stackMap) throws CorruptDataException {
            U8Pointer cursor = this.GET_REGISTER_MAP_CURSOR(MethodMetaData_29_V0.HAS_FOUR_BYTE_OFFSET(metaData), stackMap);
            if (U32Pointer.cast(cursor).at(0L).anyBitsIn(MethodMetaDataConstants.INTERNAL_PTR_REG_MASK) && this.getJitInternalPointerMap(this.getJitGCStackAtlas(metaData)).notNull()) {
                cursor = cursor.add(cursor.add(4L).at(0L).add(1));
            }
            cursor = cursor.add(4L);
            return cursor;
        }

        private U8Pointer GET_REGISTER_MAP_CURSOR(boolean fourByteOffset, VoidPointer stackMap) {
            if (J9ConfigFlags.arch_s390) {
                return U8Pointer.cast(stackMap).add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(fourByteOffset).add(12));
            }
            return U8Pointer.cast(stackMap).add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(fourByteOffset).add(8));
        }

        private static U8Pointer GET_HIGHWORD_REGISTER_MAP_CURSOR(boolean fourByteOffset, VoidPointer stackMap) {
            return U8Pointer.cast(stackMap).add(MethodMetaData_29_V0.SIZEOF_MAP_OFFSET(fourByteOffset).add(4));
        }

        private U32 getNumInlinedCallSites(J9JITExceptionTablePointer methodMetaData) throws CorruptDataException {
            U32 numInlinedCallSites = new U32(0L);
            if (methodMetaData.inlinedCalls().notNull()) {
                U32 sizeOfInlinedCallSites = new U32(UDATA.cast(methodMetaData.gcStackAtlas()).sub(UDATA.cast(methodMetaData.inlinedCalls())));
                numInlinedCallSites = new U32(sizeOfInlinedCallSites.longValue() / this.sizeOfInlinedCallSiteArrayElement(methodMetaData).longValue());
            }
            return numInlinedCallSites;
        }

        private U8Pointer getInlinedCallSiteArrayElement(J9JITExceptionTablePointer methodMetaData, int cix) throws CorruptDataException {
            U8Pointer inlinedCallSiteArray = U8Pointer.cast(this.getJitInlinedCallInfo(methodMetaData));
            if (inlinedCallSiteArray.notNull()) {
                return inlinedCallSiteArray.add((long)cix * this.sizeOfInlinedCallSiteArrayElement(methodMetaData).longValue());
            }
            return U8Pointer.NULL;
        }

        private boolean isPatchedValue(J9MethodPointer m) {
            return J9ConfigFlags.arch_power && m.anyBitsIn(1L) || UDATA.cast(m).bitNot().eq(0L);
        }

        @Override
        public void markClassesInInlineRanges(J9JITExceptionTablePointer methodMetaData, WalkState walkState) throws CorruptDataException {
            J9MethodPointer savedMethod = walkState.method;
            J9ConstantPoolPointer savedCP = walkState.constantPool;
            U32 numCallSites = this.getNumInlinedCallSites(methodMetaData);
            int i = 0;
            for (i = 0; i < numCallSites.intValue(); ++i) {
                U8Pointer inlinedCallSite = this.getInlinedCallSiteArrayElement(methodMetaData, i);
                J9MethodPointer inlinedMethod = J9MethodPointer.cast(this.getInlinedMethod(VoidPointer.cast(inlinedCallSite)));
                if (this.isPatchedValue(inlinedMethod)) continue;
                walkState.method = inlinedMethod;
                walkState.constantPool = StackWalkerUtils.UNTAGGED_METHOD_CP(walkState.method);
                StackWalkerUtils.WALK_METHOD_CLASS(walkState);
            }
            walkState.method = savedMethod;
            walkState.constantPool = savedCP;
        }
    }

    private static interface MethodMetaDataImpl
    extends IAlgorithm {
        public UDATAPointer getObjectTempScanCursor(WalkState var1) throws CorruptDataException;

        public int getJitStaticMethodResolvePushes();

        public int getJitVirtualMethodResolvePushes();

        public int getJitRecompilationResolvePushes();

        public U8Pointer getJitDescriptionCursor(VoidPointer var1, WalkState var2) throws CorruptDataException;

        public void walkJITFrameSlotsForInternalPointers(WalkState var1, U8Pointer var2, UDATAPointer var3, VoidPointer var4, J9JITStackAtlasPointer var5) throws CorruptDataException;

        public U8Pointer getJitInternalPointerMap(J9JITStackAtlasPointer var1) throws CorruptDataException;

        public U16 getJitNumberOfParmSlots(J9JITStackAtlasPointer var1) throws CorruptDataException;

        public U8Pointer getNextDescriptionCursor(J9JITExceptionTablePointer var1, VoidPointer var2, U8Pointer var3) throws CorruptDataException;

        public U32 getJitRegisterMap(J9JITExceptionTablePointer var1, VoidPointer var2) throws CorruptDataException;

        public U32 getJitHighWordRegisterMap(J9JITExceptionTablePointer var1, VoidPointer var2) throws CorruptDataException;

        public U16 getJitNumberOfMapBytes(J9JITStackAtlasPointer var1) throws CorruptDataException;

        public I16 getJitTotalFrameSize(J9JITExceptionTablePointer var1) throws CorruptDataException;

        public UDATAPointer getObjectArgScanCursor(WalkState var1) throws CorruptDataException;

        public UDATA getCurrentByteCodeIndexAndIsSameReceiver(J9JITExceptionTablePointer var1, VoidPointer var2, VoidPointer var3, boolean[] var4) throws CorruptDataException;

        public boolean hasMoreInlinedMethods(VoidPointer var1) throws CorruptDataException;

        public VoidPointer getInlinedMethod(VoidPointer var1) throws CorruptDataException;

        public UDATA getJitInlineDepthFromCallSite(J9JITExceptionTablePointer var1, VoidPointer var2) throws CorruptDataException;

        public VoidPointer getFirstInlinedCallSite(J9JITExceptionTablePointer var1, VoidPointer var2) throws CorruptDataException;

        public VoidPointer getNextInlinedCallSite(J9JITExceptionTablePointer var1, VoidPointer var2) throws CorruptDataException;

        public J9JITStackAtlasPointer getJitGCStackAtlas(J9JITExceptionTablePointer var1) throws CorruptDataException;

        public VoidPointer getStackMapFromJitPC(J9JavaVMPointer var1, J9JITExceptionTablePointer var2, UDATA var3) throws CorruptDataException;

        public UDATA getJitDataResolvePushes() throws CorruptDataException;

        public void jitAddSpilledRegistersForDataResolve(WalkState var1) throws CorruptDataException;

        public VoidPointer getJitInlinedCallInfo(J9JITExceptionTablePointer var1) throws CorruptDataException;

        public void jitGetMapsFromPC(J9JavaVMPointer var1, J9JITExceptionTablePointer var2, UDATA var3, JITMaps var4) throws CorruptDataException;

        public void jitAddSpilledRegisters(WalkState var1) throws CorruptDataException;

        public void jitAddSpilledRegisters(WalkState var1, VoidPointer var2) throws CorruptDataException;

        public U8 getNextDescriptionBit(U8Pointer var1) throws CorruptDataException;

        public VoidPointer getStackAllocMapFromJitPC(J9JavaVMPointer var1, J9JITExceptionTablePointer var2, UDATA var3, VoidPointer var4) throws CorruptDataException;

        public U8Pointer getJitStackSlots(J9JITExceptionTablePointer var1, VoidPointer var2) throws CorruptDataException;

        public void markClassesInInlineRanges(J9JITExceptionTablePointer var1, WalkState var2) throws CorruptDataException;
    }

    public static class JITMaps {
        public PointerPointer stackMap = PointerPointer.NULL;
        public PointerPointer inlineMap = PointerPointer.NULL;
    }
}

