/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.vm29.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm29.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm29.pointer.I64Pointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.U32Pointer;
import com.ibm.j9ddr.vm29.pointer.U8Pointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm29.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ITablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMClassRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMConstantRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMFieldRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMInterfaceMethodRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMMethodHandleRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMMethodRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMMethodTypeRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMStaticFieldRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMStaticMethodRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9RAMStringRefPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9VTableHeaderPointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm29.structure.J9Class;
import com.ibm.j9ddr.vm29.structure.J9ConstantPool;
import com.ibm.j9ddr.vm29.structure.J9Consts;
import com.ibm.j9ddr.vm29.structure.J9FieldFlags;
import com.ibm.j9ddr.vm29.structure.J9ITable;
import com.ibm.j9ddr.vm29.structure.J9Method;
import com.ibm.j9ddr.vm29.structure.J9RAMClassRef;
import com.ibm.j9ddr.vm29.structure.J9RAMConstantPoolItem;
import com.ibm.j9ddr.vm29.structure.J9RAMConstantRef;
import com.ibm.j9ddr.vm29.structure.J9RAMFieldRef;
import com.ibm.j9ddr.vm29.structure.J9RAMInterfaceMethodRef;
import com.ibm.j9ddr.vm29.structure.J9RAMMethodHandleRef;
import com.ibm.j9ddr.vm29.structure.J9RAMMethodRef;
import com.ibm.j9ddr.vm29.structure.J9RAMMethodTypeRef;
import com.ibm.j9ddr.vm29.structure.J9RAMStaticMethodRef;
import com.ibm.j9ddr.vm29.structure.J9RAMStringRef;
import com.ibm.j9ddr.vm29.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm29.structure.J9VTableHeader;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.ClassWalker;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.IClassWalkCallbacks;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U32;
import com.ibm.j9ddr.vm29.types.UDATA;
import java.util.HashMap;
import java.util.Iterator;

public class RamClassWalker
extends ClassWalker {
    private final J9ClassPointer ramClass;
    private final Context context;

    public RamClassWalker(StructurePointer clazz, Context context) {
        this.clazz = clazz;
        this.context = context;
        this.ramClass = clazz instanceof J9ClassPointer ? (J9ClassPointer)clazz : J9ClassPointer.NULL;
        this.fillDebugExtMap();
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void allSlotsInObjectDo(IClassWalkCallbacks classWalker) throws CorruptDataException {
        this.classWalkerCallback = classWalker;
        if (this.ramClass.isNull()) {
            throw new CorruptDataException("The StructurePointer clazz is not an instance of J9ClassPointer");
        }
        this.classWalkerCallback = classWalker;
        this.allSlotsInJitVTablesDo();
        this.allSlotsInRAMHeaderDo();
        this.allSlotsInVTableDo();
        this.allSlotsInExtendedMethodBlockDo();
        this.allSlotsInRAMMethodsSectionDo();
        this.allSlotsInConstantPoolDo();
        this.allSlotsInRAMStaticsDo();
        this.allSlotsInRAMSuperClassesDo();
        this.allSlotsInInstanceDescriptionBitsDo();
        this.allSlotsIniTableDo();
        this.allSlotsInStaticSplitTableDo();
        this.allSlotsInSpecialSplitTableDo();
    }

    private void allSlotsInRAMSuperClassesDo() throws CorruptDataException {
        long classDepth = J9ClassHelper.classDepth(this.ramClass).longValue();
        PointerPointer superclasses = this.ramClass.superclasses();
        int i = 0;
        while ((long)i < classDepth) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, superclasses.add(i), "SuperClass address", "!j9class");
            ++i;
        }
        this.classWalkerCallback.addSection(this.clazz, superclasses, classDepth * PointerPointer.SIZEOF, "Superclasses", false);
    }

    private void allSlotsInStaticSplitTableDo() throws CorruptDataException {
        int count = this.ramClass.romClass().staticSplitMethodRefCount().intValue();
        PointerPointer splitTable = this.ramClass.staticSplitMethodTable();
        for (int i = 0; i < count; ++i) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, splitTable.add(i), "J9Method address", "!j9method");
        }
        this.classWalkerCallback.addSection(this.clazz, splitTable, (long)count * PointerPointer.SIZEOF, "StaticSplitTable", false);
    }

    private void allSlotsInSpecialSplitTableDo() throws CorruptDataException {
        int count = this.ramClass.romClass().specialSplitMethodRefCount().intValue();
        PointerPointer splitTable = this.ramClass.specialSplitMethodTable();
        for (int i = 0; i < count; ++i) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, splitTable.add(i), "J9Method address", "!j9method");
        }
        this.classWalkerCallback.addSection(this.clazz, splitTable, (long)count * PointerPointer.SIZEOF, "SpecialSplitTable", false);
    }

    private void allSlotsIniTableDo() throws CorruptDataException {
        J9ITablePointer iTable = J9ITablePointer.cast(this.ramClass.iTable());
        int interfaceSize = 0;
        J9ClassPointer superclass = J9ClassHelper.superclass(this.ramClass);
        J9ITablePointer superclassITable = superclass.isNull() ? J9ITablePointer.NULL : J9ITablePointer.cast(superclass.iTable());
        while (!iTable.eq(superclassITable)) {
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, iTable.interfaceClassEA(), "iTable->interfaceClass", "!j9class");
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, iTable.nextEA(), "iTable->next", "!j9itable");
            if (!this.ramClass.romClass().modifiers().allBitsIn(J9Consts.J9_JAVA_INTERFACE)) {
                int methodCount = iTable.interfaceClass().romClass().romMethodCount().intValue();
                for (int i = 0; i < methodCount; ++i) {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_iTableMethod, iTable.nextEA().add(i + 1), "method", "!j9method");
                    interfaceSize += UDATA.SIZEOF;
                }
            }
            iTable = iTable.next();
            interfaceSize = (int)((long)interfaceSize + J9ITable.SIZEOF);
        }
        this.classWalkerCallback.addSection(this.clazz, this.ramClass.iTable(), interfaceSize, "iTable", false);
    }

    private void allSlotsInInstanceDescriptionBitsDo() throws CorruptDataException {
        if (!this.ramClass.instanceDescription().allBitsIn(1L)) {
            int totalInstanceSize = this.ramClass.totalInstanceSize().intValue();
            int fj9object_t_SizeOf = J9BuildFlags.gc_compressedPointers ? 4 : UDATA.SIZEOF;
            long totalSize = totalInstanceSize / fj9object_t_SizeOf;
            long shapeSlots = totalSize + (long)(UDATA.SIZEOF * 8 - 1) & (long)(~(UDATA.SIZEOF * 8 - 1));
            shapeSlots /= (long)(UDATA.SIZEOF * 8);
            int i = 0;
            while ((long)i < shapeSlots) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, this.ramClass.instanceDescription().add(i), "instanceDescription");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, this.ramClass.instanceLeafDescription().add(i), "instanceLeafDescription");
                ++i;
            }
            this.classWalkerCallback.addSection(this.clazz, this.ramClass.instanceDescription(), shapeSlots * 2L * (long)UDATA.SIZEOF, "InstanceDescription", false);
        }
    }

    private void allSlotsInConstantPoolDo() throws CorruptDataException {
        J9ROMClassPointer romClass = this.ramClass.romClass();
        int constPoolCount = romClass.ramConstantPoolCount().intValue();
        J9ConstantPoolPointer cpp = J9ConstantPoolPointer.cast(this.ramClass.ramConstantPool());
        U32Pointer cpDescriptionSlots = J9ROMClassHelper.cpShapeDescription(romClass);
        PointerPointer cpEntry = PointerPointer.cast(this.ramClass.ramConstantPool());
        long cpDescription = 0L;
        long cpEntryCount = this.ramClass.romClass().ramConstantPoolCount().longValue();
        long cpDescriptionIndex = 0L;
        while (cpEntryCount > 0L) {
            J9ObjectPointer slot;
            StructurePointer ref;
            long slotType;
            if (0L == cpDescriptionIndex) {
                cpDescription = cpDescriptionSlots.at(0L).longValue();
                cpDescriptionSlots = cpDescriptionSlots.add(1L);
                cpDescriptionIndex = J9ConstantPool.J9_CP_DESCRIPTIONS_PER_U32;
            }
            if ((slotType = cpDescription & J9ConstantPool.J9_CP_DESCRIPTION_MASK) == J9ConstantPool.J9CPTYPE_STRING || slotType == J9ConstantPool.J9CPTYPE_ANNOTATION_UTF8) {
                ref = J9RAMStringRefPointer.cast(cpEntry);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_RAM_UTF8, ((J9RAMStringRefPointer)ref).stringObjectEA(), "stringObject");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMStringRefPointer)ref).unusedEA(), "unused");
                if (slotType == J9ConstantPool.J9CPTYPE_STRING) {
                    this.classWalkerCallback.addSection(this.clazz, ref, J9RAMStringRef.SIZEOF, "J9CPTYPE_STRING", false);
                } else {
                    this.classWalkerCallback.addSection(this.clazz, ref, J9RAMStringRef.SIZEOF, "J9CPTYPE_ANNOTATION_UTF8", false);
                }
            } else if (slotType == J9ConstantPool.J9CPTYPE_METHOD_TYPE) {
                ref = J9RAMMethodTypeRefPointer.cast(cpEntry);
                slot = ((J9RAMMethodTypeRefPointer)ref).type();
                if (slot.notNull()) {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMMethodTypeRefPointer)ref).typeEA(), "type", "!j9object");
                } else {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMMethodTypeRefPointer)ref).typeEA(), "type");
                }
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMMethodTypeRefPointer)ref).slotCountEA(), "slotCount");
                this.classWalkerCallback.addSection(this.clazz, ref, J9RAMMethodTypeRef.SIZEOF, "J9CPTYPE_METHOD_TYPE", false);
            } else if (slotType == J9ConstantPool.J9CPTYPE_METHODHANDLE) {
                ref = J9RAMMethodHandleRefPointer.cast(cpEntry);
                slot = ((J9RAMMethodHandleRefPointer)ref).methodHandle();
                if (slot.notNull()) {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMMethodHandleRefPointer)ref).methodHandleEA(), "methodHandle", "!j9object");
                } else {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMMethodHandleRefPointer)ref).methodHandleEA(), "methodHandle");
                }
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMMethodHandleRefPointer)ref).unusedEA(), "unused");
                this.classWalkerCallback.addSection(this.clazz, ref, J9RAMMethodHandleRef.SIZEOF, "J9CPTYPE_METHODHANDLE", false);
            } else if (slotType == J9ConstantPool.J9CPTYPE_CLASS) {
                ref = J9RAMClassRefPointer.cast(cpEntry);
                if (((J9RAMClassRefPointer)ref).value().notNull()) {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMClassRefPointer)ref).valueEA(), "value", "!j9class");
                } else {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMClassRefPointer)ref).valueEA(), "value");
                }
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMClassRefPointer)ref).modifiersEA(), "modifiers");
                this.classWalkerCallback.addSection(this.clazz, ref, J9RAMClassRef.SIZEOF, "J9CPTYPE_CLASS", false);
            } else if (slotType == J9ConstantPool.J9CPTYPE_INT) {
                ref = J9RAMConstantRefPointer.cast(cpEntry);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMConstantRefPointer)ref).slot1EA(), "cpFieldInt");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMConstantRefPointer)ref).slot2EA(), "cpFieldIntUnused");
                this.classWalkerCallback.addSection(this.clazz, ref, J9RAMConstantRef.SIZEOF, "J9CPTYPE_INT", false);
            } else if (slotType == J9ConstantPool.J9CPTYPE_FLOAT) {
                ref = J9RAMConstantRefPointer.cast(cpEntry);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMConstantRefPointer)ref).slot1EA(), "cpFieldFloat");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMConstantRefPointer)ref).slot2EA(), "cpFieldIntUnused");
                this.classWalkerCallback.addSection(this.clazz, ref, J9RAMConstantRef.SIZEOF, "J9CPTYPE_FLOAT", false);
            } else if (slotType == J9ConstantPool.J9CPTYPE_LONG) {
                ref = J9RAMConstantRefPointer.cast(cpEntry);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_I64, I64Pointer.cast(cpEntry), "J9CPTYPE_LONG");
                this.classWalkerCallback.addSection(this.clazz, ref, J9RAMConstantRef.SIZEOF, "J9CPTYPE_LONG", false);
            } else if (slotType == J9ConstantPool.J9CPTYPE_DOUBLE) {
                ref = J9RAMConstantRefPointer.cast(cpEntry);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_I64, I64Pointer.cast(cpEntry), "J9CPTYPE_DOUBLE");
                this.classWalkerCallback.addSection(this.clazz, ref, 8L, "J9CPTYPE_DOUBLE", false);
            } else if (slotType == J9ConstantPool.J9CPTYPE_FIELD) {
                ref = J9RAMFieldRefPointer.cast(cpEntry);
                J9RAMStaticFieldRefPointer staticRef = J9RAMStaticFieldRefPointer.cast(cpEntry);
                if (staticRef.flagsAndClass().longValue() > 0L && !staticRef.valueOffset().eq(UDATA.MAX)) {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_IDATA, staticRef.flagsAndClassEA(), "flagsAndClass");
                } else {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMFieldRefPointer)ref).flagsEA(), "flags");
                }
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMFieldRefPointer)ref).valueOffsetEA(), "valueOffset");
                this.classWalkerCallback.addSection(this.clazz, ref, J9RAMFieldRef.SIZEOF, "J9CPTYPE_FIELD", false);
            } else if (slotType == J9ConstantPool.J9CPTYPE_INTERFACE_METHOD) {
                ref = J9RAMInterfaceMethodRefPointer.cast(cpEntry);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMInterfaceMethodRefPointer)ref).interfaceClassEA(), "interfaceClass", "!j9class");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMInterfaceMethodRefPointer)ref).methodIndexAndArgCountEA(), "methodIndexAndArgCount");
                this.classWalkerCallback.addSection(this.clazz, ref, J9RAMInterfaceMethodRef.SIZEOF, "J9CPTYPE_INTERFACE_METHOD", false);
            } else if (slotType == J9ConstantPool.J9CPTYPE_STATIC_METHOD) {
                ref = J9RAMStaticMethodRefPointer.cast(cpEntry);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMStaticMethodRefPointer)ref).methodEA(), "method", "!j9method");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMStaticMethodRefPointer)ref).methodIndexAndArgCountEA(), "unused");
                this.classWalkerCallback.addSection(this.clazz, ref, J9RAMStaticMethodRef.SIZEOF, "J9CPTYPE_STATIC_METHOD", false);
            } else if (slotType == J9ConstantPool.J9CPTYPE_UNUSED || slotType == J9ConstantPool.J9CPTYPE_UNUSED8) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, cpEntry, "unused");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, cpEntry.add(1L), "unused");
                this.classWalkerCallback.addSection(this.clazz, cpEntry, 2 * UDATA.SIZEOF, "J9CPTYPE_UNUSED", false);
            } else if (slotType == J9ConstantPool.J9CPTYPE_INSTANCE_METHOD) {
                ref = J9RAMMethodRefPointer.cast(cpEntry);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMMethodRefPointer)ref).methodIndexAndArgCountEA(), "methodIndexAndArgCount");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMMethodRefPointer)ref).methodEA(), "method", "!j9method");
                this.classWalkerCallback.addSection(this.clazz, ref, J9RAMMethodRef.SIZEOF, "J9CPTYPE_INSTANCE_METHOD", false);
            } else if (slotType == J9ConstantPool.J9CPTYPE_HANDLE_METHOD) {
                ref = J9RAMMethodRefPointer.cast(cpEntry);
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMMethodRefPointer)ref).methodIndexAndArgCountEA(), "methodTypeIndexAndArgCount");
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, ((J9RAMMethodRefPointer)ref).methodEA(), "unused");
                this.classWalkerCallback.addSection(this.clazz, ref, J9RAMMethodRef.SIZEOF, "J9CPTYPE_HANDLE_METHOD", false);
            }
            cpEntry = cpEntry.addOffset(J9RAMConstantPoolItem.SIZEOF);
            --cpEntryCount;
            cpDescription >>= (int)J9ConstantPool.J9_CP_BITS_PER_DESCRIPTION;
            --cpDescriptionIndex;
        }
        this.classWalkerCallback.addSection(this.clazz, cpp, constPoolCount * 2 * UDATA.SIZEOF, "Constant Pool               ", false);
    }

    private void allSlotsInRAMStaticsDo() throws CorruptDataException {
        if (this.ramClass.ramStatics().isNull()) {
            return;
        }
        Iterator<J9ObjectFieldOffset> ofoIterator = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(this.ramClass, J9ClassHelper.superclass(this.ramClass), new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_STATIC));
        J9ObjectFieldOffset fields = null;
        while (ofoIterator.hasNext()) {
            String additionalInfo;
            fields = ofoIterator.next();
            J9ROMFieldShapePointer field = fields.getField();
            String info = fields.getName();
            UDATA modifiers = field.modifiers();
            UDATAPointer fieldAddress = this.ramClass.ramStatics().addOffset(fields.getOffsetOrAddress());
            String string = additionalInfo = modifiers.anyBitsIn(J9FieldFlags.J9FieldFlagObject) ? "!j9object" : "";
            if (modifiers.anyBitsIn(J9FieldFlags.J9FieldSizeDouble)) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_I64, I64Pointer.cast(fieldAddress), info, additionalInfo);
                continue;
            }
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, fieldAddress, info, additionalInfo);
        }
        UDATA staticSlotCount = this.ramClass.romClass().objectStaticCount().add(this.ramClass.romClass().singleScalarStaticCount());
        staticSlotCount = J9BuildFlags.env_data64 ? staticSlotCount.add(this.ramClass.romClass().doubleScalarStaticCount()) : staticSlotCount.add(1L).bitAnd(-2L).add(this.ramClass.romClass().doubleScalarStaticCount().mult(2));
        UDATA size = Scalar.convertSlotsToBytes(new UDATA(staticSlotCount));
        this.classWalkerCallback.addSection(this.clazz, this.ramClass.ramStatics(), size.longValue(), "Ram static", false);
    }

    private void allSlotsInRAMMethodsSectionDo() throws CorruptDataException {
        int methodCount = this.ramClass.romClass().romMethodCount().intValue();
        if (methodCount != 0) {
            J9MethodPointer methods = this.ramClass.ramMethods();
            for (int i = 0; i < methodCount; ++i) {
                J9MethodPointer method = methods.add(i);
                this.classWalkerCallback.addSection(this.clazz, method, J9Method.SIZEOF, "J9Method", false);
                this.addObjectsasSlot(method);
            }
            this.classWalkerCallback.addSection(this.clazz, this.ramClass.ramMethods(), (long)methodCount * J9Method.SIZEOF, "RAM methods", false);
        }
    }

    private void allSlotsInExtendedMethodBlockDo() throws CorruptDataException {
        J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        if (vm.runtimeFlags().allBitsIn(J9Consts.J9_RUNTIME_EXTENDED_METHOD_BLOCK)) {
            long extendedMethodBlockSize = 0L;
            int romMethodCount = this.ramClass.romClass().romMethodCount().intValue();
            extendedMethodBlockSize = romMethodCount + (UDATA.SIZEOF - 1);
            U8Pointer extendedMethodStartAddr = U8Pointer.cast(this.ramClass.ramMethods()).sub(extendedMethodBlockSize &= (long)(~(UDATA.SIZEOF - 1)));
            this.classWalkerCallback.addSection(this.clazz, extendedMethodStartAddr, romMethodCount, "Extended method block", false);
            while (romMethodCount-- > 0) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_U8, extendedMethodStartAddr.add(romMethodCount), "method flag", "!j9extendedmethodflaginfo");
            }
        }
    }

    private void allSlotsInVTableDo() throws CorruptDataException {
        if (AlgorithmVersion.getVersionOf("ALG_VM_VTABLE_VERSION").getAlgorithmVersion() >= 1) {
            J9VTableHeaderPointer vTableHeader = J9ClassHelper.vTableHeader(this.ramClass);
            long vTableMethods = vTableHeader.size().longValue();
            long vTableSize = UDATA.SIZEOF;
            UDATAPointer vTable = J9ClassHelper.vTable(vTableHeader);
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, vTableHeader, "VTable size");
            if (vTableMethods > 0L) {
                vTableSize = J9VTableHeader.SIZEOF + vTableMethods * (long)UDATA.SIZEOF;
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, vTableHeader.initialVirtualMethod(), "magic method", "!j9method");
                int i = 0;
                while ((long)i < vTableMethods) {
                    this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, vTable.add(i), "method", "!j9method");
                    ++i;
                }
            }
            this.classWalkerCallback.addSection(this.clazz, vTableHeader, vTableSize, "vTable", true);
        } else {
            UDATAPointer vTable = J9ClassHelper.oldVTable(this.ramClass);
            long vTableSlots = Math.max(1L, vTable.at(0L).longValue());
            this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, vTable, "VTable size");
            int i = 1;
            while ((long)i <= vTableSlots) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, vTable.add(i), (i == 1 ? "magic " : "") + "method", "!j9method");
                ++i;
            }
            this.classWalkerCallback.addSection(this.clazz, vTable, vTableSlots * (long)UDATA.SIZEOF, "vTable", true);
        }
    }

    private void allSlotsInJitVTablesDo() throws CorruptDataException {
        J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        if (!vm.jitConfig().isNull()) {
            long jitvTableSlotsLength;
            long jitvTableSlots;
            if (AlgorithmVersion.getVersionOf("ALG_VM_VTABLE_VERSION").getAlgorithmVersion() >= 1) {
                jitvTableSlots = J9ClassHelper.vTableHeader(this.ramClass).size().longValue();
                jitvTableSlotsLength = (jitvTableSlots - 1L) * (long)UDATA.SIZEOF + J9VTableHeader.SIZEOF;
            } else {
                jitvTableSlots = J9ClassHelper.oldVTable(this.ramClass).at(0L).longValue();
                jitvTableSlotsLength = jitvTableSlots * (long)UDATA.SIZEOF;
            }
            int i = 0;
            while ((long)i < jitvTableSlots) {
                this.classWalkerCallback.addSlot(this.clazz, IClassWalkCallbacks.SlotType.J9_UDATA, UDATAPointer.cast(this.ramClass.subOffset(jitvTableSlotsLength)).add(i), "send target", "");
                ++i;
            }
            this.classWalkerCallback.addSection(this.clazz, this.ramClass.subOffset(jitvTableSlotsLength), jitvTableSlotsLength, "jitVTables", true);
        }
    }

    private void allSlotsInRAMHeaderDo() throws CorruptDataException {
        this.classWalkerCallback.addSection(this.clazz, this.clazz, J9Class.SIZEOF, "ramHeader", true);
        if (J9ClassHelper.isArrayClass(this.ramClass)) {
            this.addObjectsasSlot(J9ArrayClassPointer.cast(this.ramClass));
        } else {
            if (J9ClassHelper.isSwappedOut(this.ramClass)) {
                HashMap<String, String> renameFields = new HashMap<String, String>();
                renameFields.put("arrayClass", "currentClass");
                this.addObjectsAsSlot(this.ramClass, renameFields);
            }
            this.addObjectsasSlot(this.ramClass);
        }
    }

    @Override
    protected void fillDebugExtMap() {
        this.debugExtMap.put("romClass", "!dumpromclasslinear");
        this.debugExtMap.put("classLoader", "!j9classloader");
        this.debugExtMap.put("classObject", "!j9vmjavalangclass");
        this.debugExtMap.put("ramMethods", "!j9method");
        this.debugExtMap.put("arrayClass", "!j9class");
        this.debugExtMap.put("initializerCache", "!j9method");
        this.debugExtMap.put("subclassTraversalLink", "!j9class");
        this.debugExtMap.put("replacedClass", "!j9class");
        this.debugExtMap.put("constantPool", "!j9constantpool");
        this.debugExtMap.put("bytecodes", "!bytecodes");
    }
}

