/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools;

import com.ibm.j9ddr.tools.store.J9DDRStructureStore;
import com.ibm.j9ddr.tools.store.StructureKey;
import com.ibm.j9ddr.tools.store.StructureMismatchError;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;

public class AddStructureBlob {
    private static final String PROP_DDR_ORDER = "ddr.order";
    HashMap<String, String> opts = new HashMap();

    public AddStructureBlob() {
        this.initArgs();
    }

    private void initArgs() {
        this.opts.put("-d", null);
        this.opts.put("-f", null);
        this.opts.put("-k", null);
        this.opts.put("-s", null);
        this.opts.put("-c", "");
    }

    public static void main(String[] args) {
        AddStructureBlob app = new AddStructureBlob();
        app.parseArgs(args);
        app.run();
    }

    private String[] loadSpecNames() {
        String path = this.opts.get("-c");
        if (null == path || path.length() == 0) {
            return new String[0];
        }
        Properties props = new Properties();
        File file = new File(path);
        if (file.exists()) {
            try {
                FileInputStream in = new FileInputStream(file);
                props.load(in);
                String specs = props.getProperty(PROP_DDR_ORDER);
                if (null == specs) {
                    String msg = String.format("The cache properties file [%s] specified by the -c option does not specify a %s key", file.getAbsolutePath(), PROP_DDR_ORDER);
                    throw new IllegalArgumentException(msg);
                }
                return specs.split(",");
            }
            catch (Exception e) {
                String msg = String.format("The cache properties file [%s] specified by the -c option could not be read", file.getAbsolutePath());
                throw new IllegalArgumentException(msg, e);
            }
        }
        String msg = String.format("The cache properties file [%s] specified by the -c option does not exist", file.getAbsolutePath());
        throw new IllegalArgumentException(msg);
    }

    private void run() {
        String directoryName = this.opts.get("-d");
        String supersetName = this.opts.get("-s");
        if (supersetName == null) {
            supersetName = "superset.dat";
        }
        try {
            J9DDRStructureStore store = new J9DDRStructureStore(directoryName, supersetName);
            String path = this.opts.get("-c");
            if (null == path || path.length() == 0) {
                this.addFromFile(store);
            } else {
                this.addFromPropertiesFile(store);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (StructureMismatchError e) {
            e.printStackTrace();
        }
    }

    private void addFromFile(J9DDRStructureStore store) throws IOException, StructureMismatchError {
        String directoryName = this.opts.get("-d");
        String structureName = this.opts.get("-f");
        String keyString = this.opts.get("-k");
        String supersetName = this.opts.get("-s");
        if (keyString == null) {
            File[] structureFiles;
            File structurePath = new File(structureName);
            if (structurePath.isDirectory()) {
                structureFiles = structurePath.listFiles();
            } else {
                structureFiles = new File[]{structurePath};
                structurePath = structurePath.getParentFile();
            }
            for (File file : structureFiles) {
                if (file.exists()) {
                    store.add(null, file.getPath(), false);
                    store.updateSuperset();
                    System.out.println("Added " + file.getName() + " to superset " + supersetName + " in " + directoryName);
                    continue;
                }
                System.out.println("WARNING : The specified structure file " + file.getName() + " does not exist and was ignored");
            }
        } else {
            StructureKey key = new StructureKey(keyString);
            store.add(key, structureName, true);
            store.updateSuperset();
            System.out.println(String.format("Added %s to %s/%s as %s", structureName, directoryName, store.getSuperSetFileName(), keyString));
        }
    }

    private void addFromPropertiesFile(J9DDRStructureStore store) throws IOException, StructureMismatchError {
        String directoryName = this.opts.get("-d");
        String keyString = this.opts.get("-k");
        File structurePath = new File(this.opts.get("-f"));
        String[] specs = this.loadSpecNames();
        File[] structureFiles = new File[specs.length];
        for (int i = 0; i < specs.length; ++i) {
            structureFiles[i] = new File(structurePath, specs[i]);
        }
        for (File file : structureFiles) {
            if (file.exists()) {
                StructureKey key = new StructureKey(file.getName() + "." + keyString);
                store.add(key, file.getPath(), false);
                store.updateSuperset();
                System.out.println(String.format("Added %s to %s/%s as %s", file.getAbsolutePath(), directoryName, store.getSuperSetFileName(), key));
                continue;
            }
            System.out.println("WARNING : The specified structure file " + file.getName() + " does not exist and was ignored");
        }
    }

    private void parseArgs(String[] args) {
        if (args.length == 0 || args.length % 2 != 0) {
            System.out.println("Not enough options specified as program arguments");
            System.out.println(" args [" + args.length + "]");
            AddStructureBlob.printHelp();
            System.exit(1);
        }
        for (int i = 0; i < args.length; i += 2) {
            if (this.opts.containsKey(args[i])) {
                this.opts.put(args[i], args[i + 1]);
                continue;
            }
            System.out.println("Invalid option : " + args[i]);
            AddStructureBlob.printHelp();
            System.exit(1);
        }
        for (String key : this.opts.keySet()) {
            String value = this.opts.get(key);
            if (value != null || key.equals("-k") || key.equals("-s")) continue;
            System.err.println("The option " + key + " has not been set.\n");
            AddStructureBlob.printHelp();
            System.exit(1);
        }
    }

    private static void printHelp() {
        System.out.println("Usage :\n\njava AddStructureBlob -d <directory name> -f <structure file name> [-s <superset file name>] [-k <structure key>]\n");
    }
}

