/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.libraries;

import com.ibm.dtfj.corereaders.Builder;
import com.ibm.dtfj.corereaders.ClosingFileReader;
import com.ibm.dtfj.corereaders.DumpFactory;
import com.ibm.dtfj.corereaders.ICoreFileReader;
import com.ibm.dtfj.corereaders.NewAixDump;
import com.ibm.dtfj.corereaders.NewElfDump;
import com.ibm.j9ddr.libraries.LibraryAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;

public class DTFJLibraryAdapter
implements Builder,
LibraryAdapter {
    private static final Logger logger = Logger.getLogger("com.ibm.j9ddr.libraries");
    private File _parentDir;
    private ArrayList<String> moduleNames = null;
    private final ArrayList<String> errorMessages = new ArrayList();
    private boolean isAIX = false;

    public static void main(String[] args) {
        if (args.length > 0) {
            for (int x = 0; x < args.length; ++x) {
                File coreFile = new File(args[x]);
                System.out.println("Reading \"" + coreFile.getAbsolutePath() + "\"...");
                DTFJLibraryAdapter adapter = new DTFJLibraryAdapter();
                ArrayList<String> modules = adapter.getLibraryList(coreFile);
                for (String module : modules) {
                    System.out.println("\t" + module);
                }
            }
        } else {
            System.out.println("Usage:  \"LibraryAdapter <core files> ...\"");
            System.exit(1);
        }
    }

    @Override
    public boolean isLibraryCollectionRequired(File coreFile) {
        ICoreFileReader reader = null;
        try {
            ClosingFileReader closingFile = new ClosingFileReader(coreFile);
            reader = DumpFactory.createDumpForCore((ImageInputStream)closingFile);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not determine if library collection is required for " + coreFile.getAbsolutePath(), e);
            this.errorMessages.add(e.getMessage());
            return false;
        }
        if (reader instanceof NewElfDump) {
            return true;
        }
        return reader instanceof NewAixDump;
    }

    @Override
    public ArrayList<String> getLibraryList(File coreFile) {
        if (this.moduleNames == null) {
            this.moduleNames = new ArrayList();
            try {
                this._parentDir = coreFile.getParentFile();
                logger.fine("Creating DTFJ core file reader");
                ClosingFileReader closingFile = new ClosingFileReader(coreFile);
                ICoreFileReader reader = DumpFactory.createDumpForCore((ImageInputStream)closingFile);
                this.isAIX = reader instanceof NewAixDump;
                logger.fine("Extracting modules");
                reader.extract((Builder)this);
            }
            catch (FileNotFoundException e) {
                logger.log(Level.SEVERE, "Could not open core file " + coreFile.getAbsolutePath(), e);
                this.errorMessages.add(e.getMessage());
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error processing core file " + coreFile.getAbsolutePath(), e);
                this.errorMessages.add(e.getMessage());
            }
        }
        return this.moduleNames;
    }

    @Override
    public ArrayList<String> getErrorMessages() {
        return this.errorMessages;
    }

    public ClosingFileReader openFile(String filename) throws IOException {
        ClosingFileReader candidate = null;
        File absolute = new File(filename);
        String fileName = absolute.getName();
        File supportFileCopy = new File(this._parentDir, fileName);
        candidate = supportFileCopy.exists() ? new ClosingFileReader(supportFileCopy) : new ClosingFileReader(absolute);
        return candidate;
    }

    public Object buildModule(String name, Properties properties, Iterator sections, Iterator symbols, long loadAddress) {
        logger.fine("Module : " + name);
        if (this.isAIX) {
            int pos = name.indexOf(".a(");
            if (pos != -1 && name.lastIndexOf(41) == name.length() - 1) {
                this.moduleNames.add(name.substring(0, pos + 2));
            } else {
                this.moduleNames.add(name);
            }
        } else {
            this.moduleNames.add(name);
        }
        return null;
    }

    public Object buildProcess(Object addressSpace, String pid, String commandLine, Properties environment, Object currentThread, Iterator threads, Object executable, Iterator libraries, int addressSize) {
        if (logger.isLoggable(Level.FINEST)) {
            String msg = String.format("Building process %s : %s", pid, commandLine);
            logger.finest(msg);
        }
        return null;
    }

    public Object buildAddressSpace(String name, int id) {
        if (logger.isLoggable(Level.FINEST)) {
            String msg = String.format("Building address space %s[%d]", name, id);
            logger.finest(msg);
        }
        return null;
    }

    public Object buildRegister(String name, Number value) {
        return null;
    }

    public Object buildStackSection(Object addressSpace, long stackStart, long stackEnd) {
        return null;
    }

    public Object buildThread(String name, Iterator registers, Iterator stackSections, Iterator stackFrames, Properties properties, int signalNumber) {
        if (logger.isLoggable(Level.FINEST)) {
            String msg = String.format("Building thread %s [signal %d]", name, signalNumber);
            logger.finest(msg);
        }
        return null;
    }

    public Object buildModuleSection(Object addressSpace, String name, long imageStart, long imageEnd) {
        if (logger.isLoggable(Level.FINEST)) {
            String msg = String.format("Building module %s [0x%s - 0x%s]", name, Long.toHexString(imageStart), Long.toHexString(imageEnd));
            logger.finest(msg);
        }
        return null;
    }

    public Object buildStackFrame(Object addressSpace, long stackBasePointer, long pc) {
        return null;
    }

    public Object buildSymbol(Object addressSpace, String functionName, long relocatedFunctionAddress) {
        return null;
    }

    public Object buildCorruptData(Object addressSpace, String message, long address) {
        return null;
    }

    public long getEnvironmentAddress() {
        return 0L;
    }

    public long getValueOfNamedRegister(List registers, String string) {
        return 0L;
    }

    public void setExecutableUnavailable(String description) {
        this.errorMessages.add("Library collection not possible as the executable cannot be found [" + description + "]");
        if (logger.isLoggable(Level.FINEST)) {
            String msg = String.format("Executable not available : %s", description);
            logger.warning(msg);
        }
    }

    public void setOSType(String osType) {
        if (logger.isLoggable(Level.FINEST)) {
            String msg = String.format("OS Type : %s", osType);
            logger.finest(msg);
        }
    }

    public void setCPUType(String cpuType) {
    }

    public void setCPUSubType(String subType) {
    }

    public void setCreationTime(long millis) {
    }

    public Object buildModule(String name, Properties properties, Iterator sections, Iterator symbols) {
        if (logger.isLoggable(Level.FINEST)) {
            String msg = String.format("Building module %s", name);
            logger.finest(msg);
        }
        return null;
    }
}

