/*
 * Copyright (c) 2012, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_hr extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ssy = "saho";
        final Object[][] data = new Object[][] {
            { "ksh", "kelnski" },
            { "Ogam", "ogham pismo" },
            { "mwl", "mirandski" },
            { "Zsym", "simboli" },
            { "cch", "atsam" },
            { "mwr", "marwari" },
            { "Tagb", "tagbanwa pismo" },
            { "Zsye", "emotikoni" },
            { "%%NJIVA", "Gniva/Njiva dijalekt" },
            { "egy", "staroegipatski" },
            { "raj", "rajasthani" },
            { "Phag", "phags-pa pismo" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "rap", "rapa nui" },
            { "ter", "tereno" },
            { "AC", "Otok Ascension" },
            { "rar", "raroton\u0161ki" },
            { "tet", "tetum" },
            { "AD", "Andora" },
            { "AE", "Ujedinjeni Arapski Emirati" },
            { "nl_BE", "flamanski" },
            { "AF", "Afganistan" },
            { "AG", "Antigva i Barbuda" },
            { "type.ca.ethiopic", "etiopski kalendar" },
            { "AI", "Angvila" },
            { "key.tz", "Vremenska zona" },
            { "AL", "Albanija" },
            { "AM", "Armenija" },
            { "Teng", "tengwar pismo" },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "AR", "Argentina" },
            { "Prti", "pisani parthian" },
            { "AS", "Ameri\u010dka Samoa" },
            { "AT", "Austrija" },
            { "AU", "Australija" },
            { "AW", "Aruba" },
            { "en_US", "ameri\u010dki engleski" },
            { "AX", "\u00c5landski otoci" },
            { "mye", "myene" },
            { "AZ", "Azerbajd\u017ean" },
            { "%%AREVELA", "isto\u010dno-armenijski" },
            { "BA", "Bosna i Hercegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuano" },
            { "BD", "Banglade\u0161" },
            { "kum", "kumyk" },
            { "BE", "Belgija" },
            { "gmh", "srednjogornjonjema\u010dki" },
            { "BF", "Burkina Faso" },
            { "BG", "Bugarska" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermudi" },
            { "kut", "kutenai" },
            { "myv", "mordvinski" },
            { "BN", "Brunej" },
            { "BO", "Bolivija" },
            { "BQ", "Karipski otoci Nizozemske" },
            { "BR", "Brazil" },
            { "BS", "Bahami" },
            { "xog", "soga" },
            { "BT", "Butan" },
            { "BV", "Otok Bouvet" },
            { "BW", "Bocvana" },
            { "BY", "Bjelorusija" },
            { "BZ", "Belize" },
            { "Visp", "Visible Speech" },
            { "type.ca.persian", "perzijski kalendar" },
            { "type.nu.hebr", "hebrejski brojevi" },
            { "CA", "Kanada" },
            { "CC", "Kokosovi (Keelingovi) otoci" },
            { "mzn", "mazanderanski" },
            { "CD", "Kongo - Kinshasa" },
            { "CF", "Srednjoafri\u010dka Republika" },
            { "CG", "Kongo - Brazzaville" },
            { "CH", "\u0160vicarska" },
            { "CI", "Obala Bjelokosti" },
            { "CK", "Cookovi Otoci" },
            { "CL", "\u010cile" },
            { "Kthi", "kaithi pismo" },
            { "CM", "Kamerun" },
            { "CN", "Kina" },
            { "CO", "Kolumbija" },
            { "CP", "Otok Clipperton" },
            { "CR", "Kostarika" },
            { "CU", "Kuba" },
            { "CV", "Zelenortska Republika" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Bo\u017ei\u0107ni otok" },
            { "CY", "Cipar" },
            { "CZ", "\u010ce\u0161ka" },
            { "eka", "ekajuk" },
            { "DE", "Njema\u010dka" },
            { "goh", "starovisokonjema\u010dki" },
            { "ace", "a\u010dinski" },
            { "cgg", "chiga" },
            { "DG", "Diego Garcia" },
            { "type.nu.deva", "znamenke pisma devanagari" },
            { "DJ", "D\u017eibuti" },
            { "DK", "Danska" },
            { "ach", "a\u010doli" },
            { "gon", "gondi" },
            { "Brai", "brajica" },
            { "Brah", "brahmi pismo" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "mali armenski brojevi" },
            { "DO", "Dominikanska Republika" },
            { "gor", "gorontalo" },
            { "got", "gotski" },
            { "Mtei", "meitei mayek pismo" },
            { "zun", "zuni" },
            { "tig", "tigri\u0161ki" },
            { "Takr", "takri pismo" },
            { "DZ", "Al\u017eir" },
            { "pag", "pangasinan" },
            { "type.d0.hwidth", "Uski" },
            { "pal", "pahlavi" },
            { "EA", "Ceuta i Melilla" },
            { "chb", "\u010dib\u010da" },
            { "pam", "pampanga" },
            { "EC", "Ekvador" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "Estonija" },
            { "tiv", "tiv" },
            { "EG", "Egipat" },
            { "EH", "Zapadna Sahara" },
            { "chg", "\u010dagatajski" },
            { "pau", "palauanski" },
            { "chk", "chuukese" },
            { "chn", "chinook \u017eargon" },
            { "chm", "marijski" },
            { "chp", "chipewyan" },
            { "cho", "choctaw" },
            { "chr", "\u010derokijski" },
            { "ER", "Eritreja" },
            { "ES", "\u0160panjolska" },
            { "ET", "Etiopija" },
            { "EU", "Europska unija" },
            { "elx", "elamitski" },
            { "type.ca.gregorian", "gregorijanski kalendar" },
            { "EZ", "eurozona" },
            { "chy", "\u010dejenski" },
            { "type.nu.gujr", "gud\u017earatske znamenke" },
            { "Inds", "indijsko pismo" },
            { "ady", "adigejski" },
            { "FI", "Finska" },
            { "FJ", "Fid\u017ei" },
            { "FK", "Falklandski otoci" },
            { "FM", "Mikronezija" },
            { "key.va", "Varijanta zemlje/jezika" },
            { "FO", "Farski otoci" },
            { "Taml", "tamilsko pismo" },
            { "FR", "Francuska" },
            { "Kpel", "kpelle pismo" },
            { "tkl", "tokelaunski" },
            { "grb", "grebo" },
            { "root", "korijenski" },
            { "type.ca.indian", "indijski nacionalni kalendar" },
            { "grc", "starogr\u010dki" },
            { "GA", "Gabon" },
            { "vot", "votski" },
            { "GB", "Ujedinjeno Kraljevstvo" },
            { "pcm", "nigerijski pid\u017ein" },
            { "GD", "Grenada" },
            { "GE", "Gruzija" },
            { "GF", "Francuska Gijana" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "Tale", "tai le pismo" },
            { "GI", "Gibraltar" },
            { "afh", "afrihili" },
            { "GL", "Grenland" },
            { "enm", "srednjoengleski" },
            { "GM", "Gambija" },
            { "GN", "Gvineja" },
            { "GP", "Guadalupe" },
            { "GQ", "Ekvatorska Gvineja" },
            { "GR", "Gr\u010dka" },
            { "GS", "Ju\u017ena Georgija i Ju\u017eni Sendvi\u010dki Otoci" },
            { "GT", "Gvatemala" },
            { "GU", "Guam" },
            { "GW", "Gvineja Bisau" },
            { "tli", "tlingit" },
            { "tlh", "klingonski" },
            { "Talu", "novo tai lue pismo" },
            { "GY", "Gvajana" },
            { "ckb", "soranski kurdski" },
            { "zxx", "bez jezi\u010dnog sadr\u017eaja" },
            { "Jurc", "jurchen pismo" },
            { "de_AT", "austrijski njema\u010dki" },
            { "HK", "PUP Hong Kong Kina" },
            { "Vaii", "vai pismo" },
            { "HM", "Otoci Heard i McDonald" },
            { "HN", "Honduras" },
            { "HR", "Hrvatska" },
            { "agq", "aghem" },
            { "gsw", "\u0161vicarski njema\u010dki" },
            { "type.ca.islamic-umalqura", "islamski kalendar (Umm al-Qura)" },
            { "HT", "Haiti" },
            { "HU", "Ma\u0111arska" },
            { "tmh", "tama\u0161e\u010dki" },
            { "IC", "Kanarski otoci" },
            { "nan", "min nan kineski" },
            { "ID", "Indonezija" },
            { "peo", "staroperzijski" },
            { "IE", "Irska" },
            { "nap", "napolitanski" },
            { "naq", "nama" },
            { "zza", "zazaki" },
            { "Tang", "tangut pismo" },
            { "IL", "Izrael" },
            { "Nbat", "nabatejsko pismo" },
            { "IM", "Otok Man" },
            { "IN", "Indija" },
            { "type.co.eor", "Europska pravila razvrstavanja" },
            { "IO", "Britanski Indijskooceanski teritorij" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italija" },
            { "Zmth", "matemati\u010dko znakovlje" },
            { "type.nu.thai", "tajske znamenke" },
            { "%%POSIX", "Ra\u010dunalo" },
            { "type.nu.beng", "znamenke bengalskog pisma" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "islamski kalendar" },
            { "JM", "Jamajka" },
            { "Beng", "bengalsko pismo" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "%%1606NICT", "kasni srednjofrancuski do 1606." },
            { "ain", "ainuski" },
            { "Mend", "mende pismo" },
            { "guz", "gusii" },
            { "tog", "nyasa tonga" },
            { "type.nu.knda", "znamenke pisma kannada" },
            { "Kali", "kayah li pismo" },
            { "de_CH", "gornjonjema\u010dki (\u0161vicarski)" },
            { "type.co.phonetic", "Fonetski poredak" },
            { "type.ca.buddhist", "budisti\u010dki kalendar" },
            { "KE", "Kenija" },
            { "419", "Latinska Amerika" },
            { "KG", "Kirgistan" },
            { "KH", "Kambod\u017ea" },
            { "KI", "Kiribati" },
            { "KM", "Komori" },
            { "KN", "Sveti Kristofor i Nevis" },
            { "Knda", "kannada pismo" },
            { "Zinh", "nasljedno pismo" },
            { "fr_CA", "kanadski francuski" },
            { "KP", "Sjeverna Koreja" },
            { "KR", "Ju\u017ena Koreja" },
            { "Plrd", "pollard fonetsko pismo" },
            { "fr_CH", "\u0161vicarski francuski" },
            { "KW", "Kuvajt" },
            { "tpi", "tok pisin" },
            { "KY", "Kajmanski otoci" },
            { "KZ", "Kazahstan" },
            { "Cyrl", "\u0107irilica" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "Sveta Lucija" },
            { "phn", "feni\u010dki" },
            { "Cyrs", "staroslavenska crkvena \u010dirilica" },
            { "gwi", "gwich\u2019in" },
            { "nds", "donjonjema\u010dki" },
            { "LI", "Lihten\u0161tajn" },
            { "LK", "\u0160ri Lanka" },
            { "akk", "akadski" },
            { "cop", "koptski" },
            { "LR", "Liberija" },
            { "LS", "Lesoto" },
            { "Phlv", "pahlavi pismo" },
            { "LT", "Litva" },
            { "LU", "Luksemburg" },
            { "LV", "Latvija" },
            { "Kana", "katakana pismo" },
            { "Sora", "sora sompeng pismo" },
            { "LY", "Libija" },
            { "lad", "ladino" },
            { "vun", "vunjo" },
            { "lah", "lahnda" },
            { "lag", "langi" },
            { "Thaa", "thaana pismo" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Moldavija" },
            { "Nshu", "nushu pismo" },
            { "ME", "Crna Gora" },
            { "MF", "Saint Martin" },
            { "lam", "lamba" },
            { "MG", "Madagaskar" },
            { "MH", "Mar\u0161alovi Otoci" },
            { "ale", "aleutski" },
            { "Thai", "tajsko pismo" },
            { "type.nu.vaii", "Vai znamenke" },
            { "MK", "Makedonija" },
            { "ML", "Mali" },
            { "MM", "Mjanmar (Burma)" },
            { "MN", "Mongolija" },
            { "new", "newari" },
            { "MO", "PUP Makao Kina" },
            { "MP", "Sjevernomarijanski otoci" },
            { "MQ", "Martinique" },
            { "MR", "Mauretanija" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "type.m0.ungegn", "transliteracija prema UNGEGN-u" },
            { "MU", "Mauricijus" },
            { "alt", "ju\u017eni altai" },
            { "MV", "Maldivi" },
            { "MW", "Malavi" },
            { "MX", "Meksiko" },
            { "type.ca.japanese", "japanski kalendar" },
            { "MY", "Malezija" },
            { "MZ", "Mozambik" },
            { "Phli", "pisani pahlavi" },
            { "NA", "Namibija" },
            { "202", "Subsaharska Afrika" },
            { "type.ca.hebrew", "hebrejski kalendar" },
            { "type.co.dictionary", "rje\u010dni\u010dko razvrstavanje" },
            { "NC", "Nova Kaledonija" },
            { "%%WADEGILE", "Wade-Giles romanizacija" },
            { "%%UCRCOR", "ujedna\u010dena revidirana ortografija" },
            { "NE", "Niger" },
            { "NF", "Otok Norfolk" },
            { "NG", "Nigerija" },
            { "trv", "taroko" },
            { "Phlp", "psalter pahlavi" },
            { "NI", "Nikaragva" },
            { "Hmng", "pahawh hmong pismo" },
            { "NL", "Nizozemska" },
            { "NO", "Norve\u0161ka" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "Phnx", "feni\u010dko pismo" },
            { "rof", "rombo" },
            { "tsi", "tsimshian" },
            { "NZ", "Novi Zeland" },
            { "Merc", "meroitski kurziv" },
            { "rom", "romski" },
            { "Mero", "meroitic pismo" },
            { "crh", "krimski turski" },
            { "ang", "staroengleski" },
            { "OM", "Oman" },
            { "anp", "angika" },
            { "crs", "sej\u0161elski kreolski" },
            { "Xpeo", "staro perzijsko pismo" },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "islamski civilni kalendar" },
            { "csb", "ka\u0161upski" },
            { "en_GB", "britanski engleski" },
            { "PE", "Peru" },
            { "PF", "Francuska Polinezija" },
            { "PG", "Papua Nova Gvineja" },
            { "PH", "Filipini" },
            { "PK", "Pakistan" },
            { "PL", "Poljska" },
            { "ewo", "ewondo" },
            { "PM", "Sveti Petar i Mikelon" },
            { "PN", "Otoci Pitcairn" },
            { "PR", "Portoriko" },
            { "PS", "Palestinsko podru\u010dje" },
            { "Bali", "balijsko pismo" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "type.nu.greklow", "mali gr\u010dki brojevi" },
            { "PY", "Paragvaj" },
            { "tum", "tumbuka" },
            { "Hebr", "hebrejsko pismo" },
            { "QA", "Katar" },
            { "%%SCOTLAND", "\u0161kotski standardni engleski" },
            { "niu", "niujski" },
            { "QO", "Vanjska podru\u010dja Oceanije" },
            { "lez", "lezgi\u0161ki" },
            { "%%FONUPA", "UPA fonetika" },
            { "tvl", "tuvaluanski" },
            { "Tavt", "tai viet pismo" },
            { "001", "Svijet" },
            { "002", "Afrika" },
            { "003", "Sjevernoameri\u010dki kontinent" },
            { "RE", "R\u00e9union" },
            { "005", "Ju\u017ena Amerika" },
            { "jbo", "lojban" },
            { "Rjng", "rejang pismo" },
            { "009", "Oceanija" },
            { "RO", "Rumunjska" },
            { "RS", "Srbija" },
            { "Mroo", "mro pismo" },
            { "RU", "Rusija" },
            { "RW", "Ruanda" },
            { "%%METELKO", "metel\u010dica" },
            { "Mani", "manihejsko pismo" },
            { "Ugar", "ugaritsko pismo" },
            { "Khar", "kharoshthi pismo" },
            { "SA", "Saudijska Arabija" },
            { "pon", "pohnpeian" },
            { "Mand", "mandai pismo" },
            { "SB", "Salomonski Otoci" },
            { "twq", "tasawaq" },
            { "011", "Zapadna Afrika" },
            { "SC", "Sej\u0161eli" },
            { "SD", "Sudan" },
            { "013", "Centralna Amerika" },
            { "SE", "\u0160vedska" },
            { "014", "Isto\u010dna Afrika" },
            { "arc", "aramejski" },
            { "Loma", "loma pismo" },
            { "015", "Sjeverna Afrika" },
            { "SG", "Singapur" },
            { "SH", "Sveta Helena" },
            { "type.lb.strict", "strogi stil prijeloma retka" },
            { "017", "Sredi\u0161nja Afrika" },
            { "SI", "Slovenija" },
            { "018", "Ju\u017ena Afrika" },
            { "SJ", "Svalbard i Jan Mayen" },
            { "019", "Amerike" },
            { "SK", "Slova\u010dka" },
            { "Bamu", "bamum pismo" },
            { "Wole", "woleai pismo" },
            { "SL", "Sijera Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalija" },
            { "arn", "mapuche" },
            { "arp", "arapaho" },
            { "type.nu.taml", "tamilski brojevi" },
            { "SR", "Surinam" },
            { "SS", "Ju\u017eni Sudan" },
            { "ST", "Sveti Toma i Princip" },
            { "SV", "Salvador" },
            { "ars", "najdi arapski" },
            { "SX", "Sint Maarten" },
            { "SY", "Sirija" },
            { "yao", "yao" },
            { "SZ", "Svazi" },
            { "arw", "arava\u010dki" },
            { "yap", "japski" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "type.ms.ussystem", "ameri\u010dki sustav mjera" },
            { "021", "Sjeverna Amerika" },
            { "TC", "Otoci Turks i Caicos" },
            { "yav", "yangben" },
            { "TD", "\u010cad" },
            { "TF", "Francuski ju\u017eni i antarkti\u010dki teritoriji" },
            { "TG", "Togo" },
            { "TH", "Tajland" },
            { "TJ", "Tad\u017eikistan" },
            { "029", "Karibi" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "ybb", "yemba" },
            { "type.co.searchjl", "Pretra\u017eivanje po po\u010detnom suglasniku hangula" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "boontling" },
            { "TN", "Tunis" },
            { "TO", "Tonga" },
            { "%%NULIK", "moderni volapuk" },
            { "TR", "Turska" },
            { "TT", "Trinidad i Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tajvan" },
            { "ast", "asturijski" },
            { "Orkh", "orkhon pismo" },
            { "TZ", "Tanzanija" },
            { "nmg", "kwasio" },
            { "Zzzz", "nepoznato pismo" },
            { "Sind", "khudawadi pismo" },
            { "UA", "Ukrajina" },
            { "rup", "aromunski" },
            { "030", "Isto\u010dna Azija" },
            { "tyv", "tuvinski" },
            { "sw_CD", "kongoanski svahili" },
            { "034", "Ju\u017ena Azija" },
            { "hai", "haidi" },
            { "035", "Jugoisto\u010dna Azija" },
            { "UG", "Uganda" },
            { "hak", "hakka kineski" },
            { "type.co.pinyin", "Pinyin razvrstavanje" },
            { "039", "Ju\u017ena Europa" },
            { "Sinh", "sinhale\u0161ko pismo" },
            { "UM", "Mali udaljeni otoci SAD-a" },
            { "UN", "Ujedinjeni narodi" },
            { "US", "Sjedinjene Ameri\u010dke Dr\u017eave" },
            { "haw", "havajski" },
            { "%%1959ACAD", "akademski" },
            { "type.co.gb2312han", "razvrstavanje prema pojednostavljenom kineskom - GB2312" },
            { "UY", "Urugvaj" },
            { "prg", "pruski" },
            { "UZ", "Uzbekistan" },
            { "tzm", "tama\u0161ek (Srednji Atlas)" },
            { "type.co.stroke", "razvrstavanje po redoslijedu poteza za kineski" },
            { "nnh", "ngiemboon" },
            { "VA", "Vatikanski Grad" },
            { "pro", "staroprovansalski" },
            { "VC", "Sveti Vincent i Grenadini" },
            { "VE", "Venezuela" },
            { "VG", "Britanski Djevi\u010danski otoci" },
            { "VI", "Ameri\u010dki Djevi\u010danski otoci" },
            { "VN", "Vijetnam" },
            { "VU", "Vanuatu" },
            { "nog", "nogajski" },
            { "rwk", "rwa" },
            { "non", "staronorve\u0161ki" },
            { "053", "Australazija" },
            { "%%AREVMDA", "zapadno-armenijski" },
            { "054", "Melanezija" },
            { "WF", "Wallis i Futuna" },
            { "type.co.traditional", "tradicionalno razvrstavanje" },
            { "057", "Mikronezijsko podru\u010dje" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "type.nu.finance", "Financijski brojevi" },
            { "type.co.compat", "Prethodni redoslijed razvrstavanja, radi kompatibilnosti" },
            { "wae", "walserski" },
            { "WS", "Samoa" },
            { "Bass", "bassa vah pismo" },
            { "wal", "walamo" },
            { "was", "washo" },
            { "war", "waray" },
            { "awa", "awadhi" },
            { "061", "Polinezija" },
            { "%%KSCOR", "standardna ortografija" },
            { "XK", "Kosovo" },
            { "Gujr", "gud\u017earatsko pismo" },
            { "Zxxx", "jezik bez pismenosti" },
            { "Olck", "ol chiki pismo" },
            { "wbp", "warlpiri" },
            { "Batk", "batak pismo" },
            { "Blis", "blissymbols" },
            { "YE", "Jemen" },
            { "nqo", "n\u2019ko" },
            { "type.co.standard", "Standardno razvrstavanje" },
            { "fan", "fang" },
            { "%%ROZAJ", "resian" },
            { "fat", "fanti" },
            { "Sgnw", "znakovno pismo" },
            { "YT", "Mayotte" },
            { "ZA", "Ju\u017enoafri\u010dka Republika" },
            { "type.lb.loose", "slobodni stil prijeloma retka" },
            { "Deva", "devangari pismo" },
            { "type.nu.geor", "gruzijski brojevi" },
            { "type.co.zhuyin", "zhuyin razvrstavanje" },
            { "Hira", "hiragana pismo" },
            { "ZM", "Zambija" },
            { "%%PINYIN", "Pinyin romanizacija" },
            { "ZW", "Zimbabve" },
            { "ZZ", "nepoznato podru\u010dje" },
            { "Runr", "runsko pismo" },
            { "type.ms.metric", "metri\u010dki sustav" },
            { "type.ca.iso8601", "ISO-8601 kalendar" },
            { "lol", "mongo" },
            { "nso", "sjeverni sotski" },
            { "type.nu.telu", "znamenke telu\u0161kog pisma" },
            { "lou", "lujzijanski kreolski" },
            { "loz", "lozi" },
            { "Nkgb", "naxi geba pismo" },
            { "jmc", "machame" },
            { "type.nu.hansfin", "pojednostavljeni kineski financijski brojevi" },
            { "hil", "hiligaynonski" },
            { "type.nu.arabext", "pro\u0161irene arapsko-indijske znamenke" },
            { "nus", "nuerski" },
            { "dak", "dakota jezik" },
            { "type.nu.fullwide", "\u0161iroke znamenke" },
            { "hit", "hetitski" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "Maya", "majanski hijeroglifi" },
            { "lrc", "sjevernolurski" },
            { "Copt", "koptsko pismo" },
            { "nwc", "klasi\u010dni newari" },
            { "udm", "udmurtski" },
            { "Khmr", "kmersko pismo" },
            { "Limb", "limbu pismo" },
            { "sad", "sandawe" },
            { "type.nu.roman", "rimski brojevi" },
            { "sah", "jakutski" },
            { "sam", "samarijanski aramejski" },
            { "%%SCOUSE", "scouse" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santalski" },
            { "Tfng", "tifinar" },
            { "jpr", "judejsko-perzijski" },
            { "type.d0.npinyin", "Numeri\u010dki" },
            { "type.nu.native", "Izvorne znamenke" },
            { "sba", "ngambay" },
            { "Guru", "gurmukhi pismo" },
            { "%%ALUKU", "aluku dijalekt" },
            { "lua", "luba-lulua" },
            { "type.d0.fwidth", "\u0160iroki" },
            { "sbp", "sangu" },
            { "lui", "luiseno" },
            { "nyn", "nyankole" },
            { "nym", "nyamwezi" },
            { "lun", "lunda" },
            { "nyo", "nyoro" },
            { "luo", "luo" },
            { "fil", "filipinski" },
            { "hmn", "hmong" },
            { "del", "delavarski" },
            { "lus", "lushai" },
            { "bal", "belu\u010dki" },
            { "den", "slave" },
            { "ban", "balijski" },
            { "uga", "ugaritski" },
            { "luy", "luyia" },
            { "bas", "basa" },
            { "bax", "bamunski" },
            { "jrb", "judejsko-arapski" },
            { "es_ES", "europski \u0161panjolski" },
            { "nzi", "nzima" },
            { "sco", "\u0161kotski" },
            { "scn", "sicilijski" },
            { "aa", "afarski" },
            { "ab", "abhaski" },
            { "ae", "avesti\u010dki" },
            { "af", "afrikaans" },
            { "ak", "akanski" },
            { "bbj", "ghomala" },
            { "am", "amharski" },
            { "an", "aragonski" },
            { "Arab", "arapsko pismo" },
            { "%%SOLBA", "stolvizza/solbica dijalekt" },
            { "Jpan", "japansko pismo" },
            { "ar", "arapski" },
            { "Hrkt", "japansko slogovno pismo" },
            { "as", "asamski" },
            { "Lina", "linear A pismo" },
            { "av", "avarski" },
            { "Linb", "linear B pismo" },
            { "sdh", "ju\u017enokurdski" },
            { "ay", "ajmarski" },
            { "az", "azerbajd\u017eanski" },
            { "Khoj", "khojki pismo" },
            { "%%OSOJS", "oseacco/osojane dijalekt" },
            { "ba", "ba\u0161kirski" },
            { "type.co.unihan", "razvrstavanje prema korijenu i potezu" },
            { "be", "bjeloruski" },
            { "bg", "bugarski" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bangla" },
            { "bo", "tibetski" },
            { "dgr", "dogrib" },
            { "br", "bretonski" },
            { "bs", "bosanski" },
            { "see", "seneca" },
            { "Mymr", "mjanmarsko pismo" },
            { "type.nu.laoo", "laoske znamenke" },
            { "seh", "sena" },
            { "Nkoo", "n\u2019ko pismo" },
            { "sel", "selkupski" },
            { "ca", "katalonski" },
            { "ses", "koyraboro senni" },
            { "ce", "\u010de\u010denski" },
            { "ch", "chamorro" },
            { "%%REVISED", "izmijenjen pravopis" },
            { "co", "korzi\u010dki" },
            { "Orya", "orijsko pismo" },
            { "cr", "cree" },
            { "cs", "\u010de\u0161ki" },
            { "cu", "crkvenoslavenski" },
            { "cv", "\u010duva\u0161ki" },
            { "cy", "vel\u0161ki" },
            { "type.nu.ethi", "etiopski brojevi" },
            { "Yiii", "Yi pismo" },
            { "da", "danski" },
            { "pt_PT", "europski portugalski" },
            { "de", "njema\u010dki" },
            { "type.cf.standard", "Standardni format valute" },
            { "bej", "beja" },
            { "din", "dinka" },
            { "Bugi", "buginsko pismo" },
            { "bem", "bemba" },
            { "sga", "staroirski" },
            { "type.nu.mong", "Mongolske znamenke" },
            { "dv", "divehi" },
            { "es_419", "latinoameri\u010dki \u0161panjolski" },
            { "dz", "dzongkha" },
            { "bez", "bena" },
            { "type.ca.chinese", "kineski kalendar" },
            { "Lisu", "fraser pismo" },
            { "dje", "zarma" },
            { "type.nu.grek", "gr\u010dki brojevi" },
            { "ee", "ewe" },
            { "bfd", "bafut" },
            { "type.lb.normal", "normalni stil prijeloma retka" },
            { "ro_MD", "moldavski" },
            { "el", "gr\u010dki" },
            { "en", "engleski" },
            { "eo", "esperanto" },
            { "type.co.big5han", "razvrstavanje prema tradicionalnom kineskom - Big5" },
            { "es", "\u0161panjolski" },
            { "et", "estonski" },
            { "Hanb", "hanb pismo" },
            { "eu", "baskijski" },
            { "Buhd", "buhid pismo" },
            { "Hang", "hangul pismo" },
            { "Samr", "samaritansko pismo" },
            { "shi", "tachelhit" },
            { "hsb", "gornjolu\u017ei\u010dki" },
            { "Hani", "hansko pismo" },
            { "shn", "shan" },
            { "Hano", "hanunoo pismo" },
            { "fa", "perzijski" },
            { "Hans", "pojednostavljeno pismo" },
            { "type.nu.latn", "arapski brojevi" },
            { "Hant", "tradicionalno pismo" },
            { "az_Arab", "ju\u017enoazerbajd\u017eanski" },
            { "ff", "fula" },
            { "shu", "\u010dadski arapski" },
            { "hsn", "xiang kineski" },
            { "fi", "finski" },
            { "fj", "fid\u017eijski" },
            { "fon", "fon" },
            { "bgn", "zapadnobalud\u017eijski" },
            { "yue", "kantonski" },
            { "fo", "ferojski" },
            { "type.m0.bgn", "transliteracija prema BGN-u" },
            { "umb", "umbundu" },
            { "fr", "francuski" },
            { "sid", "sidamo" },
            { "fy", "zapadnofrizijski" },
            { "ga", "irski" },
            { "gd", "\u0161kotski gaelski" },
            { "gl", "galicijski" },
            { "gn", "gvaranski" },
            { "bho", "bhojpuri" },
            { "und", "nepoznati jezik" },
            { "type.ca.ethiopic-amete-alem", "Etiopski kalendar \"Amete Alem\"" },
            { "gu", "gud\u017earatski" },
            { "gv", "manski" },
            { "ha", "hausa" },
            { "he", "hebrejski" },
            { "hi", "hindski" },
            { "hup", "hupa" },
            { "bik", "bikolski" },
            { "bin", "bini" },
            { "ho", "hiri motu" },
            { "hr", "hrvatski" },
            { "ht", "hai\u0107anski kreolski" },
            { "hu", "ma\u0111arski" },
            { "hy", "armenski" },
            { "hz", "herero" },
            { "frc", "kajunski francuski" },
            { "%%FONIPA", "IPA fonetika" },
            { "ia", "interlingua" },
            { "Jamo", "jamo pismo" },
            { "id", "indonezijski" },
            { "type.nu.tibt", "tibetske znamenke" },
            { "ie", "interligua" },
            { "ig", "igbo" },
            { "ii", "sichuan ji" },
            { "frm", "srednjofrancuski" },
            { "ik", "inupiaq" },
            { "fro", "starofrancuski" },
            { "io", "ido" },
            { "frs", "isto\u010dnofrizijski" },
            { "frr", "sjevernofrizijski" },
            { "is", "islandski" },
            { "it", "talijanski" },
            { "iu", "inuktitut" },
            { "ja", "japanski" },
            { "Mlym", "malajalamsko pismo" },
            { "Sarb", "staro ju\u017enoarapsko pismo" },
            { "Sara", "sarati pismo" },
            { "doi", "dogri" },
            { "bkm", "kom" },
            { "sma", "ju\u017eni sami" },
            { "jv", "javanski" },
            { "Shaw", "shavian pismo" },
            { "mad", "madurski" },
            { "smj", "lule sami" },
            { "mag", "magahi" },
            { "maf", "mafa" },
            { "mai", "maithili" },
            { "smn", "inari sami" },
            { "ka", "gruzijski" },
            { "bla", "siksika" },
            { "mak", "makasar" },
            { "wuu", "wu kineski" },
            { "sms", "skolt sami" },
            { "man", "mandingo" },
            { "kg", "kongo" },
            { "Goth", "goti\u010dko pismo" },
            { "ki", "kikuyu" },
            { "mas", "masajski" },
            { "kj", "kuanyama" },
            { "kk", "kaza\u0161ki" },
            { "kl", "kalaallisut" },
            { "km", "kmerski" },
            { "kn", "karnata\u010dki" },
            { "ko", "korejski" },
            { "kr", "kanuri" },
            { "ks", "ka\u0161mirski" },
            { "Cirt", "cirth pismo" },
            { "Lepc", "lepcha pismo" },
            { "Avst", "avestansko pismo" },
            { "ku", "kurdski" },
            { "kv", "komi" },
            { "kw", "kornski" },
            { "ky", "kirgiski" },
            { "snk", "soninke" },
            { "la", "latinski" },
            { "lb", "luksembur\u0161ki" },
            { "type.nu.mlym", "malajalamske znamenke" },
            { "lg", "ganda" },
            { "Roro", "rongorongo pismo" },
            { "li", "limbur\u0161ki" },
            { "Tibt", "tibetansko pismo" },
            { "ln", "lingala" },
            { "fur", "furlanski" },
            { "lo", "laoski" },
            { "type.ms.uksystem", "imperijalni sustav mjera" },
            { "lt", "litavski" },
            { "lu", "luba-katanga" },
            { "lv", "latvijski" },
            { "sog", "sogdien" },
            { "mg", "malga\u0161ki" },
            { "mh", "mar\u0161alski" },
            { "type.co.ducet", "Standardno Unicode razvrstavanje" },
            { "mi", "maorski" },
            { "mk", "makedonski" },
            { "ml", "malajalamski" },
            { "mn", "mongolski" },
            { "mr", "marathski" },
            { "ms", "malajski" },
            { "mt", "malte\u0161ki" },
            { "my", "burmanski" },
            { "Saur", "saurashtra pismo" },
            { "Armn", "armensko pismo" },
            { "mdf", "moksha" },
            { "mde", "maba" },
            { "dsb", "donjolu\u017ei\u010dki" },
            { "Armi", "aramejsko pismo" },
            { "na", "nauru" },
            { "type.co.search", "Op\u0107enito pretra\u017eivanje" },
            { "nb", "norve\u0161ki bokm\u00e5l" },
            { "nd", "sjeverni ndebele" },
            { "ne", "nepalski" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "nizozemski" },
            { "nn", "norve\u0161ki nynorsk" },
            { "no", "norve\u0161ki" },
            { "nr", "ju\u017eni ndebele" },
            { "nv", "navajo" },
            { "kaa", "kara-kalpak" },
            { "ny", "njand\u017ea" },
            { "kac", "ka\u010dinski" },
            { "kab", "kabilski" },
            { "%%POLYTON", "politono" },
            { "oc", "okcitanski" },
            { "kaj", "kaje" },
            { "kam", "kamba" },
            { "men", "mende" },
            { "%%EMODENG", "rani moderni engleski" },
            { "oj", "ojibwa" },
            { "mer", "meru" },
            { "type.nu.armn", "armenski brojevi" },
            { "om", "oromski" },
            { "kaw", "kawi" },
            { "or", "orijski" },
            { "os", "osetski" },
            { "kbd", "kabardinski" },
            { "mfe", "mauricijski kreolski" },
            { "srn", "sranan tongo" },
            { "pa", "pand\u017eapski" },
            { "dua", "duala" },
            { "srr", "serer" },
            { "%%LIPAW", "lipova\u010dki dijalekt resian jezika" },
            { "kbl", "kanembu" },
            { "pi", "pali" },
            { "pl", "poljski" },
            { "dum", "srednjonizozemski" },
            { "type.ca.dangi", "dangi kalendar" },
            { "ps", "pa\u0161tunski" },
            { "pt", "portugalski" },
            { "mga", "srednjoirski" },
            { "key.co", "Redoslijed razvrstavanja" },
            { "pt_BR", "brazilski portugalski" },
            { "kcg", "tyap" },
            { "mgh", "makhuwa-meetto" },
            { "key.cf", "Format valute" },
            { "bra", "braj" },
            { "key.ca", "kalendar" },
            { "Laoo", "laosko pismo" },
            { "mgo", "meta\u2019" },
            { "type.hc.h23", "24-satni format (0-23)" },
            { "type.hc.h24", "24-satni format (1-24)" },
            { "ssy", metaValue_ssy },
            { "type.nu.mymr", "mijanmarske znamenke" },
            { "qu", "ke\u010duanski" },
            { "zap", "zapote\u010dki" },
            { "brx", "bodo" },
            { "Lana", "lanna pismo" },
            { "kde", "makonde" },
            { "Ethi", "etiopsko pismo" },
            { "type.hc.h12", "12-satni format (1-12)" },
            { "type.hc.h11", "12-satni format (0-11)" },
            { "rm", "retoromanski" },
            { "rn", "rundi" },
            { "key.cu", "valuta" },
            { "ro", "rumunjski" },
            { "%%SAAHO", metaValue_ssy },
            { "type.nu.orya", "orijske znamenke" },
            { "type.nu.hanidec", "kineski decimalni brojevi" },
            { "ru", "ruski" },
            { "bss", "akoose" },
            { "rw", "kinyarwanda" },
            { "zbl", "Blissovi simboli" },
            { "kea", "zelenortski" },
            { "mic", "micmac" },
            { "suk", "sukuma" },
            { "en_AU", "australski engleski" },
            { "sa", "sanskrtski" },
            { "%%UCCOR", "ujedna\u010dena ortografija" },
            { "sc", "sardski" },
            { "sus", "susu" },
            { "sd", "sindski" },
            { "se", "sjeverni sami" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "sh", "srpsko-hrvatski" },
            { "si", "sinhale\u0161ki" },
            { "sux", "sumerski" },
            { "sk", "slova\u010dki" },
            { "sl", "slovenski" },
            { "Gran", "grantha pismo" },
            { "sm", "samoanski" },
            { "sn", "shona" },
            { "so", "somalski" },
            { "type.nu.arab", "arapsko-indijske znamenke" },
            { "sq", "albanski" },
            { "sr", "srpski" },
            { "ss", "svati" },
            { "type.cf.account", "Ra\u010dunovodstveni format valute" },
            { "st", "sesotski" },
            { "Java", "javansko pismo" },
            { "su", "sundanski" },
            { "%%NEDIS", "natisone dijalekt" },
            { "sv", "\u0161vedski" },
            { "sw", "svahili" },
            { "type.nu.hantfin", "tradicionalni kineski financijski brojevi" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", "tamilski" },
            { "142", "Azija" },
            { "bua", "burjatski" },
            { "143", "Srednja Azija" },
            { "te", "telu\u0161ki" },
            { "145", "Zapadna Azija" },
            { "tg", "tad\u017ei\u010dki" },
            { "th", "tajlandski" },
            { "ti", "tigrinja" },
            { "bug", "buginski" },
            { "kfo", "koro" },
            { "en_CA", "kanadski engleski" },
            { "tk", "turkmenski" },
            { "tl", "tagalog" },
            { "tn", "cvana" },
            { "to", "tonganski" },
            { "bum", "bulu" },
            { "dyo", "jola-fonyi" },
            { "type.nu.jpan", "japanski brojevi" },
            { "tr", "turski" },
            { "ts", "tsonga" },
            { "swb", "komorski" },
            { "Cakm", "chakma pismo" },
            { "tt", "tatarski" },
            { "dyu", "dyula" },
            { "tw", "twi" },
            { "ty", "tahi\u0107anski" },
            { "%%BISKE", "san giorgio/bila dijalekt" },
            { "150", "Europa" },
            { "151", "Isto\u010dna Europa" },
            { "154", "Sjeverna Europa" },
            { "dzg", "dazaga" },
            { "155", "Zapadna Europa" },
            { "ug", "ujgurski" },
            { "Ital", "staro talijansko pismo" },
            { "Kore", "korejsko pismo" },
            { "Zyyy", "zajedni\u010dko pismo" },
            { "uk", "ukrajinski" },
            { "type.ca.coptic", "Koptski kalendar" },
            { "ur", "urdski" },
            { "%%1994", "standardizirani resian pravopis" },
            { "xal", "kalmyk" },
            { "zen", "zenaga" },
            { "uz", "uzbe\u010dki" },
            { "kha", "khasi" },
            { "%%1996", "njema\u010dka ortografija iz 1996." },
            { "nds_NL", "donjosaksonski" },
            { "Sylo", "syloti nagri pismo" },
            { "ve", "venda" },
            { "Wara", "varang kshiti pismo" },
            { "type.ca.roc", "kalendar Republike Kine" },
            { "vi", "vijetnamski" },
            { "kho", "khotanese" },
            { "khq", "koyra chiini" },
            { "key.hc", "format vremena (12 ili 24)" },
            { "%%TARASK", "taraskievica pravopis" },
            { "vo", "volap\u00fck" },
            { "syc", "klasi\u010dni sirski" },
            { "Osma", "osmanya pismo" },
            { "quc", "ki\u010de" },
            { "gaa", "ga" },
            { "wa", "valonski" },
            { "gag", "gagauski" },
            { "syr", "sirijski" },
            { "Grek", "gr\u010dko pismo" },
            { "gan", "gan kineski" },
            { "Lydi", "lidijsko pismo" },
            { "Xsux", "sumersko-akadsko cuneiform pismo" },
            { "wo", "volof" },
            { "zgh", "standardni marokanski tama\u0161ek" },
            { "ar_001", "moderni standardni arapski" },
            { "Cans", "unificirani kanadski abori\u0111inski slogovi" },
            { "gay", "gayo" },
            { "Mong", "mongolsko pismo" },
            { "mnc", "mand\u017eurski" },
            { "Latf", "fraktur latinica" },
            { "Hluw", "anatolijski hijeroglifi" },
            { "gba", "gbaya" },
            { "mni", "manipurski" },
            { "Latn", "latinica" },
            { "Latg", "keltska latinica" },
            { "type.nu.hans", "pojednostavljeni kineski brojevi" },
            { "type.nu.hant", "tradicionalni kineski brojevi" },
            { "xh", "xhosa" },
            { "type.nu.romanlow", "mali rimski brojevi" },
            { "byn", "blin" },
            { "%%PAMAKA", "pamaka dijalekt" },
            { "Lyci", "likijsko pismo" },
            { "osa", "osage" },
            { "byv", "medumba" },
            { "Moon", "moon pismo" },
            { "moh", "mohok" },
            { "kkj", "kako" },
            { "%%1694ACAD", "rani moderni francuski" },
            { "yi", "jidi\u0161" },
            { "mos", "mossi" },
            { "Syrc", "sirijsko pismo" },
            { "Dsrt", "deseret pismo" },
            { "yo", "jorupski" },
            { "type.nu.traditional", "Tradicionalni brojevi" },
            { "es_MX", "meksi\u010dki \u0161panjolski" },
            { "Syrj", "pismo zapadne Sirije" },
            { "ota", "turski - otomanski" },
            { "Syre", "sirijsko estrangelo pismo" },
            { "vai", "vai" },
            { "za", "zhuang" },
            { "Cari", "karijsko pismo" },
            { "kln", "kalenjin" },
            { "zh", "kineski" },
            { "Afak", "afaka pismo" },
            { "Bopo", "bopomofo pismo" },
            { "Perm", "staro permic pismo" },
            { "key.lb", "stil prijeloma retka" },
            { "zu", "zulu" },
            { "type.co.phonebook", "razvrstavanje po abecedi" },
            { "%%MONOTON", "monotono" },
            { "Geor", "gruzijsko pismo" },
            { "Shrd", "sharada pismo" },
            { "kmb", "kimbundu" },
            { "type.nu.jpanfin", "japanski financijski brojevi" },
            { "Cham", "\u010damsko pismo" },
            { "gez", "geez" },
            { "Syrn", "pismo isto\u010dne Sirije" },
            { "Narb", "staro sjevernoarapsko pismo" },
            { "type.co.reformed", "reformirano razvrstavanje" },
            { "Tglg", "tagalog pismo" },
            { "Egyd", "egipatsko narodno pismo" },
            { "Egyh", "egipatsko hijeratsko pismo" },
            { "Palm", "palmyrene pismo" },
            { "ebu", "embu" },
            { "Egyp", "egipatski hijeroglifi" },
            { "Geok", "gruzijsko khutsuri pismo" },
            { "zh_Hans", "kineski (pojednostavljeni)" },
            { "koi", "komi-permski" },
            { "Hung", "staro ma\u0111arsko pismo" },
            { "kok", "konkani" },
            { "%%1901", "tradicionalan njema\u010dki pravopis" },
            { "kos", "naurski" },
            { "zh_Hant", "kineski (tradicionalni)" },
            { "Sund", "sundansko pismo" },
            { "kpe", "kpelle" },
            { "type.nu.khmr", "khmerske znamenke" },
            { "Tirh", "tirhuta pismo" },
            { "ilo", "iloko" },
            { "%%VALENCIA", "valencijski" },
            { "Cprt", "cypriot pismo" },
            { "%%BAKU1926", "unificirana turska abeceda" },
            { "mua", "mundang" },
            { "type.nu.guru", "znamenke pisma gurmukhi" },
            { "mul", "vi\u0161e jezika" },
            { "cad", "caddo" },
            { "key.ms", "sustav mjernih jedinica" },
            { "mus", "creek" },
            { "Glag", "glagoljica" },
            { "gil", "gilbertski" },
            { "%%KKCOR", "Uobi\u010dajeni pravopis" },
            { "Cher", "\u010deroki pismo" },
            { "car", "karipski" },
            { "cay", "cayuga" },
            { "type.nu.tamldec", "tamilske znamenke" },
            { "krc", "karachay-balkar" },
            { "inh", "ingu\u0161etski" },
            { "krl", "karelijski" },
            { "efi", "efik" },
            { "key.nu", "brojevi" },
            { "kru", "kuru\u0161ki" },
            { "ksb", "shambala" },
            { "Telu", "telu\u0161ko pismo" },
            { "ksf", "bafia" },
        };
        return data;
    }
}
