/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.util.xml.impl;

import java.io.IOException;
import java.io.InputStream;
import jdk.internal.org.xml.sax.ContentHandler;
import jdk.internal.org.xml.sax.DTDHandler;
import jdk.internal.org.xml.sax.EntityResolver;
import jdk.internal.org.xml.sax.ErrorHandler;
import jdk.internal.org.xml.sax.InputSource;
import jdk.internal.org.xml.sax.Locator;
import jdk.internal.org.xml.sax.SAXException;
import jdk.internal.org.xml.sax.SAXParseException;
import jdk.internal.org.xml.sax.XMLReader;
import jdk.internal.org.xml.sax.helpers.DefaultHandler;
import jdk.internal.util.xml.impl.Input;
import jdk.internal.util.xml.impl.Parser;

final class ParserSAX
extends Parser
implements XMLReader,
Locator {
    public static final String FEATURE_NS = "http://xml.org/sax/features/namespaces";
    public static final String FEATURE_PREF = "http://xml.org/sax/features/namespace-prefixes";
    private boolean mFNamespaces = true;
    private boolean mFPrefixes = false;
    private DefaultHandler mHand = new DefaultHandler();
    private ContentHandler mHandCont = this.mHand;
    private DTDHandler mHandDtd = this.mHand;
    private ErrorHandler mHandErr = this.mHand;
    private EntityResolver mHandEnt = this.mHand;

    @Override
    public ContentHandler getContentHandler() {
        return this.mHandCont != this.mHand ? this.mHandCont : null;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        if (contentHandler == null) {
            throw new NullPointerException();
        }
        this.mHandCont = contentHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.mHandDtd != this.mHand ? this.mHandDtd : null;
    }

    @Override
    public void setDTDHandler(DTDHandler dTDHandler) {
        if (dTDHandler == null) {
            throw new NullPointerException();
        }
        this.mHandDtd = dTDHandler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.mHandErr != this.mHand ? this.mHandErr : null;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new NullPointerException();
        }
        this.mHandErr = errorHandler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.mHandEnt != this.mHand ? this.mHandEnt : null;
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) {
        if (entityResolver == null) {
            throw new NullPointerException();
        }
        this.mHandEnt = entityResolver;
    }

    @Override
    public String getPublicId() {
        return this.mInp != null ? this.mInp.pubid : null;
    }

    @Override
    public String getSystemId() {
        return this.mInp != null ? this.mInp.sysid : null;
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public void parse(String string) throws IOException, SAXException {
        this.parse(new InputSource(string));
    }

    @Override
    public void parse(InputSource inputSource) throws IOException, SAXException {
        if (inputSource == null) {
            throw new IllegalArgumentException("");
        }
        this.mInp = new Input(512);
        this.mPh = -1;
        try {
            this.setinp(inputSource);
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            this.panic(exception.toString());
        }
        this.parse();
    }

    public void parse(InputStream inputStream, DefaultHandler defaultHandler) throws SAXException, IOException {
        if (inputStream == null || defaultHandler == null) {
            throw new IllegalArgumentException("");
        }
        this.parse(new InputSource(inputStream), defaultHandler);
    }

    public void parse(InputSource inputSource, DefaultHandler defaultHandler) throws SAXException, IOException {
        if (inputSource == null || defaultHandler == null) {
            throw new IllegalArgumentException("");
        }
        this.mHandCont = defaultHandler;
        this.mHandDtd = defaultHandler;
        this.mHandErr = defaultHandler;
        this.mHandEnt = defaultHandler;
        this.mInp = new Input(512);
        this.mPh = -1;
        try {
            this.setinp(inputSource);
        }
        catch (IOException | RuntimeException | SAXException exception) {
            throw exception;
        }
        catch (Exception exception) {
            this.panic(exception.toString());
        }
        this.parse();
    }

    private void parse() throws SAXException, IOException {
        this.init();
        try {
            this.mHandCont.setDocumentLocator(this);
            this.mHandCont.startDocument();
            if (this.mPh != 1) {
                this.mPh = 1;
            }
            int n = 0;
            do {
                this.wsskip();
                n = this.step();
                switch (n) {
                    case 1: 
                    case 2: {
                        this.mPh = 4;
                        break;
                    }
                    case 6: 
                    case 8: {
                        break;
                    }
                    case 9: {
                        if (this.mPh >= 3) {
                            this.panic("");
                        }
                        this.mPh = 3;
                        break;
                    }
                    default: {
                        this.panic("");
                    }
                }
            } while (this.mPh < 4);
            do {
                switch (n) {
                    case 1: 
                    case 2: {
                        if (this.mIsNSAware) {
                            this.mHandCont.startElement(this.mElm.value, this.mElm.name, "", this.mAttrs);
                        } else {
                            this.mHandCont.startElement("", "", this.mElm.name, this.mAttrs);
                        }
                        if (n == 2) {
                            n = this.step();
                            break;
                        }
                    }
                    case 3: {
                        if (this.mIsNSAware) {
                            this.mHandCont.endElement(this.mElm.value, this.mElm.name, "");
                        } else {
                            this.mHandCont.endElement("", "", this.mElm.name);
                        }
                        while (this.mPref.list == this.mElm) {
                            this.mHandCont.endPrefixMapping(this.mPref.name);
                            this.mPref = this.del(this.mPref);
                        }
                        this.mElm = this.del(this.mElm);
                        if (this.mElm == null) {
                            this.mPh = 5;
                            break;
                        }
                        n = this.step();
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: {
                        n = this.step();
                        break;
                    }
                    default: {
                        this.panic("");
                    }
                }
            } while (this.mPh == 4);
            while (this.wsskip() != '\uffff') {
                switch (this.step()) {
                    case 6: 
                    case 8: {
                        break;
                    }
                    default: {
                        this.panic("");
                    }
                }
                if (this.mPh == 5) continue;
            }
            this.mPh = 6;
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            this.panic(exception.toString());
        }
        finally {
            this.mHandCont.endDocument();
            this.cleanup();
        }
    }

    @Override
    protected void docType(String string, String string2, String string3) throws SAXException {
        this.mHandDtd.notationDecl(string, string2, string3);
    }

    @Override
    protected void comm(char[] cArray, int n) {
    }

    @Override
    protected void pi(String string, String string2) throws SAXException {
        this.mHandCont.processingInstruction(string, string2);
    }

    @Override
    protected void newPrefix() throws SAXException {
        this.mHandCont.startPrefixMapping(this.mPref.name, this.mPref.value);
    }

    @Override
    protected void skippedEnt(String string) throws SAXException {
        this.mHandCont.skippedEntity(string);
    }

    @Override
    protected InputSource resolveEnt(String string, String string2, String string3) throws SAXException, IOException {
        return this.mHandEnt.resolveEntity(string2, string3);
    }

    @Override
    protected void notDecl(String string, String string2, String string3) throws SAXException {
        this.mHandDtd.notationDecl(string, string2, string3);
    }

    @Override
    protected void unparsedEntDecl(String string, String string2, String string3, String string4) throws SAXException {
        this.mHandDtd.unparsedEntityDecl(string, string2, string3, string4);
    }

    @Override
    protected void panic(String string) throws SAXException {
        SAXParseException sAXParseException = new SAXParseException(string, this);
        this.mHandErr.fatalError(sAXParseException);
        throw sAXParseException;
    }

    @Override
    protected void bflash() throws SAXException {
        if (this.mBuffIdx >= 0) {
            this.mHandCont.characters(this.mBuff, 0, this.mBuffIdx + 1);
            this.mBuffIdx = -1;
        }
    }

    @Override
    protected void bflash_ws() throws SAXException {
        if (this.mBuffIdx >= 0) {
            this.mHandCont.characters(this.mBuff, 0, this.mBuffIdx + 1);
            this.mBuffIdx = -1;
        }
    }

    @Override
    public boolean getFeature(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setFeature(String string, boolean bl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getProperty(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setProperty(String string, Object object) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

