/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.tools.ddrinteractive;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.ExpressionEvaluator;
import com.ibm.j9ddr.tools.ddrinteractive.ExpressionEvaluatorException;
import java.io.PrintStream;

public class J9XCommand
extends Command {
    private static final int DEFAULT_LINES = 2;
    private static final int DEFAULT_BYTES_PER_LINE = 16;
    private static final String DEFAULT_SEPARATOR = ",";
    private static final char[] ASCIICodes = new char[]{'.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.', '.'};

    public J9XCommand() {
        this.addCommand("j9x", "<address>", "Hexdump <address>");
        this.addCommand("j9xx", "<address>", "Hexdump <address>");
    }

    private void printHexMemoryDump(PrintStream printStream, Context context, long l, long l2, int n, int n2, boolean bl) throws CorruptDataException {
        int n3 = 0;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 == 0) {
            return;
        }
        if ((n & n - 1) != 0 || n == 0) {
            return;
        }
        l2 -= l2 % (long)n;
        while (l2 > 0L) {
            int n5;
            if (n3 % n2 == 0) {
                printStream.print(String.format("0x%08X : ", l));
                n4 = 0;
            }
            printStream.append(" ");
            switch (n) {
                case 1: {
                    printStream.print(String.format("%02x", context.process.getByteAt(l)));
                    break;
                }
                case 2: {
                    printStream.print(String.format("%04x", context.process.getShortAt(l)));
                    break;
                }
                case 4: {
                    printStream.print(String.format("%08x", context.process.getIntAt(l)));
                    break;
                }
                case 8: {
                    printStream.print(String.format("%016x", context.process.getLongAt(l)));
                    break;
                }
                default: {
                    printStream.print(String.format("Invalid width specified\n", new Object[0]));
                    return;
                }
            }
            l2 -= (long)n;
            if (bl) {
                for (n5 = 0; n5 < n; ++n5) {
                    int n6 = context.process.getByteAt(l + (long)n5) & 0xFF;
                    stringBuffer.insert(n4++, ASCIICodes[n6]);
                }
            }
            if (n3 % n2 == n2 - 1 || l2 == 0L) {
                if (bl) {
                    for (n5 = 0; n5 < (n2 - 1 - n3) * (n * 2 + 1); ++n5) {
                        printStream.append(" ");
                    }
                    printStream.append(" [ ");
                    printStream.append(stringBuffer.substring(0, n4));
                    printStream.append(" ] ");
                }
                printStream.append("\n");
            }
            l += (long)n;
            n3 = (n3 + 1) % n2;
        }
    }

    @Override
    public void run(String string, String[] stringArray, Context context, PrintStream printStream) throws DDRInteractiveCommandException {
        long l;
        if (stringArray.length == 0) {
            this.printUsage(printStream);
            printStream.println("Unexpected number of arguments.");
            return;
        }
        boolean bl = false;
        String[] stringArray2 = stringArray[0].split(DEFAULT_SEPARATOR);
        if (stringArray2[0].contains("..")) {
            String[] stringArray3 = new String[stringArray2.length + 1];
            String[] stringArray4 = stringArray2[0].split("\\.\\.");
            if (stringArray4.length != 2) {
                printStream.println("Incorrect range specified. Use '..' to separate two addresses in a range, e.g. !j9x address1..address2");
                return;
            }
            stringArray3[0] = stringArray4[0];
            stringArray3[1] = stringArray4[1];
            System.arraycopy(stringArray2, 1, stringArray3, 2, stringArray2.length - 1);
            stringArray2 = stringArray3;
            bl = true;
        }
        try {
            l = ExpressionEvaluator.eval(stringArray2[0]);
        }
        catch (ExpressionEvaluatorException expressionEvaluatorException) {
            printStream.println("Invalid start address specified.");
            this.printUsage(printStream);
            return;
        }
        long l2 = 32L;
        int n = context.process.bytesPerPointer();
        int n2 = 0;
        int n3 = stringArray2.length;
        switch (n3) {
            case 4: {
                n2 = Integer.valueOf(stringArray2[3]);
                if (n2 < 1) {
                    printStream.println("Invalid number of columns specified.");
                    this.printUsage(printStream);
                    return;
                }
            }
            case 3: {
                boolean bl2;
                n = Integer.valueOf(stringArray2[2]);
                boolean bl3 = bl2 = n == 1 || n == 2 || n == 4 || n == 8;
                if (!bl2) {
                    printStream.println("Invalid pointer size specified.");
                    this.printUsage(printStream);
                    return;
                }
            }
            case 2: {
                try {
                    if (!bl) {
                        if (stringArray2[1].startsWith("-")) {
                            l2 = ExpressionEvaluator.eval(stringArray2[1].substring(1), 16);
                            l -= l2;
                            break;
                        }
                        l2 = ExpressionEvaluator.eval(stringArray2[1], 16);
                        break;
                    }
                    long l3 = ExpressionEvaluator.eval(stringArray2[1]);
                    l2 = l3 - l;
                    break;
                }
                catch (ExpressionEvaluatorException expressionEvaluatorException) {
                    if (!bl) {
                        printStream.println("Invalid count specified.");
                    } else {
                        printStream.println("Invalid end address specified.");
                    }
                    this.printUsage(printStream);
                    return;
                }
            }
            case 1: {
                break;
            }
            default: {
                this.printUsage(printStream);
                return;
            }
        }
        if (n2 == 0) {
            n2 = 16 / n;
        }
        l2 -= l2 % (long)n;
        try {
            this.printHexMemoryDump(printStream, context, l, l2, n, n2, true);
        }
        catch (Exception exception) {
            throw new DDRInteractiveCommandException(exception);
        }
    }

    public String[] splitArguments(String[] stringArray) {
        return this.splitArguments(stringArray, DEFAULT_SEPARATOR);
    }

    public String[] splitArguments(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
        }
        String string2 = stringBuffer.toString();
        return string2.split(string);
    }

    private void printUsage(PrintStream printStream) {
        printStream.append("Usage:\n");
        printStream.append("  !j9x address                                              : display bytes at address\n");
        printStream.append("  !j9x address,count                                        : display count bytes from address\n");
        printStream.append("  !j9x address,-count                                       : display count bytes backwards from address\n");
        printStream.append("  !j9x startAddress..endAddress                             : display bytes between startAddress and endAddress\n");
        printStream.append("  !j9x [address,count|startAddress..endAddress],[1|2|4|8]   : set word size in output to 1,2,4 or 8 bytes\n");
        printStream.append("  !j9x [address,count|startAddress..endAddress],[1|2|4|8],n : format output to have n columns of words per row\n");
        printStream.append("The address, count, startAddress and endAddress parameters can be decimal or hexadecimal ('0x' prefix indicates hexadecimal, 'd' prefix indicates decimal).\n");
        printStream.append("If no prefix is specified the 'count' parameter is hexadecimal by default, all other parameters default to decimal.\n");
        printStream.append("For example:\n");
        printStream.append("  !j9x 0x7fa54800d4cf,20");
        printStream.append("  !j9x 0x7fa54800d4cf..0x7fa54800d4ef");
        printStream.append("  !j9x 0x7fa54800d4cf,d32,8,4");
        printStream.append("The address, count, startAddress and endAddress parameters can be expressions, for example:\n");
        printStream.append("  !j9x 0x7fa54800d4cf+32\n");
        printStream.append("  !j9x 0x7fa54800d4cf+0x20\n");
        printStream.append("  !j9x 0x7fa54800d4cf+(32*4)\n");
    }
}

