/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.virtualization.management;

import com.ibm.oti.util.Msg;
import com.ibm.virtualization.management.internal.GuestOSProcessorUsageUtil;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;

public final class GuestOSProcessorUsage {
    private static final int HASHMASK = 0xFFFFFFF;
    private long cpuTime;
    private long timestamp;
    private float cpuEntitlement;
    private long hostCpuClockSpeed;

    public GuestOSProcessorUsage() {
    }

    private GuestOSProcessorUsage(long l, long l2, float f, long l3) throws IllegalArgumentException {
        if (l < -1L || f < -1.0f || l3 < -1L || l2 < 0L) {
            throw new IllegalArgumentException();
        }
        this.cpuTime = l;
        this.timestamp = l2;
        this.cpuEntitlement = f;
        this.hostCpuClockSpeed = l3;
    }

    public long getCpuTime() {
        return this.cpuTime;
    }

    public long getHostCpuClockSpeed() {
        return this.hostCpuClockSpeed;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public float getCpuEntitlement() {
        return this.cpuEntitlement;
    }

    void updateValues(long l, long l2, float f, long l3) {
        this.cpuTime = l;
        this.timestamp = l2;
        this.cpuEntitlement = f;
        this.hostCpuClockSpeed = l3;
    }

    public static GuestOSProcessorUsage from(CompositeData compositeData) {
        GuestOSProcessorUsage guestOSProcessorUsage = null;
        if (null != compositeData) {
            long l;
            float f;
            long l2;
            long l3;
            if (!GuestOSProcessorUsageUtil.getCompositeType().isValue(compositeData)) {
                throw new IllegalArgumentException(Msg.getString("K05E5"));
            }
            try {
                l3 = (Long)compositeData.get("cpuTime");
                l2 = (Long)compositeData.get("timestamp");
                f = ((Float)compositeData.get("cpuEntitlement")).floatValue();
                l = (Long)compositeData.get("hostCpuClockSpeed");
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IllegalArgumentException(Msg.getString("K05E6"));
            }
            guestOSProcessorUsage = new GuestOSProcessorUsage(l3, l2, f, l);
        }
        return guestOSProcessorUsage;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n========== ");
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" ==========\n\n");
        stringBuilder.append("timestamp = ");
        stringBuilder.append(this.timestamp);
        stringBuilder.append("\n");
        stringBuilder.append("cpuTime = ");
        stringBuilder.append(this.cpuTime);
        stringBuilder.append("\n");
        stringBuilder.append("cpuEntitlement = ");
        stringBuilder.append(this.cpuEntitlement);
        stringBuilder.append("\n");
        stringBuilder.append("hostCpuClockSpeed = ");
        stringBuilder.append(this.hostCpuClockSpeed);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!(object instanceof GuestOSProcessorUsage)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        GuestOSProcessorUsage guestOSProcessorUsage = (GuestOSProcessorUsage)object;
        if (guestOSProcessorUsage.getCpuTime() != this.getCpuTime()) {
            return false;
        }
        if (guestOSProcessorUsage.getTimestamp() != this.getTimestamp()) {
            return false;
        }
        if (guestOSProcessorUsage.getCpuEntitlement() != this.getCpuEntitlement()) {
            return false;
        }
        return guestOSProcessorUsage.getHostCpuClockSpeed() == this.getHostCpuClockSpeed();
    }

    public int hashCode() {
        long l = this.getCpuTime() + this.getTimestamp() + this.getHostCpuClockSpeed() + (long)this.getCpuEntitlement();
        return (int)(((l >> 32) + l & 0xFFFFFFFL) * 23L);
    }
}

